
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `piwigo1560`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activity`
--

CREATE TABLE `[[dbprefix]]activity` (
  `activity_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object` varchar(255) NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `action` varchar(255) NOT NULL,
  `performed_by` mediumint(8) unsigned NOT NULL,
  `session_idx` varchar(255) NOT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `occured_on` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `details` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]caddie`
--

CREATE TABLE `[[dbprefix]]caddie` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `element_id` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`element_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `id_uppercat` smallint(5) unsigned DEFAULT NULL,
  `comment` text,
  `dir` varchar(255) DEFAULT NULL,
  `rank` smallint(5) unsigned DEFAULT NULL,
  `status` enum('public','private') NOT NULL DEFAULT 'public',
  `site_id` tinyint(4) unsigned DEFAULT NULL,
  `visible` enum('true','false') NOT NULL DEFAULT 'true',
  `representative_picture_id` mediumint(8) unsigned DEFAULT NULL,
  `uppercats` varchar(255) NOT NULL DEFAULT '',
  `commentable` enum('true','false') NOT NULL DEFAULT 'true',
  `global_rank` varchar(255) DEFAULT NULL,
  `image_order` varchar(128) DEFAULT NULL,
  `permalink` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categories_i3` (`permalink`),
  KEY `categories_i2` (`id_uppercat`),
  KEY `lastmodified` (`lastmodified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `author` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `author_id` mediumint(8) unsigned DEFAULT NULL,
  `anonymous_id` varchar(45) NOT NULL,
  `website_url` varchar(255) DEFAULT NULL,
  `content` longtext,
  `validated` enum('true','false') NOT NULL DEFAULT 'false',
  `validation_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comments_i2` (`validation_date`),
  KEY `comments_i1` (`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `param` varchar(40) NOT NULL DEFAULT '',
  `value` text,
  `comment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`param`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='configuration table';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('activate_comments', 'false', 'Global parameter for usage of comments system'),
('nb_comment_page', '10', 'number of comments to display on each page'),
('log', 'true', 'keep an history of visits on your website'),
('comments_validation', 'false', 'administrators validate users comments before becoming visible'),
('comments_forall', 'false', 'even guest not registered can post comments'),
('comments_order', 'ASC', 'comments order on picture page and cie'),
('comments_author_mandatory', 'false', 'Comment author is mandatory'),
('comments_email_mandatory', 'false', 'Comment email is mandatory'),
('comments_enable_website', 'true', 'Enable "website" field on add comment form'),
('user_can_delete_comment', 'false', 'administrators can allow user delete their own comments'),
('user_can_edit_comment', 'false', 'administrators can allow user edit their own comments'),
('email_admin_on_comment_edition', 'false', 'Send an email to the administrators when a comment is modified'),
('email_admin_on_comment_deletion', 'false', 'Send an email to the administrators when a comment is deleted'),
('gallery_locked', 'false', 'Lock your gallery temporary for non admin users'),
('gallery_title', '[[site_name]]', 'Title at top of each page and for RSS feed'),
('rate', 'false', 'Rating pictures feature is enabled'),
('rate_anonymous', 'true', 'Rating pictures feature is also enabled for visitors'),
('page_banner', '<h1>%gallery_title%</h1>\n\n<p>[[site_desc]]</p>', 'html displayed on the top each page of your gallery'),
('history_admin', 'false', 'keep a history of administrator visits on your website'),
('history_guest', 'true', 'keep a history of guest visits on your website'),
('allow_user_registration', 'true', 'allow visitors to register?'),
('allow_user_customization', 'true', 'allow users to customize their gallery?'),
('nb_categories_page', '12', 'Param for categories pagination'),
('nbm_send_html_mail', 'true', 'Send mail on HTML format for notification by mail'),
('nbm_send_mail_as', '', 'Send mail as param value for notification by mail'),
('nbm_send_detailed_content', 'true', 'Send detailed content for notification by mail'),
('nbm_complementary_mail_content', '', 'Complementary mail content for notification by mail'),
('nbm_send_recent_post_dates', 'true', 'Send recent post by dates for notification by mail'),
('email_admin_on_new_user', 'none', 'Send an email to theadministrators when a user registers'),
('email_admin_on_comment', 'false', 'Send an email to the administrators when a valid comment is entered'),
('email_admin_on_comment_validation', 'true', 'Send an email to the administrators when a comment requires validation'),
('obligatory_user_mail_address', 'false', 'Mail address is obligatory for users'),
('c13y_ignore', NULL, 'List of ignored anomalies'),
('extents_for_templates', 'a:0:{}', 'Actived template-extension(s)'),
('blk_menubar', '', 'Menubar options'),
('menubar_filter_icon', 'false', 'Display filter icon'),
('index_sort_order_input', 'true', 'Display image order selection list'),
('index_flat_icon', 'false', 'Display flat icon'),
('index_posted_date_icon', 'true', 'Display calendar by posted date'),
('index_created_date_icon', 'true', 'Display calendar by creation date icon'),
('index_slideshow_icon', 'true', 'Display slideshow icon'),
('index_new_icon', 'true', 'Display new icons next albums and pictures'),
('picture_metadata_icon', 'true', 'Display metadata icon on picture page'),
('picture_slideshow_icon', 'true', 'Display slideshow icon on picture page'),
('picture_favorite_icon', 'true', 'Display favorite icon on picture page'),
('picture_download_icon', 'true', 'Display download icon on picture page'),
('picture_navigation_icons', 'true', 'Display navigation icons on picture page'),
('picture_navigation_thumb', 'true', 'Display navigation thumbnails on picture page'),
('picture_menu', 'false', 'Show menubar on picture page'),
('picture_informations', 'a:11:{s:6:"author";b:1;s:10:"created_on";b:1;s:9:"posted_on";b:1;s:10:"dimensions";b:0;s:4:"file";b:0;s:8:"filesize";b:0;s:4:"tags";b:1;s:10:"categories";b:1;s:6:"visits";b:1;s:12:"rating_score";b:1;s:13:"privacy_level";b:1;}', 'Information displayed on picture page'),
('week_starts_on', 'monday', 'Monday may not be the first day of the week'),
('updates_ignored', 'a:3:{s:7:"plugins";a:0:{}s:6:"themes";a:0:{}s:9:"languages";a:0:{}}', 'Extensions ignored for update'),
('order_by', 'ORDER BY date_available DESC, file ASC, id ASC', 'default photo order'),
('order_by_inside_category', 'ORDER BY date_available DESC, file ASC, id ASC', 'default photo order inside category'),
('original_resize', 'false', NULL),
('original_resize_maxwidth', '2016', NULL),
('original_resize_maxheight', '2016', NULL),
('original_resize_quality', '95', NULL),
('mobile_theme', 'smartpocket', NULL),
('mail_theme', 'clear', NULL),
('picture_sizes_icon', 'true', NULL),
('index_sizes_icon', 'true', NULL),
('index_edit_icon', 'true', NULL),
('index_caddie_icon', 'true', NULL),
('display_fromto', 'false', NULL),
('picture_edit_icon', 'true', NULL),
('picture_caddie_icon', 'true', NULL),
('picture_representative_icon', 'true', NULL),
('show_mobile_app_banner_in_admin', 'true', NULL),
('show_mobile_app_banner_in_gallery', 'false', NULL),
('index_search_in_set_button', 'false', NULL),
('index_search_in_set_action', 'true', NULL),
('upload_detect_duplicate', 'true', NULL),
('webmaster_id', '1', NULL),
('secret_key', '[[secretkey]]', 'a secret key specific to the gallery for internal use'),
('piwigo_db_version', '15', NULL),
('modus_theme', 'a:5:{s:4:"skin";s:9:"newspaper";s:16:"album_thumb_size";i:250;s:17:"index_photo_deriv";s:6:"2small";s:22:"index_photo_deriv_hdpi";s:6:"xsmall";s:19:"display_page_banner";b:0;}', NULL),
('smartpocket', 'a:2:{s:4:"loop";b:1;s:8:"autohide";i:5000;}', NULL),
('data_dir_checked', '1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favorites`
--

CREATE TABLE `[[dbprefix]]favorites` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `is_default` enum('true','false') NOT NULL DEFAULT 'false',
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `groups_ui1` (`name`),
  KEY `lastmodified` (`lastmodified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]group_access`
--

CREATE TABLE `[[dbprefix]]group_access` (
  `group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`,`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL DEFAULT '1970-01-01',
  `time` time NOT NULL DEFAULT '00:00:00',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `IP` char(39) NOT NULL DEFAULT '',
  `section` enum('categories','tags','search','list','favorites','most_visited','best_rated','recent_pics','recent_cats') DEFAULT NULL,
  `category_id` smallint(5) DEFAULT NULL,
  `search_id` int(10) unsigned DEFAULT NULL,
  `tag_ids` varchar(50) DEFAULT NULL,
  `image_id` mediumint(8) DEFAULT NULL,
  `image_type` enum('picture','high','other') DEFAULT NULL,
  `format_id` int(11) unsigned DEFAULT NULL,
  `auth_key_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history_summary`
--

CREATE TABLE `[[dbprefix]]history_summary` (
  `year` smallint(4) NOT NULL DEFAULT '0',
  `month` tinyint(2) DEFAULT NULL,
  `day` tinyint(2) DEFAULT NULL,
  `hour` tinyint(2) DEFAULT NULL,
  `nb_pages` int(11) DEFAULT NULL,
  `history_id_from` int(10) unsigned DEFAULT NULL,
  `history_id_to` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `history_summary_ymdh` (`year`,`month`,`day`,`hour`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images`
--

CREATE TABLE `[[dbprefix]]images` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `file` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `date_available` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `date_creation` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `comment` text,
  `author` varchar(255) DEFAULT NULL,
  `hit` int(10) unsigned NOT NULL DEFAULT '0',
  `filesize` mediumint(9) unsigned DEFAULT NULL,
  `width` smallint(9) unsigned DEFAULT NULL,
  `height` smallint(9) unsigned DEFAULT NULL,
  `coi` char(4) DEFAULT NULL COMMENT 'center of interest',
  `representative_ext` varchar(4) DEFAULT NULL,
  `date_metadata_update` date DEFAULT NULL,
  `rating_score` float(5,2) unsigned DEFAULT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  `storage_category_id` smallint(5) unsigned DEFAULT NULL,
  `level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `md5sum` char(32) DEFAULT NULL,
  `added_by` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rotation` tinyint(3) unsigned DEFAULT NULL,
  `latitude` double(8,6) DEFAULT NULL,
  `longitude` double(9,6) DEFAULT NULL,
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `images_i2` (`date_available`),
  KEY `images_i3` (`rating_score`),
  KEY `images_i4` (`hit`),
  KEY `images_i5` (`date_creation`),
  KEY `images_i1` (`storage_category_id`),
  KEY `images_i6` (`latitude`),
  KEY `images_i7` (`path`),
  KEY `lastmodified` (`lastmodified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_category`
--

CREATE TABLE `[[dbprefix]]image_category` (
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `rank` mediumint(8) unsigned DEFAULT NULL,
  PRIMARY KEY (`image_id`,`category_id`),
  KEY `image_category_i1` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_format`
--

CREATE TABLE `[[dbprefix]]image_format` (
  `format_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ext` varchar(255) NOT NULL,
  `filesize` mediumint(9) unsigned DEFAULT NULL,
  PRIMARY KEY (`format_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image_tag`
--

CREATE TABLE `[[dbprefix]]image_tag` (
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `tag_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`,`tag_id`),
  KEY `image_tag_i1` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `id` varchar(64) NOT NULL DEFAULT '',
  `version` varchar(64) NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
('en_GB', '15.6.0', 'English [GB]'),
('af_ZA', '15.6.0', 'Afrikaans [ZA]'),
('es_AR', '15.6.0', 'Argentina [AR]'),
('az_AZ', '15.6.0', 'Azərbaycanca [AZ]'),
('id_ID', '15.6.0', 'Bahasa Indonesia [ID]'),
('pt_BR', '15.6.0', 'Brasil [BR]'),
('br_FR', '15.6.0', 'Brezhoneg [FR]'),
('ca_ES', '15.6.0', 'Català [CA]'),
('da_DK', '15.6.0', 'Dansk [DK]'),
('de_DE', '15.6.0', 'Deutsch [DE]'),
('dv_MV', '15.6.0', 'Dhivehi [MV]'),
('en_UK', '15.6.0', 'English [UK]'),
('en_US', '15.6.0', 'English [US]'),
('es_ES', '15.6.0', 'Español [ES]'),
('eo_EO', '15.6.0', 'Esperanto [EO]'),
('et_EE', '15.6.0', 'Estonian [EE]'),
('eu_ES', '15.6.0', 'Euskara [ES]'),
('fi_FI', '15.6.0', 'Finnish [FI]'),
('fr_FR', '15.6.0', 'Français [FR]'),
('fr_CA', '15.6.0', 'Français [QC]'),
('ga_IE', '15.6.0', 'Gaeilge [IE]'),
('gl_ES', '15.6.0', 'Galego [ES]'),
('hr_HR', '15.6.0', 'Hrvatski [HR]'),
('it_IT', '15.6.0', 'Italiano [IT]'),
('lv_LV', '15.6.0', 'Latviešu [LV]'),
('lt_LT', '15.6.0', 'Lietuviu [LT]'),
('lb_LU', '15.6.0', 'Lëtzebuergesch [LU]'),
('hu_HU', '15.6.0', 'Magyar [HU]'),
('ms_MY', '15.6.0', 'Malay [MY]'),
('es_MX', '15.6.0', 'México [MX]'),
('nl_NL', '15.6.0', 'Nederlands [NL]'),
('nb_NO', '15.6.0', 'Norsk bokmål [NO]'),
('nn_NO', '15.6.0', 'Norwegian nynorsk [NO]'),
('pl_PL', '15.6.0', 'Polski [PL]'),
('pt_PT', '15.6.0', 'Português [PT]'),
('km_KH', '15.6.0', 'ខ្មែរ [KH]'),
('ro_RO', '15.6.0', 'Română [RO]'),
('ar_EG', '15.6.0', 'العربية (مصر) [EG]'),
('sk_SK', '15.6.0', 'Slovensky [SK]'),
('sh_RS', '15.6.0', 'Srpski [SR]'),
('sl_SI', '15.6.0', 'Slovenšcina [SI]'),
('zh_CN', '15.6.0', '简体中文 [CN]'),
('mn_MN', '15.6.0', 'Монгол [MN]'),
('vi_VN', '15.6.0', 'Tiếng Việt [VN]'),
('sv_SE', '15.6.0', 'Svenska [SE]'),
('tr_TR', '15.6.0', 'Türkçe [TR]'),
('ru_RU', '15.6.0', 'Русский [RU]'),
('wo_SN', '15.6.0', 'Wolof [SN]'),
('cs_CZ', '15.6.0', 'Česky [CZ]'),
('gu_IN', '15.6.0', 'ગુજરાતી[IN]'),
('kn_IN', '15.6.0', 'ಕನ್ನಡ [IN]'),
('ka_GE', '15.6.0', 'ქართული [GE]'),
('ta_IN', '15.6.0', 'தமிழ் [IN]'),
('bn_IN', '15.6.0', 'বাংলা[IN]'),
('th_TH', '15.6.0', 'ภาษาไทย [TH]'),
('zh_TW', '15.6.0', '中文 (繁體) [TW]'),
('zh_HK', '15.6.0', '中文 (香港) [HK]'),
('ja_JP', '15.6.0', '日本語 [JP]'),
('ko_KR', '15.6.0', '한국어 [KR]'),
('hy_AM', '15.6.0', 'Հայերեն (Hayerēn) [AM]'),
('he_IL', '15.6.0', 'עברית [IL]'),
('ar_SA', '15.6.0', 'العربية [AR]'),
('ar_MA', '15.6.0', 'العربية [MA]'),
('fa_IR', '15.6.0', 'پارسی [IR]'),
('kok_IN', '15.6.0', 'कोंकणी [IN]'),
('is_IS', '15.6.0', 'Íslenska [IS]'),
('el_GR', '15.6.0', 'Ελληνικά [GR]'),
('bg_BG', '15.6.0', 'Български [BG]'),
('mk_MK', '15.6.0', 'Македонски [MK]'),
('sr_RS', '15.6.0', 'Српски [SR]'),
('uk_UA', '15.6.0', 'Українська [UA]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lounge`
--

CREATE TABLE `[[dbprefix]]lounge` (
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]old_permalinks`
--

CREATE TABLE `[[dbprefix]]old_permalinks` (
  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `permalink` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `date_deleted` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `last_hit` datetime DEFAULT NULL,
  `hit` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permalink`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `state` enum('inactive','active') NOT NULL DEFAULT 'inactive',
  `version` varchar(64) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rate`
--

CREATE TABLE `[[dbprefix]]rate` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `element_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `anonymous_id` varchar(45) NOT NULL DEFAULT '',
  `rate` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL DEFAULT '1970-01-01',
  PRIMARY KEY (`element_id`,`user_id`,`anonymous_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search`
--

CREATE TABLE `[[dbprefix]]search` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `search_uuid` char(23) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `created_by` mediumint(8) unsigned DEFAULT NULL,
  `forked_from` int(10) unsigned DEFAULT NULL,
  `rules` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `data` mediumtext NOT NULL,
  `expiration` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]sessions`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sites`
--

CREATE TABLE `[[dbprefix]]sites` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `galleries_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sites_ui1` (`galleries_url`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]sites`
--

INSERT INTO `[[dbprefix]]sites` VALUES
(1, './galleries/');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `tags_i1` (`url_name`),
  KEY `lastmodified` (`lastmodified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]themes`
--

CREATE TABLE `[[dbprefix]]themes` (
  `id` varchar(64) NOT NULL DEFAULT '',
  `version` varchar(64) NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]themes`
--

INSERT INTO `[[dbprefix]]themes` VALUES
('modus', '15.6.0', 'modus'),
('smartpocket', '15.6.0', 'Smart Pocket');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]upgrade`
--

CREATE TABLE `[[dbprefix]]upgrade` (
  `id` varchar(20) NOT NULL DEFAULT '',
  `applied` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]upgrade`
--

INSERT INTO `[[dbprefix]]upgrade` VALUES
('61', '[[regtime]]', 'upgrade included in installation'),
('62', '[[regtime]]', 'upgrade included in installation'),
('63', '[[regtime]]', 'upgrade included in installation'),
('64', '[[regtime]]', 'upgrade included in installation'),
('65', '[[regtime]]', 'upgrade included in installation'),
('66', '[[regtime]]', 'upgrade included in installation'),
('67', '[[regtime]]', 'upgrade included in installation'),
('68', '[[regtime]]', 'upgrade included in installation'),
('69', '[[regtime]]', 'upgrade included in installation'),
('70', '[[regtime]]', 'upgrade included in installation'),
('71', '[[regtime]]', 'upgrade included in installation'),
('72', '[[regtime]]', 'upgrade included in installation'),
('73', '[[regtime]]', 'upgrade included in installation'),
('74', '[[regtime]]', 'upgrade included in installation'),
('75', '[[regtime]]', 'upgrade included in installation'),
('76', '[[regtime]]', 'upgrade included in installation'),
('77', '[[regtime]]', 'upgrade included in installation'),
('78', '[[regtime]]', 'upgrade included in installation'),
('79', '[[regtime]]', 'upgrade included in installation'),
('80', '[[regtime]]', 'upgrade included in installation'),
('81', '[[regtime]]', 'upgrade included in installation'),
('82', '[[regtime]]', 'upgrade included in installation'),
('83', '[[regtime]]', 'upgrade included in installation'),
('84', '[[regtime]]', 'upgrade included in installation'),
('85', '[[regtime]]', 'upgrade included in installation'),
('86', '[[regtime]]', 'upgrade included in installation'),
('87', '[[regtime]]', 'upgrade included in installation'),
('88', '[[regtime]]', 'upgrade included in installation'),
('89', '[[regtime]]', 'upgrade included in installation'),
('90', '[[regtime]]', 'upgrade included in installation'),
('91', '[[regtime]]', 'upgrade included in installation'),
('92', '[[regtime]]', 'upgrade included in installation'),
('93', '[[regtime]]', 'upgrade included in installation'),
('94', '[[regtime]]', 'upgrade included in installation'),
('95', '[[regtime]]', 'upgrade included in installation'),
('96', '[[regtime]]', 'upgrade included in installation'),
('97', '[[regtime]]', 'upgrade included in installation'),
('98', '[[regtime]]', 'upgrade included in installation'),
('99', '[[regtime]]', 'upgrade included in installation'),
('100', '[[regtime]]', 'upgrade included in installation'),
('101', '[[regtime]]', 'upgrade included in installation'),
('102', '[[regtime]]', 'upgrade included in installation'),
('103', '[[regtime]]', 'upgrade included in installation'),
('104', '[[regtime]]', 'upgrade included in installation'),
('105', '[[regtime]]', 'upgrade included in installation'),
('106', '[[regtime]]', 'upgrade included in installation'),
('107', '[[regtime]]', 'upgrade included in installation'),
('108', '[[regtime]]', 'upgrade included in installation'),
('109', '[[regtime]]', 'upgrade included in installation'),
('110', '[[regtime]]', 'upgrade included in installation'),
('111', '[[regtime]]', 'upgrade included in installation'),
('112', '[[regtime]]', 'upgrade included in installation'),
('113', '[[regtime]]', 'upgrade included in installation'),
('114', '[[regtime]]', 'upgrade included in installation'),
('115', '[[regtime]]', 'upgrade included in installation'),
('116', '[[regtime]]', 'upgrade included in installation'),
('117', '[[regtime]]', 'upgrade included in installation'),
('118', '[[regtime]]', 'upgrade included in installation'),
('119', '[[regtime]]', 'upgrade included in installation'),
('120', '[[regtime]]', 'upgrade included in installation'),
('121', '[[regtime]]', 'upgrade included in installation'),
('122', '[[regtime]]', 'upgrade included in installation'),
('123', '[[regtime]]', 'upgrade included in installation'),
('124', '[[regtime]]', 'upgrade included in installation'),
('125', '[[regtime]]', 'upgrade included in installation'),
('126', '[[regtime]]', 'upgrade included in installation'),
('127', '[[regtime]]', 'upgrade included in installation'),
('128', '[[regtime]]', 'upgrade included in installation'),
('129', '[[regtime]]', 'upgrade included in installation'),
('130', '[[regtime]]', 'upgrade included in installation'),
('131', '[[regtime]]', 'upgrade included in installation'),
('132', '[[regtime]]', 'upgrade included in installation'),
('133', '[[regtime]]', 'upgrade included in installation'),
('134', '[[regtime]]', 'upgrade included in installation'),
('135', '[[regtime]]', 'upgrade included in installation'),
('136', '[[regtime]]', 'upgrade included in installation'),
('137', '[[regtime]]', 'upgrade included in installation'),
('138', '[[regtime]]', 'upgrade included in installation'),
('139', '[[regtime]]', 'upgrade included in installation'),
('140', '[[regtime]]', 'upgrade included in installation'),
('141', '[[regtime]]', 'upgrade included in installation'),
('142', '[[regtime]]', 'upgrade included in installation'),
('143', '[[regtime]]', 'upgrade included in installation'),
('144', '[[regtime]]', 'upgrade included in installation'),
('145', '[[regtime]]', 'upgrade included in installation'),
('146', '[[regtime]]', 'upgrade included in installation'),
('147', '[[regtime]]', 'upgrade included in installation'),
('148', '[[regtime]]', 'upgrade included in installation'),
('149', '[[regtime]]', 'upgrade included in installation'),
('150', '[[regtime]]', 'upgrade included in installation'),
('151', '[[regtime]]', 'upgrade included in installation'),
('152', '[[regtime]]', 'upgrade included in installation'),
('153', '[[regtime]]', 'upgrade included in installation'),
('154', '[[regtime]]', 'upgrade included in installation'),
('155', '[[regtime]]', 'upgrade included in installation'),
('156', '[[regtime]]', 'upgrade included in installation'),
('157', '[[regtime]]', 'upgrade included in installation'),
('158', '[[regtime]]', 'upgrade included in installation'),
('159', '[[regtime]]', 'upgrade included in installation'),
('160', '[[regtime]]', 'upgrade included in installation'),
('161', '[[regtime]]', 'upgrade included in installation'),
('162', '[[regtime]]', 'upgrade included in installation'),
('163', '[[regtime]]', 'upgrade included in installation'),
('164', '[[regtime]]', 'upgrade included in installation'),
('165', '[[regtime]]', 'upgrade included in installation'),
('166', '[[regtime]]', 'upgrade included in installation'),
('167', '[[regtime]]', 'upgrade included in installation'),
('168', '[[regtime]]', 'upgrade included in installation'),
('169', '[[regtime]]', 'upgrade included in installation'),
('170', '[[regtime]]', 'upgrade included in installation'),
('171', '[[regtime]]', 'upgrade included in installation'),
('172', '[[regtime]]', 'upgrade included in installation'),
('173', '[[regtime]]', 'upgrade included in installation'),
('174', '[[regtime]]', 'upgrade included in installation');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `password` varchar(255) DEFAULT NULL,
  `mail_address` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_ui1` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]'),
(2, 'guest', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_access`
--

CREATE TABLE `[[dbprefix]]user_access` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_auth_keys`
--

CREATE TABLE `[[dbprefix]]user_auth_keys` (
  `auth_key_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `auth_key` varchar(255) NOT NULL,
  `user_id` mediumint(8) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `duration` int(11) unsigned DEFAULT NULL,
  `expired_on` datetime NOT NULL,
  PRIMARY KEY (`auth_key_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_cache`
--

CREATE TABLE `[[dbprefix]]user_cache` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `need_update` enum('true','false') NOT NULL DEFAULT 'true',
  `cache_update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `forbidden_categories` mediumtext,
  `nb_total_images` mediumint(8) unsigned DEFAULT NULL,
  `last_photo_date` datetime DEFAULT NULL,
  `nb_available_tags` int(5) DEFAULT NULL,
  `nb_available_comments` int(5) DEFAULT NULL,
  `image_access_type` enum('NOT IN','IN') NOT NULL DEFAULT 'NOT IN',
  `image_access_list` mediumtext,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_cache_categories`
--

CREATE TABLE `[[dbprefix]]user_cache_categories` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `date_last` datetime DEFAULT NULL,
  `max_date_last` datetime DEFAULT NULL,
  `nb_images` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `count_images` mediumint(8) unsigned DEFAULT '0',
  `nb_categories` mediumint(8) unsigned DEFAULT '0',
  `count_categories` mediumint(8) unsigned DEFAULT '0',
  `user_representative_picture_id` mediumint(8) unsigned DEFAULT NULL,
  PRIMARY KEY (`user_id`,`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_feed`
--

CREATE TABLE `[[dbprefix]]user_feed` (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_check` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_group`
--

CREATE TABLE `[[dbprefix]]user_group` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_infos`
--

CREATE TABLE `[[dbprefix]]user_infos` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `nb_image_page` smallint(3) unsigned NOT NULL DEFAULT '15',
  `status` enum('webmaster','admin','normal','generic','guest') NOT NULL DEFAULT 'guest',
  `language` varchar(50) NOT NULL DEFAULT 'en_UK',
  `expand` enum('true','false') NOT NULL DEFAULT 'false',
  `show_nb_comments` enum('true','false') NOT NULL DEFAULT 'false',
  `show_nb_hits` enum('true','false') NOT NULL DEFAULT 'false',
  `recent_period` tinyint(3) unsigned NOT NULL DEFAULT '7',
  `theme` varchar(255) NOT NULL DEFAULT 'modus',
  `registration_date` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `enabled_high` enum('true','false') NOT NULL DEFAULT 'true',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `activation_key` varchar(255) DEFAULT NULL,
  `activation_key_expire` datetime DEFAULT NULL,
  `last_visit` datetime DEFAULT NULL,
  `last_visit_from_history` enum('true','false') NOT NULL DEFAULT 'false',
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `preferences` text,
  PRIMARY KEY (`user_id`),
  KEY `lastmodified` (`lastmodified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]user_infos`
--

INSERT INTO `[[dbprefix]]user_infos` VALUES
(1, 15, 'webmaster', '[[language]]', 'false', 'false', 'false', 7, 'modus', '[[regtime]]', 'true', 8, NULL, NULL, NULL, 'false', '[[regtime]]', 'a:1:{s:17:"show_whats_new_15";b:0;}'),
(2, 15, 'guest', 'en_GB', 'false', 'false', 'false', 7, 'modus', '[[regtime]]', 'true', 0, NULL, NULL, NULL, 'false', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_mail_notification`
--

CREATE TABLE `[[dbprefix]]user_mail_notification` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `check_key` varchar(16) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `enabled` enum('true','false') NOT NULL DEFAULT 'false',
  `last_send` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_mail_notification_ui1` (`check_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
