<?php 
/*** COPYRIGHT NOTICE *********************************************************
 *
 * Copyright 2009-2017 ProjeQtOr - Pascal BERNARD - support@projeqtor.org
 * Contributors : -
 *
 * This file is part of ProjeQtOr.
 * 
 * ProjeQtOr is free software: you can redistribute it and/or modify it under 
 * the terms of the GNU Affero General Public License as published by the Free 
 * Software Foundation, either version 3 of the License, or (at your option) 
 * any later version.
 * 
 * ProjeQtOr is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for 
 * more details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * ProjeQtOr. If not, see <http://www.gnu.org/licenses/>.
 *
 * You can get complete code of ProjeQtOr, other resource, help and information
 * about contributors at http://www.projeqtor.org 
 *     
 *** DO NOT REMOVE THIS NOTICE ************************************************/

/* ============================================================================
 * Habilitation defines right to the application for a menu and a profile.
 */ 
require_once('_securityCheck.php');
class ProjectHistory extends SqlElement {

  // extends SqlElement, so has $id
  public $id;    // redefine $id to specify its visible place 
  public $idProject;
  public $day;
  public $realWork;
  public $leftWork;
  public $realCost;
  public $leftCost;
  public $totalRealCost;
  public $totalLeftCost;
  public $realCostLocal;
  public $leftCostLocal;
  public $totalRealCostLocal;
  public $totalLeftCostLocal;
  public $_noHistory; // This is an history, so don't save history on history
   /** ==========================================================================
   * Constructor
   * @param $id Int the id of the object in the database (null if not stored yet)
   * @return void
   */ 
  function __construct($id = NULL, $withoutDependentObjects=false) {
    parent::__construct($id,$withoutDependentObjects);
  }

  
   /** ==========================================================================
   * Destructor
   * @return void
   */ 
  function __destruct() {
    parent::__destruct();
  }

  function save() {
    if ($this->realCost<0) $this->realCost=0;
    if ($this->leftCost<0) $this->leftCost=0;
    if ($this->totalRealCost<0) $this->totalRealCost=0;
    if ($this->totalLeftCost<0) $this->totalLeftCost=0;
    if ($this->realCostLocal<0) $this->realCostLocal=0;
    if ($this->leftCostLocal<0) $this->leftCostLocal=0;
    if ($this->totalRealCostLocal<0) $this->totalRealCostLocal=0;
    if ($this->totalLeftCostLocal<0) $this->totalLeftCostLocal=0;
    return parent::save();
  }
// ============================================================================**********
// MISCELLANOUS FUNCTIONS
// ============================================================================**********
  
}
?>