
-- ///////////////////////////////////////////////////////////
-- // PROJECTOR                                             //
-- //-------------------------------------------------------//
-- // Version : V0.9.0                                      //
-- // Date : 2010-05-21                                     //
-- ///////////////////////////////////////////////////////////
--
--
DROP TABLE IF EXISTS `${prefix}workflow`;
CREATE TABLE `${prefix}workflow` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `idle` int(1) unsigned DEFAULT '0',
  `workflowUpdate` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_general_ci;

DROP TABLE IF EXISTS `${prefix}workflowstatus`;
CREATE TABLE `${prefix}workflowstatus` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `idWorkflow` int(12) unsigned NOT NULL,
  `idStatusFrom` int(12) unsigned NOT NULL,
  `idStatusTo` int(12) unsigned NOT NULL,
  `idProfile` int(12) unsigned NOT NULL,
  `allowed` int(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_general_ci;

DELETE FROM `${prefix}menu` WHERE id IN (59,60);
INSERT INTO `${prefix}menu` (`id`, `name`, `idMenu`, `type`, `sortOrder`, `level`, `idle`) VALUES
(59, 'menuWorkflow', 36, 'object', 943, NULL, 0),
(60, 'menuActionType', 36, 'object', 951, NULL, 0);

INSERT INTO `${prefix}habilitation` (`idProfile`, `idMenu`, `allowaccess`) VALUES
(1, 59, 1),
(1, 60, 1);

ALTER TABLE `${prefix}type` ADD idWorkflow int(12) unsigned DEFAULT NULL;

ALTER TABLE `${prefix}action` ADD idActionType int(12) unsigned DEFAULT NULL;

INSERT INTO `${prefix}type` (`scope`, `name`, `sortOrder`, `idle`, `color`) VALUES
('Action', 'Project', 10, 0, NULL),
('Action', 'Internal', 20, 0, NULL),
('Action', 'Customer', 20, 0, NULL);

-- DATA FOR SAMPLE WORKFLOWS
INSERT INTO `${prefix}workflow` (id,name, description, idle, workflowUpdate) VALUES 
(1,'Default','Default workflow with just logic constraints.
Anyone can change status.',0,'[     ]'),
(2,'Simple','Simple workflow with limited status.
Anyone can change status.',0,'[      ]'),
(3,'External validation','Elaborated workflow with internal team treatment and external validation.',0,'[      ]'),
(4,'External acceptation & validation','Elaborated workflow with external acceptation, internal team treatment and external validation.',0,'[     ]');


INSERT INTO `${prefix}workflowstatus` (idWorkflow,idStatusFrom,idStatusTo,idProfile,allowed) VALUES 
(0,1,8,1,1),
(0,1,8,2,1),
(0,1,8,3,1),
(3,1,2,4,1),
(1,1,11,3,1),
(1,1,11,4,1),
(1,1,11,6,1),
(1,1,11,7,1),
(1,1,11,5,1),
(1,1,10,1,1),
(1,1,10,2,1),
(1,1,10,3,1),
(1,1,10,4,1),
(1,1,10,6,1),
(1,1,10,7,1),
(1,1,10,5,1),
(1,1,11,1,1),
(1,1,11,2,1),
(1,2,10,1,1),
(1,2,3,1,1),
(1,2,3,2,1),
(1,2,3,3,1),
(1,2,3,4,1),
(1,2,3,6,1),
(1,2,3,7,1),
(1,2,3,5,1),
(2,1,10,1,1),
(2,1,10,2,1),
(2,1,10,3,1),
(2,1,10,4,1),
(2,1,10,6,1),
(2,1,10,7,1),
(2,1,10,5,1),
(1,1,3,1,1),
(1,1,3,4,1),
(1,1,4,3,1),
(1,1,2,3,1),
(1,1,2,7,1),
(1,1,4,2,1),
(1,1,3,2,1),
(1,1,3,7,1),
(1,1,3,3,1),
(1,1,4,4,1),
(1,1,4,1,1),
(1,1,4,7,1),
(3,1,10,3,1),
(3,1,10,4,1),
(3,1,3,3,1),
(3,1,3,4,1),
(5,1,8,1,1),
(5,1,8,2,1),
(5,1,8,3,1),
(5,1,8,4,1),
(5,1,8,6,1),
(5,1,8,7,1),
(5,1,8,5,1),
(5,1,10,1,1),
(5,1,10,2,1),
(5,1,10,3,1),
(5,1,10,4,1),
(5,1,10,6,1),
(5,1,10,7,1),
(5,1,10,5,1),
(5,1,5,1,1),
(5,1,5,2,1),
(5,1,5,3,1),
(5,1,5,4,1),
(5,1,5,6,1),
(5,1,5,7,1),
(5,1,5,5,1),
(1,4,5,2,1),
(1,4,5,3,1),
(1,4,5,4,1),
(1,4,5,6,1),
(1,4,5,7,1),
(1,4,5,5,1),
(1,1,2,1,1),
(1,1,2,2,1),
(1,1,2,4,1),
(1,1,2,6,1),
(1,1,2,5,1),
(1,1,3,6,1),
(1,1,3,5,1),
(1,1,4,6,1),
(1,1,4,5,1),
(1,1,9,1,1),
(1,1,9,2,1),
(1,1,9,3,1),
(1,1,9,4,1),
(1,1,9,6,1),
(1,1,9,7,1),
(1,1,9,5,1),
(1,2,11,1,1),
(1,2,11,2,1),
(1,2,11,3,1),
(1,2,11,4,1),
(1,2,11,6,1),
(1,2,11,7,1),
(1,2,11,5,1),
(1,2,10,2,1),
(1,2,10,3,1),
(1,2,10,4,1),
(1,2,10,6,1),
(1,2,10,7,1),
(1,2,10,5,1),
(1,2,4,1,1),
(1,2,4,2,1),
(1,2,4,3,1),
(1,2,4,4,1),
(1,2,4,6,1),
(1,2,4,7,1),
(1,2,4,5,1),
(1,2,9,1,1),
(1,2,9,2,1),
(1,2,9,3,1),
(1,2,9,4,1),
(1,2,9,6,1),
(1,2,9,7,1),
(1,2,9,5,1),
(1,11,10,1,1),
(1,11,10,2,1),
(1,11,10,3,1),
(1,11,10,4,1),
(1,11,10,6,1),
(1,11,10,7,1),
(1,11,10,5,1),
(1,11,3,1,1),
(1,11,3,2,1),
(1,11,3,3,1),
(1,11,3,4,1),
(1,11,3,6,1),
(1,11,3,7,1),
(1,11,3,5,1),
(1,11,4,1,1),
(1,11,4,2,1),
(1,11,4,3,1),
(1,11,4,4,1),
(1,11,4,6,1),
(1,11,4,7,1),
(1,11,4,5,1),
(1,11,9,1,1),
(1,11,9,2,1),
(1,11,9,3,1),
(1,11,9,4,1),
(1,11,9,6,1),
(1,11,9,7,1),
(1,11,9,5,1),
(1,8,10,1,1),
(1,8,10,2,1),
(1,8,10,3,1),
(1,8,10,4,1),
(1,8,10,6,1),
(1,8,10,7,1),
(1,8,10,5,1),
(1,8,3,1,1),
(1,8,3,2,1),
(1,8,3,3,1),
(1,8,3,4,1),
(1,8,3,6,1),
(1,8,3,7,1),
(1,8,3,5,1),
(1,8,4,1,1),
(1,8,4,2,1),
(1,8,4,3,1),
(1,8,4,4,1),
(1,8,4,6,1),
(1,8,4,7,1),
(1,8,4,5,1),
(1,8,5,1,1),
(1,8,5,2,1),
(1,8,5,3,1),
(1,8,5,4,1),
(1,8,5,6,1),
(1,8,5,7,1),
(1,8,5,5,1),
(1,8,6,1,1),
(1,8,6,2,1),
(1,8,6,3,1),
(1,8,6,4,1),
(1,8,6,6,1),
(1,8,6,7,1),
(1,8,6,5,1),
(1,8,12,1,1),
(1,8,12,2,1),
(1,8,12,3,1),
(1,8,12,4,1),
(1,8,12,6,1),
(1,8,12,7,1),
(1,8,12,5,1),
(1,8,7,1,1),
(1,8,7,2,1),
(1,8,7,3,1),
(1,8,7,4,1),
(1,8,7,6,1),
(1,8,7,7,1),
(1,8,7,5,1),
(1,8,9,1,1),
(1,8,9,2,1),
(1,8,9,3,1),
(1,8,9,4,1),
(1,8,9,6,1),
(1,8,9,7,1),
(1,8,9,5,1),
(1,10,3,1,1),
(1,10,3,2,1),
(1,10,3,3,1),
(1,10,3,4,1),
(1,10,3,6,1),
(1,10,3,7,1),
(1,10,3,5,1),
(1,10,4,1,1),
(1,10,4,2,1),
(1,10,4,3,1),
(1,10,4,4,1),
(1,10,4,6,1),
(1,10,4,7,1),
(1,10,4,5,1),
(1,10,9,1,1),
(1,10,9,2,1),
(1,10,9,3,1),
(1,10,9,4,1),
(1,10,9,6,1),
(1,10,9,7,1),
(1,10,9,5,1),
(1,3,4,1,1),
(1,3,4,2,1),
(1,3,4,3,1),
(1,3,4,4,1),
(1,3,4,6,1),
(1,3,4,7,1),
(1,3,4,5,1),
(1,3,9,1,1),
(1,3,9,2,1),
(1,3,9,3,1),
(1,3,9,4,1),
(1,3,9,6,1),
(1,3,9,7,1),
(1,3,9,5,1),
(1,4,8,1,1),
(1,4,8,2,1),
(1,4,8,3,1),
(1,4,8,4,1),
(1,4,8,6,1),
(1,4,8,7,1),
(1,4,8,5,1),
(1,4,5,1,1),
(1,4,6,1,1),
(1,4,6,2,1),
(1,4,6,3,1),
(1,4,6,4,1),
(1,4,6,6,1),
(1,4,6,7,1),
(1,4,6,5,1),
(1,4,12,1,1),
(1,4,12,2,1),
(1,4,12,3,1),
(1,4,12,4,1),
(1,4,12,6,1),
(1,4,12,7,1),
(1,4,12,5,1),
(1,4,7,1,1),
(1,4,7,2,1),
(1,4,7,3,1),
(1,4,7,4,1),
(1,4,7,6,1),
(1,4,7,7,1),
(1,4,7,5,1),
(1,5,8,1,1),
(1,5,8,2,1),
(1,5,8,3,1),
(1,5,8,4,1),
(1,5,8,6,1),
(1,5,8,7,1),
(1,5,8,5,1),
(1,5,6,1,1),
(1,5,6,2,1),
(1,5,6,3,1),
(1,5,6,4,1),
(1,5,6,6,1),
(1,5,6,7,1),
(1,5,6,5,1),
(1,5,12,1,1),
(1,5,12,2,1),
(1,5,12,3,1),
(1,5,12,4,1),
(1,5,12,6,1),
(1,5,12,7,1),
(1,5,12,5,1),
(1,5,7,1,1),
(1,5,7,2,1),
(1,5,7,3,1),
(1,5,7,4,1),
(1,5,7,6,1),
(1,5,7,7,1),
(1,5,7,5,1),
(1,6,8,1,1),
(1,6,8,2,1),
(1,6,8,3,1),
(1,6,8,4,1),
(1,6,8,6,1),
(1,6,8,7,1),
(1,6,8,5,1),
(1,6,12,1,1),
(1,6,12,2,1),
(1,6,12,3,1),
(1,6,12,4,1),
(1,6,12,6,1),
(1,6,12,7,1),
(1,6,12,5,1),
(1,6,7,1,1),
(1,6,7,2,1),
(1,6,7,3,1),
(1,6,7,4,1),
(1,6,7,6,1),
(1,6,7,7,1),
(1,6,7,5,1),
(1,12,8,1,1),
(1,12,8,2,1),
(1,12,8,3,1),
(1,12,8,4,1),
(1,12,8,6,1),
(1,12,8,7,1),
(1,12,8,5,1),
(1,12,7,1,1),
(1,12,7,2,1),
(1,12,7,3,1),
(1,12,7,4,1),
(1,12,7,6,1),
(1,12,7,7,1),
(1,12,7,5,1),
(1,7,8,1,1),
(1,7,8,2,1),
(1,7,8,3,1),
(1,7,8,4,1),
(1,7,8,6,1),
(1,7,8,7,1),
(1,7,8,5,1),
(1,9,8,1,1),
(1,9,8,2,1),
(1,9,8,3,1),
(1,9,8,4,1),
(1,9,8,6,1),
(1,9,8,7,1),
(1,9,8,5,1),
(2,1,9,1,1),
(2,1,9,2,1),
(2,1,9,3,1),
(2,1,9,4,1),
(2,1,9,6,1),
(2,1,9,7,1),
(2,1,9,5,1),
(2,8,10,1,1),
(2,8,10,2,1),
(2,8,10,3,1),
(2,8,10,4,1),
(2,8,10,6,1),
(2,8,10,7,1),
(2,8,10,5,1),
(2,8,9,1,1),
(2,8,9,2,1),
(2,8,9,3,1),
(2,8,9,4,1),
(2,8,9,6,1),
(2,8,9,7,1),
(2,8,9,5,1),
(2,10,3,1,1),
(2,10,3,2,1),
(2,10,3,3,1),
(2,10,3,4,1),
(2,10,3,6,1),
(2,10,3,7,1),
(2,10,3,5,1),
(2,10,9,1,1),
(2,10,9,2,1),
(2,10,9,3,1),
(2,10,9,4,1),
(2,10,9,6,1),
(2,10,9,7,1),
(2,10,9,5,1),
(2,3,4,1,1),
(2,3,4,2,1),
(2,3,4,3,1),
(2,3,4,4,1),
(2,3,4,6,1),
(2,3,4,7,1),
(2,3,4,5,1),
(2,3,9,1,1),
(2,3,9,2,1),
(2,3,9,3,1),
(2,3,9,4,1),
(2,3,9,6,1),
(2,3,9,7,1),
(2,3,9,5,1),
(2,4,8,1,1),
(2,4,8,2,1),
(2,4,8,3,1),
(2,4,8,4,1),
(2,4,8,6,1),
(2,4,8,7,1),
(2,4,8,5,1),
(2,4,7,1,1),
(2,4,7,2,1),
(2,4,7,3,1),
(2,4,7,4,1),
(2,4,7,6,1),
(2,4,7,7,1),
(2,4,7,5,1),
(2,7,8,1,1),
(2,7,8,2,1),
(2,7,8,3,1),
(2,7,8,4,1),
(2,7,8,6,1),
(2,7,8,7,1),
(2,7,8,5,1),
(2,9,8,1,1),
(2,9,8,2,1),
(2,9,8,3,1),
(2,9,8,4,1),
(2,9,8,6,1),
(2,9,8,7,1),
(2,9,8,5,1),
(3,1,2,3,1),
(3,1,9,3,1),
(3,1,9,4,1),
(3,2,10,3,1),
(3,2,10,4,1),
(3,2,3,3,1),
(3,2,3,4,1),
(3,2,9,3,1),
(3,2,9,4,1),
(3,8,10,3,1),
(3,8,10,4,1),
(3,8,3,3,1),
(3,8,3,4,1),
(3,8,9,3,1),
(3,8,9,4,1),
(3,10,3,3,1),
(3,10,3,4,1),
(3,10,9,3,1),
(3,10,9,4,1),
(3,3,4,3,1),
(3,3,4,4,1),
(3,3,9,3,1),
(3,3,9,4,1),
(3,4,3,3,1),
(3,4,3,4,1),
(3,4,5,3,1),
(3,4,5,4,1),
(3,4,6,3,1),
(3,5,6,3,1),
(3,6,8,6,1),
(3,6,8,7,1),
(3,6,12,6,1),
(3,6,12,7,1),
(3,12,7,3,1),
(3,12,7,4,1),
(3,12,7,6,1),
(3,12,7,7,1),
(3,7,8,3,1),
(3,7,8,4,1),
(3,7,8,6,1),
(3,7,8,7,1),
(3,9,8,3,1),
(3,9,8,4,1),
(3,9,8,6,1),
(3,9,8,7,1),
(4,1,2,3,1),
(4,1,2,4,1),
(4,2,11,6,1),
(4,2,11,7,1),
(4,2,9,6,1),
(4,2,9,7,1),
(4,11,10,3,1),
(4,11,10,4,1),
(4,11,3,3,1),
(4,11,3,4,1),
(4,8,10,3,1),
(4,8,10,4,1),
(4,8,3,3,1),
(4,8,3,4,1),
(4,10,3,3,1),
(4,10,3,4,1),
(4,3,4,3,1),
(4,3,4,4,1),
(4,11,2,3,1),
(4,4,5,3,1),
(4,4,5,4,1),
(4,5,6,3,1),
(4,4,10,3,1),
(4,4,10,4,1),
(4,4,3,3,1),
(4,4,3,4,1),
(4,6,8,6,1),
(4,6,8,7,1),
(4,6,12,6,1),
(4,6,12,7,1),
(4,12,7,3,1),
(4,12,7,4,1),
(4,12,7,6,1),
(4,12,7,7,1),
(4,7,8,3,1),
(4,7,8,6,1),
(4,9,8,6,1);

UPDATE `${prefix}type` set idWorkflow='1';
