<?php  
/**
 * Set language short cooe here (ISO 639-1 Code)
 * See Language Code Reference 
 * http://www.w3schools.com/tags/ref_language_codes.asp
 */
define('APP_LANGUAGE_SHORT_CODE','ru'); 

/**
 * Set the text direction: (ltr or rtl)
 * ltr - the writing direction is left-to-right. This is default
 * rtl - the writing direction is right-to-left
 */
define('APP_LANGUAGE_TEXT_DIRECTION','ltr');

define('TEXT_FIELDTYPE_INPUT_TITLE','Поле ввода');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_TITLE','Числовое поле');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_COMMENTS_TITLE','Числовое поле в комментариях');
define('TEXT_FIELDTYPE_INPUT_URL_TITLE','Поле для URL');
define('TEXT_FIELDTYPE_INPUT_DATE_TITLE','Дата с календарем');
define('TEXT_FIELDTYPE_INPUT_DATETIME_TITLE','Дата с календарем и выбором времени');
define('TEXT_FIELDTYPE_INPUT_FILE_TITLE','Поле для загрузки файла');
define('TEXT_FIELDTYPE_ATTACHMENTS_TITLE','Вложения');
define('TEXT_FIELDTYPE_TEXTAREA_TITLE','Поле для текста');
define('TEXT_FIELDTYPE_TEXTAREA_WYSIWYG_TITLE','Поле для текста с редактором');
define('TEXT_FIELDTYPE_DROPDOWN_TITLE','Выпадающий список');
define('TEXT_FIELDTYPE_DROPDOWN_MULTIPLE_TITLE','Выпадающий список с выбором нескольких значений');
define('TEXT_FIELDTYPE_CHECKBOXES_TITLE','Флажки');
define('TEXT_FIELDTYPE_RADIOBOXES_TITLE','Переключатели');
define('TEXT_FIELDTYPE_FORMULA_TITLE','MySQL Формула');
define('TEXT_FIELDTYPE_USERS_TITLE','Пользователи');
define('TEXT_FIELDTYPE_GROUPEDUSERS_TITLE','Группа пользователей');
define('TEXT_FIELDTYPE_ENTITY_TITLE','Сущность');
define('TEXT_FIELDTYPE_ACTION_TITLE','Действие');
define('TEXT_FIELDTYPE_ID_TITLE','ID');
define('TEXT_FIELDTYPE_DATEADDED_TITLE','Дата добавления');
define('TEXT_FIELDTYPE_CREATEDBY_TITLE','Создано');
define('TEXT_FIELDTYPE_USER_STATUS_TITLE','Статус пользователя');
define('TEXT_FIELDTYPE_USER_ACCESSGROUP_TITLE','Группа доступа');
define('TEXT_FIELDTYPE_USER_FIRSTNAME_TITLE','Имя');
define('TEXT_FIELDTYPE_USER_LASTNAME_TITLE','Фамилия');
define('TEXT_FIELDTYPE_USER_EMAIL_TITLE','E-mail');
define('TEXT_FIELDTYPE_USER_PHOTO_TITLE','Фото');
define('TEXT_FIELDTYPE_USER_LANGUAGE_TITLE','Язык');
define('TEXT_FIELDTYPE_USER_USERNAME_TITLE','Имя пользователя');
define('TEXT_FIELDTYPE_USER_PASSWORD_TITLE','Пароль');
define('TEXT_FIELDTYPE_USER_SKIN_TITLE','Внешний вид');
define('TEXT_FIELDTYPE_PROGRESS_TITLE','Прогресс');

define('TEXT_FIELDTYPE_INPUT_TOOLTIP','Простое текстовое поле ввода');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_TOOLTIP','Это поле используется для чисел');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_COMMENTS_TOOLTIP','Данное поле предназначено для отображения в комментариях. Значение этого поля равно сумме введеных чисел в комментариях.');
define('TEXT_FIELDTYPE_INPUT_URL_TOOLTIP','Текстовое поле для URL-адресов. Значение поля будет автоматически преобразовываться в URL');
define('TEXT_FIELDTYPE_INPUT_DATE_TOOLTIP','Календарь будет автоматически добавлен к этому полю');
define('TEXT_FIELDTYPE_INPUT_DATETIME_TOOLTIP','Календарь с выбором времени будет автоматически добавлен к этому полю');
define('TEXT_FIELDTYPE_INPUT_FILE_TOOLTIP','Позволяет загрузить один файл');
define('TEXT_FIELDTYPE_ATTACHMENTS_TOOLTIP','Позволяет загружать несколько файлов сразу');
define('TEXT_FIELDTYPE_TEXTAREA_TOOLTIP','Многострочное поле для текста');
define('TEXT_FIELDTYPE_TEXTAREA_WYSIWYG_TOOLTIP','Визуальный редактор будет автоматически добавлен к этому полю');
define('TEXT_FIELDTYPE_DROPDOWN_TOOLTIP','Выпадающий список с опциями, которые можно определить, нажав на имя поля в списке полей.');
define('TEXT_FIELDTYPE_DROPDOWN_MULTIPLE_TOOLTIP','Выдающий список с живым поиском и возможностью выбора нескольких значений.');
define('TEXT_FIELDTYPE_CHECKBOXES_TOOLTIP','Флажки с опциями, которые можно определить, нажав на имя поля в списке полей.');
define('TEXT_FIELDTYPE_RADIOBOXES_TOOLTIP','Переключатели с опциями, которые можно определить, нажав на имя поля в списке полей.');
define('TEXT_FIELDTYPE_FORMULA_TOOLTIP','Значение этого поля будет рассчитываться по формуле, указанной ниже.');
define('TEXT_FIELDTYPE_USERS_TOOLTIP','Специальное поле позволяет назначать пользователей к элементам и настраивать доступ пользователей к элементам.');
define('TEXT_FIELDTYPE_GROUPEDUSERS_TOOLTIP','Специальное поле, позволяющее назначать группу пользователей к элементам и настраивать доступ пользователей к элементам.');
define('TEXT_FIELDTYPE_ENTITY_TOOLTIP','Специальное поле, позволяющее связывать элементы с существующей сущностью.');
define('TEXT_FIELDTYPE_USER_PASSWORD_TOOLTIP','Оставьте поле пустым, и пароль будет сгенерирован автоматически.');
define('TEXT_FIELDTYPE_PROGRESS_TOOLTIP','Автоматически создает список от 1 до 100');

define('TEXT_BUTTON_LOGIN','Вход');
define('TEXT_BUTTON_SAVE','Сохранить');
define('TEXT_BUTTON_CLOSE','Закрыть');
define('TEXT_BUTTON_EDIT','Редактировать');
define('TEXT_BUTTON_DELETE','Удалить');
define('TEXT_BUTTON_CHANGE','Изменить');
define('TEXT_BUTTON_ADD_FORM_TAB','Добавить новую вкладку');
define('TEXT_BUTTON_SORT_FORM_TAB','Сортировать вкладки');
define('TEXT_BUTTON_PREVIEW_FORM','Предварительный просмотр формы');
define('TEXT_BUTTON_ADD_NEW_FIELD','Добавить новое поле');
define('TEXT_BUTTON_ADD_NEW_VALUE','Добавить значение');
define('TEXT_BUTTON_RESTORE_PASSWORD','Восстановить пароль');
define('TEXT_BUTTON_SEARCH','Поиск');
define('TEXT_BUTTON_CREATE_BACKUP','Создать резервную копию');
define('TEXT_BUTTON_DOWNLOAD','Скачать');
define('TEXT_BUTTON_RESTORE','Восстановить');
define('TEXT_BUTTON_ADD_COMMENT','Добавить комментарий');
define('TEXT_BUTTON_ADD_NEW_REPORT','Добавить отчет');
define('TEXT_BUTTON_CONFIGURE_FILTERS','Фильтры');
define('TEXT_BUTTON_CONFIGURE_SORTING','Сортировка');
define('TEXT_BUTTON_ADD_NEW_REPORT_FILTER','Добавить фильтр');
define('TEXT_BUTTON_CREATE_SUB_VALUE','Добавить вложенное значение');
define('TEXT_BUTTON_REMOVE_ALL_FILTERS','Удалить все фильтры');
define('TEXT_BUTTON_REMOVE_FILTER','Удалить фильтр');
define('TEXT_BUTTON_CONTINUE','Продолжить');
define('TEXT_BUTTON_IMPORT','Импорт');
define('TEXT_BUTTON_BIND','Связать');
define('TEXT_BUTTON_CREATE','Создать');

define('TEXT_ERROR','Ошибка:');
define('TEXT_ERROR_GENERAL','Некоторые поля обязательны для заполнения. Они отмечены выше.');
define('TEXT_ERROR_REQUIRED','Это поле обязательно для заполнения!');
define('TEXT_ERROR_FILE_EXTENSION','Этот тип файла не допускается');
define('TEXT_ERROR_REQUIRED_NUMBER','Пожалуйста, введите число.');
define('TEXT_ERROR_USEREMAL_EXIST','E-mail уже существует!');
define('TEXT_ERROR_USERNAME_EXIST','Имя пользователя уже существует!');
define('TEXT_ERROR_USEREMAL_EMPTY','E-mail пользователя не может быт пустым');
define('TEXT_ERROR_USERNAME_EMPTY','Имя пользователя не может быт пустым');
define('TEXT_ERROR_FORMULA_CALCULATION','Сущность "%s". Поле "%s" [%s]. Ошибка расчета формулы "%s".');
define('TEXT_ERROR_USER_DELETE','Вы не можете удалить собственный аккаунт');
define('TEXT_ERROR_PASSOWRD_CONFIRMATION','Подтверждение пароля должно совпадать с вашим паролем');
define('TEXT_ERROR_PASSOWRD_LENGTH','Ваш пароль должен содержать не менее ' . CFG_PASSWORD_MIN_LENGTH . ' символов.');
define('TEXT_ERROR_DEFAULT_LDAP_GROUP','Группа доступа для пользователей LDAP не настроена. LDAP вход не разрешен.');
define('TEXT_ERROR_ITEM_HAS_SUB_ITEM','Вы не можете удалить данный элемент, потому что он имеет вложенные элементы в сущностях: %s');
define('TEXT_ERROR_DELETE_USER_GROUP','Вы не можете удалить эту группу, потому что %s пользователи назначенные на эту группу');

define('TEXT_MENU_DASHBOARD','Главная');
define('TEXT_MENU_LOGIN','Вход');
define('TEXT_MENU_LDAP_LOGIN','LDAP Вход');
define('TEXT_MENU_CONFIGURATION','Настройки');
define('TEXT_MENU_COMMON_SETTINGS','Общие настройки');
define('TEXT_MENU_APPLICATION','Приложение');
define('TEXT_MENU_EMAIL_OPTIONS','Электронная почта');
define('TEXT_MENU_LDAP','LDAP');
define('TEXT_MENU_LOGIN_PAGE','Страница входа');
define('TEXT_MENU_APPLICATION_STRUCTURE','Структура приложения');
define('TEXT_MENU_USERS_ACCESS_GROUPS','Группы пользователей');
define('TEXT_MENU_TOOLS','Инструменты');
define('TEXT_MENU_BACKUP','Резервное копирование базы данных');
define('TEXT_MENU_SERVER_INFO','О сервере');
define('TEXT_MENU_SUPPORT','Поддержка');
define('TEXT_MENU_REPORT_FORUM','Форум');
define('TEXT_MENU_CONTACT_US','Контакты');
define('TEXT_MENU_ENTITIES_LIST','Сущности приложения'); 
define('TEXT_MENU_IMPORT_DATA','Импорт данных');
define('TEXT_MENU_CHECK_VERSION','Проверка версии');
define('TEXT_MENU_EXTENSION','Дополнение');

define('TEXT_HEADING_LDAP','Настройка LDAP');
define('TEXT_LDAP_USE','Использовать LDAP');
define('TEXT_LDAP_SERVER_NAME','Имя сервера LDAP');
define('TEXT_LDAP_SERVER_NAME_NOTES','Если используется LDAP, укажите хост или IP-адрес сервера LDAP. Кроме этого, вы можете указать ссылку. Например, ldap://hostname:port/.');
define('TEXT_LDAP_SERVER_PORT','Порт сервера LDAP');
define('TEXT_LDAP_SERVER_PORT_NOTES','Вы можете указать порт, который должен использоваться для соединения с сервером LDAP вместо порта по умолчанию 389.');
define('TEXT_LDAP_BASE_DN','Основное имя LDAP [ <var>dn</var> ]');
define('TEXT_LDAP_BASE_DN_NOTES','Уникальное имя (Distinguished Name), определяющее информацию о пользователе, например <samp>o=My Company,c=US</samp>.');  
define('TEXT_LDAP_UID','Идентификационный номер LDAP [ <var>uid</var> ]');
define('TEXT_LDAP_UID_NOTES','Это ключ, с помощью которого производится поиск заданного идентификатора входа в систему. Например, <var>uid</var>, <var>sn</var> и так далее.');
define('TEXT_LDAP_USER_FILTER','Фильтр имени пользователя LDAP');
define('TEXT_LDAP_USER_FILTER_NOTES','В дальнейшем вы можете ограничить диапазон искомых объектов с помощью дополнительных фильтров.<br>Например, результатом <samp>objectClass=posixGroup</samp> будет <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp>.<br>Фильтр проверки принадлежности к группе: (memberOf=cn=TestGroup,cn=Users,dc=MyCompany,dc=org)');
define('TEXT_LDAP_EMAIL_ATTRIBUTE','E-mail атрибут LDAP');
define('TEXT_LDAP_EMAIL_ATTRIBUTE_NOTES','Задайте имя атрибута E-mail пользователя (если он существует) для автоматического присвоения E-mail адресов новым пользователям. Если это поле оставить пустым, то E-mail адреса пользователей, которые впервые вошли на конференцию, также будут пустыми.');
define('TEXT_LDAP_USER_DN','Пользователь LDAP [ <var>dn</var> ]');
define('TEXT_LDAP_USER_DN_NOTES','Оставьте поле пустым для использования анонимного соединения. Если поле заполнено, приложение использует указанное имя при соединении с сервером LDAP для поиска правильного пользователя. Например, <samp>uid=Username,ou=MyUnit,o=MyCompany,c=US</samp>. Требуется для серверов Active Directory.');
define('TEXT_LDAP_PASSWORD','Пароль LDAP');
define('TEXT_LDAP_PASSWORD_NOTES','Оставьте поле пустым для использования анонимного соединения. В противном случае введите пароль для вышеуказанного пользователя. Требуется для серверов Active Directory.<br /><em><strong>Внимание:</strong> этот пароль будет сохранён в базе данных в незашифрованном виде и будет виден всем, кто имеет доступ к базе или к этой странице настроек.</em>');
define('TEXT_LDAP_IS_NOT_ENABLED','LDAP не включен');
define('TEXT_LDAP_ERROR_NOT_AVAILABLE','PHP LDAP расширение не доступно.Проверьте конфигурацию сервера.');
define('TEXT_LDAP_ERROR_CONNECTION','Не удается подключиться к LDAP-серверу.');
define('TEXT_LDAP_ERROR_BINDING','Ошибка соединения с сервером при использовании указанных имя пользователя и пароля.');
define('TEXT_LDAP_ERROR_INCORRECT_PASSWORD','Вы указали неверный пароль. Пожалуйста, проверьте пароль и попробуйте еще раз.');
define('TEXT_LDAP_ERROR_INCORRECT_USERNAME','Вы указали неверное имя пользователя. Пожалуйста, проверьте свои имя и повторите попытку.');

define('TEXT_HEADING_EMAIL_OPTIONS','Параметры электронной почты');  
define('TEXT_EMAIL_USE_NOTIFICATION','Использовать уведомление по электронной почте ');
define('TEXT_EMAIL_SUBJECT_LABEL','Ярлык для темы письма');
define('TEXT_EMAIL_AMOUNT_PREVIOUS_COMMENTS','Количество комментариев в письме');
define('TEXT_EMAIL_COPY_SENDER','Отсылать копию письма отправителю');
define('TEXT_EMAIL_SEND_FROM_SINGLE','Отправлять все письма с адреса тех. поддержки');
define('TEXT_EMAIL_ADDRESS_FROM','Адрес электронной почты');
define('TEXT_EMAIL_NAME_FROM','Имя');
define('TEXT_EMAIL_USE_SMTP','Использовать SMTP');
define('TEXT_EMAIL_SMTP_SERVER','SMTP сервер');
define('TEXT_EMAIL_SMTP_PORT','SMTP порт');
define('TEXT_EMAIL_SMTP_ENCRYPTION','SMTP шифрование');
define('TEXT_EMAIL_SMTP_LOGIN','SMTP Вход');
define('TEXT_EMAIL_SMTP_PASSWORD','SMTP пароль');    
define('TEXT_EMAIL_SMTP_CONFIGURATION','Настройки SMTP');
define('TEXT_HEADING_USER_REGISTRATION_EMAIL','Шаблон письма для регистрации нового пользователя');
define('TEXT_MENU_USER_REGISTRATION_EMAIL','Новый пользователь');
define('TEXT_NEW_USER_DEFAULT_EMAIL_SUBJECT','Ваша учетная запись была создана в  ' . CFG_APP_NAME);
define('TEXT_REGISTRATION_EMAIL_SUBJECT','Тема:');
define('TEXT_REGISTRATION_EMAIL_SUBJECT_NOTE','Тема по умолчанию: "' . TEXT_NEW_USER_DEFAULT_EMAIL_SUBJECT);
define('TEXT_REGISTRATION_EMAIL_BODY','Текст письма:');
define('TEXT_REGISTRATION_EMAIL_BODY_NOTE','Данные для входа будут автоматически включены в нижнюю часть письма');

define('TEXT_NAV_ENTITY','Сущность');
define('TEXT_NAV_GENERAL_CONFIG','Общая конфигурация');
define('TEXT_NAV_FIELDS_CONFIG','Конфигурация полей');
define('TEXT_NAV_FIELDS_CHOICES_CONFIG','Опции');
define('TEXT_NAV_VIEW_CONFIG','Настройка отображения');
define('TEXT_NAV_FORM_CONFIG','Настройка формы');
define('TEXT_NAV_LISTING_CONFIG','Настройка списка');
define('TEXT_NAV_LISTING_FILTERS_CONFIG','Фильтры по умолчанию');
define('TEXT_NAV_USER_PUBLIC_PROFILE_CONFIG','Публичный профиль');
define('TEXT_NAV_ACCESS_CONFIG','Доступ');
define('TEXT_NAV_ENTITY_ACCESS','Настройка доступа');
define('TEXT_NAV_FIELDS_ACCESS','Доступ к полям');
define('TEXT_NAV_SWITCH','Переключиться к');
define('TEXT_NAV_COMMENTS_CONFIG','Настройка комментариев');
define('TEXT_NAV_COMMENTS_ACCESS','Доступ к комментариям');
define('TEXT_NAV_COMMENTS_FIELDS','Форма комментариев');
define('TEXT_NAV_COMMENTS_FORM_CONFIG','Настройка формы комментариев');

define('TEXT_USERNAME','Имя пользователя');
define('TEXT_PASSWORD','Пароль');
define('TEXT_ARE_YOU_SURE','Вы уверены?');
define('TEXT_CONFIGURATION','Конфигурация');
define('TEXT_WARNING','Предупреждение');
define('TEXT_DELETE','Удалить');
define('TEXT_YES','Да');
define('TEXT_NO','Нет');
define('TEXT_NAME','Имя');
define('TEXT_DESCRIPTION','Описание');
define('TEXT_SORT_ORDER','Сортировка');
define('TEXT_HEADING_DELETE','Удалить?');
define('TEXT_DEFAULT_DELETE_CONFIRMATION','Вы уверены, что хотите удалить "%s"?');
define('TEXT_NO_RECORDS_FOUND','Записей не найдено');
define('TEXT_DISPLAY_NUMBER_OF_ITEMS', 'Отображено <nobr><strong>%s</strong> - <strong>%s</strong></nobr> <nobr>(всего <strong>%s</strong>)</nobr>');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Предыдущая страница');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Следующая страница');
define('PREVNEXT_TITLE_PAGE_NO', 'Страница %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Предыдущие %d страниц');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Следующие %d страниц');
define('TEXT_WARN_DELETE_SUCCESS','Запись <b>%s</b> была успешно удалена');
define('TEXT_WIDHT','Ширина');
define('TEXT_HEIGHT','Высота');
define('TEXT_ADD','Добавить');
define('TEXT_VIEW_ALL','Показать все');
define('TEXT_INFO','Информация');
define('TEXT_ACTION','Действие');
define('TEXT_ID','#');
define('TEXT_DATE_ADDED','Дата добавления');
define('TEXT_CREATED_BY','Создано');
define('TEXT_SEARCH','Поиск');
define('TEXT_SEARCH_RESULT_FOR','Поиск по: <b>%s</b>');
define('TEXT_ACTIVE','Активный');
define('TEXT_INACTIVE','Неактивный');
define('TEXT_IS_DEFAULT','По умолчанию?');
define('TEXT_IS_LDAP_DEFAULT','По умолчанию для LDAP?');
define('TEXT_ADMINISTRATOR','Администратор');

define('TEXT_LOGIN_DETAILS','Детали для входа'); 
define('TEXT_MY_ACCOUNT','Личный кабинет');
define('TEXT_CHANGE_PASSWORD','Изменить пароль');
define('TEXT_LOGOFF','Выход');
define('TEXT_EMAIL','E-mail');
define('TEXT_ENTITIES_HEADING','Сущности приложения');
define('TEXT_ADD_NEW_ENTITY','Добавить новую сущность');
define('TEXT_HEADING_ENTITY_IFNO','Информация о сущности');
define('TEXT_HEADING_ENTITY_CONFIGURATION','Конфигурация сущности');
define('TEXT_HEADING_NEW_FORM_TAB','Новая вкладка формы');
define('TEXT_HEADING_EDIT_FORM_TAB','Редактировать вкладку формы');
define('TEXT_CREATE_SUB_ENTITY','Создать вложенную сущность');
define('TEXT_LISTING_CFG_INFO','Просто переместите поля между боксами для включения или исключения полей в списке');
define('TEXT_FIELDS_IN_LISTING','Поля в списке');
define('TEXT_FIELDS_EXCLUDED_FROM_LISTING','Исключены из списка');
define('TEXT_WARN_DELETE_ENTITY_USERS','Вы не можете удалить сущность <b>%s</b>, потому что это зарезервированная сущность');
define('TEXT_WARN_DELETE_ENTITY_HAS_PARENT','Вы не можете удалить сущность <b>%s</b>, потому что она имеет вложенные сущности. Удалите сначала вложенные сущности.');
define('TEXT_WARN_DELETE_ENTITY_HAS_ITEMS','Вы не можете удалить сущность <b>%s</b>, потому что есть добавленные данные. Удалите все данные для этой сущности.');
define('TEXT_WARN_DELETE_FROM_TAB','Вы не можете удалить вкладку формы <b>%s</b> с полями.<br> Переместите поля на другую вкладку формы.');
define('TEXT_TITLES','Заголовки');
define('TEXT_MENU_TITLE','Название меню');
define('TEXT_MENU_TITLE_TOOLTIP','Это значение будет использоваться в главном навигационном меню.');
define('TEXT_LISTING_HEADING','Заголовок списка');
define('TEXT_LISTING_HEADING_TOOLTIP','Это значение будет использоваться в списке элементов.');
define('TEXT_WINDOW_HEADING','Заголовок окна');
define('TEXT_WINDOW_HEADING_TOOLTIP','Это значение будет использоваться во всплывающем окне при вставке или редактировании элемента.');
define('TEXT_INSERT_BUTTON_TITLE','Кнопка добавления');
define('TEXT_INSERT_BUTTON_TITLE_TOOLTIP','Это значение будет использоваться на кнопке для добавления элемента.');
define('TEXT_EMAIL_SUBJECT_NEW_ITEM','Тема письма для нового элемента');
define('TEXT_EMAIL_SUBJECT_NEW_ITEM_TOOLTIP','Это значение будет использоваться при создании нового элемента');
define('TEXT_EMAIL_SUBJECT_NEW_COMMENT','Тема письма для нового комментария');
define('TEXT_EMAIL_SUBJECT_NEW_COMMENT_TOOLTIP','Это значение будет использоваться при добавлении нового комментария.');
define('TEXT_DEFAULT_EMAIL_SUBJECT_NEW_ITEM','Новая запись:');
define('TEXT_DEFAULT_EMAIL_SUBJECT_NEW_COMMENT','Новый комментарий:');
define('TEXT_COMMENTS_TITLE','Комментарии');
define('TEXT_USE_COMMENTS','Использовать комментарии');
define('TEXT_USE_COMMENTS_TOOLTIP','Разрешить добавлять комментарии к элементам. Если эта опция включена, проверьте "Настройки комментариев" в меню слева.');
define('TEXT_COMMENTS_ACCESS_INFO','Настройте, какие группы пользователей буду иметь доступ к комментариям.');
define('TEXT_COMMENT_IFNO','Комментарий');
define('TEXT_COMMENT_WAS_DELETED','Комментарий был удален');
define('TEXT_COMMENTS_FORM_CFG_INFO','Вы можете настроить, какие поля будут доступны для редактирования в форме комментариев.');
define('TEXT_AVAILABLE_FIELS','Доступные поля');
define('TEXT_FIELDS_IN_COMMENTS_FORM','Поля в форме комментариев');
define('TEXT_HEADING_FIELD_IFNO','Информация о поле');
define('TEXT_GENERAL_INFO','Основная информация');
define('TEXT_FORM_TAB','Вкладка формы');
define('TEXT_TOOLTIP','Подсказка');
define('TEXT_SHORT_NAME','Краткое название');
define('TEXT_IS_HEADING','Заголовок?');
define('TEXT_IS_REQUIRED','Обязательное поле?');
define('TEXT_TYPE','Тип');
define('TEXT_REQUIRED_MESSAGE','Сообщение');
define('TEXT_FORM_TAB_INFO','Вкладка формы, на которой будет размещено поле.');
define('TEXT_FIELD_NAME_INFO','Название поля');
define('TEXT_FIELD_SHORT_NAME_INFO','Краткое название, которое будет использоваться в списке.');
define('TEXT_IS_HEADING_INFO','Если поле является заголовком, то значение этого поля будет использоваться как заголовок на странице элемента и как тема письма. Только одно поле можно установить в качестве заголовка.');
define('TEXT_FIELD_TYPE_INFO','Тип влияет на отображения поля');
define('TEXT_IS_REQUIRED_INFO','Выберите эту опцию, если поле является обязательным. По умолчанию пользователь видит сообщение: "Это поле обязательно!". Также вы можете ввести персонализированное сообщение ниже.');
define('TEXT_REQUIRED_MESSAGE_INFO','Сообщение "Это поле обязательно!" будет заменено.');
define('TEXT_TOOLTIP_INFO','Текст для подсказки');
define('TEXT_FORMULA','Формула');
define('TEXT_FORMULA_TIP','Используйте [ID поля] для установки значения поля в формуле. Пример: ([36]+[54])/2 где 36 и 54 - идентификаторы числовых полей. <a href="https://docs.rukovoditel.net.ru/index.php?p=25" target="_blank"><u>Посмотреть больше примеров</u></a>');
define('TEXT_ENTER_WIDTH','Выберите ширину поля.');
define('TEXT_INPTUT_SMALL','Небольшое поле');
define('TEXT_INPUT_MEDIUM','Среднее поле');
define('TEXT_INPUT_LARGE','Большое поле');
define('TEXT_INPUT_XLARGE','Очень большое поле');
define('TEXT_ENTER_HEIGHT','Введите высоту в пикселях (например "60") или оставьте поле пустым.');
define('TEXT_HEADING_VALUE_IFNO','Детали');
define('TEXT_BACKGROUND_COLOR','Цвет фона');
define('TEXT_PARENT','Родительский');
define('TEXT_CHOICES_PARENT_INFO','Выберите родительское значение');
define('TEXT_CHOICES_NAME_INFO','Введите имя');
define('TEXT_CHOICES_IS_DEFAULT_INFO','Это значение будет выбрано по умолчанию при создании элемента.');
define('TEXT_CHOICES_BACKGROUND_COLOR_INFO','Значение в списке будет отображаться с выбранным цветом фона');
define('TEXT_CHOICES_SORT_ORDER_INFO','Введите сортировку для значений в списке');
define('TEXT_CHOICES_USERS_INFO','Выберите пользователей, которые будут назначены к этому значению.');
define('TEXT_ALLOW_SEARCH','Использовать для поиска?');
define('TEXT_ALLOW_SEARCH_TIP','Эта опция позволяет использовать данное поле для поиска элементов');
define('TEXT_USERS_GROUPS','Группа пользователей');
define('TEXT_VIEW_ACCESS','Просмотр');
define('TEXT_VIEW_ONLY_ACCESS','Только просмотр');
define('TEXT_CREATE_ONLY_ACCESS','Только создание');
define('TEXT_CREATE_ACCESS','Создать');
define('TEXT_UPDATE_ACCESS','Обновить');
define('TEXT_DELETE_ACCESS','Удалить');
define('TEXT_VIEW_ASSIGNED_ACCESS','Просматривать только назначенные');
define('TEXT_ACCESS_UPDATED','Доступ обновлен!');
define('TEXT_ENTITY_ACCESS_INFO','На этой странице вы можете настроить доступ для каждой группы пользователей.<br>Для открытия доступа выберите опцию "Просмотр" и настройте доступ для Создания/Редактирования/Удаления.<br>Опция "Просматривать только назначенные" разрешает просматривать только те элементы, на которые назначены пользователи.');
define('TEXT_ADMINISTRATOR_FULL_ACCESS','Администратор имеет полный доступ');
define('TEXT_FIELDS','Поля');
define('TEXT_ACCESS','Доступ');
define('TEXT_HEADING_APPLICATION','Настройки приложения');
define('TEXT_APPLICATION_NAME','Название приложения');
define('TEXT_APPLICATION_SHORT_NAME','Краткое название приложения');
define('TEXT_APPLICATION_LOGO','Лого');
define('TEXT_APPLICATION_TIMEZONE','Временная зона');  
define('TEXT_ROWS_PER_PAGE','Строк на странице');
define('TEXT_DATE_FORMAT','Формат даты');
define('TEXT_DATETIME_FORMAT','Формат даты/времени');
define('TEXT_DATE_FORMAT_IFNO','больше о формате даты см. <a target="_blanck" href="http://php.net/manual/ru/function.date.php">http://php.net/manual/ru/function.date.php</a>');
define('TEXT_MIN_PASSWORD_LENGTH','Минимальная длина пароля пользователя');
define('TEXT_HEADING_LOGIN_PAGE_CONFIGURATION','Настройка страницы входа');
define('TEXT_LOGIN_PAGE_HEADING','Заголовок страницы');
define('TEXT_LOGIN_PAGE_CONTENT','Описание страницы');
define('TEXT_LOGIN_PAGE_BACKGROUND','Изображение для фона');
define('TEXT_LOGIN_PAGE_BACKGROUND_INFO','Изображение растягивается на всю ширину страницы. Рекомендуется использовать изображение 1920х1200');
define('TEXT_CONFIGURATION_UPDATED','Настройки успешно обновлены');
define('TEXT_HEADING_USER_GROUP_IFNO','Информация о группе');
define('TEXT_HEADING_USERS_ACCESS_GROUPS','Группы доступа для пользователей  ');
define('TEXT_ADD_NEW_USER_GROUP','Добавить новую группу');
define('TEXT_SORT_GROUPS','Сортировать группы');
define('TEXT_VIEW_ONLY','Только просмотр');
define('TEXT_HIDE','Скрыть');
define('TEXT_HEADING_LOGIN','Вход');
define('TEXT_HEADING_LDAP_LOGIN','LDAP Вход');
define('TEXT_HEADING_CHANGE_PASSWORD','Изменить пароль');
define('TEXT_NEW_PASSWORD','Новый пароль');
define('TEXT_PASSWORD_CONFIRMATION','Подтверждение пароля');
define('TEXT_PASSWORD_UPDATED','Ваш пароль был успешно обновлен');
define('TEXT_USER_PASSWORD_UPDATED','Пароль был успешно обновлен');
define('TEXT_USER_NOT_FOUND','Нет соответствия для имени пользователя или пароля');
define('TEXT_USER_IS_NOT_ACTIVE','Ваш аккаунт неактивен');
define('TEXT_PASSWORD_FORGOTTEN','Забыли пароль?');
define('TEXT_HEADING_RESTORE_PASSWORD','Восстановить пароль');
define('TEXT_RESTORE_PASSWORD_EMAIL_SUBJECT',CFG_APP_NAME . ' - Новый пароль');  
define('TEXT_RESTORE_PASSWORD_EMAIL_BODY','Новый пароль был запрошен. Данные для входа в ' . CFG_APP_NAME . ':');
define('TEXT_RESTORE_PASSWORD_SUCCESS','Новый пароль был выслан на адрес электронной почты');
define('TEXT_REMEMBER_ME','Запомнить меня');
define('TEXT_HEADING_MY_ACCOUNT','Личный кабинет');
define('TEXT_ACCOUNT_UPDATED','Аккаунт обновлен');
define('TEXT_ACCESS_FORBIDDEN','Доступ запрещен');
define('TEXT_ACCESS_FORBIDDEN_MESSAGE','Извините, у вас нет доступа к этой странице.');
define('TEXT_NO_ACCESS','У вас нет доступа');
define('TEXT_BUTTON_INFO','Информация');
define('TEXT_RESET_SEARCH','Сброс');
define('TEXT_HEADING_DB_BACKUP','Резервное копирование базы данных');
define('TEXT_BACKUP_CREATED','Резервная копия создана');
define('TEXT_DOWNLOAD','Скачать');
define('TEXT_RESTORE','Восстановить');
define('TEXT_BACKUP_DELETED','Файл удален');
define('TEXT_FILE_NOT_FOUD','Файл не найден');
define('TEXT_DB_RESTORE_CONFIRMATION','Вы уверены, что хотите восстановить данные из "%s" ? <br><b>Примечание:</b> все существуюшие данные будут заменены.');
define('TEXT_BACKUP_RESTORED','База восстановлена');
define('TEXT_COMMENTS','Комментарии');
define('TEXT_ATTACHMENTS','Вложения');
define('TEXT_REPORTS','Отчеты');
define('TEXT_STANDARD_REPORTS','Стандартные отчеты');
define('TEXT_HEADING_REPORTS','Отчеты');
define('TEXT_IN_MENU','Отображать в меню');
define('TEXT_IN_DASHBOARD','Отображать на главной');
define('TEXT_HEADING_REPORTS_IFNO','Информация об отчете');
define('TEXT_WARN_DELETE_REPORT_SUCCESS','Отчет удален');
define('TEXT_REPORT_ENTITY','Сущность');
define('TEXT_VIEW','Просмотреть');
define('TEXT_PLEASE_WAYIT_FILES_LOADING','Пожалуйста, подождите, файлы загружаются.');
define('TEXT_ADD_ATTACHMENTS','Добавить вложения');
define('TEXT_HEADING_SERVER_INFORMATION','Информация о сервере');
define('TEXT_HEADING_FILTERS_FOR_REPORT','Фильтры для отчета:');
define('TEXT_HEADING_FILTERS_FOR','Фильтры для:');
define('TEXT_HEADING_REPORTS_SORTING','Настройка сортировки');
define('TEXT_FIELDS_FOR_SORTING','Поля для сортировки');
define('TEXT_FIELDS_EXCLUDED_FROM_SORTING','Исключить из сортировки');
define('TEXT_LISTING_SORTING_CFG_INFO','Просто переместите поля между боксами, чтобы включить или исключить поля для сортировки.<br>Нажмите на значок со стрелкой, чтобы изменить тип сортировки.');
define('TEXT_REPORT_NOT_FOUND','Отчет не найден!');
define('TEXT_FIELD','Поле');
define('TEXT_VALUES','Значение');
define('TEXT_HEADING_REPORTS_FILTER_IFNO','Настройка фильтра');
define('TEXT_SELECT_FIELD','Выберите поле');
define('TEXT_WARN_DELETE_FILTER_SUCCESS','Фильтр удален');
define('TEXT_WARN_DELETE_ALL_FILTERS_SUCCESS','Фильтры удалены');
define('TEXT_FILTERS_CONDITION','Состояние');
define('TEXT_FILTERS_CONDITION_TOOLTIP','Включить или исключить выбранные значения');
define('TEXT_CONDITION_INCLUDE','Включить');
define('TEXT_CONDITION_EXCLUDE','Исключить');
define('TEXT_FILTERS_NUMERIC_FIELDS_TOOLTIP','Примеры значений: <ul><li>1|2|3<br>значение=1 или значение=2 или значение=3</li><li>>5&<10<br>значение>5 и значение<10</li><li>>=5&!=10<br>значение>=5 и значение !=10</li></ul>');
define('TEXT_DISPLAY_USERS_AS','Показать как');
define('TEXT_DISPLAY_USERS_AS_DROPDOWN','Раскрывающийся список');
define('TEXT_DISPLAY_USERS_AS_CHECKBOXES','Флажки');
define('TEXT_DISPLAY_USERS_AS_DROPDOWN_MULTIPLE','Выпадающий список с выбором нескольких значений');
define('TEXT_DISPLAY_USERS_AS_TOOLTIP','Используйте флажки для выбора нескольких пользователей');
define('TEXT_USERS_LIST','Список пользователей');
define('TEXT_FILTER_BY_DAYS','Фильтр по дням');
define('TEXT_FILTER_BY_DAYS_TOOLTIP','Доступные значения: <code>0</code> - текущий день, <code>-1</code> - предыдущий день, <code>+1</code> - следующий день. Так же вы можете указать несколько значений: <code>-1&2&3</code>, <code>>=0</code>, <code>>0&<0</code>');
define('TEXT_FILTER_BY_DATES','Фильтр по дате');
define('TEXT_FILTER_BY_DATES_TOOLTIP','Указать период');
define('TEXT_FILTER_BY_USERS','Фильтр по пользователям');
define('TEXT_FILTER_BY_VALUES','Фильтр по значениям');
define('TEXT_DATE_FROM','От');
define('TEXT_DATE_TO','До');
define('TEXT_DESCENDING_ORDER','По убыванию');
define('TEXT_ASCENDING_ORDER','По возрастанию');
define('TEXT_LISTING_FILTERS_CFG_INFO','Установите фильтры, которые будут использоваться по умолчанию для списка элементов');
define('TEXT_SELECT_ENTITY','Выберите сущность');
define('TEXT_FIELDTYPE_ENTITY_SELECT_ENTITY_TOOLTIP','Элементы из этой сущности будут использоваться в качестве значений для этого поля.');
define('TEXT_DETAILS','Детали');
define('TEXT_LANGUAGE','Язык');
define('TEXT_SKIN','Внешний вид');
define('TEXT_SKIN_TOOLTIP','Если внешний вид по умолчанию не задан, пользователи могут изменять внешний вид.<br>Выбранный внешний вид будет установлен для всех пользователей, и возможность изменять внешний вид будет скрыта.');
define('TEXT_CHANGE_SKIN','Изменить внешний вид');
define('TEXT_COMMENT','Комментарий');
define('TEXT_PREVIOUS_COMMENTS','Предыдущие комментарии');
define('TEXT_PAGE_NOT_FOUND_HEADING','Страница не найдена!');
define('TEXT_PAGE_NOT_FOUND_CONTENT','Страница, которую вы открываете, не существует.');
define('TEXT_TOP_ENTITIES','Сущности');
define('TEXT_SUB_ENTITIES','Вложенные сущности');
define('TEXT_FILTER_FIELD_VALUES_NOT_AVAILABLE','Значения этого поля не доступны в отчете');
define('TEXT_NEW_PROJECT_VERSION','Новая версия!');
define('TEXT_NEW_PROJECT_VERSION_INFO','Новая версия Руководитель %s доступна для скачивания');
define('TEXT_REMOVE_INSTALL_FOLDER','Пожалуйста, удалите папку "install"');
define('TEXT_WITH_SELECTED','С выбранными');
define('TEXT_EXPORT','Экспорт');
define('TEXT_HEADING_EXPORT','Экспорт');
define('TEXT_BUTTON_EXPORT','Экспорт');
define('TEXT_SELECT_FIELD_TO_EXPORT','Выберите поля для экспорта');
define('TEXT_FILENAME','Имя файла');
define('TEXT_PLEASE_SELECT_ITEMS','Пожалуйста, выберите элементы');
define('TEXT_INTERNAL_FIELDS','Внутренние поля');
define('TEXT_RELATIONSHIP_HEADING','Связь');
define('TEXT_URL_HEADING','Url');
define('TEXT_MORE_ACTIONS','Другие действия');
define('TEXT_EXPORT_COMMENTS','Экспорт комментариев');
define('TEXT_HEADING_IMPORT_DATA','Импорт данных');
define('TEXT_HEADING_IMPORT_DATA_TO','Импорт данных в: %s');
define('TEXT_IMPORT_DATA_INFO','Вы можете импортировать данные из таблицы в формате Excel');
define('TEXT_PARENT_ITEM_ID','ID родительского элемента');
define('TEXT_PARENT_ITEM_ID_INFO','Введите ID родительского элемента из сущности: %s');
define('TEXT_PARENT_ITEM_ID_NOT_FOUND','Элемент #%s не найден в сущности %s. Пожалуйста, введите правильный идентификатор элемента.');
define('TEXT_FILE_NOT_LOADED','Файл не загружен');
define('TEXT_IMPORT_BIND_FIELDS','Свяжите поля  со столбцами таблицы ниже и начните импорт. Колонки, не связанные с полем, не будут импортироваться.');
define('TEXT_BIND_FIELD','Привязать поле');
define('TEXT_HEADING_BIND_FIELD','Привязать поле');
define('TEXT_NONE','Ни одного');
define('TEXT_IMPORT_FIRST_ROW','Импортировать первую строку?');
define('TEXT_DATEPICKER_DAYS','"Воскресенье", "Понедельник", "Вторник", "Среда", "Четверг", "Пятница", "Суббота"');
define('TEXT_DATEPICKER_DAYSSHORT','"Вск", "Пнд", "Втр", "Срд", "Чтв", "Птн", "Суб", "Вск"');
define('TEXT_DATEPICKER_DAYSMIN','"Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб", "Вс"');
define('TEXT_DATEPICKER_MONTHS','"Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"');
define('TEXT_DATEPICKER_MONTHSSHORT','"Янв", "Фев", "Мар", "Апр", "Май", "Июн", "Июл", "Авг", "Сен", "Окт", "Ноя", "Дек"');
define('TEXT_DATEPICKER_TODAY','Сегодня');
define('TEXT_USE_SEARCH','Использовать Живой поиск');
define('TEXT_USE_SEARCH_INFO','Отображать мгновенные результаты по мере ввода');
define('TEXT_SELECT_SOME_VALUES','Выберите значение');
define('TEXT_NO_RESULTS_MATCH','Нет совпадений с');
define('TEXT_USER_PWD_CHANGED_EMAIL_SUBJECT','Ваш пароль изменен');
define('TEXT_USER_PWD_CHANGED_EMAIL_BODY','Ваш пароль изменен администратором');
define('TEXT_DATE_BACKGROUND','Цвет фона');
define('TEXT_DATE_BACKGROUND_TOOLTIP','Просроченные даты будут выделятся выбранным цветом.');
define('TEXT_USE_EDITOR_IN_COMMENTS','Использовать HTML редактор');
define('TEXT_USE_EDITOR_IN_COMMENTS_TOOLTIP','Использовать HTML редактор для текста комментария.');
define('TEXT_HEADING_CECK_VERSION','Проверка версии');
define('TEXT_VERSION_INFO','Вы используете Руководитель');
define('TEXT_UPDATES_INSTALLED','Обновления успешно установлены');
define('TEXT_USER_PUBLIC_PROFILE_CFG_INFO','Публичный профиль отображается при наведении курсора на имя пользователя. По умолчанию отображается фото пользователя.<br>Просто переместите поля между боксами для включения или исключения полей в профиле.');
define('TEXT_FIELDS_IN_USER_PUBLIC_PROFILE','Поля в профиле');
define('TEXT_FIELDS_EXCLUDED_FROM_USER_PUBLIC_PROFILE','Исключены из профиля');
define('TEXT_USER_PUBLIC_PROFILE_NO_FIELDS','Нет доступных полей для отображения в профиле');
define('TEXT_HEADING_EXTENSION','Дополнение');
define('TEXT_EXTENSION_IFNO','Дополнение расширит ваше приложение, добавив такие возможности, как: диаграмма Ганта, календарь, графический отчет, шаблоны, учет времени, информационные страницы и многое другое.');
define('TEXT_PERIOD','Период');
define('TEXT_DAILY','Ежедневно');
define('TEXT_MONTHLY','Ежемесячно');
define('TEXT_YEARLY','Годовой');
define('TEXT_FIRST_DAY_OF_WEEK','Первый день недели');
define('TEXT_FIRST_DAY_OF_WEEK_INFO','Будет отображаться как в первый день недели в календаре');
define('TEXT_SETTINGS','Настройки');
define('TEXT_FULL_ACCESS','Полный доступ');
define('TEXT_MORE_INFO','Подробнее');
define('TEXT_SETP','Шаг');
define('TEXT_SAVING','Сохранение...');
define('TEXT_UNDO','Отменить');
define('TEXT_REDO','Вернуть');
define('TEXT_INSERT','Вставить');
define('TEXT_MOVE_UP','Переместить в верх');
define('TEXT_MOVE_DOWN','Переместить вниз');
define('TEXT_ZOOM_OUT','Уменьшить');
define('TEXT_ZOOM_IN','Увеличить');
define('TEXT_PRINT','Распечатать');
define('TEXT_MENU_DONATE','Поддержать проект');
define('TEXT_ERROR_NO_HEADING_FIELD','Не найдено поле, установленное как Заголовок. Пожалуйста установите поле как Заголовок на странице настройки полей.');
define('TEXT_ERROR_LOADING_DATA','Ошибка загрузки данных');
define('TEXT_CONFIGURE_DASHBOARD','Настройка главной страницы');
define('TEXT_CONFIGURE_DASHBOARD_INFO','Просто переместите отчеты между боксами для включения или исключения отчетов на главной странице');
define('TEXT_REPORTS_ON_DASHBOARD','Отчеты на главной');
define('TEXT_MY_REPORTS','Мои отчеты');
define('TEXT_CONFIGURE_THEME','Настройка темы');
define('TEXT_SIDEBAR','Боковая панель');
define('TEXT_SIDEBAR_POSITION','Положение панели');
define('TEXT_SCALE','Масштаб');
define('TEXT_DEFAULT','По умолчанию');
define('TEXT_SIDEBAR_FIXED','Зафиксирована');
define('TEXT_SIDEBAR_POS_LEFT','Слева');
define('TEXT_SIDEBAR_POS_RIGHT','Справа');
define('TEXT_SCALE_REDUCED','Уменьшенный');

//new defines for version 1.5
define('TEXT_FIELDTYPE_RELATED_RECORDS_TITLE','Связанные записи');
define('TEXT_FIELDTYPE_RELATED_RECORDS_TOOLTIP','Специальное поле, позволяющее связывать записи между сущностями');
define('TEXT_FIELDTYPE_RELATED_RECORDS_SELECT_ENTITY_TOOLTIP','Записи выбранной сущности могут связываться с сущностью');
define('TEXT_BUTTON_ADD','Добавить');
define('TEXT_BUTTON_LINK','Связать');
define('TEXT_BUTTON_DELETE_RELATION','Удалить связь');
define('TEXT_LINK_RECORD','Связать запись');
define('TEXT_SEARCH_RECORD_BY_ID','Найти запись по номеру (ID):');
define('TEXT_ENTITY','Сущность');
define('TEXT_FILTERS_DISPLAY','Отображать');
define('TEXT_FILTERS_DISPLAY_WITH_RELATED_RECORDS','Отображать со связанными записями');
define('TEXT_FILTERS_DISPLAY_WITHOUT_RELATED_RECORDS','Отображать без связанных записей');
define('TEXT_FILTERS_FOR_ENTITY','Фильтры для сущности');
define('TEXT_FILTERS_FOR_ENTITY_SHORT','Для сущности');
define('TEXT_REPORT','Отчет');
define('TEXT_ADD_IN','Добавить в');
define('TEXT_SELECT_AN_OPTION','Выберите один вариант');
define('TEXT_SELECT_SOME_OPTIONS','Выберите некоторые опции');
define('TEXT_DISPLAY_IN_MENU','Отображать в меню');
define('TEXT_MENU_ICON_TITLE','Иконка меню');
define('TEXT_MENU_ICON_TITLE_TOOLTIP','Введите название иконки из библиотеки <a href="https://fontawesome.com/v4/icons/" target="_blank">Font Awesome</a> или <a href="https://icons8.com/line-awesome" target="_blank">Line Awesome</a><br>Например: fa-bell или la-bell.');

//new defines for version 1.6
define('TEXT_FIELDTYPE_INPUT_MASKED','Поле с маской ввода');
define('TEXT_FIELDTYPE_INPUT_MASKED_TOOLTIP','Для ввода данных в определенном формате (дата, телефон и т.д.)');
define('TEXT_INPUT_FIELD_MASK','Маска');
define('TEXT_INPUT_FIELD_MASK_TIP','Например: 99/99/9999 или (999) 999-9999 или a*-999-a999<br>
<ul>
  <li>a - Пользователь должен ввести букву (A-Z, a-z)</li>
	<li>я - Пользователь должен ввести букву (А-Я, а-я)</li>
  <li>9 - Пользователь должен ввести цифру (0-9)</li>
  <li>* - Пользователь должен ввести букву или цифру </li>
</ul>');
define('TEXT_MENU_REVIEWS','Отзывы');
define('TEXT_AVAILABLE_FIELDS','Доступные поля');
define('TEXT_NO_NUMERIC_FIELDS','Числовые поля отсутствуют.');
define('TEXT_EXTENSION_LICENSE_KEY_IFNO','При покупке Дополнения вам нужно ввести доменное имя <span class="label label-sm label-warning">%s</span>, чтобы получить ключ продукта.');
define('TEXT_URL_PREFIX','Префикс');
define('TEXT_URL_PREFIX_TIP','Если в ссылке отсутствует префикс, то префикс "http://" будет автоматически добавлен к ссылке. Если вы хотите использовать другой префикс по умолчанию (например "sip:"), введите его в это поле.');
define('TEXT_URL_PREVIEW_TEXT','Текст ссылки');
define('TEXT_URL_PREVIEW_TEXT_TIP','По умолчанию в ссылке используя текст "Просмотреть". Вы можете ввести собственный текст или ввести "none", чтобы показать значение поля в ссылки.');
define('TEXT_SEARCH_HELP','Рекомендации по поиску');
define('TEXT_SEARCH_HELP_INFO_FIELDS','Вы можете указать поля по которым будет осуществлятся поиск.');
define('TEXT_SEARCH_HELP_INFO_FIELDS_EXAMPLE','Если поля не указаны, поиск осуществляется по всем доступным полям, в которых разрешен поиск.');
define('TEXT_SEARCH_HELP_INFO_ANDOR','При поиске, вы можете разделять ключевые слова и фразы предлогами *AND*, *OR*.');
define('TEXT_SEARCH_HELP_INFO_ANDOR_EXAMPLE','Например, вы можете ввести <u>Задача1 AND Задача2</u>. В результате будет будут выведены записи, содержащие оба слова. Тем не менее, если вы заносите <u>Задача1 OR Задача2</u>, вы получите список, который содержит оба или одно из слов, заданных в поиске. Если слова не разделяются символами И или ИЛИ, поиск будет работать с определением ИЛИ.');
define('TEXT_SEARCH_HELP_INFO_QUOTES','Вы можете также найти точно заданные слова, заключая их в кавычки.');
define('TEXT_SEARCH_HELP_INFO_QUOTES_EXAMPLE','Например, если вы ищете <u>"Моя задача"</u>, вы получите список записей, которые содержат эту фразу целиком.');
define('TEXT_SEARCH_HELP_INFO_BRACKETS','Скобки могут использоваться, чтобы управлять порядком логических действий.');
define('TEXT_SEARCH_HELP_INFO_BRACKETS_EXAMPLE','Например, вы можете ввести <u>Компьютеры and (карманные or ноутбуки)</u>');
define('TEXT_ERROR_INVALID_KEYWORDS','Поисковый запрос составлен неверно');
define('TEXT_SEARCH_IN_COMMENTS','Искать в комментариях');
define('TEXT_GO_TO','Перейти в');
define('TEXT_FIELDTYPE_IMAGE_TITLE','Поле для загрузки изображения');
define('TEXT_FIELDTYPE_IMAGE_TOOLTIP','Позволяет загрузить одно изображение');
define('TEXT_PREVIEW_IMAGE_SIZE','Ширина изображения');
define('TEXT_PREVIEW_IMAGE_SIZE_TIP','Максимальная ширина изображения при отображении (по умолчанию 250px)');
define('TEXT_USE_IMAGE_PREVIEW','Предварительный просмотр');
define('TEXT_USE_IMAGE_PREVIEW_TIP','Использовать предварительный просмотр для изображений');
define('TEXT_NOTIFY_WHEN_CHANGED','Уведомлять при изменении');
define('TEXT_NOTIFY_WHEN_CHANGED_TIP','Назначенные пользователи будут уведомлены, если значение изменилось.');
define('TEXT_DEFAULT_EMAIL_SUBJECT_UPDATED_ITEM','Запись обновлена:');
define('TEXT_EMAIL_SUBJECT_UPDATED_ITEM','Тема письма для обновленного элемента');
define('TEXT_EMAIL_SUBJECT_UPDATED_ITEM_TOOLTIP','Это значение будет использоваться при обновлении  элемента');
define('TEXT_ENTER_VALUE','Введите значение');
define('TEXT_ENTER_CORRECT_VALUE','Введите правильное значение');
define('TEXT_DAYS_BEFORE_DATE','Несколько дней до указанной даты');
define('TEXT_DAYS_BEFORE_DATE_TIP','Введите несколько дней и цвет фона, чтобы выделить поле до указанной даты');
define('TEXT_FIELD_SETTINGS','Настройки поля');
define('TEXT_FIELDS_IN_POPUP','Поля в всплывающем окне');
define('TEXT_FIELDS_IN_LISTING_RELATED_ITEMS','Отметьте поля, которые будут отображаться в списке связанных записей. Так как ширина списка ограничена, используйте только ключевые поля. Другие необходимые поля могут отображатся в сплывающем окне.');
define('TEXT_FIELDS_IN_POPUP_RELATED_ITEMS','Отметьте поля, которые будут отображаться в всплывающем окне при наведении на связанную запись.');
define('TEXT_CONDITION_EMPTY_VALUE','Пустое значение');
define('TEXT_DISPLAY_USER_NAME_ORDER','Отображение имени пользователя');
define('TEXT_FIRSTNAME_LASTNAME','Имя Фамилия');
define('TEXT_LASTNAME_FIRSTNAME','Фамилия Имя');
define('TEXT_FILTER_BY_MONTH','Фильтр по месяцам');
define('TEXT_FILTER_BY_YEAR','Фильтр по годам');
define('TEXT_FILTER_BY_OVERDUE_DATE','Только просроченные даты');
define('TEXT_FILTER_BY_MONTH_TOOLTIP','Доступные значения: <code>0</code> - текущий месяц, <code>-1</code> - предыдущий месяц, <code>+1</code> - следующий месяц. Так же вы можете указать несколько значений: <code>-1&2&3</code>, <code>>=0</code>, <code>>0&<0</code>');
define('TEXT_FILTER_BY_YEAR_TOOLTIP','Доступные значения: <code>0</code> - текущий год, <code>-1</code> - предыдущий год, <code>+1</code> - следующий год. Так же вы можете указать несколько значений: <code>-1&2&3</code>, <code>>=0</code>, <code>>0&<0</code>');
define('TEXT_RESERVED_FORM_TAB','Зарезервированная вкладка. Вы можете изменить только название.');
define('TEXT_FIELDTYPE_RELATED_RECORDS_TOOLTIP_EXTRA','
  <span class="help-block">
    <span class="label label-sm label-info">Примечание:</span>
    данное поле не отображается в форме создания записи. Добавить связи можно уже после создания записи.
  </span>');
  
//new defines for version 1.7
define('TEXT_ASSIGNED_TO','Назначен на');
define('TEXT_DISPLAY_IN_HEADER','Отображать в верхнем меню');
define('TEXT_DISPLAY_IN_HEADER_TOOLTIP','Иконка отчета будет отображаться в верхнем навигационном меню.');
define('TEXT_LISTING_HORISONTAL_SCROLL','Горизонтальная прокрутка списка');
define('TEXT_LISTING_HORISONTAL_SCROLL_INFO','По умолчанию горизонтальная прокрутка списка применяется ко всем полям. Вы можете зафиксировать несколько полей с левой стороны.');
define('TEXT_NUMBER_FIXED_FIELD','Количество зафиксированных полей');
define('TEXT_NUMBER_FIXED_FIELD_INFO','Введите количество зафиксированных полей, к которым горизонтальная прокрутка не будет применятся.');
define('TEXT_DISPLAY_IN_MAIN_COLUMN','Отображать в основной колонке');
define('TEXT_DISPLAY_IN_MAIN_COLUMN_INFO','По умолчанию, связанные записи отображаются в правой колонке. После установки данной опции, связанные записи будут отображаться отдельным списком на странице записи.');
define('TEXT_SEARCH_RECORD_BY_ID_NAME_TIP','Найти запись по ID или названию. Оставьте поле пустым, чтобы отобразить все записи.');
define('TEXT_DISPLAY_NAME_AS_LINK','Отображать название как ссылку');
define('TEXT_DISPLAY_NAME_AS_LINK_INFO','Название записи будет ссылаться на страницу записи');
define('TEXT_UNLINK','Удалить связь');
define('TEXT_SELECT_ALL','Выбрать все');
define('TEXT_CALCULATE_TOTALS','Вычислять сумму в списке записей');
define('TEXT_CALCULATE_TOTALS_INFO','Сумма значений данного поля будет подсчитываться в списке записей');
define('TEXT_DISPLAY_COMMENTS_ID','Отображать номер (ID) комментария');
define('TEXT_DISPLAY_COMMENTS_TOOLTIP','По номеру можно легко сослаться на нужный комментарий.');
define('TEXT_ERROR_COMMENTS_FORM_GENERAL','Ни одно из полей не заполнено');
define('TEXT_SELECT_HEADING_FIELD','Выберите поле, которое будет отображаться как заголовок в списке');
define('TEXT_ERROR_IMAGE_FILE_IS_NOT_UPLOADED','Файл не загружен. Максимальный размер файла %s Мб.');
define('TEXT_FIELDTYPE_PARENT_ITEM_ID_TITLE','Связь');
define('TEXT_APPLIED_FILTERS','Установленные фильтры');
define('TEXT_NO_FILTERS_SETUP','Нет фильтров');
define('TEXT_DEFAULT_FILTERS','Фильтры по умолчанию');
define('TEXT_SAVE_FILTERS','Сохранить фильтры');
define('TEXT_UPDATE','Обновить');
define('TEXT_DELETE_FILTERS','Удалить фильтры');
define('TEXT_MESSAGE_FILTER_SAVED','Фильтр сохранен');
define('TEXT_COPYRIGHT_NAME','Авторские права');
define('TEXT_COPYRIGHT_NAME_TOOLTIP','Введите название вашей компании. Текст отображается в нижней части страницы. Символ &copy; добавляется автоматически.');
define('TEXT_POWERED_BY','При поддержке');
define('TEXT_POWERED_BY_TITLE','Универсальная система управления проектами');
define('TEXT_MENU_GLOBAL_LISTS','Глобальные списки');
define('TEXT_HEADING_GLOBAL_LISTS','Глобальные списки');
define('TEXT_GLOBAL_LISTS_INFO','Глобальные списки могут быть применены в любых сущностях для типов полей: "Выпадающий список", "Флажки", "Переключатели".');
define('TEXT_HEADING_GLOBAL_LIST_IFNO','Глобальный список');
define('TEXT_GLOBAL_LIST_CHOICES_CONFIG','Опции');
define('TEXT_BUTTON_SORT','Сортировать');
define('TEXT_SORT_VALUES','Сортировать значения');
define('TEXT_USE_GLOBAL_LIST','Использовать глобальный список');
define('TEXT_USE_GLOBAL_LIST_TOOLTIP','Значения из выбранного списка будут использоваться для данного поля');
define('TEXT_BUTTON_CANCEL','Отмена');
define('TEXT_NUMBER_FORMAT','Формат отображения числа');
define('TEXT_NUMBER_FORMAT_INFO','Введите: число знаков после запятой (0-9) / разделитель дробной части / разделитель тысяч. Допустимые значения для разделителя: точка, запятая, пробел или символ *, при котором разделитель не применяется.<br>Оставьте поле пустым, чтобы не использовать формат отображения.');
define('TEXT_NUMBER_FORMAT_INFO_NOTE','Обратите внимание: данный формат используется по умолчанию только при создании нового числового поля. При отображении числа используются индивидуальные настройки числового поля.');
define('TEXT_BUTTON_SEND_TEST_EMAIL','Отправить тестовое письмо');
define('TEXT_EMAIL_USE_SMTP_INFO','Письмо с темой "%s" будет отправлено на адрес: %s');
define('TEXT_TEST_EMAIL_SUBJECT','Это проверка электронной почты');
define('TEXT_EMAIL_SENT','Письмо успешно отправлено');
define('TEXT_DEFAULT_TEXT','Текст по умолчанию');
define('TEXT_DEFAULT_TEXT_INFO','Может быть пустым, или, к примеру, введите  "Пожалуйста, выберите"');
define('TEXT_DEFAULT_DATE','Дата по умолчанию');
define('TEXT_DEFAULT_DATE_INFO','Оставьте пустым или введите число. Например: 0 - текущая дата, 5 - текущая дата + 5 дней.');
define('TEXT_FIELDTYPE_BOOLEAN_TITLE','Логическое поле');
define('TEXT_FIELDTYPE_BOOLEAN_TOOLTIP','В логическом поле могут храниться только два значения: "Да" и "Нет"');
define('TEXT_BOOLEAN_TRUE','Да');
define('TEXT_BOOLEAN_FALSE','Нет');
define('TEXT_BOOLEAN_TRUE_VALUE','Значение "Да"');
define('TEXT_BOOLEAN_TRUE_VALUE_INFO','Оставьте поле пустым или введите ваше значение');
define('TEXT_BOOLEAN_FALSE_VALUE','Значение "Нет"');
define('TEXT_BOOLEAN_FALSE_VALUE_INFO','Оставьте поле пустым или введите ваше значение');
define('TEXT_FIELDTYPE_TEXT_PATTERN','Текст по шаблону');
define('TEXT_FIELDTYPE_TEXT_PATTERN_TOOLTIP','Специальное поле, которое позволяет отобразить текст в заданном шаблоне.');
define('TEXT_PATTERN','Шаблон');
define('TEXT_ENTER_TEXT_PATTERN_INFO','Используйте [ID поля] для установки значения поля в шаблоне.<br> Пример: "[36]ваш текст[54]" где 36 и 54 - идентификаторы полей.<br>Так же, доступны: [id], [date_added], [created_by], [parent_item_id], [current_user_name]');
define('TEXT_FIELDTYPE_USER_STATUS_TOOLTIP','Неактивные пользователи не могут войти в систему и не получают уведомления по электронной почте');
define('TEXT_APP_LOGO_URL','Ссылка для лого');
define('TEXT_APP_LOGO_URL_TOOLTIP','Будет открываться в новом окне');
define('TEXT_USERS_CONFIGURATION','Настройки пользователей');
define('TEXT_ALLOW_CHANGE_USERNAME','Разрешить изменять имя пользователя');
define('TEXT_ALLOW_REGISTRATION_WITH_THE_SAME_EMAIL','Разрешить регистрацию с одинаковым email');
define('TEXT_FIELDS_TYPES_GROUP_INPUT_FIELDS','Поле ввода');
define('TEXT_FIELDS_TYPES_GROUP_DATES','Дата');
define('TEXT_FIELDS_TYPES_GROUP_UPLOAD','Загрузка');
define('TEXT_FIELDS_TYPES_GROUP_TEXT','Текст');
define('TEXT_FIELDS_TYPES_GROUP_LIST','Список');
define('TEXT_FIELDS_TYPES_GROUP_USERS','Пользователи');
define('TEXT_FIELDS_TYPES_GROUP_ENTITY','Сущность');
define('TEXT_DOWNLOAD_ALL_ATTACHMENTS','Скачать все');
define('TEXT_FILTER_BY_WEEK','Фильтр по неделям');
define('TEXT_FILTER_BY_WEEK_TOOLTIP','Доступные значения: <code>0</code> - текущая неделя, <code>-1</code> - предыдущая неделя, <code>+1</code> - следующуя неделя. Так же вы можете указать несколько значений: <code>-1&2&3</code>, <code>>=0</code>, <code>>0&<0</code>');
define('TEXT_HIDE_FIELD_NAME','Скрыть название поля');
define('TEXT_HIDE_FIELD_NAME_TIP','В целях экономии места, вы можете скрыть название поля при отображении списка пользователей.');
define('TEXT_LAST_COMMENT_DATE','Дата последнего комментария');
define('TEXT_HIDE_FIELD_IF_EMPTY','Скрыть поле, если значение пустое');
define('TEXT_HIDE_FIELD_IF_EMPTY_TIP','На странице записи поле будет скрыто, если значение поля пустое');
define('TEXT_TOOLTIP_DISPLAY_AS_ICON','Отображать как иконку');
define('TEXT_TOOLTIP_DISPLAY_AS_ICON_INFO','По умолчанию, текст подсказки отображается под полем');
define('TEXT_MENU_DATABASE_EXPORT','Экспорт приложения');
define('TEXT_DATABASE_EXPORT_APPLICATION','Экспорт шаблона приложения');
define('TEXT_BUTTON_EXPORT_DATABASE','Экспорт шаблона приложения');
define('TEXT_DATABASE_EXPORT_EXPLANATION','Данная функция создает шаблон вашего приложения. Экспортируются  только те данные, которые относятся к настройкам вашего приложения.<br>С помощью шаблона, вы можете клонировать ваше приложение или поделиться им.');
define('TEXT_DATABASE_EXPORT_TOOLTIP','<b>Примечание:</b> экспортируется только текущий пользователь и его Логин/Пароль, которые используются для входа в систему после установки шаблона.<br>Для установки шаблона используйте кнопку "Восстановить БД из файла".');
define('TEXT_COPY_FIELDS','Копировать поля');
define('TEXT_COPY','Копировать');
define('TEXT_PLEASE_SELECT_FIELDS','Пожалуйста, выберите поля');
define('TEXT_SELECT_FORM_TAB','Выберете вкладку формы');
define('TEXT_FIELDS_COPY_SUCCESS','Поля успешно скопированы');
define('TEXT_HEADING_TEMPLATE','Шаблон заголовка');
define('TEXT_HEADING_TEMPLATE_INFO','По умолчанию используется поле, установленное как "Заголовок"');
define('TEXT_IS_UNIQUE_FIELD_VALUE','Уникальное поле');
define('TEXT_IS_UNIQUE_FIELD_VALUE_TIP','Введенное значение будет проверяться на уникальность для данной сущности');
define('TEXT_PLEASE_WAIT_UNIQUE_FIELDS_CHECKING','Выполняется проверка данных. Повторите попытку через несколько секунд.');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR','Значение поля должно быть уникально');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR_GENERAL','Некоторые поля должны быть уникальны. Они отмечены выше.');
define('TEXT_IMPORT_DATA_TOOLTIP','Перед началом импорта, вы должны подготовить данные в Excel:
<ul>
  <li>формат даты: YYYY-MM-DD</li>	
  <li>формат даты и времени: YYYY-MM-DD HH:MM</li>
  <li>формат чисел: 20000.00 (количество знаков после запятой - любое, разделитель дробной части - точка, разделитель тысяч - не используется)</li>
  <li>логическое поле: true | false</li>
</ul>
Продублируйте поля, которые нуждаются в подготовке, и с помощью формул в Excel подготовьте данные. Данные нужно пересохранить, как значения, иначе импортируются сами формулы.');

//new defines for version 1.8
define('TEXT_WARN_DELETE_ENTITY_HAS_RELATIONSHIP','Сущность <b>%s</b> не может быть удалена, потому что установлены следующие связи: <br>%s.<br><br>Удалите все связи перед удалением сущности.');
define('TEXT_SEARCH_IN_ALL','Отключить фильтры');
define('TEXT_SEARCH_TYPE_AND','Искать все слова');
define('TEXT_SEARCH_TYPE_MATCH','Точное совпадение');
define('TEXT_SEARCH_HELP_INFO_CONFIGURATION','Настройки поиска');
define('TEXT_SEARCH_HELP_INFO_CONFIGURATION_DESCRIPTION','
			<ul>
				<li>Отключить фильтры<br>Данная опция расширяет область поиска, отключив фильтры.</li>
				<li>Искать все слова<br>Будут показаны записи, содержащие все слова.</li>
				<li>Точное совпадение<br>Будут показаны записи, содержащие точное совпадение ключевых слов.</li>				
			</ul>');
define('TEXT_IS_ACTIVE_FILTER','Активный фильтр?');
define('TEXT_IS_ACTIVE_FILTER_INFO','Неактивные фильтры отображаются в списке установленных фильтров, но не используются при выборке данных');
define('TEXT_SAVE_AS_TEMPLATE','Сохранить как шаблон');
define('TEXT_SAVE_AS_TEMPLATE_INFO','Выбранные значения можно сохранить как шаблон. Шаблоны доступны в списке установленных фильтров.');
define('TEXT_MY_TEMPLATES','Мои шаблоны');
define('TEXT_ENTER_TEMPLATE_NAME','Введите название шаблона');
define('TEXT_SAVE_TAMPLATE_NOTE','Отмеченные поля будут сохранены в новый шаблон');
define('TEXT_TEMPLATES_FIELDS','Поля');
define('TEXT_TEMPLATE_ALREADY_EXIST','Шаблон "%s" уже существует');
define('TEXT_TEMPLATES_UPDATE_FIELDS','Обновить выбранные поля для этого шаблона');
define('TEXT_SELECT_TEMPLATE','Выбрать шаблон');
define('TEXT_ADD_NEW_TEMPLATE','Новый шаблон');
define('TEXT_BUTTON_UPDATE','Обновить');
define('TEXT_UPDATE_SELECTED_TEMPLATE_INFO','Отмеченные поля будут обновлены для выбранного шаблона');
define('TEXT_MENU_CONFIGURATION_MENU','Настройка меню');
define('TEXT_CONFIGURATION_MENU_EXPLAIN','У вас есть возможность настроить дополнительные разделы главного меню.');
define('TEXT_ADD_NEW_MENU_ITEM','Добавить раздел меню');
define('TEXT_SORT','Сортировать');
define('TEXT_SELECT_ENTITIES','Выберите сущности');
define('TEXT_FIELDTYPE_INPUT_VPIC_TITLE','vPIC');
define('TEXT_FIELDTYPE_INPUT_VPIC_TOOLTIP','Поле ввода с кнопкой "расшифровать" позволяет расшифровать идентификационный номер автомобиля (vin) на регулируемые виды транспортного средства с использованием сервиса <a href="https://vpic.nhtsa.dot.gov/" target="_blank">vpic.nhtsa.dot.gov</a>');
define('TEXT_FIELDS_TYPES_GROUP_SPCEIAL_FIELDS','Специальные');
define('TEXT_DECODE_VIN','Расшифровка идентификационного номера автомобиля');
define('TEXT_VPIC_AUTO_FILL_FIELDS','Автоматически заполнять поля');
define('TEXT_VPIC_AUTO_FILL_FIELDS_TIP','Данные будут автоматически заполнятся, если имя поля и имя характеристики совпадают');
define('TEXT_VPIC_OTHER_DETAILS','Характеристики');
define('TEXT_VPIC_OTHER_DETAILS_TIP','По умолчанию проверяются следующие характеристики: Make, Manufacturer Name, Model, Model Year, Vehicle Type, Body Class<br>Если вам нужно больше, введите названия через запятую');
define('TEXT_DATA_SAVED','Данные сохранены');
define('TEXT_SELECT_NONOE','Снять выделение');
define('TEXT_DELETE_SELECTED_CONFIRMATION','Вы уверены что хотите удалить выбранные записи?');
define('TEXT_QUICK_COMMENT','Быстрый комментарий');
define('TEXT_COMMENT_PLACEHOLDER','Введите ваш комментарий здесь');
define('TEXT_REPLY','Ответить');
define('TEXT_USERS_IMPORT_NOTE','При импорте пользователей, обязательными являются следующие поля: Имя, Фамилия, E-mail. Если имя пользователя не указано, то используется имя пользователя из E-mail<br>
		<b>Обратите внимание:</b> при импорте пользователей уведомление о новой учетной записи не отсылается. Это связано с тем, что веб-сервера имеют ограничения на количество отправки почты за секунду.<br>
		Импортированным пользователя необходимо использовать форму восстановления пароля для получения своего пароля.');
define('TEXT_USERS_IMPORT_USERS_GROUP','Выберите группу доступа пользователей');
define('TEXT_IMPORT_BIND_FIELDS_ERROR','Ошибка импорта: не выбраны поля связанные со столбцами таблицы');
define('TEXT_IMPORT_BIND_USERS_FIELDS_ERROR','Ошибка импорта: обязательными являются следующие поля: Имя, Фамилия, E-mail');
define('TEXT_IMPORT_SET_PWD_AS_USERNAME','Использовать имя пользователя в качестве пароля');
define('TEXT_USERS_IMPORT_ERROR','Следующие пользователи не были импортированы, так как уже существуют:');
define('TEXT_SIZE','Размер');
define('TEXT_BACKUP_TYPE_AUTO','Автоматически');
define('TEXT_BACKUP_FOLDER','Папка резервного копирования');
define('TEXT_BACKUP_DESCRIPTION_TIP','Введите комментарий к резервной копии БД или оставьте поле пустым');
define('TEXT_BUTTON_DB_RESOTRE_FROM_FILE','Восстановить БД из файла');
define('TEXT_FILE','Файл');
define('TEXT_MAX_FILE_SIZE','Максимальный размер файла %s Мб.');
define('TEXT_CRON_BACKUP','Резервное копирование с помощью <a href="https://docs.rukovoditel.net.ru/index.php?p=70" target="_blank"><u>cron</u></a>');
define('TEXT_MENU_MAINTENANCE_MODE','Режим обслуживания');
define('TEXT_HEADING_MAINTENANCE_MODE','Режим обслуживания');
define('TEXT_MAINTENANCE_MODE','Режим обслуживания');
define('TEXT_MAINTENANCE_MODE_NOTE','Если режим обслуживания включен, то войти в систему смогут только администраторы.<br>Другие пользователи, которые были авторизованы, автоматически выйдут из приложения.<br>На странице входа будет отображено сообщение, которое настраивается ниже.');
define('TEXT_MESSAGE_HEADING','Заголовок сообщения');
define('TEXT_MESSAGE_CONTENT','Содержание сообщения');
define('TEXT_MAINTENANCE_MESSAGE_HEADING','Включен режим обслуживания!');
define('TEXT_MAINTENANCE_MESSAGE_CONTENT','Доступ разрешен только администраторам');
define('TEXT_FORMULA_TIP_USAGE','Вы можете использовать в формуле синтаксис MySql: условный оператор "if([344]>10,[321],0)", математические функции "ABS([23])" и служебные поля "id, date_added, create_by"');
define('TEXT_MENU_ATTACHMENTS','Вложения');
define('TEXT_HEADING_ATTACHMENTS_CONFIGURAITON','Настройка вложений');
define('TEXT_MAX_UPLOAD_FILE_SIZE','Максимальный размер загружаемого файла');
define('TEXT_MAX_UPLOAD_FILE_SIZE_TIP','<a href="https://docs.rukovoditel.net.ru/index.php?p=10" target="_blank">' . 'Как изменить это значение?' . '</a>');
define('TEXT_RESIZE_IMAGES','Изменять размер изображений');
define('TEXT_RESIZE_IMAGES_TIP','Для экономии места на сервере, вы можете уменьшать загружаемые изображения.<br>При включении опции загружаемые изображения будут масштабироваться по ширине или высоте, указанной ниже.');
define('TEXT_MAX_IMAGE_WIDTH','Максимальная ширина изображения');
define('TEXT_MAX_IMAGE_HEIGHT','Максимальная высота изображения');
define('TEXT_ENTER_VALUES_IN_PIXELS_OR_LEAVE_LBANK','Введите размер в пикселях или оставьте поле пустым.');
define('TEXT_IMAGES_TYPES','Тип изображений');
define('TEXT_RESIZE_IMAGES_TYPES_TIP','Укажите типы изображений, для которых будет применяться масштабирование');
define('TEXT_SKIP_IMAGE_RESIZE','Не применять масштабирование для изображений');
define('TEXT_SKIP_IMAGE_RESIZE_TIP','Введите размер в пикселях или оставьте поле пустым.<br>Если ширина или высота изображения превышает указанный размер, масштабирование не будет применяться.');
define('TEXT_RECAPTCHA_VERIFY_ROBOT','Пожалуйста, подтвердите, что вы не робот!');
define('TEXT_MENU_SECURITY','Безопасность');
define('TEXT_HEADING_SECURITY_CONFIGURATION','Настройки безопасности');
define('TEXT_STATUS','Статус');
define('TEXT_RECAPTCHA_SITE_KEY','Ключ');
define('TEXT_RECAPTCHA_SECRET_KEY','Секретный ключ');
define('TEXT_RECAPTCHA_INFO','reCAPTCHA  будет отображаться на странице входа. <a href="https://www.google.com/recaptcha/intro/index.html" target="_blank">Подробнее о reCAPTCHA</a>');
define('TEXT_RECAPTCHA_HOW_ENABLE','Для включения откройте файл "config/security.php", измените CFG_RECAPTCHA_ENABLE на true, введите ключ в CFG_RECAPTCHA_KEY и секретный ключ в CFG_RECAPTCHA_SECRET_KEY.');
define('TEXT_RESTRICTED_COUNTRIES','Ограничение по странам');
define('TEXT_ALLOWED_COUNTRIES','Разрешенные страны');
define('TEXT_RESTRICTED_COUNTRIES_INFO','На странице входа будет выполняться проверка страны пользователя. Страна пользователя определяется по IP. Если страна отсутствует в списке разрешенных или не определяется, страница входа будет недоступна.');
define('TEXT_RESTRICTED_COUNTRIES_HOW_ENABLE','Для включения откройте файл "config/security.php", измените CFG_RESTRICTED_COUNTRIES_ENABLE на true  и введите список разрешенных стран через запятую в CFG_ALLOWED_COUNTRIES_LIST, например "RU,US"');
define('TEXT_RESTRICTED_BY_IP','Ограничение по IP');
define('TEXT_RESTRICTED_BY_IP_INFO','На странице входа будет выполняться проверка IP пользователя. Если IP отсутствует в списке разрешенных или не определяется, страница входа будет недоступна.');
define('TEXT_RESTRICTED_BY_IP_HOW_ENABLE','Для включения откройте файл "config/security.php", измените CFG_RESTRICTED_BY_IP_ENABLE на true  и введите список разрешенных IP через запятую в CFG_ALLOWED_IP_LIST, например "192.168.2.1,192.168.2.2"');
define('TEXT_ALLOWED_IP','Разрешенные IP');
define('TEXT_DISPLAY_COUNTER_ON_DASHBOARD','Отображать как счетчик на главной');
define('TEXT_STATISTICS','Статистика');
define('TEXT_COUNTERS','Счетчики');
define('TEXT_NOTIFICATIONS_SCHEDULE','Уведомления по расписанию');
define('TEXT_NOTIFICATIONS_SCHEDULE_TIP','Перед включением данной возможности необходимо настроить CRON_HTTP_SERVER_HOST в файле config/server.php и создать задачу, которая будет выполняться каждый час (<a href="https://docs.rukovoditel.net.ru/index.php?p=70" target="_blank"><u>cron</u></a>):');
define('TEXT_NOTIFICATIONS_SCHEDULE_INFO','Пользователи смогут настраивать уведомления по расписанию для стандартных отчетов');
define('TEXT_DAY','День');
define('TEXT_TIME','Время');
define('TEXT_NOTIFICATION','Уведомление');
define('TEXT_REPORTS_NOTIFICATION_EMAIL','Здравствуйте.<p>Вы получили это сообщение потому, что следите за отчетом "%s".</p>');
define('TEXT_TECHNICAL_SUPPORT','Отдел технической поддержки');
define('TEXT_TECHNICAL_SUPPORT_INFO','Внутренние уведомления, такие как восстановление пароля и другие, будут отсылаться от email технической поддержки');
define('TEXT_DISABLE_NOTIFICATIONS','Отключить уведомления');
define('TEXT_DISABLE_NOTIFICATIONS_INFO','Вы не будете получать уведомления по электронной почте для записей на которые вы назначены');
define('TEXT_HEADER_TOP_MENU','Верхнее меню');
define('TEXT_CONFIGURE_HOT_REPORTS_INFO','Просто переместите отчеты между боксами для включения или исключения отчетов в верхнем меню');
define('TEXT_URL','Url');
define('TEXT_DEFAULT_VALUE','Значение по умолчанию');
define('TEXT_DEFAULT_VALUE_INFO','Введите значение по умолчанию или оставьте поле пустым');
define('TEXT_DO_NOT_NOTIFY','Не уведомлять');
define('TEXT_DO_NOT_NOTIFY_INFO','Назначенные пользователи не будут получать уведомление');
define('TEXT_IS_ACTIVE','Активный');
define('TEXT_SEND_ON_SCHEDULE','Отправлять по расписанию');
define('TEXT_SEND_EMAILS_ON_SCHEDULE','Отправлять письма по расписанию');
define('TEXT_SEND_EMAILS_ON_SCHEDULE_INFO','Перед включением данной возможности необходимо установить задачу по расписанию каждую минуту (<a href="https://docs.rukovoditel.net.ru/index.php?p=70" target="_blank"><u>cron</u></a>):');
define('TEXT_MAXIMUM_NUMBER_EMAILS','Максимальное число писем');
define('TEXT_MAXIMUM_NUMBER_EMAILS_INFO','Максимальное число писем, отправляемое при выполнении Cron за один раз');
define('TEXT_SEND_EMAILS_ON_SCHEDULE_DESCRIPTION','Перед включением данной возможности проверьте <a href="https://docs.rukovoditel.net.ru/index.php?p=8" target="_blank"><u>ограничения на отправку почты</u></a> на вашем сервере.');
define('TEXT_MAILER_ERROR','Ошибка отправки сообщения для %s');
define('TEXT_HIDE_INSERT_BUTTON_IN_REPORTS','Скрыть кнопку добавления в отчетах'); 
define('TEXT_DISABLE_NOTIFICATIONS_FIELDS_INFO','Назначенные пользователи не будут получать уведомления');
define('TEXT_FROM_TO','с %s по %s');

//new defines for version 1.9
define('TEXT_MOVE_LEFT','Переместить влево');
define('TEXT_MOVE_RIGHT','Переместить вправо');
define('TEXT_LIMITED_ACCESS','Ограниченный доступ');
define('TEXT_SEARCH_USERS','Поиск пользователей');
define('TEXT_USER_IS_NOT_FOUD','Пользователь не найден');
define('TEXT_USERS','Пользователи');
define('TEXT_FIELDTYPE_MAPBBCODE_TITLE','Карта');
define('TEXT_FIELDTYPE_MAPBBCODE_TOOLTIP','Поле ввода позволяет вводить координаты карты и отображать карту в соответствии с заданным координатам. С помощью встроенного редактора карты, у вас есть возможность выделить на карте область, нарисовать линию или вставить маркер.');
define('TEXT_DEFAULT_POSITION','Позиция по умолчанию');
define('TEXT_DEFAULT_POSITION_TIP','Введите координаты на карте. Например: 45.26329,34.10156');
define('TEXT_DEFAULT_ZOOM','Масштаб по умолчанию');
define('TEXT_DEFAULT_ZOOM_TIP','Масштаб карты. Например: 8');
define('TEXT_OPEN_MAP_EDITOR','Открыть редактор карт');
define('TEXT_USERS_NOTIFICATIONS','Мои уведомления');
define('TEXT_DELETE_SELECTED','Удалить выбранное');
define('TEXT_DISABLE_EMAIL_NOTIFICATIONS','Отключить уведомления по почте');
define('TEXT_DISABLE_INTERNAL_NOTIFICATIONS','Отключить внутренние уведомления');
define('TEXT_DISABLE_INTERNAL_NOTIFICATIONS_INFO','Верхнее меню "Мои уведомления" будет отключено.');
define('TEXT_DISABLE_HIGHLIGH_UNREAD','Отключить выделение непрочитанных записей');
define('TEXT_DISABLE_HIGHLIGH_UNREAD_INFO','Будет отключено подсветка непрочитанных записей.');
define('TEXT_FIELDTYPE_BARCODE_TITLE','Штрих-код');
define('TEXT_FIELDTYPE_BARCODE_TOOLTIP','В форме записи значение поля хранится как число, а в шаблоне экспорта это поле выводится в виде изображения штрих-кода.');
define('TEXT_FIELDTYPE_BARCODE_HEIGHT_TIP','Высота штрих-кода. По умолчанию 30 пикселей.');
define('TEXT_FIELDTYPE_BARCODE_TYPE','Тип штрих-кода');
define('TEXT_FIELDTYPE_BARCODE_TYPE_TIP','');
define('TEXT_DISPLAY_FIELD_VALUE','Отображать значение поля');
define('TEXT_FIELDTYPE_BARCODE_DSIPLAY_TIP','По умолчанию при экспорте отображается только штрих-код');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING','Способ генерации значения');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING_TIP','Используйте [ID поля] для установки значения поля в шаблоне.<br> Пример: "[36]ваш текст[54]" где 36 и 54 - идентификаторы полей ввода.<br>[auto:10] - значение будет сгенерировано автоматически. 10 - длина значения');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING_TIP_ICON','Введите метод генерации или оставьте поле пустым. Значение будет автоматически генерироваться при нажатии на кнопку "Сохранить"');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS','Определения маски');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS_TIP','Теперь вы можете задать свои собственные определения маски. Введите каждое определение в новой строке, например:<br>~=[+-]<br>h=[A-Fa-f0-9]');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS_TIP_ICON','
[abc]	- Любые символы между скобками<br>
[^abc] - Любой символ не в скобках<br>
[0-9] - Любая цифра в скобках<br>
(x|y)- Любой из указанных вариантов
');
define('TEXT_FIELDTYPE_QRCODE_TITLE','QR-код');
define('TEXT_FIELDTYPE_QRCODE_TOOLTIP','Поле для генерации QR кода');
define('TEXT_QRCODE_PATTERN','Шаблон для кодирования');
define('TEXT_HIDE_FIELD_ON_INFO_PAGE','Скрыть поле на странице записи');
define('TEXT_CODE_ERROR_CORRECTION','Код коррекции ошибок (ECC):');
define('TEXT_CODE_ERROR_CORRECTION_L','L - минимум');
define('TEXT_CODE_ERROR_CORRECTION_M','M - достаточно');
define('TEXT_CODE_ERROR_CORRECTION_Q','Q - много');
define('TEXT_CODE_ERROR_CORRECTION_H','H - максимум');
define('TEXT_PIXEL_SIZE','Размер пикселя');
define('TEXT_MENU_USERS_REGISTRATION','Регистрация пользователей');
define('TEXT_PUBLIC_REGISTRATION','Публичная регистрация');
define('TEXT_USE_PUBLIC_REGISTRATION','Включить публичную регистрацию');
define('TEXT_PUBLIC_REGISTRATION_USER_GROUP','Выберите группу доступа, которая будет назначаться пользователю при публичной регистрации.');
define('TEXT_REGISTRATION_BUTTON_TITLE','Кнопка регистрации');
define('TEXT_BUTTON_REGISTRATCION','Регистрация');
define('TEXT_REGISTRATION_NEW_USER','Регистрация нового пользователя');
define('TEXT_BUTTON_BACK','Назад');
define('TEXT_NOTE','Примечание');
define('TEXT_ADMINISTRATOR_NOTE','Примечание администратора');
define('TEXT_DISABLE_CHANGE_PWD','Запретить смену пароля');
define('TEXT_SELECT_USERS_GROUPS','Выберите группы пользователей');
define('TEXT_SEND','Отправить');
define('TEXT_COLUMN','Колонка');
define('TEXT_COLUMN_IMPORT_INFO','Укажите колонку для импорта');
define('TEXT_SORT_LIKE_FILE','Cортировать как в файле');
define('TEXT_DISABLE_ATTACHMENTS','Отключить вложения');
define('TEXT_SHOW','Показать');
define('TEXT_APP_LANGUAGE_TIP','Пользователи могут изменить язык в Личном Кабинете.');
define('TEXT_DISABLE_USERS_DEPENDENCY','Отключить зависимость');
define('TEXT_DISABLE_USERS_DEPENDENCY_INFO','По умолчанию, список пользователей зависит от назначенных пользователей в родительской записи.');
define('TEXT_CALCULATE_AVERAGE_VALUE','Вычислить среднее значение');
define('TEXT_REDIRRECTS','Переходы');
define('TEXT_REDIRECT_AFTER_ADDING','Переход после добавления записи');
define('TEXT_REDIRECT_AFTER_CLICK_HEADING','Переход после нажатия на заголовок записи');
define('TEXT_REDIRECT_TO_SUBENTITY','Переходить в список дочерних записей (если существуют)');
define('TEXT_REDIRECT_TO_LISTING','Оставаться на текущей странице');
define('TEXT_REDIRECT_TO_INFO','Переходить на страницу записи');
define('TEXT_DISPLAYS_ASSIGNED_ITEMS_ONLY','Отображает только назначенные записи ');
define('TEXT_DISPLAYS_ASSIGNED_ITEMS_ONLY_INFO','Добавляет фильтр по текущему пользователю');
define('TEXT_ROWS_PER_PAGE_IF_NOT_SET','Если не установлено, отображаются все записи.');
define('TEXT_CONFIGURE_FILTERS','Настроить фильтры');

//new defines for version 2.0
define('TEXT_IFRAME','iFrame');
define('TEXT_BUTTON_SEND','Отправить');
define('TEXT_FIELDTYPE_INPUT_EMAIL_TITLE','Поле для E-mail');
define('TEXT_FIELDTYPE_INPUT_EMAIL_TOOLTIP','Поле для ввода E-mail адреса');
define('TEXT_ERROR_REQUIRED_EMAIL','Пожалуйста, введите действительный адрес электронной почты.');
define('TEXT_DISPLAY_AS_LINK','Отображать как ссылку');
define('TEXT_FIELDTYPE_SECTION','Секция');
define('TEXT_FIELDTYPE_SECTION_TOOLTIP','Специальный тип поля предназначен для группирования элементов формы. Название поля является заголовком секции.');
define('TEXT_NAV_FORMS_FIELDS_DISPLAY_RULES','Правила отображения полей');
define('TEXT_FORMS_FIELDS_DISPLAY_RULES','Правила отображения полей в форме');
define('TEXT_BUTTON_ADD_NEW_RULE','Добавить новое правило');
define('TEXT_RULE_FOR_FIELD','Правило для поля');
define('TEXT_FORMS_FIELDS_DISPLAY_RULES_INFO','Для полей типа список у вас есть возможность настроить отображение полей, в зависимости от выбранного значения списка. <a href="https://docs.rukovoditel.net.ru/index.php?p=64" target="_blank">Подробнее</a>');
define('TEXT_DISPLAY_FIELDS','Отобразить поля');
define('TEXT_HIDE_FIELDS','Скрыть поля');
define('TEXT_SELECT_FIELD_VALUES','Выберите значения поля');
define('TEXT_EDIT_FIELDS','Редактировать поля');
define('TEXT_FIELDTYPE_RANDOM_VALUE','Случайное значение');
define('TEXT_FIELDTYPE_RANDOM_VALUE_TOOLTIP','Генерирует случайное значение из указанных символов.');
define('TEXT_VALUE_LENGTH','Длина значения');
define('TEXT_CHARACTERS','Символы');
define('TEXT_CHARACTERS_TIP','По умолчанию используются только цифры. Введите свои символы, из которых будет генерироваться значение.');
define('TEXT_SPLIT_VALUE','Разделить значение');
define('TEXT_SPLIT_VALUE_INFO','Значение можно разделить на несколько частей. Введите количество частей.');
define('TEXT_SPLIT_VALUE_CHAR','Разделитель');
define('TEXT_SPLIT_VALUE_CHAR_INFO','По умолчанию "-"');
define('TEXT_START_ROW','Начало строки');
define('TEXT_START_ROW_TIP','В значение можно добавить начало и конец');
define('TEXT_END_ROW','Конец строки');
define('TEXT_INTERNAL_FIELD_NOTE','Зарезервированное поле в системе.');
define('TEXT_RECORD_NOT_FOUND','Запись не найдена');
define('TEXT_FILE_NOT_FOUND','Файл не найден');
define('TEXT_DISPLAY_AS_COUNTER','Отображать как счетчик');
define('TEXT_DISPLAY_ICON','Отображать иконку');
define('TEXT_COLOR','Цвет');
define('TEXT_EXTRA_FIELDS','Дополнительные поля');
define('TEXT_DASHBOARD_REPORT_EXTRA_FIELDS_INFO','Будет высчитываться сумма для выбранных полей');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_TITLE','Многоуровневый выпадающий список');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_TOOLTIP','Каждый уровень из списка значений отображается как отдельный список');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS','Настройки уровней');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS_INFO','Введите название для каждого уровня вложенности с новой строки. Первая строка - первый уровень и т.д.');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS_TIP','Например:<br>&nbsp;&nbsp;Страна<br>&nbsp;&nbsp;Область<br>Или:<br>&nbsp;&nbsp;Страна, Выберите страну<br>&nbsp;&nbsp;Область, Выберите область');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_VALUE_DISPLAY','Собственный столбец для каждого значения');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_VALUE_DISPLAY_TIP','По умолчанию, выбранные значения будут отображаться в одном столбце');
define('TEXT_COLUMNS_IMPORT','Импортировать колонки');
define('TEXT_COLUMNS_IMPORT_INFO','Для импорта простого списка укажите 1 - будет импортирована первая колонка. Для импорта зависимых значений, таких как (страна/область) укажите 2. В таком случае, будут считываться первые две колонки в файле. Значения в строках не должны быть пустые.');
define('TEXT_DASHBOARD_DEFAULT_MSG','<h3 class="page-title">Добро пожаловать!</h3><p>Это – главная страница системы. Сейчас она пустая, но вы можете отобразить здесь различные отчеты и счетчики.</p><p>Для того, чтобы отобразить ваш первый отчет, выберите слева вкладку "Отчеты" и создайте необходимый вам отчет, установив при создании галочку "Отображать на главной".</p>');
define('TEXT_DASHBOARD_DEFAULT_ADMIN_MSG','<h3 class="page-title">Вас приветствует Руководитель – ваш новый помощник в ведении дел!</h3> 
<p>Это – главная страница вашей системы. Сейчас она пустая, но вы можете отобразить здесь различные отчеты и счетчики.</p> 
<p>Для того, чтобы отобразить ваш первый отчет, выберите слева вкладку "Отчеты" и создайте необходимый вам отчет, установив при создании галочку "Отображать на главной".</p>
<p>Если вы еще не успели ознакомиться с системой более подробно, рекомендуем посетить раздел "<a href="https://docs.rukovoditel.net.ru/index.php" target="_blank">Документация</a>". Там вы найдете различные советы по настройке системы.</p>
<p>Остались вопросы? Вы всегда можете обратиться к нам за помощью! </p>
<p><a href="https://www.rukovoditel.net.ru" target="_blank">www.rukovoditel.net.ru</a></p>');
define('TEXT_FILES_UPLOAD_LIMIT','Ограничение загрузки');
define('TEXT_FILES_UPLOAD_LIMIT_TIP','Максимальное количество файлов, которые могут быть загружены. Оставьте поле пустым, чтобы убрать какие-либо ограничения.');
define('TEXT_FILES_UPLOAD_SIZE_LIMIT','Ограничение размера файла');
define('TEXT_FILES_UPLOAD_SIZE_LIMIT_TIP','Максимальный размер загружаемого файла, в МБ');
define('TEXT_FILE_TOO_LARGE','Слишком большой файл');
define('TEXT_MAXIMUM_UPLOAD_LIMIT','Превышен лимит на количество загружаемых файлов. Максимальное количество файлов: ');
define('TEXT_COMPLETED','Завершено');
define('TEXT_CANCELLED','Отменено');
define('TEXT_FROM_SESSION_ERROR','Ошибка отправки формы. Пожалуйста, повторите попытку.');
define('TEXT_ERROR_MESSAGE','Сообщение об ошибке');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR_MSG_TIP','Сообщение об ошибке отображается в случае, если поле не уникально.');
define('TEXT_ICON','Иконка');
define('TEXT_HIDEN_FIELDS','Скрытые поля');
define('TEXT_HIDEN_FIELDS_IN_FORM','Скрытые поля не отображаются в форме');
define('TEXT_NAV_ITEM_PAGE_CONFIG','Настройка страницы записи');
define('TEXT_COLUMNS_SIZE','Размеры колонок');
define('TEXT_ITEM_PAGE_COLUMNS_SIZE','Страница записи разделена на две колонки и вы можете настроить их размер.');
define('TEXT_ITEM_DETAILS_POSITION','Детали записи');
define('TEXT_ITEM_DETAILS_POSITION_INFO','По умолчанию, поля записи разделены на две колонки. Вы можете объединить их в одну.');
define('TEXT_ONE_COLUMN','Одна колонка');
define('TEXT_TWO_COLUMNS','Две колонки');
define('TEXT_ITEM_HIDDEN_PAGE_INFO','По умолчанию отображаются все поля.');
define('TEXT_LEFT_COLUMN','Левая колонка');
define('TEXT_RIGHT_COLUMN','Правая колонка');
define('TEXT_ITEM_DETAILS_SUM_ENTITIES','Чтобы отобразить записи из вложенных сущностей, просто укажите позицию на странице. Также, вы можете настроить собственные фильтры списка для каждой сущности.');
define('TEXT_ITEM_PAGE_PARENT_ITEM','Страница записи родительской сущности');
define('TEXT_HIDE_IN_TOP_MENU','Скрыть в верхнем меню');
define('TEXT_TOP_LEVEL','Верхний уровень');
define('TEXT_CALCULATE_AVERAGE_VALUE_INFO','Среднее значение отображается в списке записей');
define('TEXT_REPORTS_CREATE_ACCESS','Стандартные отчеты');
define('TEXT_UPDATE_SELECTED_ACCESS','Обновить выбранные');
define('TEXT_DELETE_SELECTED_ACCESS','Удалить выбранные');
define('TEXT_EXPORT_ACCESS','Экспорт записи');
define('TEXT_EXPORT_SELECTED_ACCESS','Экспортировать выбранные');
define('TEXT_VIEW_ALL_ACTION_WIDHT_ASSIGNED_ACCESS','Просмотр всех. Действия с назначенными');
define('TEXT_ENTITY_ACCESS_INFO_EXTRA','<br>Опция "Просмотр всех. Действия с назначенными" разрешает выполнять действия только с назначенными записями.<br>Опция "Обновить выбранные" будет доступна при установленном дополнении. <a href="https://docs.rukovoditel.net.ru/index.php?p=89" target="_blank">Подробнее.</a>');
define('TEXT_CONDITION_NOT_EMPTY_VALUE','Непустое значение');
define('TEXT_FIELDTYPE_AUTOSTATUS_TITLE','Автоматический статус');
define('TEXT_FIELDTYPE_AUTOSTATUS_TOOLTIP','После создания поля, создайте необходимые статусы, нажав на имя поля в списке полей. Статус будет устанавливаться автоматически при создании или редактировании записи, в зависимости от настроенных фильтров. <a href="https://docs.rukovoditel.net.ru/index.php?p=16" target="_blank">Подробнее</a>.');
define('TEXT_FIELDTYPE_AUTOSTATUS_OPTIONS_TIP','Для каждой опции установите фильтры, нажав на название опции. Значение будет устанавливаться, если состояние записи совпадает с установленными фильтрами. Проверка состояний выполняется в заданной сортировке и если состояние найдено, проверка прекращается. ');
define('TEXT_FILTERS','Фильтры');
define('TEXT_AUTOUPDATE','Автообновление');
define('TEXT_DISPLAY_IN_HEADER_AUTOUPDATE_TOOLTIP','Данные отчета обновляются каждую минуту. Данная опция увеличивает нагрузку на сервер. Используйте ее там, где это действительно необходимо.');
define('TEXT_PREFIX','Префикс');
define('TEXT_SUFFIX','Суффикс');
define('TEXT_PREVIEW_IMAGE_SIZE_IN_LISTING','Ширина изображения в списке');
define('TEXT_MARK_AS_READ','Отметить, как прочитанные');
define('TEXT_DISPLAY_NUMBER_OF_ITEMS_OPEN_REPORT','Отображено %s. Перейти в отчет<i class="fa fa-angle-right"></i>');
define('TEXT_DISABLE_CHECK_FOR_UPDATES','Отключить проверку обновлений');
define('TEXT_EXAMPLE','Пример');
define('TEXT_DISPLAY_FILE_DATE_ADDED','Показывать дату загрузки файла');
define('TEXT_NEW_FEATURES_FOR_YOUR_BUSINESS','Новые возможности для вашего бизнеса');
define('TEXT_ONE_OFF_CHARGE','Разовый платеж');
define('TEXT_UPDATES_FOR_FREE','Последующие обновления бесплатны');
define('TEXT_FREE_SUPPORT','Бесплатная поддержка');
define('TEXT_BUY_EXTENSION','Купить дополнение');
define('TEXT_EXTENSION_FEATURES','Возможности Дополнения');
define('TEXT_EXTENSION_FEATURES_INFO','В Дополнение входит набор отчетов и инструментов для более эффективного планирования и управления.');
define('TEXT_EXTENSION_FEATURES_LIST','');
define('TEXT_HIDE_ADMIN','Скрыть администраторов');
define('TEXT_ACTION_IMPORT_DATA','Импортировать данные');
define('TEXT_ACTION_UPDATE_DATA','Обновить данные');
define('TEXT_ACTION_UPDATE_AND_IMPORT_DATA','Обновить и импортировать новые');
define('TEXT_UPDATE_BY_FIELD','Обновить по полю');
define('TEXT_USE_COLUMN','Использовать колонку');
define('TEXT_UPDATE_SETTINGS','Настройки обновления');
define('TEXT_COUNT_ITEMS_ADDED','Добавлено записей');
define('TEXT_COUNT_ITEMS_UPDATED','Обновлено записей');
define('TEXT_SEND_NOTIFICATION','Отправлять уведомление');
define('TEXT_REGISTRATION_SEND_NOTIFICATION_INFO','Выбранные пользователи получают уведомление по электронной почте при создании новой учетной записи пользователя');
define('TEXT_SERVER_LOAD','Нагрузка на сервер');
define('TEXT_REPORTS_IN_HEADER_MENU','Отчеты в верхнем меню');
define('TEXT_SERVER_LOAD_INFO','Здесь вы можете настроить функции кэширования приложения для снижения нагрузки на сервер.');
define('TEXT_USE_CACHE','Использовать кэш');
define('TEXT_CACHE_LIVETIME','Время жизни кэша');
define('TEXT_CACHE_LIVETIME_INFO','В секундах');
define('TEXT_REPORTS_IN_HEADER_MENU_CACHE_INFO','По умолчанию, отчеты в верхнем меню обновляются каждый раз при обновлении страницы, что создает нагрузку на сервер при работе с большим количеством очетов и пользователей.');
define('TEXT_CACHE_FOLDER','Папка кэша');

//new defines for version 2.1
define('TEXT_PIVOT_ACCESS_TABLE','Сводная таблица доступа');
define('TEXT_COPY_ACCESS','Копировать доступ');
define('TEXT_SELECT_ENTITY_TO_COPY_ACCESS','Выберите сущности для копирования доступа.');
define('TEXT_COPY_ACCESS_INFO','Существующие права доступа будут перезаписаны.');
define('TEXT_USERS_ALERTS','Оповещения пользователей');
define('TEXT_USERS_ALERTS_INFO','На этой странице у вас есть возможность создавать оповещения для выбранных пользователей  или групп пользователей. <a href="https://docs.rukovoditel.net.ru/index.php?p=15" target="_blank">Подробнее</a>.');
define('TEXT_LOCATION','Расположение');
define('TEXT_LOCATION_ON_DASHBOARD','На главной странице');
define('TEXT_LOCATION_ON_ALL_PAGES','На всех страницах');
define('TEXT_TITLE','Название');
define('TEXT_ALERT_INFO','Информация');
define('TEXT_ALERT_SUCCESS','Совет');
define('TEXT_ALERT_WARNING','Предупреждение');
define('TEXT_ALERT_DANGER','Срочное сообщение');
define('TEXT_DISPLAY_DATE','Дата отображения');
define('TEXT_DB_RESTORE_PROCESS','Восстановление базы данных');
define('TEXT_DB_RESTORE_PROCESS_INFO','Этот процесс может занять несколько минут, не закрывайте окно браузера.<br><br>В случае возникновения ошибки, восстановите базу данных с помощью phpMyAdmin.');
define('TEXT_IF_NOT_ASSIGNED_DISPLY_EVERYONE','Если группа и пользователи не указаны, сообщение будет отображаться всем.');
define('TEXT_FLOWCHART','Блок-схема');
define('TEXT_ENTITIES_FLOWCHART_INFO','На блок-схеме отображены сущности и связи. В целях экономии места, связь с зарезервированной сущностью "Пользователи" (типы полей "Пользователи" и "Группа пользователей") не отображается стрелкой.');
define('TEXT_PUBLIC_REGISTRATION_USER_GROUP_MULTIPLE','Если указано несколько групп, пользователи смогут самостоятельно выбрать группу при регистрации.');
define('TEXT_HEADING_WIDTH_BASED_CONTENT','Вычислять ширину ячейки на основе содержимого');
define('TEXT_HEADING_WIDTH_BASED_CONTENT_INFO','По умолчанию, ячейка заголовка имеет ширину 100%');

//new defines for version 2.2
define('TEXT_VALUE','Значение');
define('TEXT_CHOICES_VALUE_INFO','Значение может использоваться в вычислениях формулы. <a href="https://docs.rukovoditel.net.ru/index.php?p=25#get_value" target="_blank">Подробнее</a>');
define('TEXT_FIELDS_TYPES_GROUP_NUMERIC','Числовое поле');
define('TEXT_FIELDTYPE_JS_FORMULA_TITLE','JS Формула');
define('TEXT_FIELDTYPE_JS_FORMULA_TOOLTIP','Значение этого поля будет рассчитываться по формуле, указанной ниже. Значение рассчитывается непосредственно в форме добавления записи. Вы можете использовать синтаксис JavaScript в формуле.');
define('TEXT_JS_FORMULA_TIP','Используйте [ID поля] для установки значения поля в формуле. Пример: ([36]+[54])/2 где 36 и 54 - идентификаторы числовых полей. <a href="https://docs.rukovoditel.net.ru/index.php?p=72" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_JS_FORMULA_ERROR','Ошибка расчета формулы');
define('TEXT_DISPLAY_CHOICES_VALUES','Отображать значения опций');
define('TEXT_DISPLAY_CHOICES_VALUES_TIP','Установленные значения опций будут отображаться в списке, например (+10)');
define('TEXT_NAV_ACCESS_RULES','Правила доступа');
define('TEXT_ACCESS_ALLOCATION_RULES','Правила распределения доступа');
define('TEXT_ACCESS_ALLOCATION_RULES_INFO','На этой странице у вас есть возможность настроить доступ пользователей в зависимости от значений выбранного поля. <a href="https://docs.rukovoditel.net.ru/index.php?p=28" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ADD_FIELD','Добавить поле');
define('TEXT_ACCESS_RULES_FOR_FIELD','Правила распределения доступа для поля "%s"');
define('TEXT_ACCESS_RULES_FOR_FIELD_INFO','Настройте правила доступа для выбранных значений поля.');
define('TEXT_ACCESS_RULES_SELECT_ACCESS','Если значения не выбраны, пользователи будут иметь доступ только на просмотр.');
define('TEXT_ACCESS_RULES_FIELDS_VIEW_ONLY_ACCESS','Выберите поля, доступ к которым будет только на просмотр.');
define('TEXT_USE_DEFAULT_IF_NOT_SELECTED','Если значение не выбрано, будут использоваться настройки по умолчанию.');
define('TEXT_FIELDTYPE_TODO_LIST_TITLE','Список дел');
define('TEXT_FIELDTYPE_TODO_LIST_TOOLTIP','Специальный тип поля позволяющий вам создавать список дел (подзадач) в рамках одной задачи. Каждая подзадача вводится с новой строчки в текстовом поле. Символ * в начале строки означает, что подзадача завершена. <a href="https://docs.rukovoditel.net.ru/index.php?p=26" target="_blank"><u>Подробнее</u></a>.');
define('TEXT_AUTO_ADD_COMMENT','Автоматически добавлять комментарий');
define('TEXT_OPEN_COMMENT_FORM','Открывать форму комментария');
define('TEXT_FIELDTYPE_TODO_LIST_USE_COMMENTS_INFO','Использовать комментарии при отметке в списке');
define('TEXT_FOR_SUCCESSFUL_CHECK','Текст для успешной отметки');
define('TEXT_FOR_UNCHECK','Текст для снятия отметки');
define('TEXT_SELECT_REPORTS','Выберите отчеты');
define('TEXT_SORT_ITEMS_IN_LIST','Для сортировки элементов в списке, просто перетащите их.');
define('TEXT_REPORTS_GROUPS','Группы отчетов');
define('TEXT_REPORTS_GROUPS_INFO','Группируйте отчеты по определенной сущности или данным и выводите их на отдельной странице. <a href="https://docs.rukovoditel.net.ru/index.php?p=68" target="_blank"><u>Подробнее</u></a>');
define('TEXT_SECTIONS','Секции');
define('TEXT_CONFIGURE_DASHBOARD_SECTION_INFO','Каждая секция состоит из двух колонок для отчетов.');
define('TEXT_ADD_SECTION','Добавить секцию');
define('TEXT_REPORT_ALREADY_ASSIGNED','Этот отчет уже используется.');
define('TEXT_RELATED_ENTITIES_BY_FIELD_ENTITY','Связанные сущности по полю "Сущность"');
define('TEXT_RELATED_ENTITIES_BY_FIELD_ENTITY_INFO','Чтобы отобразить записи из связанных сущностей, просто укажите позицию на странице. Также, вы можете настроить собственные фильтры списка для каждой сущности.');
define('TEXT_FIELDTYPE_PARENT_VALUE_TITLE','Значение из родительской сущности');
define('TEXT_FIELDTYPE_PARENT_VALUE_TOOLTIP','Данный тип поля предназначен для отображения значения из родительской сущности. Обратите внимание, что данный тип поля нельзя применить в формулах. Чтобы использовать в формуле значение из родительской сущности, используйте функцию SELECT.');
define('TEXT_LDAP_FIRSTNAME','Атрибут "Имя"');
define('TEXT_LDAP_FIRSTNAME_NOTE','Например: givenname');
define('TEXT_LDAP_LASTNAME','Атрибут "Фамилия"');
define('TEXT_LDAP_LASTNAME_NOTE','Например: sn');
define('TEXT_USE_LDAP_LOGIN_ONLY','Использовать только LDAP вход');
define('TEXT_LDAP_GROUP_FILTER','Фильтр LDAP');
define('TEXT_LDAP_GROUP_FILTER_INFO','При использовании LDAP новый пользователь будет автоматически помещен в эту группу, если его учетная запись удовлетворяет данному фильтру.');

//new defines for version 2.3
define('TEXT_ADD_COMMENT_CREATE_RELATED_ITEM','Добавлять комментарий при создании связи');
define('TEXT_ADD_COMMENT_DELETE_RELATED_ITEM','Добавлять комментарий при удалении связи');
define('TEXT_ADD_COMMENT_WITHOUT_NOTIFICATION','Добавить комментарий без уведомления');
define('TEXT_ADD_COMMENT_WITH_NOTIFICATION','Добавить комментарий с уведомлением');
define('TEXT_FIELDTYPE_MYSQL_QUERY_TITLE','MySQL запрос');
define('TEXT_FIELDTYPE_MYSQL_QUERY_TOOLTIP','Специальный тип поля для создания пользовательского MySQL запроса к выбранной сущности. <a href="https://docs.rukovoditel.net.ru/index.php?p=24" target="_blank"><u>Подробнее</u></a>.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_ENTITY','Выбрать из сущности');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_ENTITY_TOOLTIP','Выберите сущность к которой будет строится MySQL запрос');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_QUERY','Выбрать поле');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_QUERY_TIP','Укажите поле, которое будет выбрано в запросе.<br>Например: [12]. Можно использовать функции MySQL.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_WHERE_QUERY','Условие');
define('TEXT_FIELDTYPE_MYSQL_QUERY_WHERE_QUERY_TIP','Используя ID полей, задайте условия того, что должно быть выбрано в запросе. Например: [50]=[12]. Можно использовать функции MySQL.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_DINAMIC_QUERY','Выполнять динамически');
define('TEXT_FIELDTYPE_MYSQL_QUERY_DINAMIC_QUERY_INFO','По умолчанию запрос выполняется при добавлении/редактировании записи. Установив данную опцию запрос будет выполняться непосредственно при просмотре записи.');
define('TEXT_HIDE_ADD_BUTTON_RULES','Скрыть кнопку "Добавить"');
define('TEXT_HIDE_ADD_BUTTON_RULES_INFO','Установите фильтры для сущности "%s" при которых кнопка "Добавить" будет скрыта для сущности "%s".');
define('TEXT_FIELDTYPE_IMAGE_MAP_TITLE','План-схема');
define('TEXT_FIELDTYPE_IMAGE_MAP_TOOLTIP','Это специальный тип поля для отображения пользовательских карт, поэтажных планов, создания пользовательских меток маркеров на карте и многое другое. После создания поля нажмите на название и добавьте варианты карт и загрузите свое изображение для каждого варианта. <a href="https://docs.rukovoditel.net.ru/index.php?p=18" target="_blank"><u>Подробнее</u></a>');
define('TEXT_MAP_SETTINGS','Настройки карты');
define('TEXT_IMAGE','Изображение');
define('TEXT_IMAGE_MAP_FILENAME_INFO','Загрузите изображение которое будет использоваться для построения карты.<br><b>Обратите внимание:</b> изменение изображения карты может привести к тому, что позиции элементов карты могут не вписаться в новое изображение карты.');
define('TEXT_IMAGE_MAP_FILENAME_DESCRIPTION','Минимальный размер изображения карты - 512x512px.');
define('TEXT_FIELDTYPE_IMAGE_MAP_BACKGROUND_COLOR_INFO','К маркерам на карте будет применяться фон из значений списка. Также к каждому значению списка можно загрузить свою иконку.');
define('TEXT_FIELDTYPE_IMAGE_MAP_OPTIONS_TIP','Для опций верхнего уровня загрузите изображение которое будет использоваться на карте.');
define('TEXT_ICONS','Иконки');
define('TEXT_FIELDTYPE_IMAGE_MAP_ICONS_TIP','Загрузите иконки размером 24x24. <a href="https://www.iconfinder.com" target="_blank">Поиск иконок</a>');
define('TEXT_EXT_PB_USER_AGREEMENT_TEXT','Ссылка на страницу "Пользовательское соглашение"');
define('TEXT_EXT_PB_USER_AGREEMENT_TEXT_INFO','Добавьте текст со ссылкой на страницу "Пользовательское соглашение" на вашем сайте. В форме появится обязательная опция, которую пользователь должен установить перед отправкой формы. ');
define('TEXT_FIELDTYPE_MIND_MAP_TITLE','Диаграмма связей (Mind map)');
define('TEXT_FIELDTYPE_MIND_MAP_TOOLTIP','Специальный тип поля для построения диаграммы связей в виде древовидной схемы, на которой изображены слова, идеи, задачи связанные ветвями, отходящими от центрального понятия или идеи. <a href="https://docs.rukovoditel.net.ru/index.php?p=19" target="_blank"><u>Подробнее</u></a>');
define('TEXT_MIND_MAP_START_TIP','Нажмите "Tab", чтобы вставить дочерний элемент, "Enter", чтобы вставить родственный элемент.');
define('TEXT_SAVE','Сохранить');
define('TEXT_RESET','Сброс');
define('TEXT_RESET_MAP_CONFIRM','Сбросить текущую карту и начать новую?');
define('TEXT_LAYOUT','Макет');
define('TEXT_SHAPE','Форма');
define('TEXT_NUMBER','Число');
define('TEXT_SUM','Сумма');
define('TEXT_AVERAGE','Среднее');
define('TEXT_MINIMUM','Минимальное');
define('TEXT_MAXIMUM','Максимальное');
define('TEXT_ON_TOP','Вверху');
define('TEXT_ON_BOTTOM','Внизу');
define('TEXT_ON_RIGHT','Справа');
define('TEXT_ON_LEFT','Слева');
define('TEXT_GRAPH','Диаграмма');
define('TEXT_TREE','Дерево');
define('TEXT_MAP','Карта');
define('TEXT_INHERIT','Наследовать');
define('TEXT_AUTOMATIC','Автоматически');
define('TEXT_BOX','Коробка');
define('TEXT_ELLIPSE','Эллипс');
define('TEXT_UNDERLINE','Подчеркнуть');
define('TEXT_INSERT_CHILD','Вставить дочерний элемент');
define('TEXT_INSERT_SIBLING','Вставить родственный элемент');
define('TEXT_EDIT','Редактировать');
define('TEXT_SET_VALUE','Установить значение');
define('TEXT_CENTER_MAP','Центр карты');
define('TEXT_ERROR_HEADING_FIELD_ONLY_INPUT_SUPPORT','Используйте поле ввода в качестве заголовка.');
define('TEXT_START','Начало');
define('TEXT_LISGIN_CONFIGURATION_INFO','На этой страницы вы можете настроить варианты внешнего вида списка записей. <a href="https://docs.rukovoditel.net.ru/index.php?p=65" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_TABLE','Таблица');
define('TEXT_LIST','Список');
define('TEXT_GRID','Плитка');
define('TEXT_MOBILE','Мобильное устройство');
define('TEXT_NOT_REQUIRED_FIELD','Не обязательное поле');
define('TEXT_DISPLAY_FIELD_NAMES','Отображать название полей');
define('TEXT_ALIGN','Выравнивание');
define('TEXT_ALIGN_LEFT','По левому краю');
define('TEXT_ALIGN_CENTER','По центру');
define('TEXT_ALIGN_RIGHT','По правому краю');
define('TEXT_DISPLAY_AS','Показать как');
define('TEXT_INLINE_LIST','Строка');
define('TEXT_SECTION_WIDHT_TIP','Введите проценты или пиксели. Например. 100% или 150px. Значение по умолчанию - авто.');
define('TEXT_GRID_WIDHT_INFO','Введите минимальную ширину ячейки в пикселях.<br>Например: 250. Количество ячеек в строке будет рассчитываться автоматически в зависимости от ширины экрана.');
define('TEXT_IMPORT','Импортировать');
define('TEXT_LDAP_INFO','Для аутентификации в системе Руководитель пользователи смогут использовать свои LDAP данные. <a href="https://docs.rukovoditel.net.ru/index.php?p=9" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_TITLE','Разница в днях');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_TOOLTIP','Специальный тип поля, который высчитывает разницу в днях между двумя датами. <a href="https://docs.rukovoditel.net.ru/index.php?p=88" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_HOLIDAYS','Праздничные даты');
define('TEXT_START_DATE','Дата начала');
define('TEXT_END_DATE','Дата окончания');
define('TEXT_EXCLUDE_LAST_DAY','Исключить последний день');
define('TEXT_EXCLUDE_WEEK_DAYS','Исключить дни недели');
define('TEXT_EXCLUDE_HOLIDAYS','Исключить праздники');
define('TEXT_CURRENT_DATE','Текущая дата');
define('TEXT_FIELDTYPE_HOURS_DIFFERENCE_TITLE','Разница в часах');
define('TEXT_FIELDTYPE_HOURS_DIFFERENCE_TOOLTIP','Специальный тип поля, который высчитывает разницу в часах между двумя датами. <a href="https://docs.rukovoditel.net.ru/index.php?p=88" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_WORKING_HOURS','Рабочее время');
define('TEXT_WORKING_HOURS_INFO','Для расчета разницы будут использоваться только рабочее время.');
define('TEXT_HOLIDAYS_INFO','Праздничные даты можно исключить при расчете разницы дней. <a href="https://docs.rukovoditel.net.ru/index.php?p=88" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_LOGIN_AS','Войти как <b>%s</b>');
define('TEXT_LOGIN_BACK_AS_ADMIN','Вернуться в систему как администратор');

//new defines for version 2.4
define('TEXT_FIELDTYPE_BOOLEAN_CHECKBOX_TITLE','Логическое поле (Флажок)');
define('TEXT_DISPLAY_IN_LISTING','Отображать в списке');
define('TEXT_COUNT_RELATED_ITEMS','Количество связанных записей');
define('TEXT_LIST_RELATED_ITEMS','Список связанных записей');
define('TEXT_HEADING_PATTER_IN_LINSING','Шаблон заголовка в списке');
define('TEXT_HIDE_FIELD_IF_NO_RECORDS','Скрыть поле при отсутствии записей');
define('TEXT_HIDE_BUTTONS','Скрыть кнопки');
define('TEXT_CHANGE_STRUCTURE','Изменить структуру');
define('TEXT_CHANGE_STRUCTURE_INFO','Внимание: данная операция повлечет за собой изменение записей для выбранной сущности. Рекомендуется сделать резервную копию базы данных перед началом действий.');
define('TEXT_MOVE_ENTITY','Переместить сущность');
define('TEXT_MOVE_TO_PARETN_ITEM_INFO','Все записи будут перемещены в выбранный элемент.');
define('TEXT_ENTITY_STRUCTURE_CHANGED','Структура сущностей изменена.');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_TITLE','Автоинкремент');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_TOOLTIP','При добавлении новой записи, значение поля увеличивается на один. Поле в форме отображается как поле ввода, и значение можно откорректировать.');
define('TEXT_FIELDTYPE_TEXT_PATTERN_STATIC','Статический текст по шаблону');
define('TEXT_FIELDTYPE_TEXT_PATTERN_STATIC_TOOLTIP','Специальное поле, которое позволяет отобразить текст в заданном шаблоне. Значение генерируется при добавлении/изменении записи. Есть возможность поиска по значению.');
define('TEXT_TOOLTIP_ON_ITEM_PAGE','Подсказка на странице записи');
define('TEXT_DISPLAY_ON_ITEM_PAGE','Отображать на странице записи');
define('TEXT_EXTRA','Дополнительно');
define('TEXT_EMAIL_SUBJECT','Тема сообщения');
define('TEXT_ENCRYPT_FILE_NAME','Шифровать имя файла');
define('TEXT_ENCRYPT_FILE_NAME_TIP','По умолчанию имя файла зашифровано в целях безопасности.');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_DINAMIC_INFO','По умолчанию разница рассчитывается при добавлении/редактировании записи. Используйте этот параметр для динамического расчета с текущей датой.');
define('TEXT_USERS_LOGIN_LOG','Журнал входа пользователей');
define('TEXT_IP','IP');
define('TEXT_LOGIN_ATTEMPT','Попытка входа');
define('TEXT_SUCCESSFUL_LOGIN','Успешный вход');
define('TEXT_FIELDTYPE_USER_LAST_LOGIN_DATE','Дата последнего входа');
define('TEXT_DELETE_DATA','Удалить данные');
define('TEXT_FIELDTYPE_YEARS_DIFFERENCE_TITLE','Разница в годах');
define('TEXT_FIELDTYPE_YEARS_DIFFERENCE_TOOLTIP','Специальный тип поля, который высчитывает разницу в годах между двумя датами. <a href="https://docs.rukovoditel.net.ru/index.php?p=88" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_CALCULATE_DIFFERENCE_DAYS','Вычислять разницу в днях');
define('TEXT_FIELDTYPE_PHONE','Телефон');
define('TEXT_FIELDTYPE_PHONE_TOOLTIP','Специальный тип поля для ввода телефона. Можно настроить для совершения звонков. <a href="https://docs.rukovoditel.net.ru/index.php?p=62" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_INPUT_FIELD_PHONE_MASK_TIP','Например: +7(999)999-99-99<br>
<ul>  
  <li>9 - Пользователь должен ввести цифру (0-9)</li>  
</ul>');
define('TEXT_FIELDTYPE_DATE_UPDATED_TITLE','Дата обновления');
define('TEXT_MIN_VALUE','Минимальное значение');
define('TEXT_MIN_VALUE_WARNING','Введите значение, большее или равное {0}.');
define('TEXT_MAX_VALUE','Максимальное значение');
define('TEXT_MAX_VALUE_WARNING','Введите значение, меньшее или равное {0}.');
define('TEXT_MIN_MAX_VALUE_TIP','Введите число или введите [ID] поля для применения значения поля в правиле.');
define('TEXT_PHONE','Телефон');
define('TEXT_ERROR_REQUIRED_DIGITS','Пожалуйста, введите целое число.');
define('TEXT_DASHBOARD_CONFIGURATION','Настройка главной страницы');
define('TEXT_DASHBOARD_CONFIGURATION_INFO','На главную страницу можно добавить информационные блоки или страницы. В инфо блоке можно выводить информацию о текущем пользователе. <a href="https://docs.rukovoditel.net.ru/index.php?p=13" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ADD_INFO_BLOCK','Добавить информационный блок');
define('TEXT_ADD_PAGE','Добавить страницу');
define('TEXT_ADD_INFO_SECTIONS_INFO','Информационные блоки можно объединить в секции.');
define('TEXT_COLUMNS','Колонки');
define('TEXT_POSITION','Позиция');
define('TEXT_DASHBOARD_BLOCK_SECTION_INFO','[user_name] - имя пользователя');
define('TEXT_AUTHORIZED_USER_BY_DEFAULT','Авторизованный пользователь по умолчанию');
define('TEXT_AUTHORIZED_USER_BY_DEFAULT_INFO','При добавлении новой записи авторизованный пользователь назначается по умолчанию');
define('TEXT_HELP_SYSTEM','Справочная система');
define('TEXT_HELP_SYSTEM_INFO','Создавайте информационные страницы и объявления для конкретной сущности. <a href="https://docs.rukovoditel.net.ru/index.php?p=27" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ADD_ANNOUNCEMENT','Добавить объявление');
define('TEXT_HIDE_COUNT_OF_RECORDS','Скрыть количество записей');
define('TEXT_SUM_BY_FIELD','Сумма по полю');
define('TEXT_COUNTER_SUM_BY_FIELD_INFO','По умолчанию отображается количество записей.');
define('TEXT_ITEMS_LISTING','Список записей');
define('TEXT_HELP','Помощь');
define('TEXT_ALLOW_LOGIN_FOR_USERS','Разрешить вход для пользователей');
define('TEXT_ALLOWED_EXTENSIONS','Разрешенные расширения');
define('TEXT_ALLOWED_EXTENSIONS_TIP','Введите расширения через запятую, например: gif,jpg,sql,zip');
define('TEXT_ENTITIES_PAGE_INFO','Руководитель позволяет создавать собственную базу данных путем добавления новых сущностей и связей. <a href="https://docs.rukovoditel.net.ru/index.php?p=12" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_SHOW_USERS','Показывать пользователей');
define('TEXT_IN_LISTING','В списке');
define('TEXT_IN_ITEM_PAGE','На странице записи');
define('TEXT_FIELDTYPE_GROUPEDUSERS_SHOW_USERS_TIP','Вместе с названием группы будет отображаться список пользователей.');
define('TEXT_SHOW_USERS_ACCESS_GROUP','Показывать группу доступа');
define('TEXT_CHANGE_COL_WIDTH_IN_LISTIN','Изменять ширину колонок в списке');
define('TEXT_ENTITY_MOVE_TO','Переместить в');

//new defines for version 2.5
define('TEXT_VALUE_VIEW_ONLY_INFO','Значения поля доступно только для просмотра.');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_SEPARATE_NUMBERING','Раздельная нумерация для каждой родительской записи');
define('TEXT_MAPS','Карты');
define('TEXT_FIELDTYPE_GOOGLE_MAP_TITLE','Карта Google');
define('TEXT_FIELDTYPE_GOOGLE_MAP_TOOLTIP','Поле для отображения маркера на карте. Координаты маркера определяются автоматически по введенному адресу. <a href="https://docs.rukovoditel.net.ru/index.php?p=17" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_API_KEY','Ключ API');
define('TEXT_FIELDTYPE_GOOGLE_MAP_API_KEY_TIP','Вы должны получить ключ API с помощью консоли Google Cloud Platform. <u>GeoLocation API</u> и <u>Map Embed API</u> должны быть включены. <a href="https://developers.google.com/maps/documentation/javascript/get-api-key#quick-guide" target="_blank">Подробнее.</a>');
define('TEXT_ADDRESS','Адрес');
define('TEXT_ADDRESS_PATTERN_INOF','Используйте одно или несколько полей, где хранится адрес.<br>Пример: "[36], [54]" где 36 и 54 - идентификаторы полей.');
define('TEXT_WIDTH_INPUT_TIP','Введите проценты или пиксели. Например: 100% или 250px');
define('TEXT_HEIGHT_INPUT_TIP','Введите высоту в пикселях. Например: 250px');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_TITLE','Защищенное поле ввода');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_TOOLTIP','Специальный тип поля для защиты информации пользователя. Это поле позволяет полностью ограничить и скрыть такие данные, как идентификационный номер, раскрыв только последние 3-4 символа.');
define('TEXT_REPLACE_WITH_SYMBOL','Заменить на символ');
define('TEXT_DISCLOSE_NUMBER_FIRST_LETTERS','Раскрыть количество первых букв');
define('TEXT_DISCLOSE_NUMBER_LAST_LETTERS','Раскрыть количество последних  букв');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_USERS_GROUPS_TIP','Выберите группы пользователей, которые будут видеть полное значение.');
define('TEXT_FILTERS_PANELS','Панели фильтров');
define('TEXT_DEFAULT_FILTER_PANEL','Панель фильтров по умолчанию');
define('TEXT_DEFAULT_FILTER_PANEL_INFO','Вы можете отключить данную панель или показывать ее для определенных групп пользователей.  <a href="https://docs.rukovoditel.net.ru/index.php?p=67" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_QUICK_FILTERS_PANELS','Панели быстрых фильтров');
define('TEXT_QUICK_FILTER_PANEL_INFO','Данные панели применяются для фильтрации данных по наиболее часто используемым параметрам. Вы можете создать горизонтальную или вертикальную панель быстрых фильтров. В настройках панели можно выбрать поля и значения, которые будут использоваться для фильтров. <a href="https://docs.rukovoditel.net.ru/index.php?p=67" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_CONFIGURE','Настроить');
define('TEXT_FILTERS_PANELS_ACCESS_INFO','Выберите группы пользователей, которые будут иметь доступ к панели фильтров. По умолчанию панель доступна для всех пользователей.');
define('TEXT_HORIZONTAL','Горизонтальная');
define('TEXT_VERTICAL','Вертикальная');
define('TEXT_FIELDS_CONFIGURATION','Настройка полей');
define('TEXT_PANES_FILTERS_FIELDS_CONFIGURATION_INFO','Добавьте поля, которые будут использоваться в панели фильтров.');
define('TEXT_PANEL','Панель');
define('TEXT_RESET_FILTERS','Cбросить фильтры');
define('TEXT_ENTER_LIST_HEIGHT','Введите высоту списка в пикселях.');
define('TEXT_CLEAR','Очистить');
define('TEXT_EXCLUDE_VALUES','Исключить значения');
define('TEXT_ACTIVE_FILTERS','Активные фильтры');
define('TEXT_ACTIVE_FILTERS_INFO','Список обновляется автоматически после выбора значения фильтра.');
define('TEXT_USER','Пользователь');
define('TEXT_OK','OK');
define('TEXT_BUTTON_REPLY','Ответить');
define('TEXT_BUTTON_FORWARD','Переслать');
define('TEXT_WARNING_ITEM_HAS_SUB_ITEM','<b>Внимание:</b> сущность "%s" имеет вложенные сущности.<br>Все записи из вложенных сущностей будут удалены.');
define('TEXT_CONFIRM_DELETE','подтвердить удаление');
define('TEXT_BUTTON_EMPTY','Очистить');
define('TEXT_FIELDTYPE_TAGS_TITLE','Теги');
define('TEXT_FIELDTYPE_TAGS_TOOLTIP','Специальный тип поля, который позволяет выбрать уже существующую или динамически создать новую опцию в раскрывающемся списке. <a href="https://docs.rukovoditel.net.ru/index.php?p=79" target="_blank"><u>Подробнее</u></a>');
define('TEXT_NO_RESULTS_FOUND','Совпадений не найдено');
define('TEXT_SEARCHING','Поиск…');
define('TEXT_LOADING_MORE_RESULTS','Загрузка данных…');
define('TEXT_RESULTS_COULD_NOT_BE_LOADED','Невозможно загрузить результаты.');
define('TEXT_AUTOMATICALLY_CREATE_TAG','Автоматически создавать тег');
define('TEXT_AUTOMATICALLY_CREATE_TAG_TIP','При вводе пробела или запятой в строке поиска, тег будет добавляться автоматически.');
define('TEXT_FIELDTYPE_ENTITY_AJAX_TITLE','Сущность, выпадающий список (ajax)');
define('TEXT_FIELDTYPE_ENTITY_AJAX_TOOLTIP','Специальное поле для списков с большим количеством данных. Позволяет установить связь с существующей сущностью. Отображается в виде выпадающего списка, данные в который загружаются ajax запросом.');
define('TEXT_SEARCH_BY_FIELDS','Поиск по полям');
define('TEXT_SEARCH_BY_FIELDS_INFO','Укажите поля, по которым будет осуществляться поиск записей. По умолчанию используется Заголовок.');
define('TEXT_COPY_VALUES','Копировать значения');
define('TEXT_COPY_FIELD_VALUES_INFO','Значения из выбранной записи можно скопировать в текущую форму.<br>Укажите связи полей в новой строке в формате:<br> 
[13]=[14]<br>
13 - id поля выбранной сущности<br>
14 - id поля текущей сущности');
define('TEXT_DELETE_BY_CREATOR_ONLY','Удаляется только создателем');
define('TEXT_FIELDTYPE_USER_ROLES_TITLE','Роли пользователей');
define('TEXT_FIELDTYPE_USER_ROLES_TOOLTIP','Данный тип поля позволяет назначить пользователя на запись и установить ему дополнительную роль доступа для вложенных сущностей. После создания поля, нажмите на название поля и добавьте необходимые роли пользователей. <a href="https://docs.rukovoditel.net.ru/index.php?p=77" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_USER_ROLES','Роли пользователей');
define('TEXT_USER_ROLES_ENTITIES_WARNING','Роли пользователей могут настраиваться только для вложенных сущностей. В текущей сущности нет под-сущностей.');
define('TEXT_USER_ROLES_INFO','После добавления роли, нажмите на название и настройте доступ. Если добавлена только одна роль, она будет автоматически назначаться пользователю.');
define('TEXT_USER_ROLES_ACCESS_INFO','Выберите необходимые сущности и настройте доступ. При назначении роли пользователю, правила доступа к выбранным сущностям заменят основные правила для группы пользователя.');
define('TEXT_ROLE','Роль');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_TITLE','Многоуровневый список сущностей');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_TOOLTIP','Список значений формируется на основе выбранного значения из родительской сущности.');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_SELECT_ENTITY_TOOLTIP','Выберите сущность последнего уровня в дереве сущностей.');
define('TEXT_HIDE_PLUS_BUTTON','Скрыть кнопку "+"');
define('TEXT_FIELDS_EXPORT','Экспорт полей');
define('TEXT_FIELDS_EXPORT_INFO','Данный функционал предназначенные для переноса настроенных полей в другое приложение. Выбранные поля экспортируются в файл в формате xml. Для импорта созданного файла воспользуйтесь кнопкой <i class="fa fa-upload"></i>');
define('TEXT_IMPORT_FIELDS','Импортировать поля');
define('TEXT_CONTINUE','Продолжить');
define('TEXT_IMPORTED_FIELDS','Импортировано полей: %s');
define('TEXT_IMPORT_FIELDS_INFO','Для импорта полей используйте xml файл, полученный при экспорте полей.<br><b>Обратите внимание:</b> импортируемые поля будут иметь новые ID.<br>Если ID полей применяются в формулах, формулы нужно скорректировать.');
define('TEXT_SELECT_USER_GROUPS_COMMON_INFO','Выберите группы пользователей, которые будут иметь доступ. По умолчанию доступ есть у всех пользователей.');
define('TEXT_LISTING_CONFIG_ACCESS_INFO','Выберите группы пользователей, которые будут иметь доступ к настройкам списка. По умолчанию настройка полей списка доступна для всех пользователей.');
define('TEXT_CURRENT_USER','Текущий пользователь');
define('TEXT_FIELDTYPE_MONTHS_DIFFERENCE_TITLE','Разница в месяцах');
define('TEXT_FIELDTYPE_MONTHS_DIFFERENCE_TOOLTIP','Специальный тип поля, который высчитывает разницу в месяцах между двумя датами.');
define('TEXT_CALCULATE_DIFFERENCE_DAYS_INFO','При расчете разницы между датами будет учитываться количество дней.');
define('TEXT_HIDE_DROPDOWN','Скрыть список');
define('TEXT_FIELDTYPE_USERS_APPROVE_TITLE','Утвердить');
define('TEXT_FIELDTYPE_USERS_APPROVE_TOOLTIP','Этот тип поля позволяет выбрать список пользователей для утверждения записи или добавления подписи.');
define('TEXT_BUTTON_TITLE','Название кнопки');
define('TEXT_APPROVE','Утвердить');
define('TEXT_CONFIRMATION_WINDOW','Окно подтверждения');
define('TEXT_CONFIRMATION_TEXT','Текст подтверждения');
define('TEXT_ADD_COMMENT','Добавлять комментарий');
define('TEXT_COMMENT_TEXT','Текст комментария');
define('TEXT_APPROVED','Утверждено');
define('TEXT_FIELDTYPE_USERS_APPROVE_FILTERS_INFO','Установите фильтры, при которых кнопка "Утвердить" будет доступна.');
define('TEXT_BUTTON','Кнопка');
define('TEXT_ALL_USERS_APPROVED','Все пользователи утвердили');
define('TEXT_ALL_USERS_APPROVED_INFO','Выберите действие, которое будет выполняться после утверждения записи всеми пользователями. Действие можно настроить в <a href="https://docs.rukovoditel.net.ru/index.php?p=31" target="_blank">Дополнение->Автоматизация действий</a>.');
define('TEXT_PLEASE_PROVIDE_SIGNATURE','Пожалуйста, поставьте свою подпись.');
define('TEXT_SIGNATURE','Подпись');
define('TEXT_WIDTH_IN_ITEM_PAGE','Ширина на странице записи');
define('TEXT_WIDTH_IN_ITEM_PAGE_INFO','Ширина изображения в пикселях при отображении на странице записи.');
define('TEXT_WIDTH_IN_PRINT_PAGE','Ширина на странице печати');
define('TEXT_WIDTH_IN_PRINT_PAGE_INFO','Ширина изображения в пикселях при отображении на странице печати.');
define('TEXT_DELETION','Удаление');
define('TEXT_CONFIRM_DELETION','Подтверждать удаление');
define('TEXT_ALLOWS_DELETE_IF_HAS_DELETE_ACCESS','Разрешить удаление, если у пользователя есть доступ к удалению записи');
define('TEXT_RULES','Правила');

//new defines for version 2.6
define('TEXT_ACCESS_CONFIGURATION','Настройка доступа');
define('TEXT_SEND_NOTIFICATION_TO_ASSIGNED_ONLY','Отправлять уведомления только назначенным пользователям');
define('TEXT_SEND_COMMENTS_NOTIFICATION_TO_ASSIGNED_INFO','По умолчанию, при добавлении комментария уведомления получают пользователи, назначенные на запись, а также, пользователи, которые участовали в обсуждении.');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_TITLE','Карта Google маршруты');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_TOOLTIP','Поле для отображения нескольких маркеров на карте. Координаты маркеров определяются автоматически по введенным адресам. По заданным маркерам можно проложить маршрут. <a href="https://docs.rukovoditel.net.ru/index.php?p=17" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_ADDRESS_TIP','Введите несколько адресов с новой строки.');
define('TEXT_MARKER','Маркер');
define('TEXT_LABEL','Метка');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_LABEL_TIP','Вы можете ввести метки для каждого адреса в новой строке.');
define('TEXT_LABEL_COLOR','Цвет метки');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_ICONS_TIP','Вы можете установить иконку для каждого адреса. Введите http адрес иконки в новой строке.');
define('TEXT_DIRECTIONS','Направления');
define('TEXT_MODE','Режим');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_MODE_TIP','Чтобы включить расчет направлений, необходимо указать, какой режим транспортировки следует использовать. <a href="https://developers-dot-devsite-v2-prod.appspot.com/maps/documentation/javascript/directions?hl=ru#DirectionsRequests" target="_blank">Подробнее.</a><br><b>Примечание:</b>  Directions API должен быть включен в console.cloud.google.com<br><b>Обратите внимание:</b> пользовательские маркеры и иконки не работают при расчете направлений.');
define('TEXT_OPTIMIZE_WAYPOINTS','Оптимизировать путевые точки');
define('TEXT_PROVIDE_ROUTE_ALTERNATIVES','Альтернативные маршруты');
define('TEXT_AVOID_FERRIES','Избегать паромов');
define('TEXT_AVOID_HIGHWAYS','Избегать шоссе');
define('TEXT_AVOID_TOLLS','Избегать платных проездов');
define('TEXT_TRIM_VALUE','Обрезать значение');
define('TEXT_TRIM_VALUE_INFO','Может использоваться, если вам нужно получить часть значения поля.');
define('TEXT_TRIM_VALUE_EXAMPLE','Будет использоваться PHP функция <a href="https://www.php.net/manual/ru/function.substr.php" target="_blank">substr</a>.<br>В поле ввода введите int $start [, int $length ]. Например: 0,4');
define('TEXT_DISPLAY_LAST_COMMENT_IN_LISTING','Отображать последний комментарий в списке');
define('TEXT_DISPLAY_LAST_COMMENT_IN_LISTING_INFO','Комментарий будет отображается вместе с заголовком.');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_FIELDS_IN_POPUP_TIP','Введите ID полей через запятую для каждого адреса с новой строки.');
define('TEXT_FORM_CONFIG_INFO','На этой странице у вас есть возможность отсортировать поля в форме, создать дополнительные вкладки для полей а также встроить свой JavaScript код в форму. <a href="https://docs.rukovoditel.net.ru/index.php?p=64" target="_blank">Подробнее</a>.');
define('TEXT_ADD_JAVASCRIPT','Добавить JavaScript');
define('TEXT_JAVASCRIPT_IN_FORM','JavaScript в форме');
define('TEXT_JAVASCRIPT_IN_FORM_INFO','Введенный JavaScript будет встраиваться в форму при ее отображении.');
define('TEXT_JAVASCRIPT_ONSUBMIT_FORM_INFO','Введенный JavaScript будет вызываться при событии onSubmit. Чтобы остановить отправку формы используйте: return false;');
define('TEXT_DEFAULT_NOTIFICATIONS','Уведомления по умолчанию');
define('TEXT_DEFAULT_NOTIFICATIONS_INFO','Уведомления по умолчанию отправляются всем назначенным пользователям. Используйте тип поля "Пользователи" чтобы назначить пользователей на запись.<br>Для более гибких настроек уведомлений используйте <a href="https://docs.rukovoditel.net.ru/index.php?p=75" target="_blank"><u>правила отправки почты</u></a>.');
define('TEXT_HIDE_CHECKBOXES_IF_NO_ACCESS','Скрыть флажки, если нет прав на редактирование поля');
define('TEXT_BODY','Тело');
define('TEXT_END','Окончание');
define('TEXT_ALLOW_PUBLIC_ACCESS','Разрешить публичный доступ');
define('TEXT_ENTER_TEXT_PATTERN_INFO_SHORT','Используйте [ID поля] для установки значения поля в шаблоне.');
define('TEXT_PUBLIC_ATTACHMENTS_TIP','Выберите вложения, для которых будет разрешён публичный доступ по специальной ссылке. Данная опция используется при экспорте данных через api, xml  и т.д.');
define('TEXT_DISPLAY_ONLY_ASSIGNED_RECORDS','Отображать только назначенные записи');
define('TEXT_DISPLAY_ONLY_ASSIGNED_RECORDS_INFO','Данное правило будет применяться, если к выбранной сущности установлены права "' . TEXT_VIEW_ASSIGNED_ACCESS . '"');
define('TEXT_HIDE_COUNTER_IF_NO_RECORDS','Скрыть счетчик, если нет записей');
define('TEXT_HEADER','Верхний колонтитул');
define('TEXT_FOOTER','Нижний колонтитул');
define('TEXT_FIELDTYPE_DYNAMIC_DATE_TITLE','Динамическая дата');
define('TEXT_FIELDTYPE_DYNAMIC_DATE_TOOLTIP','Данный тип поля предназначен для отображения даты, которая рассчитывается по MySQL формуле. Формула должна возвращать значение в timestamp. Формат даты задайте в настройках поля. Этот тип поля может применяться в календарном отчете или диаграмме Ганта.');
define('TEXT_GLOBAL_LIST_USER_NOTES','Данная опция используется, если список применяется к полю "Группа пользователей".');
define('TEXT_RECORDS_VISIBILITY','Видимость записей');
define('TEXT_RECORDS_VISIBILITY_INFO','Настройте видимость записей в зависимости от значения полей. <a href="https://docs.rukovoditel.net.ru/index.php?p=82" target="_blank"><u>Подробнее</u></a>');
define('TEXT_ADD_RULE','Добавить правило');
define('TEXT_USERS_GROUPS_FOR_RULE_TIP','Выберите группы пользователей, для которых будет применяться данное правило.');
define('TEXT_LINKED_ENTITIES','Связанные сущности');
define('TEXT_RECORDS_VISIBILITY_LINK_ENTITY_INFO','Установить связь между сущностью Пользователи и текущей сущностью при помощи полей, которые используют одинаковый глобальный список или сущность.');
define('TEXT_MAX_DATE','Максимальная выбираемая дата');
define('TEXT_MIN_DATE','Минимальная выбираемая дата');
define('TEXT_OVERDUE_DATES','Просроченные даты');
define('TEXT_DISABLE_COLOR','Отключить цвет');
define('TEXT_DISABLE_COLOR_BY_FIELD_TIP','Выберите поле и значения, при которых выделение цветом будет отключено.');
define('TEXT_HIDE_ACCESS_GROUP','Скрыть название группы из списка');
define('TEXT_USE_GROUPS_TIP','Будут отображаться пользователи только из указанных групп.');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_PARENT_FIELD_TIP','Значение родительского элемента будет использоваться из выбранного поля.');
define('TEXT_DIGITAL_SIGNATURE_LOGIN','Вход по ЭЦП');
define('TEXT_DIGITAL_SIGNATURE_LOGIN_INFO','Выберите модуль ЭЦП, который будет использоваться для входа пользователей.');
define('TEXT_EXTENSION_REQUIRED','Требуется дополнение.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_TITLE','Группы доступа пользователей');
define('TEXT_FIELDTYPE_ACCESS_GROUP_TOOLTIP','Вы сможете присвоить группу доступа пользователей на запись. Все пользователи из выбранной группы будут иметь доступ к записи.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_USERS_GROUP_TIP','Будут отображаться только указанные группы.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_NOTIFY_TIP','Уведомления будут отправляться всем пользователям выбранных групп. Рекомендуется включить опцию "Отправлять по расписанию" в настройках электронной почты.');
define('TEXT_MULTI_LEVEL_IMPORT','Многоуровневый импорт');
define('TEXT_MULTI_LEVEL_IMPORT_INFO','Укажите сущность необходимого уровня вложенности для импорта многоуровневых записей.');
define('TEXT_MULTI_LEVEL_IMPORT_NOTE','Обязательным правилом является привязка каждого поля, отмеченного как заголовок, для каждого уровня дерева сущностей.');
define('TEXT_MULTI_LEVEL_IMPORT_HEADING_ERROR','Ошибка: отсутствует поле заголовок для сущности "%s".');
define('TEXT_HEADING','Заголовок');
define('TEXT_FIELDTYPE_SIGNATURE_TITLE','Подпись');
define('TEXT_FIELDTYPE_SIGNATURE_TOOLTIP','Поле позволяет добавить имя и подпись. Не связано с пользователями приложения. <a href="https://docs.rukovoditel.net.ru/index.php?p=80" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ENTER_YOUR_NAME','Введите ваше имя');
define('TEXT_DISPLAY_PROGRESS_BAR','Показать индикатор выполнения');
define('TEXT_MIN_WIDTH','Минимальная ширина');
define('TEXT_PROGRESS_BAR','Индикатор выполнения');
define('TEXT_FIELDTYPE_STAGES_TITLE','Этапы');
define('TEXT_FIELDTYPE_STAGES_TOOLTIP','Специальный тип поля, который отображает панель этапов на странице записи, с помощью которой можно оперативно перейти на следующий этап. После создания поля, нажмите на название чтобы создать этапы. <a href="https://docs.rukovoditel.net.ru/index.php?p=81" target="_blank"><u>Подробнее</u></a>');
define('TEXT_STAGES_PANEL','Панель этапов');
define('TEXT_TRIANGLE','Треугольник');
define('TEXT_RECTANGLE','Прямоугольник');
define('TEXT_DOT','Точка');
define('TEXT_CIRCLE','Круг');
define('TEXT_ACTION_BY_CLICK','Действие по клику');
define('TEXT_ALLOW_CHANGING_VALUE','Разрешить изменение значения');
define('TEXT_ALLOW_CHANGING_VALUE_NEXT_STEP','Разрешить изменение значения только на следующий этап');
define('TEXT_ACTIVE_ITEM_COLOR','Цвет активного элемента');
define('TEXT_CONFIRM_ACTION','Подтвердите действие');
define('TEXT_FIELDTYPE_STAGES_ACTION_TIP','У вас есть возможность подключить процесс из автоматизации к любому этапу. Если процесс выбран, он будет выполняться при переходе на этот этап.');
define('TEXT_FIELDTYPE_IFRAME_TITLE','Iframe');
define('TEXT_FIELDTYPE_IFRAME_TOOLTIP','Простое поле ввода для ввода url-адреса, который будет открыт в iframe');
define('TEXT_SCROLL_BAR','Полоса прокрутки');
define('TEXT_EXTRA_PARAMS','Дополнительные параметры');
define('TEXT_FIELDTYPE_IFRAME_EXTRA_PARAMS_TIP','Будут включены в тег iframe');
define('TEXT_2STEP_VERIFICATION','Двухэтапная аутентификация');
define('TEXT_2STEP_VERIFICATION_INFO','Если включено, пользователю при входе в систему помимо учетных данных необходимо будет ввести специальный код, отправленный по email или СМС. <a href="https://docs.rukovoditel.net.ru/index.php?p=83" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ENABLE_TEXT_2STEP_VERIFICATION','Включить двухэтапную аутентификацию');
define('TEXT_SEND_CODE_BY','Отправлять код по');
define('TEXT_2STEP_VERIFICATION_EMAIL_SUBJECT','Вход в ' . $_SERVER['HTTP_HOST'] . ' ' . i18n_date('d F Y h:i',time()));
define('TEXT_2STEP_VERIFICATION_EMAIL_BODY','Код для входа: %s');
define('TEXT_CODE_FROM_EMAIL','Код из Email');
define('TEXT_CODE_FROM_EMAIL_INFO','Вам отправлено сообщение с кодом на адрес %s');
define('TEXT_INCORRECT_CODE','Неверный код');
define('TEXT_CODE_FROM_SMS','Код из SMS');
define('TEXT_CODE_FROM_SMS_INFO','Вам отправлено SMS сообщение с кодом на номер %s');
define('TEXT_MAIN_FEATURES','Основные возможности');
define('TEXT_EXT_FEATURES_LIST','Календарь,Диаграмма Ганта,Воронкообразная диаграмма,Канбан-доска,Сводные отчеты,Онлайн чат,Интеграция с почтой,Телефония,SMS,API');
define('TEXT_FULL_LIST_OF_FEATURES','Полный список возможностей');

//new defines for version 2.7
define('TEXT_FIELDTYPE_BARCODE_ACCEPTED_TYPE_TIP','Все типы поддерживают разные наборы символов или имеют обязательную длину. Пожалуйста, смотрите в Википедии поддерживаемые символы и длину для каждого типа. Наиболее используемые типы - CODE_128 и CODE_39, так как лучше поддерживаются сканерами.');
define('TEXT_OVERDUE_DATE_WITH_TIME','Просроченные даты с учетом времени');
define('TEXT_FIELDTYPE_TIME','Время');
define('TEXT_FIELDTYPE_TIME_TOOLTIP','Поле для ввода времени в формате: "часы":"минуты". В базе данных значение поля хранится в минутах.');
define('TEXT_CALENDAR','Календарь');
define('TEXT_SUM_IN_COMMENTS','Сумма в комментариях');
define('TEXT_SUM_IN_COMMENTS_INFO',' Значение этого поля будет равно сумме введенных значений в комментариях.');
define('TEXT_DISPLAY_PREFIX_SUFFIX_IN_FORM','Показать префикс/суффикс в форме');
define('TEXT_PHP_EXTENSION_REQUIRED','<b>Ошибка:</b> Требуется расширение PHP "<b>%s</b>". Проверьте php.ini на вашем сервере, чтобы включить это расширение.');
define('TEXT_LOGIN_BY_PHONE_NUMBER','Вход по номеру телефона');
define('TEXT_ALLOW_LOGIN_BY_PHONE_NUMBER','Разрешить вход по номеру телефона');
define('TEXT_ALLOW_LOGIN_BY_PHONE_NUMBER_INFO','На странице входа появится дополнительная ссылка на страницу "' . TEXT_LOGIN_BY_PHONE_NUMBER . '"');
define('TEXT_ENTER_YOUR_PHONE_NUMBER','Введите ваш номер телефона');
define('TEXT_FIELDTYPE_ENTITY_MYSQL_QUERY_TIP','Добавьте MySQL условие для выборки только определенных записей. <a href="https://docs.rukovoditel.net.ru/index.php?p=78" target="_blank"><u>Подробнее</u></a>');
define('TEXT_HIGHLIGHT_ROW','Выделить строку');
define('TEXT_LISGIN_HIGHLIGHT_ROW_INFO','Установите значения полей, при которых будет выделяться цветом вся строка в списке. Данные правила применяются ко всем спискам.<br>Вы можете установить несколько правил, и они будут применяться в порядке сортировки.');
define('TEXT_FIELD_ACCESS_INFO','Настройте доступ к полю для каждой группы пользователей.');
define('TEXT_YOU_CANT_DELETE_YOURSELF','Вы не можете удалить себя');
define('TEXT_DOCUMENTATION','Документация');
define('TEXT_NEWS','Новости');
define('TEXT_USER_ACTIVATION','Активация пользователя');
define('TEXT_BY_EMAIL','По электронной почте');
define('TEXT_MANUALLY','Вручную');
define('TEXT_PUBLIC_REGISTRATION_TIP','Ваши клиенты/подрядчики смогут самостоятельно регистрироваться в системе. <a href="https://docs.rukovoditel.net.ru/index.php?p=14" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_USER_ACTIVATION_AUTOMATIC_TIP','Учетная запись пользователя автоматически активируется после регистрации, и пользователь сразу получает доступ в приложение.');
define('TEXT_USER_ACTIVATION_BY_EMAIL_TIP','Учетная запись активируется после подтверждения Email адреса. На Email адрес пользователя будет отправлен специальный код.');
define('TEXT_USER_ACTIVATION_MANUALLY_TIP','Администратор вручную проверяет и активирует новых пользователей.');
define('TEXT_REGISTRATION_SUCCESS_PAGE','Страница успешной регистрации');
define('TEXT_EMAIL_ABOUT_USER_ACTIVATION','Письмо об активации пользователя');
define('TEXT_REGISTRATION_SUCCESS_PAGE_HEADING','Ваш аккаунт создан и неактивен на данный момент');
define('TEXT_REGISTRATION_SUCCESS_PAGE_DESCRIPTION','В ближайшее время ваша учетная запись будет проверена. Вы получите уведомление об активации вашего аккаунта.');
define('TEXT_USER_ACTIVATION_EMAIL_SUBJECT','Ваша учетная запись активирована');
define('TEXT_USER_ACTIVATION_EMAIL_BODY','Войдите в приложение по следующей ссылке %s');
define('TEXT_EMAIL_VERIFICATION_EMAIL_SUBJECT','Подтверждение почтового адреса');
define('TEXT_EMAIL_VERIFICATION_EMAIL_BODY','
<p>Здравствуйте,<br>
Вы получили это письмо, поскольку указали данный почтовый адрес при регистрации на сайте "<a href="' . url_for('users/login','',true) . '">' . CFG_APP_NAME . '</a>".</p>
<p>Нам необходимо убедиться в том, что именно Вы являетесь владельцем этого e-mail адреса.</p>
<p>Для подтверждения электронного ящика, введите следующий код: <b>%s</b></p>
<p><small>Это письмо было отправлено автоматически.<br>
Если Вы считаете, что получили его по ошибке, просто проигнорируйте его.</small></p>
');
define('TEXT_EMAIL_VERIFIED','Почтовый адрес подтвержден');
define('TEXT_EMAIL_NOT_VERIFIED','Email не подтвержден');
define('TEXT_CHECK_SPAM_FOLDER','Если письмо не придёт в течение пяти минут, проверьте папку "Спам".');
define('TEXT_RESEND_CODE','Повторно отправить код');
define('TEXT_RESEND_CODE_TIP','Для повторной отправки кода введите ваш логин/пароль.');
define('TEXT_CHNAGE_EMAIL','Изменить адрес электронной почты');
define('TEXT_HIDE_COORDINATES_IN_FORM','Скрыть координаты в форме');
define('TEXT_FIELDTYPE_DIGITAL_SIGNATURE_TITLE','Цифровая подпись');
define('TEXT_FIELDTYPE_DIGITAL_SIGNATURE_TOOLTIP','Это поле предназначено для работы с модулями цифровой подписи, позволяющими подписывать документы. <a href="https://docs.rukovoditel.net.ru/index.php?p=84" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_MODULE','Модуль');
define('TEXT_FIELDS_FOR_SIGNATURE','Поля для подписи');
define('TEXT_DIGITAL_SIGNATURE','Электронная подпись');
define('TEXT_FIELDTYPE_AJAX_REQUEST_TITLE','Ajax запрос');
define('TEXT_FIELDTYPE_AJAX_REQUEST_TOOLTIP','Специальный тип поля, позволяющий вам выполнить вычисления на лету в форме записи. <a href="https://docs.rukovoditel.net.ru/index.php?p=99" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_PHP_CODE','PHP код');
define('TEXT_DEBUG_MODE','Режим отладки');
define('TEXT_CUSTOM_CSS','Пользовательский CSS');
define('TEXT_CUSTOM_CSS_INFO','Вы можете добавить свои собственные стили, которые переопределят CSS по умолчанию.');
define('TEXT_FILE_PATH','Путь к файлу');
define('TEXT_ERRRO_FOLDER_NOT_WRITABLE','Ошибка: папка "%s" недоступна для записи!');
define('TEXT_SET_FILTERS_FOR_ACTION_BUTTON','Установите фильтры, при которых кнопка действия будет доступна.');
define('TEXT_HIDE_ENTITY_NAME','Скрыть название сущности');
define('TEXT_TOOLBAR','Панель инструментов');
define('TEXT_IN_ONE_LINE','В одну строку');
define('TEXT_FIELDTYPE_USERS_AJAX_TITLE','Пользователи Ajax');
define('TEXT_FIELDTYPE_USERS_AJAX_TOOLTIP','Поле отображается в виде выпадающего списка, данные в который загружаются ajax запросом. Выбранные пользователи из списка считаются назначенными на запись и получают уведомления.');
define('TEXT_DISPLAY_SETTINGS','Настройки отображения');
define('TEXT_HIDE_EMPTY_BLOCK','Cкрыть пустой блок');
define('TEXT_HIDE_BY_CONDITION','Скрыть по условию');
define('TEXT_HIDE_BY_CONDITION_SUBENTITY_INFO','Установите фильтры для родительской записи, при которых вложенная сущность будет скрыта на странице записи.');
define('TEXT_SEPARATOR','Разделитель');
define('TEXT_RECORDS_VISIBILITY_EMPTY_VALUE_INFO','Для выбранных полей будет добавлена проверка на пустое значение.');
define('TEXT_FIELDTYPE_ITEMS_BY_QUERY_TITLE','Список записей по MySql запросу');
define('TEXT_FIELDTYPE_ITEMS_BY_QUERY_TOOLTIP','Специальный тип поля, который отображает список записей по пользовательскому запросу к базе данных. <a href="https://docs.rukovoditel.net.ru/index.php?p=101" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_NUMBER_OF_RECORDS','Количество записей');
define('TEXT_TOTAL','Всего');
define('TEXT_ERROR_REQUIRED_URL','Пожалуйста, введите корректный адрес.');
define('TEXT_EXTENSION_REQUIRED_URL','<a href="https://www.rukovoditel.net.ru/extension.php" target="_blank">' . TEXT_EXTENSION_REQUIRED . '</a>');

//new defines for version 2.8
define('TEXT_JS_CODE','JS код');
define('TEXT_CODE_ON_ITEM_PAGE','Введенный код будет встраиваться на страницу записи. <a href="https://docs.rukovoditel.net.ru/index.php?p=66" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_PHP_CODE_TITLE','PHP код');
define('TEXT_FIELDTYPE_PHP_CODE_TOOLTIP','Специальный тип поля, позволяющий вам выполнить собственный PHP код. <a href="https://docs.rukovoditel.net.ru/index.php?p=104" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_RUN_DYNAMIC','Выполнять динамически');
define('TEXT_FIELDTYPE_PHP_CODE_RUN_DYNAMIC_INFO','По умолчанию код выполняется при добавлении/редактировании записи. Установив данную опцию код будет выполняться непосредственно при просмотре записи.');
define('TEXT_FIELDTYPE_PROCESS_BUTTON_TITLE','Кнопка процесса');
define('TEXT_FIELDTYPE_PROCESS_BUTTON_TOOLTIP','Специальный тип поля, с помощью которого можно отобразить кнопку из автоматизации действий непосредственно в списке записей. <a href="https://docs.rukovoditel.net.ru/index.php?p=105" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_VIDEO_TITLE','Видео');
define('TEXT_FIELDTYPE_VIDEO_TOOLTIP','Поле ввода для ввода url-адреса с YouTube или Vimeo. Также вы можете ввести прямую ссылку на видеофайл (.mp4 .ogg .webm).');
define('TEXT_VIDEO_PLAYER','Видеоплеер');
define('TEXT_VIDEO_TAG_NOT_SUPPORTED','Ваш браузер не поддерживает тег video.');
define('TEXT_BUTTON_DISPLAYS_IN_LISTING','Кнопка отображается в списке записей');
define('TEXT_HIDE_VIDEO_PLAYER','Скрыть видеоплеер на странице записи');
define('TEXT_FIELDTYPE_INPUT_ENCRYPTED_TITLE','Зашифрованное поле ввода');
define('TEXT_HIDE_VALUE','Скрыть значение');
define('TEXT_FIELDTYPE_INPUT_ENCRYPTED_TOOLTIP','Введенное значение хранится в базе в зашифрованном виде. Данные шифруются с помощью специального ключа.');
define('TEXT_ENCRYPTION_KEY','Ключ шифрования');
define('TEXT_ENCRYPTION_KEY_INFO','Чтобы добавить ключ шифрования откройте <code>config/database.php</code> файл и <br>
вставьте следующую строку в конце файла: <code>define(\'DB_ENCRYPTION_KEY\',\'my_key\');</code><br>
Вместо <code>my_key</code> введите ваш ключ.<br>
<b>Внимание:</b> нельзя изменять ключ для существующих данных. Это приведет к потере данных.');
define('TEXT_FIELDTYPE_TEXTAREA_ENCRYPTED_TITLE','Зашифрованное поле для текста');
define('TEXT_ENCRYPTION_KEY_ERROR','Ошибка: для поля "%s" требуется ключ шифрования. Проверьте настройки поля.');
define('TEXT_ADD_ROW','Добавить ряд');
define('TEXT_ROW','Ряд');
define('TEXT_COUNT_OF_COLUMNS','Количество колонок');
define('TEXT_COLUMN_WIDHT','Ширина колонки');
define('TEXT_PREVIEW','Предварительный просмотр');
define('TEXT_FORMS_ROWS_INFO','После добавления ряда переместите поля в колонки. Обратите внимание: ширина поля равна ширины колонки.');
define('TEXT_FIELD_NAME_IN_NEW_ROW','Название поля с новой строки');
define('TEXT_CONFIRM','Подтвердить');
define('TEXT_STEP','Шаг');
define('TEXT_FAVICON','Значок веб-сайта (Favicon)');
define('TEXT_ONE_COLUMN_TABS','Одна колонка (Вкладки)');
define('TEXT_ONE_COLUMN_ACCORDION','Одна колонка (Аккордеон)');
define('TEXT_WINDOW_WIDTH','Ширина окна');
define('TEXT_WIDE','Широкое');
define('TEXT_XWIDE','Очень Широкое');
define('TEXT_FIELDTYPE_JALALI_CALENDAR_TITLE','Джалали Календарь');
define('TEXT_FIELDTYPE_JALALI_CALENDAR_TOOLTIP','Календарь Джалали-это солнечный календарь, который все еще используется в Иране, а также в Афганистане.');
define('TEXT_PLAY_AUDIO_FILE','Воспроизвести аудиофайл');
define('TEXT_VALIDATE_URL','Проверка url-адреса');
define('TEXT_DATE_FORMAT_IN_CALENDAR','Формат даты в календаре');
define('TEXT_FIELDTYPE_SUBENTITY_FORM_TITLE','Форма вложенной сущности');
define('TEXT_FIELDTYPE_SUBENTITY_FORM_TOOLTIP','Этот тип позволяет встроить форму вложенной сущности в форму родительской сущности. Это означает, что при добавлении родительской записи одновременно будут добавляться и записи для вложенной сущности. <a href="https://docs.rukovoditel.net.ru/index.php?p=107" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_SUB_ENTITY','Вложенная сущность');
define('TEXT_FIELDS_DISPLAY','Отображение полей');
define('TEXT_INTO_COLUMN','В столбец');
define('TEXT_INTO_ROW','В ряд');
define('TEXT_IN_NEW_WINDOW','В новом окне');
define('TEXT_FIELDS_IN_FORM','Поля в форме');
define('TEXT_FIELS_DISPLAY_IN_FOR_TYPE_ROW','При таком отображении вы можете использовать ограниченное количество полей. Правила отображения полей в форме не поддерживаются.');
define('TEXT_FIELS_DISPLAY_IN_FOR_TYPE_NEW_WINDOW','При нажатии на кнопку форма откроется в собственном окне. В этом случае поддерживаются все поля.');
define('TEXT_FIELDS_IN_LISTING_ON_FORM_PAGE','Добавленные записи отображаются в табличном списке на странице формы.');
define('TEXT_ENTER_COLUMN_WIDHT_BY_COMMA','Введите ширину в процентах для каждой колонки через запятую.<br>Например: 50,25,25');
define('TEXT_MAX_COUNT_RECORDS','Максимальное количество записей');
define('TEXT_MAX_COUNT_RECORDS_IN_FORM_INFO','Ограничьте количество записей в форме');
define('TEXT_SHOW_NUMBER_OF_RECORDS','Показать количество записей');
define('TEXT_INSERT_RECORD_AUTOMATICALLY','Автоматически вставлять запись');
define('TEXT_INSERT_RECORD_AUTOMATICALLY_INFO','Введите количество записей, которые будут автоматически добавлены в форму.');
define('TEXT_PDF_EXPORT_FONTS','Шрифты для экспорта в pdf');
define('TEXT_PDF_EXPORT_FONTS_INFO','Для экспорта данных в PDF формате используется библиотека <a href="https://github.com/dompdf/dompdf" target="_blank">Dompdf</a>. На этой странице вы можете добавить свои собственные шрифты, которые можно использовать в шаблонах экспорта. <a href="https://docs.rukovoditel.net.ru/index.php?p=108" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FONTS_FOLDER','Папка шрифтов');
define('TEXT_ERRROR_FILE_NOT_WRITABLE','Ошибка: файл "%s" недоступен для записи!');
define('TEXT_ROTATE','Повернуть');
define('TEXT_CREATE_ATTACHMENTS_PREVIEW','Создание отдельного файл для предварительного просмотра изображения');
define('TEXT_CREATE_ATTACHMENTS_PREVIEW_TIP','Применяется если для поля "Вложения" установлена опция "Предварительный просмотр"');
define('TEXT_FOLDER','Папка');
define('TEXT_FIELDTYPE_INPUT_IP_TITLE','IPv4 адрес');
define('TEXT_FIELDTYPE_INPUT_IP_TOOLTIP','Поле для ввода IPv4 адреса. В базе данных значение хранится как число.');
define('TEXT_FIELDTYPE_INPUT_DYNAMIC_MASK_TITLE','Поле с динамической маской ввода');
define('TEXT_FIELDTYPE_INPUT_DYNAMIC_MASK_TOOLTIP','Позволяет создать маску ввода для данных у которых нет фиксированной длины. Также вы можете добавить свой JavaScript код для определения маски. Используется следующая библиотека: <a href="https://github.com/RobinHerbots/Inputmask" target="_blank">github.com/RobinHerbots/Inputmask</a>');
define('TEXT_FIELDTYPE_INPUT_DYNAMIC_MASK_INFO','Чтобы определить динамическую часть, используйте конструкцию {n, m} - это означает что символ может повторяться от n до m раз.');
define('TEXT_FIELDTYPE_INPUT_DYNAMIC_MASK_OPTIONAL_INFO','Чтобы определить необязательную часть, используйте конструкцию [a]  - это означает что символ можно пропустить.');
define('TEXT_BARCODE','Штрих-код');
define('TEXT_ENTER_TEXT_PATTERN_DEATE_INFO','${Ymd} - текущая дата: ' . date('Ymd') . ' (<a href="https://www.php.net/manual/ru/datetime.format.php" target="_blank">формат даты</a> можно корректировать)');
define('TEXT_BARCODE_GENERATED_AUTOMATICALLY','Штрих-код генерируется автоматически');
define('TEXT_FIELDTYPE_RANDOM_VALUE_UNIQUE_TOOLTIP','Каждое значение является уникальным для текущей сущности.');
define('TEXT_SCANNING_BARCODE','Сканирование штрихкода');
define('TEXT_SSL_REQUIRED','Требуется SSL');
define('TEXT_CAMERA','Камера');

//new defines for version 2.9
define('TEXT_APPLY','Применить');
define('TEXT_CANCEL','Отменить');
define('TEXT_ASSIGN_USER_TO_MULTIPLE_GROUPS','Назначать пользователя на несколько групп');
define('TEXT_ASSIGN_USER_TO_MULTIPLE_GROUPS_INFO','Пользователь сможет переключаться между группами в личном кабинете. <a href="https://docs.rukovoditel.net.ru/index.php?p=116" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_DISPLAY_USER_GROUP_IN_MENU','Отображать название группы доступа в меню');
define('TEXT_CHANGE_ACCESS_GROUP','Сменить группу доступа');
define('TEXT_LOGIN_AS_USER','Войти как');
define("TEXT_HOURLY",'Eжечасно');
define('TEXT_DISTANCE','Расстояние');
define('TEXT_CALCULATE_TOTAL_DISTANCE','Вычислить общее расстояние');
define('TEXT_KILOMETERS','Километры');
define('TEXT_MILES','Мили');
define('TEXT_TOTAL_DISTANCE_IN_KILOMETERS','Общее расстояние в километрах');
define('TEXT_TOTAL_DISTANCE_IN_MILES','Общее расстояние в милях');
define('TEXT_SAVE_VALUE','Сохранить значение');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_SAVE_VALUE_TIP','Выберите числовое поле, чтобы сохранить расстояние. Значение будет сохранено в фоновом режиме после рендеринга карты.');
define('TEXT_ERROR_LIB','Библиотека PHP <b>%s</b> не установлена ​​на вашем веб-сервере');
define('TEXT_EXTNER_VALUE_IN_PERCENT_OR_PIXELS','Введите значение в процентах или пикселях. Например: 50 или 50%');
define('TEXT_SOCIAL_LOGIN','Авторизация через соцсети');
define('TEXT_ENABLE_SOCIAL_LOGIN','Включить авторизацию через соцсети');
define('TEXT_ENABLE_SOCIAL_LOGIN_ONLY','Использовать только авторизацию через соцсети');
define('TEXT_SELECT_SOCIAL_NETWORKS','Выберите социальные сети');
define('TEXT_APP_ID','ID приложения');
define('TEXT_VKONTAKTE','ВКонтакте');
define('TEXT_SECRET_KEY','Секретный ключ');
define('TEXT_LOGIN_WITH','Войти через');
define('TEXT_CREATE_USER','Создавать пользователя');
define('TEXT_CREATE_USER_AUTOMATICALLY','Автоматически создавать пользователя');
define('TEXT_REDIRECT_TO_PUBLIC_REGISTRATION','Перенаправлять на форму публичной регистрации');
define('TEXT_GOOGLE','Google');
define('TEXT_FACEBOOK','Facebook');
define('TEXT_REDIRECT_URI','Redirect URI');
define('TEXT_LINKEDIN','LinkedIn');
define('TEXT_TWITTER','Twitter');
define('TEXT_SOCIAL_LOGIN_INFO','На этой странице у вас есть возможность настроить авторизацию через популярные соцсети. <a href="https://docs.rukovoditel.net.ru/index.php?p=118" target="_blank"><u>Подробнее.</u></a>.');
define('TEXT_GUEST_LOGIN','Гостевой вход');
define('TEXT_GUEST_LOGIN_INFO','Настройте гостевой доступ в приложение без ввода логина и пароля. <a href="https://docs.rukovoditel.net.ru/index.php?p=120" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ENABLE_GUEST_LOGIN','Включить гостевой вход');
define('TEXT_LOGIN_AS_GUEST','Войти как гость');
define('TEXT_GUEST_LOGIN_USER_INFO','Выберите пользователя, который будет автоматически входить в систему при гостевом доступе.');
define('TEXT_TREE_TABLE','Древовидная таблица');
define('TEXT_FIELDTYPE_NESTED_CALCULATIONS_TITLE','Вычисления с вложенными записями');
define('TEXT_FIELDTYPE_NESTED_CALCULATIONS_TOOLTIP','Специальный тип поля для выполнения вычислений по вложенным записям в рамках одной ветки дерева в древовидном списке. <a href="https://docs.rukovoditel.net.ru/index.php?p=123" target="_blank"><u>Подробнее.</u></a>'
        . '<p><b>Обратите внимание:</b> вычисления выполняются только при добавлении/редактировании записи в конкретной ветке дерева.</p>');
define('TEXT_FUNCTION','Функция');
define('TEXT_PERFORM_CALCULATION','Выполнить вычисление');
define('TEXT_ONLY_AT_THE_TOP_LEVEL','Только в на верхнем уровне');
define('TEXT_ALL_OVER_TREE_BRANCH','По всей ветке дерева');
define('TEXT_FUNCTION_SUM','SUM -  вычисляет сумму значений');
define('TEXT_FUNCTION_COUNT','COUNT - подсчитывает количество записей');
define('TEXT_DISPLAY_NESTED_RECORDS','Отображать вложенные записи');
define('TEXT_CHANGE_PARENT_ITEM','Изменить родительскую запись');

//new defines for version 3.0
define('TEXT_UNIQUE_FOR_EACH_PARENT_RECORD','Уникальное для каждой родительской записи');
define('TEXT_IS_UNIQUE','Уникальное?');
define('TEXT_ENTITIES_GROUPS','Группы сущностей');
define('TEXT_ENTITIES_GROUPS_INFO','Вы можете разделять и фильтровать сущности по группам.');
define('TEXT_GROUP','Группа');
define('TEXT_STRONG_PASSWORD','Надежный пароль');
define('TEXT_STRONG_PASSWORD_TIP','Пароль должен содержать: цифры, символы верхнего регистра и специальные символы.');
define('TEXT_KEEP_CURRENT_FORM_OPEN','Оставить текущую форму открытой');
define('TEXT_SAVE_AND_CLOSE','Сохранить и закрыть');
define('TEXT_EDITABLE_FIELDS_IN_LISTING','Редактируемые поля в списке');
define('TEXT_EDITABLE_FIELDS_IN_LISTING_INFO','Пользователь может изменить значение отдельного поля, щелкнув по ячейке таблицы.');
define('TEXT_COLLAPSED','Cвернутый');
define('TEXT_ALLOW_CHANGE_FILE_NAME','Разрешить изменение имени файла');
define('TEXT_DROP_DOWN_MENU_ON_HOVER','Выпадающее меню при наведении мыши');
define('TEXT_YOU_CANT_DELETE_FIELD','Вы не можете удалить поле "%s".');
define('TEXT_FIELD_USING_IN_FORMULA','Поле используется в формуле');
define('TEXT_DELETE_FIELD_WARNING','<b>Внимание:</b> удаление поля приведет к удалению всех данных, связанных с этим полем в базе данных.');
define('TEXT_TOGGLE_ON','Включить');
define('TEXT_TOGGLE_OFF','Выключить');
define('TEXT_SELECT_IMAGE','Выберите изображение');
define('TEXT_UPLOAD','Загрузить');
define('TEXT_SNAP_PHOTO','Сделать снимок');
define('TEXT_FIELDTYPE_IMAGE_AJAX_TITLE','Поле для загрузки изображения (Ajax)');
define('TEXT_EXCLUDE_VALUES_NOT_IN_LISTING','Исключить значения, отсутствующие в списке записей');
define('TEXT_FIELDTYPE_COLOR_TITLE','Выбор цвета');
define('TEXT_FIELDTYPE_COLOR_TOOLTIP','Отображает цвета, которые были настроены для опций, непосредственно в раскрывающемся списке.');
define('TEXT_TARGET','Цель');
define('TEXT_TARGET_BLANK','Новое окно (_blank)');
define('TEXT_TARGET_SELF','Текущее окно (_self)');
define('TEXT_SIGNATURE_REQUIRED','Требуется подпись');
define('TEXT_DISABLE_USER_AVATAR','Отключить аватар пользователя');
define('TEXT_CURRENT_USER_GROUP','Текущая группа пользователя');
define('TEXT_CUSTOM_HTML','Пользовательский HTML');
define('TEXT_CUSTOM_HTML_INFO','Добавьте пользовательский код в теги head и body. Поддерживаются только HTML, CSS и JS.');
define('TEXT_ADD_CODE_END_OF_HEAD','Добавьте код в конце тега <head>');
define('TEXT_ADD_CODE_BEFORE_BODY','Добавьте код перед тегом </body>');
define('TEXT_RESET_SORTING','Сбросить сортировку');
define('TEXT_VALUES_WILL_SORTED_BY_NAME','Значения будут отсортированы по названию');
define('TEXT_DISPLAY_PARENT_NAME','Отображать название родителя');
define('TEXT_SELECT_ALL_RECORDS','Выбрать все записи');
define('TEXT_ON_CURRENT_PAGE_ONLY','Только на текущей странице');
define('TEXT_SELECTED_RECORDS','Выбрано записей: <b>%s</b>');
define('TEXT_RESET_SELECTION','Сбросить выбор');
define('TEXT_FIELDTYPE_AUTOSTATUS_ACTION_TIP','У вас есть возможность подключить процесс из автоматизации к любому статусу. Если процесс выбран, он будет выполняться автоматически при переходе на указанный статус.');
define('VALUE_FROM_PARENT_ENTITY','Значение из родительской сущности');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_PARENT_FIELD_VALUE_TIP','Если создано отдельное поле, в котором выбирается значение из родительской сущности, выберите данное поле чтобы установитиь взаимосвязьс списков. <a href="https://docs.rukovoditel.net.ru/index.php?p=126" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_TEXT','Текст');
define('TEXT_BACKGROUND','Фон');
define('TEXT_SAVE_AS','Сохранить как');
define("TEXT_ADD_RECORDS_TO_FAVORITES","Добавлять записи в избранное");
define('TEXT_ADD_RECORDS_TO_FAVORITES_TIP','Значок звездочки появится на странице записи, что позволит пользователям добавлять записи в избранное. <a href="https://docs.rukovoditel.net.ru/index.php?p=127" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FAVORITES','Избранное');
define('TEXT_DISPLAYED','Отображено');
define('TEXT_DISPLAY_SEARCH_BAR','Отобразить строку поиска');
define('TEXT_FIELDTYPE_IMAGE_MAP_NESTED_TITLE','План-схема для вложенных записей');
define('TEXT_FIELDTYPE_IMAGE_MAP_NESTED_TOOLTIP','Специальный тип поля для отображения пользовательских карт. Пользователи смогут загружать собственные изображения карты. Маркеры на карте - это записи из вложенной сущности. <a href="https://docs.rukovoditel.net.ru/index.php?p=18" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_HIDDEN_FIELDS_IN_FORM','Скрытые поля в форме');
define('TEXT_HIDDEN_FIELDS_IN_FORM_TIP','Вы можете скрыть технические поля для всех групп пользователей, кроме администраторов.');
define('TEXT_ALL_STAGES','Все этапы');
define('TEXT_CONSISTENTLY','Последовательно');
define('TEXT_BRANCHING','Разветвление');
define('TEXT_FIELDTYPE_STAGES_SHOW_CONSISTENTLY_TIP','Отображать только один этап после текущего');
define('TEXT_FIELDTYPE_STAGES_SHOW_BRANCHING_TIP','Отображается только текущая ветка в дереве этапов.');
define('TEXT_GLOBAL_VARS','Глобальные переменные');
define('TEXT_GLOBAL_VARS_INFO','Создавайте глобальные константы, которые можно использовать в собственном PHP-коде или типе поля MySql Формула. <a href="https://docs.rukovoditel.net.ru/index.php?p=128" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ADD_FOLDER','Добавить папку');
define('TEXT_CUSTOM_PHP','Пользовательский PHP');
define('TEXT_CUSTOM_PHP_INFO','Создавайте свои собственные функции и классы, которые можно использовать в поле PHP Код или в PHP коде в автоматизации.  <a href="https://docs.rukovoditel.net.ru/index.php?p=129" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_F11_FULLSCREEN','F11 - полный экран');
define('TEXT_DISABLE','Отключить');
define('TEXT_DISPLAYS_AS_TAB','Отображается как вкладка');
define('TEXT_AUTO_BACKUP','Автобэкап');
define('TEXT_AUTOMATIC_BACKUP','Автоматическое резервное копирование');
define('TEXT_AUTOMATIC_BACKUP_INFO','Для запуска резервного копирования по расписанию,  вам нужно установить задачу по расписанию (cron) в панели управления вашего хостинга.');
define('TEXT_KEEP_FIELS','Хранить файлы');
define('TEXT_ENTER_NUMBER_OF_DAYS','Введите количество дней');
define('TEXT_FORM_WIZARD','Form Wizard');
define('TEXT_TAB_GROUPS','Группы вкладок');
define('TEXT_TAB_GROUPS_INFO','Если имеется большое количество вкладок, то для экономии места в форме вы можете сгруппировать вкладки. <a href="https://docs.rukovoditel.net.ru/index.php?p=64" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FORM_WIZARD_INFO','Разделите ввод данных по шагам с помощью вкладок. Если эта опция включена, пользователь должен вводить данные шаг за шагом. В этом случае кнопка Сохранить отображается на последней вкладке. <a href="https://docs.rukovoditel.net.ru/index.php?p=130" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_NEXT','Далее');
define('TEXT_PREVIOUS','Назад');
define('TEXT_OF','из');

//new defines for version 3.1
define('TEXT_EMAILS_LAYOUT','Макет письма');
define('TEXT_EMAILS_LAYOUT_INFO','Создайте HTML макет для электронных писем в приложении. <a href="https://docs.rukovoditel.net.ru/index.php?p=132" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_SEND_TEST_EMAIL_INFO','Письмо с темой "%s" будет отправлено на адрес:');
define('TEXT_COUNTRY','Страна');
define('TEXT_INTERNATIONAL','Международный');
define('TEXT_STEAM','Steam');
define('TEXT_DOMAIN','Доменное имя');
define('TEXT_HTML_CODE','HTML код');
define('TEXT_MYSQL_QUERY','MySQL запрос');
define('TEXT_USE_HTML_EDITOR','Использовать HTML редактор');
define('TEXT_EMPTY_VALUE','Пустое значение');
define('TEXT_AVAILABLE_VALUES','Доступные значения');
define('TEXT_FIELDTYPE_YANDEX_MAP_TITLE','Карта Яндекс');
define('TEXT_FIELDTYPE_YANDEX_MAP_TOOLTIP','Поле для отображения маркера на карте. Координаты маркера определяются автоматически по введенному адресу. <a href="https://docs.rukovoditel.net.ru/index.php?p=135" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_YANDEX_MAP_API_KEY_TIP','Зайдите на страницу "<a href="https://developer.tech.yandex.ru/" target="_blank">Кабинета Разработчика</a>" и нажмите кнопку "Получить ключ". Во всплывающем окне выберите сервис "JavaScript API и HTTP Геокодер"');
define('TEXT_YANDEX','Яндекс');

//new defines for version 3.2
define('TEXT_GELIOSSOFT_SITE','geliossoft.ru');
define('TEXT_GELIOSSOFT_ENABLE','Включить интеграцию с GeliosSoft');
define('TEXT_SPEED','Скорость');
define('TEXT_SPEED_KPH','км/ч');
define('TEXT_DATA_REFRESH_INTERVAL','Интервал обновления данных');
define('TEXT_SECONDS','Секунды');
define('TEXT_LAST_MESSAGE','Последнее сообщение');
define('TEXT_DATEPICKER_DAYS_HOURS_MINUTES_SHORT','д.,ч.,м.,с.');
define('TEXT_AGO','назад');
define('TEXT_SIDEBAR_WIDTH','Ширина боковой панели');
define('TEXT_CARS','Автомобили');
define('TEXT_SHOW_WEEK_NUMBERS','Показывать номера недель');
define('TEXT_FIELDTYPE_INPUT_DATE_EXTRA_TITLE','Расширенный календарь');
define('TEXT_FIELDTYPE_INPUT_DATE_EXTRA_TOOLTIP','Календарь для выбора даты и времени, который имеет ряд дополнительных настроек отображения. <a href="https://docs.rukovoditel.net.ru/index.php?p=137" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_MINIMUM_TIME','Минимальное время');
define('TEXT_MAXIMUM_TIME','Максимальное время');
define('TEXT_ALLOWED_TIME','Разрешенное время');
define('TEXT_FORMAT','Формат');
define('TEXT_DISABLED_DATES','Отключенные даты');
define('TEXT_DISABLED_WEEK_DAYS','Отключенные дни недели');
define('TEXT_DISABLED_DATES_BY_QUERY','Отключенные даты по SQL запросу');
define('TEXT_FIELDTYPE_YANDEX_MAP_DIRECTIONS_TITLE','Карта Яндекс маршруты');
define('TEXT_FIELDTYPE_YANDEX_MAP_DIRECTIONS_TOOLTIP','Поле для отображения нескольких маркеров на карте. Координаты маркеров определяются автоматически по введенным адресам. По заданным маркерам можно проложить маршрут. <a href="https://docs.rukovoditel.net.ru/index.php?p=135" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_YANDEX_MAP_NESTED_TITLE','Карта Яндекс маршруты (Вложенная сущность)');
define('TEXT_FIELDTYPE_YANDEX_MAP_NESTED_TOOLTIP','Маршрут будет построен по адресам из вложенной сущности. <a href="https://docs.rukovoditel.net.ru/index.php?p=135" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_WINDOW','Окно');
define('TEXT_LOGS','Логи');
define('TEXT_STORE_IN_DB','Хранить в базе');
define('TEXT_RECORDS_VISIBILITY_SQL_QUERY_INFO','Добавьте свой собственный запрос, который будет включен в Правила видимости записей');
define('TEXT_ERRORS','Ошибки');
define('TEXT_ALL','Все');
define('TEXT_REFRESH','Обновить');
define('TEXT_DISPLAY_AS_DROPDOWN_AJAX_TIP','При большом количеством кнопок в списке, рекомендуется использовать выпадающий список ajax-типа. Это уменьшает нагрузку на сервер.');
define('TEXT_LOGS_INFO','Внимание: не оставляйте логи постоянно включенными, так как они создают дополнительную нагрузку на сервер.  <a href="https://docs.rukovoditel.net.ru/index.php?p=138" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_GOOGLE_MAP_NESTED_TITLE','Карта Google маршруты (Вложенная сущность)');
define('TEXT_FIELDTYPE_GOOGLE_MAP_NESTED_TOOLTIP','Маршрут будет построен по адресам из вложенной сущности.');
define('TEXT_DATE','Дата');
define('TEXT_VALUE_FROM_SQL_TIP','Введите название поля из sql запроса.');
define('TEXT_CALCULATOR','Калькулятор');
define('TEXT_DATA_IN_BORWSER_CONSOLE','Данные отображаются в консоли браузера.');

//new defines for version 3.3
define('TEXT_TAB','Символ табуляции');
define('TEXT_SPACE','Пробел');
define('TEXT_OTHER','Другой');
define('TEXT_ENCODING','Кодировка');
define('TEXT_START_IMPORT_FROM_LINE','Начать импорт со строки');
define('TEXT_TEXT_SELECT_ALL_TIP','Если введено, пользователь может нажать на него и выбрать все значения в списке.');
define('TEXT_EVERY_DAY','Каждый день');
define('TEXT_EXTENDED','Расширенный');
define('TEXT_NAME_ON_MOBILE_DEVICE','Название на мобильном устройстве ');
define('TEXT_HIDE_IF_EMPTY','Скрыть, если нет записей');
define('TEXT_NESTED_ENTITIES_MENU','Меню вложенных сущностей');
define('TEXT_NESTED_ENTITIES_MENU_INFO','В целях экономии  места на странице, вы можете объединить сущности в группы. <a href="https://docs.rukovoditel.net.ru/index.php?p=144" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_ICON_COLOR','Цвет иконки');
define('TEXT_TEXT_COPIED','Текст скопирован');
define('TEXT_DOCS_PREVIEW','Предварительный просмотр документов');
define('TEXT_DOCS_PREVIEW_INFO','Пользователи смогут просмотреть документы во вложении через выбранный сервис, без скачивания их на диск.');
define('TEXT_IGNORE_CURRENT_DAY','Не учитывать текущий день');
define('TEXT_SENDER','Отправитель');

//new defines for version 3.4
define('TEXT_NUMBER_DISPLAYED_CHARACTERS_IN_LIST','Количество отображаемых символов в списке');
define('TEXT_NUMBER_DISPLAYED_CHARACTERS_IN_LIST_INFO','Если задано, длинный текст будет обрезан и будет добавлена ссылка "Подробнее".');
define('TEXT_READ_MORE','Подробнее');
define('TEXT_FIELDTYPE_RELATED_MAIL_TITLE','Связанные письма');
define('TEXT_FIELDTYPE_RELATED_MAIL_TOOLTIP','Если вы используете функцию <a href="https://docs.rukovoditel.net.ru/index.php?p=32" target="_balnk">интеграции с почтой</a>, с этим типом поля вы можете отображать связанные письма в списке записей. <a href="https://docs.rukovoditel.net.ru/index.php?p=147" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_COUNT_RELATED_EMAILS','Количество связанных писем ');
define('TEXT_LIST_RELATED_EMAILS','Список связанных писем ');
define('TEXT_UNREAD_EMAILS_ONLY','Только непрочитанные письма');
define('TEXT_HAS_RELATED_EMALS','Есть связанные письма');
define('TEXT_HAS_UNREAD_RELATED_EMALS','Есть непрочитанные письма');
define('TEXT_NO_RELATED_EMALS','Нет связанных писем');
define('TEXT_DO_NOT_APPLY_RECORD_VISIBILITY_RULES','Не применять правила видимости записей');
define('TEXT_DO_NOT_APPLY_RECORD_VISIBILITY_RULES_INFO','Правила видимости записей не будут включены в sql-запрос для выбора записей');
define('TEXT_ALLOW_SORT_ORDER','Разрешить сортировку');
define('TEXT_ALLOW_SORT_ORDER_ATTACHMENTS_TIP','На странице записи появится возможность сортировать вложения');
define('TEXT_DYNAMIC_MASK','Динамическая маска');
define('TEXT_FORM_ADD_IN','Форма "Добавить в"');
define('TEXT_FORM_ADD_IN_FILTERS_TIP','Форма "Добавить в" отображается если родительская запись явно не указана. Настройте фильтры для выпадающего списка записей из родительской сущности.');
define('TEXT_DISABLE_TIME_BY_QUERY','Отключенное время по SQL запросу');
define('TEXT_RECORDS_VISIBILITY_PHP_CODE_INFO','Добавьте свой собственный php-код для выбора записей, которые будут видны пользователям.');
define('TEXT_DISABLE_LISTING_FIELDS_CONFIGURATION','Отключить настройку полей в списке');
define('TEXT_DISABLE_FOR_ALL','Отключить для всех');
define('TEXT_DISABLE_LISTING_FIELDS_CONFIGURATION_TIP','По умолчанию каждый пользователь может настроить собственные столбцы в списке. Если отключено, то будут использоваться стандартные настройки.');
define('TEXT_VIEW_ALL_RECORDS','Просмотр всех записей');
define('TEXT_FILENAME_TEMPLATE','Шаблон для имени файла');
define('TEXT_FIELDTYPE_ATTACHMENTS_FILENAME_TEMPLATE_NOTE','Применяется если: Ограничение загрузки = 1');
define('TEXT_YOU_CAN_USE','Вы можете использовать');
define('TEXT_FIELDTYPE_3DVIEWER_TITLE','Поле для загрузки 3D моделей');
define('TEXT_FIELDTYPE_3DVIEWER_TOOLTIP','Загружайте и просматривайте 3D-модели в форматах .obj, .fbx, .stl, .gltf');
define('TEXT_VIEW_3D_MODEL_ON_RECORD_PAGE','Просмотр 3D-модели на странице записи');
define('TEXT_VIEWPORT_HEIGHT','Высота области просмотра');
define('TEXT_SELECT_FILE','Выберите файл');
define('TEXT_LOADING','Загрузка...');
define('TEXT_OBJECT_COLOR','Цвет объекта');
define('TEXT_HIDE_NAME_ON_PRINT_PAGE','Скрыть имя на странице печати');
define('TEXT_ENTER_PASSWORD_MANDATORY','Ввод пароля обязателен');
define('TEXT_LISTING_TYPE','Тип списка');
define('TEXT_RECORD_INFO_COLLAPSED_BY_DEFAULT','Информация о записи свернута по умолчанию');
define('TEXT_HIDE_FIELD_NAMES','Скрыть название полей');
define('TEXT_HIDE_FIELD_NAMES_TIP','В целях экономии места, вы можете скрыть название полей на странице записи.');
define('DISPLAY_QR_CODE_ON_ITEM_PAGE','Отобразить  QR код на странице записи');
define('TEXT_ENTER_RECORDS_ID_BY_COMMA','Введите ID записей через запятую');
define('TEXT_LISTING_HIGHLIGHT_NUMERIC_FIELDS_TOOLTIP','Также вы можете сравнить значения из текущей записи, например: <code> >0&<[552]</code>');
define('TEXT_GRID_ELEMENT_WILL_BE_CLICKABLE','Элемент сетки будет кликабельным и перенаправит на страницу информации о записи');
define('TEXT_ATTACHMENTS_SORT_ORDER','Сортировка вложений');
define('TEXT_BY_DATE_UPLOAD','По дате загрузки');
define('TEXT_BY_FILENAME','По имени файла');
define('TEXT_MANUAL_SORTING','Ручная сортировка');
define('TEXT_ALLOW_ACCESS_FOR_ALL_USERS','Разрешить доступ всем пользователям');
define('TEXT_DISPLAY_FILTER_PANEL','Отображать панель фильтров');
define('TEXT_DISPLAY_COPY_TO_CLIPBOARD_ICON','Отобразить значок копирования в буфер обмена');
define('TEXT_ICON_WILL_DISPLAYED_ON_RECORD_PAGE','Значок будет отображаться на странице записи.');
define('TEXT_COPIED','Скопировано');
define('TEXT_COPY_TO_CLIPBOARD','Скопировать в буфер обмена');
define('TEXT_DISPLAY_INPUT_FIELD_ENTER_PERSON_NAME','Отобразить поле ввода для ввода имени пользователя');
define('TEXT_DISPLAY','Отображение');
define('TEXT_PAGINATION','Разбиение на страницы');
define('TEXT_FILTER_BY_ENTITY','Фильтр по сущности');
define('TEXT_FILTER_BY_GLOBAL_LIST','Фильтр по глобальному списку');

//new defines for version 3.5
define('TEXT_ABOUT_APP','О программе');
define('TEXT_ABOUT_APP_DETAILS','
<p>CRM Руководитель - это свободное программное обеспечение с открытым кодом,  распространяемое на условиях <a target="_blank" href="https://www.gnu.org/licenses/gpl-3.0.html">GNU GPLv3</a></p>
<p>Автором и правообладателем программы являются:</p>
<ul>
    <li>Харчишин Сергей Васильевич</li>
    <li>Харчишина Ольга Александровна</li>
</ul>
<p><a href="https://fips.ru/EGD/3b18c104-1db7-4f2d-83fb-2d38e1474ca3" target="_blank"><i class="fa fa-file-text-o"></i> Электронный охранный документ</a></p>
<p><a href="https://reestr.digital.gov.ru/reestr/1910526/" target="_blank"><i class="fa fa-certificate"></i> Программа входит в реестр ‍отечественного ПО</a></p>
<p><a href="mailto:support@rukovoditel.net.ru">support@rukovoditel.net.ru</a><br><a target="_blank" href="https://www.rukovoditel.net.ru">www.rukovoditel.net.ru</a></p>
');
define('TEXT_SORT_BY_FIELD','Сортировать по полю');
define('TEXT_GROUP_BY_FIELD','Группировать по полю');
define('TEXT_AUDIO_RECORDING','Запись аудио');
define('TEXT_ALLOW_AUDIO_RECORDING','Разрешить запись аудио');
define('TEXT_ALLOW_AUDIO_RECORDING_INFO','Рядом с кнопкой вложения появится значок микрофона');
define('TEXT_AUDIO_RECORDING_LENGTH','Длина аудиозаписи');
define('TEXT_AUDIO_RECORDING_LENGTH_INFO','Ограничьте длину аудиозаписи в минутах.');
define('TEXT_RECORD','Запись');
define('TEXT_PAUSE','Пауза');
define('TEXT_STOP','Остановить');
define('TEXT_RESUME','Возобновить');
define('TEXT_AUDIO_RECORD','Аудиозапись');
define('TEXT_START_RECORDING','Начать запись');
define('TEXT_FIELDTYPE_ONLYOFFICE_TITLE','ONLYOFFICE Сервер');
define('TEXT_FIELDTYPE_ONLYOFFICE_TOOLTIP','Загруженные файлы можно просмотреть и изменить с помощью редактора документов ONLYOFFICE. Для работы данного поля требуется доступ к серверу ONLYOFFICE. <a href="https://docs.rukovoditel.net.ru/index.php?p=149" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_URL_TO_JS_API','Url-адрес для API JavaScript');
define('TEXT_ONLYOFFICE_API_JS_INFO','Где <b>documentserver</b> - это имя сервера, на котором установлен ONLYOFFICE Document Server.');
define('TEXT_ONLYOFFICE_SECRET_KEY_INFO','Секретный ключ используется для подписи веб-токена JSON и проверки подлинности токена по запросу в ONLYOFFICE Docs. <a href="https://helpcenter.onlyoffice.com/ru/installation/docs-configure-jwt.aspx" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_DELETE_FILE','Удалить файл');
define('TEXT_REGION','Регион');
define('TEXT_ALLOW_EDIT_DOCUEMENT','Разрешить редактировать документ');
define('TEXT_USERS_WITH_VIEW_ACCESS','Пользователям с доступом на просмотр записи');
define('TEXT_USERS_WITH_EDIT_ACCESS','Пользователям с доступом на редактирование записи');
define('TEXT_ASSIGNED_USERS','Назначенные пользователи');
define('TEXT_SPECIFY_REQUIRED_FIELDS','Укажите необходимые поля');
define('TEXT_DISABLE_EMAIL_NOTIFICATIONS_TIP','Будут отключены только уведомления по электронной почте по умолчанию. Правила отправки почты по-прежнему будут работать.');
define('TEXT_DATE_RANGE','Диапазон дат');
define('TEXT_MERGE_VALUE','Объединить значение');
define('TEXT_EXCLUDE_VALUE','Исключить значение');
define('TEXT_PREVKOUS_VALUE','Предыдущее значение');
define('TEXT_WEB_APPLICATION_ICONS','Иконки веб-приложений');
define('TEXT_ACCESSIBILITY_ICONS','Иконки специальных возможностей');
define('TEXT_HAND_ICONS','Иконки рук');
define('TEXT_TRANSPORTATION_ICONS','Иконки транспорта');
define('TEXT_GENDER_ICONS','Гендерные иконы');
define('TEXT_FILE_TYPE_ICONS','Иконки типов файлов');
define('TEXT_SPINNER_ICONS','Спиннер-иконки');
define('TEXT_FORM_CONTROL_ICONS','Иконки управления формой');
define('TEXT_PAYMENT_ICONS','Иконки платежей');
define('TEXT_CHART_ICONS','Иконки диаграмм');
define('TEXT_CURRENCY_ICONS','Иконки валют');
define('TEXT_TEXT_EDITOR_ICONS','Иконки текстового редактора');
define('TEXT_DIRECTIONAL_ICONS','Иконки направления');
define('TEXT_VIDEO_PLAYER_ICONS','Иконки видеоплеера');
define('TEXT_CANT_DELTE_ITEM','Невозможно удалить запись');
define('TEXT_LIST_USED_WARN','Список используется в следующих полях:');
define('TEXT_FILE_STORAGE','Хранение файлов');
define('TEXT_FIELDTYPE_DROPBOX_TITLE','Dropbox');
define('TEXT_ACCESS_TOKEN','Токен доступа');
define('TEXT_ROOT_FOLDER','Корневая папка');
define('TEXT_APP_CODE','Код приложения');
define('TEXT_APP_KEY','Ключ приложения');
define('TEXT_APP_TOKEN','Токен приложения');
define('TEXT_GET_VALUE','Получить значение');
define('TEXT_CHECK_FIELD_SETTINGS','Проверьте настройки поля.');
define('TEXT_FIELDTYPE_YANDEX_DISK_TITLE','Яндекс Диск');
define('TEXT_OAUTH_TOKEN','OAuth-токен');
define('TEXT_CLIENTID','ClientID');
define('TEXT_ROOT_FOLDER_FILE_STORAGE_WARN','Если вы меняете имя корневой папки, вам необходимо вручную изменить имя в сервисе хранения файлов.');
define('TEXT_FILE_STORAGE_TOOLTIP','Специальное поле, позволяющее загружать файлы в сервис хранения файлов. <a href="https://docs.rukovoditel.net.ru/index.php?p=150" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_PRIVATE_KEY_FILENAME','Имя файла закрытого ключа');
define('TEXT_PRIVATE_KEY_FILENAME_TIP','Создайте закрытый ключ для своей  сервисной учетной записи в формате JSON. Загрузите JSON-файл в папку <code>config/</code>.');
define('TEXT_FIELDTYPE_GOOGLE_DRIVE_TITLE','Google Диск');
define('TEXT_FIELDTYPE_GOOGLE_DRIVE_ROOT_FOLDER','Идентификатор папки на Google диске');
define('TEXT_FIELDTYPE_GOOGLE_DRIVE_ROOT_FOLDER_TIP','Создайте новую папку, в которой будут находиться файлы. Идентификатор папки вы можете найти в URL страницы. <code>Примечание:</code> доступ к папке должен быть предоставлен вашей сервисной учетной записи.');
define('TEXT_FIELDTYPE_GOOGLE_DRIVE_TOOLTIP','Специальное поле, позволяющее загружать файлы в сервис хранения файлов Google Disk. <a href="https://docs.rukovoditel.net.ru/index.php?p=153" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_DROPBOX_TOOLTIP','Специальное поле, позволяющее загружать файлы в сервис хранения файлов Dropbox. <a href="https://docs.rukovoditel.net.ru/index.php?p=152" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_FIELDTYPE_YANDEX_DISK_TOOLTIP','Специальное поле, позволяющее загружать файлы в сервис хранения файлов Yandex Диск. <a href="https://docs.rukovoditel.net.ru/index.php?p=151" target="_blank"><u>Подробнее.</u></a>');

//new defines for version 3.6
define('TEXT_CURRENT_APP_VERSION', 'Версия программы');
define('TEXT_UPDATE_INSTRUCTION','<a href="https://docs.rukovoditel.net.ru/index.php?p=63" target="_blank"><i class="fa fa-hand-o-right"></i> Инструкция по обновлению</a>');
define('TEXT_COMPOSITE_UNIQUE_FIELDS','Составные уникальные поля');
define('TEXT_COMPOSITE_UNIQUE_FIELDS_INFO','Данный функционал предназначен для объединения уникальных полей в группы.  Проверка на уникальность будет проходить для группы, поля сравниваются парами. Устанавливать флаг уникальности для отдельного поля не нужно. <a href="https://docs.rukovoditel.net.ru/index.php?p=160" target="_blank"><u>Подробнее.</u></a>');
define('TEXT_COMPOSITE_UNIQUE_MESSAGE_TIP','Используйте констаны <code>[f1]</code>, <code>[f2]</code> для вставки значения полей в сообщение.<br>Константы <code>[f1_in]</code> и <code>[f2_in]</code> используются, если сравниваются поля с выбором нескольких значений. В данных константах размещены значения, которые пересекаются.');
define('TEXT_MESSAGE_TEXT','Текст сообщения');
define('TEXT_YANDEX_SMARTCAPTCHA_HOW_ENABLE','Для включения откройте файл "config/security.php", измените CFG_YANDEX_SMARTCAPTCHA_ENABLE на true, введите ключ в CFG_YANDEX_SMARTCAPTCHA_KEY и секретный ключ в CFG_YANDEX_SMARTCAPTCHA_SECRET_KEY.');
define('TEXT_WHO_IS_ONLINE','Кто в сети');
define('TEXT_ONLINE','В сети');
define('TEXT_OFFLINE','Не в сети');
define('TEXT_ENABLE_WHO_IS_ONLINE_REPORT','Включить отчет "Кто в сети"');
define('TEXT_ENABLE_WHO_IS_ONLINE_REPORT_TIP','Если включено, в меню "Инструменты" появится страница "Кто в сети".');
define('TEXT_STATUS_UPDATE_TIME','Время обновления статуса');
define('TEXT_IN_MINUTES','В минутках');
define('TEXT_AUTO_LOGOUT_INACTION_USERS','Автоматический выход из системы для бездействующих пользователей');
define('TEXT_TIME_WITHOUT_ACTION','Время бездействия');
define('TEXT_BLOCK_RECORD_FORM_WHEN_EDITING','Блокировать форму записи при редактировании');
define('TEXT_BLOCK_RECORD_FORM_WHEN_EDITING_INFO','Если  пользователь начал внесение изменений, другому пользователю редактирование будет не доступно.<br>Данное правило применяется ко всем формам сущности и формам автоматизации.');
define('TEXT_FORM_BLOCKED_WARNING','Форма заблокирована. <b>[user_name]</b> вносит изменения.<br>Повторите попытку позже.');
define('TEXT_NEGATIVE_NUMBER_COLOR','Цвет отрицательного числа');
define('TEXT_HIDE_PAGE_TITLE','Скрыть заголовок страницы');
define('TEXT_HIDE_PRINT_BUTTON','Скрыть кнопку печати');
define('TEXT_CURRENT_YEAR','Текущий год');
define('TEXT_MAXIMUM_NUMBER_OF_FIELS_TO_UPLOAD','Максимальное количество загружаемых файлов');
define('TEXT_UPDATE_BY_CREATOR_ONLY','Обновить только создателем');
define('TEXT_LOGIN_ATTEMPT_INFO','На этой странице вы можете ограничить количество попыток входа в систему. После неудачных попыток входа в систему IP-адрес пользователя будет временно заблокирован.');
define('TEXT_NUMBER_LOGIN_ATTEMPTS','Количество попыток входа в систему');
define('TEXT_NUMBER_LOGIN_ATTEMPTS_TIP','Количество попыток входа в систему, разрешенных в течение указанного периода.');
define('TEXT_NUMBER_MINUTES','Количество минут');
define('TEXT_NUMBER_MINUTES_IP_BLOCKED_TIP','Количество минут, на которые IP-адрес будет заблокирован.');
define('TEXT_LOGIN_ATTEMPT_VERIFY_ERROR','Количество попыток входа в систему ограничено. Пожалуйста, повторите попытку позже.');
define('TEXT_RESTRICTIONS','Ограничения');
define('TEXT_DO_NOT_APPLY_RESTRICTIONS_FOR','Не применять ограничения для');
define('TEXT_VIEW_PLUS_DISPLAY_IN_FORM','Просмотр + показать значение в форме');
define('TEXT_MAXLENGTH','Максимальное количество символов');
define('TEXT_MAXLENGTH_TIP','Установите максимально допустимое количество символов.');
define('TEXT_TRUSTED_IP','Доверенные IP адреса');
define('TEXT_TRUSTED_IP_TIP','Введите IP-адреса через запятую. Проверка не будет применена к введенным IP-адресам.');
define('TEXT_FIELD_DOES_NOT_EXIST_ERROR','Ошибка: отсутствует поле "%s" в сущности "%s".');
define('TEXT_COPY_GROUP_QUESTION','Скопировать группу "%s"?');
define('TEXT_COPY_GROUP_TIP','Введите данные новой группы. Права доступа к сущностям, полям и комментариям будут скопированы из группы "%s".');
define('TEXT_LIMIT_LIST','Ограничить список');
define('TEXT_LIMIT_LIST_INFO','Выберите группу пользователей или конкретных пользователей, которые будут доступны в списке.');
define('TEXT_USE_CANCEL_BUTTON','Применять кнопку "Отменить"');
define('TEXT_FIELDTYPE_USERS_APPROVE_CANCEL_BTN_TIP','Пользователи могут отменить выполненное действие.');
define('TEXT_HIDE_BUTTON','Скрыть кнопку');
define('TEXT_FIELDTYPE_USERS_APPROVE_HIDE_CANCEL_BTN_TIP','Выберите поле и значения, при которых кнопка "Отменить" будет скрыта.');
define('TEXT_DELETE_BTN','Кнопка удаления');
define('TEXT_USE_DELETE_BUTTON','Использовать кнопку "Удалить"');
define('TEXT_ANY_USERS','Любой пользователь');
define('TEXT_FIELDTYPE_SIGNATURE_FILTERS_TIP','По умолчанию Кнопка доступна все пользователям. Нажмите на название поля в списке, чтобы настроить условия отображения кнопки.');
define('TEXT_MY_CURRENT_SIGNATURE', 'Моя текущая подпись');
define('TEXT_USE_ID_FEM','Использовать ее');
define('TEXT_DISPLAY_USER_CURRENT_SIGNATURE','Отображать текущую подпись пользователя');
define('TEXT_DISPLAY_USER_CURRENT_SIGNATURE_TIP','Если ранее пользователь подписывал какой-либо элемент, в следующий раз он может использовать собственную подпись, щелкнув по ней одним щелчком мыши.');
define('TEXT_SELECT_USER_GROUP_FOR_RULE','Выберите группы пользователей, для который будет применяться правило. По умолчанию для всех пользователей.');
define('TEXT_ALL_USERS','Все пользователи');
define('TEXT_RESET_TO_DEFAULT','Сбросить к значению по умолчанию');
define('TEXT_SET_MSG_FILTERS','Установите фильтры, при которых сообщение будет отправлено.');










