<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
require('runtime.inc.php');

/**
 * @var \SCHLIX\cmsApplication_Basic
 */
global $Application; 
global $_cache_table_exists;
/**
 * @var \App\Core_versioning
 */
global $Versioning;
global $Blocks, $Macros, $SiteTheme, $HTMLHeader, $SystemConfig, $SystemLog, $CurrentWebSiteThemeName, $CurrentFrontendApplication;
global $__html_output;


function getApplicationToLoad() {
    global $SystemConfig, $CurrentFrontendApplication;
    
    $error = 0;
    $main_app_replacement = $SystemConfig->get('system','str_main_app');
    $app_to_load = $CurrentFrontendApplication = $main_app_replacement ? $main_app_replacement : 'html'; // set to html by default
    $rq_app = fget_string('app');
    if (SCHLIX_SEF_ENABLED && empty($rq_app)) {
        
        $s = get_relative_url_request_path();
        
        $url_array = explode('/', $s);
        // update - June 5, 2025
        if ((SCHLIX_SITE_HTTPBASE === '') && (___c($url_array) === 1) && (!isset ($url_array[1])))
        {            
            redirect_url(SCHLIX_SITE_HTTPBASE.'/');
            exit();
        }
        $appname = isset($url_array[1]) ? $url_array[1] : '';
        // end update - June 5, 2025
        $sub_app = NULL;
        if (strpos($appname,'.') > 0)
        {
            list($main_app, $sub_app) = explode('.', $appname);
            $the_real_app_name = (!empty($sub_app) && strtolower($sub_app) != 'admin') ? get_application_real_name_by_alias($main_app) 
                    : get_application_real_name_by_alias($appname);
        } else
        {
            $the_real_app_name = get_application_real_name_by_alias($appname);
        }
        if ($the_real_app_name) {
            if ($sub_app)
            {
                $complete_class_name = $the_real_app_name.'.'.$sub_app;
                $include_filename = "/apps/{$the_real_app_name}/{$sub_app}/{$complete_class_name}.class.php";
            } else
            {
                $complete_class_name =  $the_real_app_name;
                $include_filename = "/apps/{$the_real_app_name}/{$complete_class_name}.class.php";
            }
            if (file_exists(SCHLIX_SYSTEM_PATH . $include_filename) || file_exists(SCHLIX_SITE_PATH . $include_filename))
            {
                $app_to_load = $sub_app ? $the_real_app_name.'_'.$sub_app : $the_real_app_name;
            } else
            {
                $error = 404;                
            }            
        } else {
            
            if ($appname === 'admin')
                return ['app'=> 'admin', 'error'=>0];
            else {
                if (!empty($appname))
                    $error = 404;
            }
        }
        
    } else {
        
        if (!empty($rq_app))
            $app_to_load = alpha_numeric_with_dash_underscore($rq_app);
    }
    return ['app'=> $app_to_load,'error'=> $error];
}

//_________________________________________________________________________//
/**
 * Initialize SCHLIX CMS
 * @global \SCHLIX\cmsDatabase $SystemDB
 * @global \SCHLIX\cmsLogger $SystemLog
 * @global \SCHLIX\cmsApplication_Basic $Application
 * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
 * @global \App\Core_BlockManager $Blocks
 * @global \App\Core_MacroManager $Macros
 * @global \App\Core_ThemeManager $SiteTheme
 * @global \App\EmailQueue $SystemMail
 * @global \App\Core_EditorManager $WYSIWYGEditor
 * @global \App\Core_EditorManager $WYSIWYGEditorProfiles
 * @global string $__html_output
 * @global string $__application_to_load
 * @return string
 */
function Initialize() {

    global $Application, $SystemConfig, $Blocks, $Macros, $SiteTheme, $HTMLHeader, $SystemMail, $SystemDB, $SystemLog, $__html_output;
    global $__application_to_load;
    global $WYSIWYGEditor;//, $WYSIWYGEditorProfiles;
    
    $WYSIWYGEditor = new \App\Core_EditorManager();
    //$WYSIWYGEditorProfiles = new \App\wysiwygEditors_Profiles();
    $SystemMail = new \App\EmailQueue();
    if (ob_get_length() > 0)
        ob_end_clean();
    ob_start();
    $HTMLHeader = new SCHLIX\cmsHTMLPageHeader();
    $Blocks = new \App\Core_BlockManager();
    $Macros = new \App\Core_MacroManager();
    $SiteTheme = new App\Core_ThemeManager();
    $frontend_skin = $SystemConfig->get('system','str_frontend_skin');
    
    $result = getApplicationToLoad();
    $__application_to_load = $result['app']; $error = $result['error'] ;
    
    if (empty($frontend_skin) || $__application_to_load === 'admin')
        $frontend_skin = 'bootstrap3';        
    if (!defined('SCHLIX_THEME_SKIN'))
        define('SCHLIX_THEME_SKIN', $frontend_skin);
    $classname = 'App\\' . $__application_to_load;

    if (defined ('SCHLIX_SITE_OFFLINE') && SCHLIX_SITE_OFFLINE== true && $__application_to_load != 'admin' )
    {        
        $error_message = 'Site is temporarily offline';
        include('system/libs/schlix/view.offline.template.php');
            exit;
    }
    if ($result['app'] != 'admin' && $SystemDB->tableExists('gk_redirection_items')) {
        $app_redirect = new \App\Core_Redirection();
        $app_redirect->doRedirect();
    }

    $Application = new $classname();
    if ($Application->isFrontendRuntimeDisabled()) {
        //echo sprintf(___('Application %s cannot be instantiated from the frontend'),$classname);
        $command['action'] = '404error';
    } else {

        $command = $Application->interpretFriendlyURL($_SERVER['REQUEST_URI']);       
        if ($error)
            $command['action'] = '404error';
    }
        $display_partial_output = $Application->Run($command);
    

    $__html_output = ob_get_contents(); // $Macros->runBeforeFinalHTMLOutput( ob_get_contents() );
    ob_end_clean();
    if ($__application_to_load != 'admin')
        $Blocks->Run($command);
    //////////////////////////////////////
    return $display_partial_output;
}


//_________________________________________________________________________//
function RunScheduler() {
    $system_cron = new \App\Core_CronScheduler();
    $system_cron->runAllScheduledItems();
}
/**
 * Begins
 */
global $__application_to_load;

setupSchlixRuntime();
set_csrf_token(); // CSRF prevention (Beta)
// This is so you can change the user class for integration with different types of authentication provider - e.g: LDAP, Active Directory, Facebook, OpenID, etc
$sv = isset( $_SESSION['__visit']) ? (int) ($_SESSION['__visit']) : 0;
$_SESSION['__visit'] = $sv + 1;
$default_user_class = '\\App\\' . SCHLIX_DEFAULT_USER_CLASS;
$CurrentUser = new $default_user_class(false); // not admin mode
$outputChoice = Initialize();
if ($outputChoice == false)
    echo SCHLIX\cmsPageOutput::ApplicationBody();
else
    $SiteTheme->Run(false);

// lower priority, set to last so visitors aren't too disrupted. This is an acceptable workaround.
// DO NOT use register_shutdown_function
RunScheduler();