<?php
if (!defined('SCHLIX_INSTALLER')) die('Please visit /install/');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
$sess_time_zone = fsession_string('system_timezone');
$sess_site_scheme = fsession_string('site_scheme') ;
$sess_domain_name_port = fsession_string('site_domain_name_and_port');
$sess_site_httpbase = fsession_string('site_httpbase');
$sess_site_name =  fsession_string('site_name');
$sess_short_site_name = fsession_string('short_site_name');
$sess_admin_username = fsession_string('admin_username');
$sess_admin_password = fsession_string('admin_password');
$sess_admin_login_time = fsession_int('admin_login_time');

$sess_remember_me_cookie_time = fsession_int('remember_me_cookie_time');
$sess_mail_default_sender = fsession_string('mail_default_sender');
$sess_mail_default_email = fsession_string('mail_default_email');
$sess_record_404_errors = fsession_int('record_404_errors');
?>
<script type="text/javascript" src="../system/js/jstz/jstz.min.js"></script>
<script type="text/javascript">
var stz = '<?= ___h($sess_time_zone) ?>';

function probeUserTimeZone()
{
    var tz = jstz.determine();
    return tz.name();   
}

function setTz()
{
    if (stz == '')
    {
        var tz = probeUserTimeZone();
        if (tz != '')
        {
            var select = document.getElementById("system_timezone");
            for(var i = 0;i < select.options.length;i++){
                if(select.options[i].value == tz ){
                    select.options[i].selected = true;
                }
            }        
        }
    }
}

SCHLIX.Event.onDOMReady(setTz);

</script>

<form action="index.php?action=database" method="post" enctype="multipart/form-data" class="form-install" autocomplete="off">

    <h2>Site Settings</h2>
    <p>You can only set up one site during this installation. If you wish set up an additional site, please go to the Site Manager section.</p>

    <div class="form-horizontal">
        <!-- input -->
        <div class="form-group">
            <label for="system_timezone" class="control-label col-xs-3">System Timezone</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-calendar-check"></i>
                    </span>
                    <?= INPUT::TimeZoneSelectList('system_timezone', $sess_time_zone, ['class' => 'form-control','id'=>'system_timezone']); ?>
                </div>
            </div>
        </div>
        <!-- input -->
        <div class="form-group">
            <label for="site_scheme" class="control-label col-xs-3">Site URL</label>
            <div class="col-xs-7">
                <p>If you have SSL certificate <strong>already installed</strong> on your server, it is highly recommended to choose https instead of http. If you don't have the SSL certificate and choose https, your site will not be accessible</p>
                <div class="row">
                    <div class="col-xs-4">
                        <div class="input-group">

                            <span class="input-group-addon">
                                <i class="fas fa-server"></i>
                            </span>
                            <!-- col -->
                            <select class="form-control" id="site_scheme" name="site_scheme">
                                <option value="http" <?= $sess_site_scheme == 'http' ? 'selected="selected"' : '' ?> >http://</option>
                                <option value="https" <?= $sess_site_scheme == 'https' ? 'selected="selected"' : '' ?>>(SSL) https://</option>
                            </select>
                        </div>

                    </div>
                    <div class="col-xs-7">
                        <!-- col -->
                        <div class="input-group">
                            <input class="form-control" placeholder="URL (e.g. http://localhost)" name="site_domain_name_and_port"  id="site_domain_name_and_port" type="url"  required="required" value="<?= $sess_domain_name_port; ?>" readonly="readonly" />


                        </div>
                        <!-- end col -->
                    </div>
                </div>

                <div class="checkbox">
                    <label><input type="checkbox" name="use_wildcard" id="use_wildcard" value="1" />Disable multi-site and use wildcard URL.</label>                
                </div>
                <em>Selecting this option means that all parked domain names will be served here as well. Leave unchecked if you are not sure.</em>

                <div class="checkbox">
                    <label><input type="checkbox" name="use_www" id="use_www" value="1" />Make this site valid for both <strong>www</strong> and <strong>without www</strong> (e.g. www.example.com and example.com)</label>                
                </div>
                <em><strong>Recommended for production sites</strong>. Uncheck this if you are installing this on a subdomain (e.g. subdomain.example.com). Leave unchecked if you are not sure. Note: Both options can be left unchecked, but only one option can be selected</em>
            </div>
            

        </div>  

        <!-- input -->
        <div class="form-group">
            <label for="base_path" class="control-label col-xs-3">Base Path</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-folder-open"></i>
                    </span>
                    <input class="form-control" placeholder="Base Path" name="site_httpbase"  id="site_httpbase" type="text"  value="<?= $sess_site_httpbase ? $sess_site_httpbase : '(none)' ?>" readonly="readonly" />

                </div>
                
            </div>
        </div>

        <!-- input -->
        <div class="form-group">
            <label for="site_name" class="control-label col-xs-3">Site Name</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-bookmark"></i>
                    </span>
                    <input class="form-control" placeholder="Site Name" name="site_name"  id="site_name" type="text"  value="<?= ___h($sess_site_name); ?>" autocomplete="off" pattern=".{2,64}" required="required" title="2 to 64 characters" />
                </div>
            </div>
        </div>        
        <!-- input -->
        <div class="form-group">
            <label for="short_site_name" class="control-label col-xs-3">Site ID</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-bookmark"></i>
                    </span>
                    <input class="form-control" placeholder="Site ID (short name)" name="short_site_name"  id="site_name" type="text"  value="<?= ___h($sess_short_site_name); ?>" pattern="^[A-Za-z0-9\-]{3,20}$" autocomplete="off" required="required" title="3 to 20 characters, alphanumeric only" />

                </div>
                <p class="small"><em>This field is used to identify multisite. Please use only alphanumeric characters.</em></p>
            </div>
        </div>        

        <!-- input -->
        <div class="form-group">
            <label for="admin_username" class="control-label col-xs-3">Admin username</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-user"></i>
                    </span>
                    <input class="form-control" placeholder="Admin username" name="admin_username"  id="admin_username" type="text"  value="<?= ___h($sess_admin_username); ?>" pattern="^[A-Za-z0-9_]{3,25}$" autocomplete="off" required="required" />

                </div>
            </div>
        </div>        


        <!-- input -->
        <div class="form-group">
            <label for="admin_password" class="control-label col-xs-3">Admin password</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-lock"></i>
                    </span>
                    <input class="form-control" placeholder="Password" name="admin_password"  id="admin_password" type="password"  value="<?= ___h($sess_admin_password); ?>" pattern=".{7,50}" autocomplete="off" required="required" />
                    <input class="form-control" placeholder="Verify your password" name="admin_password_verify"  id="admin_password_verify" type="password"  value="" pattern=".{7,50}" autocomplete="off" required="required" />

                </div>
                <p class="small"><em>Minimum 7 characters.</em></p>
            </div>
        </div>        

        <!-- input -->
        <div class="form-group">
            <label for="base_path" class="control-label col-xs-3">Session valid for</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-clock"></i>
                    </span>
                    <select id="admin_login_time" name="admin_login_time" class="form-control" required="required">
                        <option value="0">Please select</option>
                        <?php foreach ($arr_login_time as $second => $word): ?>
                        <option value="<?= $second ?>" <?= $sess_admin_login_time == $second ? 'selected' : '' ?>><?= $word ?></option>
                        <?php endforeach ?>
                    </select>
                </div>
            </div>
        </div>      
        
        <!-- input -->
        <div class="form-group">
            <label for="base_path" class="control-label col-xs-3">Remember Me cookie valid for</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-clock"></i>
                    </span>
                    <select id="remember_me_cookie_time" name="remember_me_cookie_time" class="form-control" required="required">
                        <option value="0">Please select</option>
                        <?php foreach ($arr_cookie_time as $second => $word): ?>
                        <option value="<?= $second ?>" <?= $sess_remember_me_cookie_time == $second ? 'selected' : '' ?>><?= $word ?></option>
                        <?php endforeach ?>
                    </select>
                </div>
            </div>
        </div>                  
        
        <hr />

        <h2>Email Settings</h2>
        <!-- input -->
        <div class="form-group">
            <label for="admin_username" class="control-label col-xs-3">From:</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-user"></i>
                    </span>
                    <input class="form-control" placeholder="From field" name="mail_default_sender"  id="mail_default_sender" type="text"  value="<?= ___h($sess_mail_default_sender); ?>" pattern=".{3,64}" autocomplete="off" required="required" />

                </div>
            </div>
        </div>        

        <!-- input -->
        <div class="form-group">
            <label for="admin_username" class="control-label col-xs-3">E-mail:</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-envelope"></i>
                    </span>
                    <input class="form-control" placeholder="Email Address" name="mail_default_email"  id="mail_default_email" type="email"  value="<?= ___h($sess_mail_default_email); ?>" pattern=".{7,127}" autocomplete="off" required="required" />

                </div>
                <p class="small"><em>If you need to configure further settings (SMTP, mail authentication, etc, please go to the Site Manager after this installation is complete.</em></p>
            </div>
        </div>       

        <hr />


        <h2>Other Settings</h2>
        <!-- input -->
            <div class="form-group">
                <div class="col-xs-7 col-xs-offset-3">
                    <div class="checkbox">
                        <label><input type="checkbox" value="1" name="record_404_errors" id="record_404_errors"  <?= $sess_record_404_errors == 1 ? 'checked="checked"' : '' ?> />Record 404 Errors in the database.</label>
                    </div>
                </div>
            </div>
        
            
        <!-- input -->
        <div class="form-group">
            <div class="col-xs-offset-3 col-xs-7 text-center">
                <button type="submit" name="submit" class="btn btn-success" id="continue_to_next_step" value="Submit" onclick="javascript:var x = ajaxTestSiteURL();return x;" />
                <i class="fas fa-arrow-circle-right"></i> Submit
                </button>
            </div>
        </div>
        <!-- end -->
            
        <!-- input -->
        <?php /*
        <div class="form-group">
            <label for="schlix_js_mode" class="control-label col-xs-3">SCHLIX Javascript Mode</label>
            <div class="col-xs-7">
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="far fa-file-code"></i>
                    </span>
                    <select id="schlix_js_mode" name="schlix_js_mode" class="form-control" required="required">
                        <option value="1" <?= intval($_SESSION['schlix_js_mode']) == 3 ? 'selected' : '' ?>>Production (Minified, GZIP-ped)</option>
                        <option value="2" <?= intval($_SESSION['schlix_js_mode']) == 2 ? 'selected' : '' ?>>Minified only</option>
                        <option value="3" <?= intval($_SESSION['schlix_js_mode']) == 1 ? 'selected' : '' ?>>Debug</option>
                    </select>


                </div>
                <p class="small"><em>If you need to configure further settings (SMTP, mail authentication, etc, please go to the Site Manager after this installation is complete.</em></p>
            </div>
        </div>  */ ?>     
    </div>      
</form>
