<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
?>
<div class="box box-success">
    <div class="box-header">
        
        <h3 class="box-title"><i class="fa fa-envelope"></i> <?= ___('Last 5 incoming messages') ?></h3>
    </div>
    <div class="box-body" id="incoming-messages">
        <?php if ($incoming_messages): ?>
        <?php foreach ($incoming_messages as $incoming_message): ?>
            <!-- chat item -->
            <div class="item">
                <p class="message">
                    <strong class="name">
                        
                        <small class="text-muted pull-right"><i class="far fa-clock"></i> <?= $incoming_message['date_created']; ?></small>
                        <?= ___h($incoming_message['subject']) . ' - ' . ___h($incoming_message['name']) . ' ' . ___h("<{$incoming_message['email']}>") ?>
                    </strong>
                    <Br />
                                    <i class="far fa-envelope fa-2x"></i>

                    <?= ___h(str_limit(strip_tags($incoming_message['message']), 255) . '...'); ?>
                </p> 
            </div><!-- /.item -->         
        <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-info"><?= ___('No new message' ) ?></div>
        <?php endif ?>

    </div>
</div><!-- /.box (chat box) -->
