<?php
namespace App;

/**
 * Core: Menu - Admin class
 * 
 * Core - Menu
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Menu_Admin extends \SCHLIX\cmsAdmin_CategorizedList {

    /**
     *
     * @var Core_Menu 
     */
    protected $app;    
    
    protected $reserved_menu_types = ['home','external_link','menu_placeholder','menu_divider'];

    //_________________________________________________________________________//
    public function __construct() {
        parent::__construct();
        $this->setItemFieldNamesForAjaxListing('id', 'title', 'date_created', 'parent_id', 'category_id', 'cid', 'status','sefurl', 'font_icon');
    }
    
    /**
     * Returns category ID# if a block with this name exists. Returns 0 otherwise
     * @global \cmsDatabase $SystemDB
     * @param string $title
     * @return int
     */
    public function getExistingMenuCategoryIDWithName($title) {
        global $SystemDB;

        $title = sanitize_string($title);
        $sql = "SELECT {$this->field_category_id} FROM {$this->table_categories} WHERE title={$title} ";

        $category = $SystemDB->getQueryResultSingleRow($sql);
        return ($category !== NULL) ? $category[$this->field_category_id] : NULL;
    }

    /**
     * Returns an array of error list if there's an error during save category
     * @param array $datavalues
     * @return array
     */
    public function onGetAdminValidationErrorListBeforeSaveCategory($datavalues) {
        $error_list = parent::onGetAdminValidationErrorListBeforeSaveCategory($datavalues);
        $existing_id = $this->getExistingMenuCategoryIDWithName($datavalues['title']);
        if ($existing_id > 0)
        {
            if ( ($datavalues[$this->field_id] == 'new') )
            {
                $error_list[] = sprintf(___('Cannot create a new category with the name %s since it already exists'),___h($datavalues['title'])); 
            } else
            {
                $this_block_category_id = (int) $datavalues[$this->field_category_id];
                if ($this_block_category_id != $existing_id)
                {
                    $error_list[] = sprintf(___('Cannot rename menu category to [%s] as there is already an existing menu category with the same name'),___h($datavalues['title'])); 
                }
            }
        }
        return $error_list;
    }
    
    //_________________________________________________________________________//
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;

        $start = (int) $start;
        $end = (int) $end;
        $id = (int) $id;
        $category_sortby = '';
        $item_sortby = '';
        if ($start > $end)
            return ajax_reply(400, 'Invalid Request');
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $total_item_count = $this->app->getTotalItemCountByCategoryID($id, false);
        $total_category_count = $this->app->getTotalCategoryCount();
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $normalized_category_fields = implode(',', quote_array_of_field_names_for_query($this->getCategoryFieldNamesForAjaxListing()));

        $result_array_directories = [];
        $result_array_files = [];
        $category_start = $start;
        // directory always at the top
        if ($id == 0) {  // just get the categories
            $result_array = $this->app->getAllCategories($normalized_category_fields, '', $start, $end, $this->field_category_id, $sortdirection);
            $result_array_items = $this->app->getMenuArrayByCategoryID($id, false, $normalized_item_fields);
            if ($result_array_items)
                $result_array = array_merge($result_array, $result_array_items);
            $result_array = $this->setPreviewLinkForCategoryListingResult($result_array);
        }
        else {
            /*$result_array = $this->app->getAllItems($normalized_item_fields, "category_id = {$id}", $start, $end, $sortby, $sortdirection, false);
            $result_array = $this->setPreviewLinkForItemListingResult($result_array);*/
            $result_array = $this->app->getMenuArrayByCategoryID($id, false, $normalized_item_fields);
            $result_array = $this->modifyAjaxGetAllItemsResult($result_array);
        }
        if ($id == 0)
            $total_count = $total_category_count;
        else
            $total_count = $total_item_count;
        return ajax_datasource_reply(200, $result_array, $start, $end, $items_per_page, $total_count, $sortby, $sortdirection);
    } 
    
    public function modifyAjaxGetAllItemsResult($result) {
        
        $result = parent::modifyAjaxGetAllItemsResult($result);
        $count = ___c($result);
        for ($i = 0; $i < $count; $i++ )
        {
            if ($result[$i]['id'] > 0)
            {
                $result[$i]['edit_link'] = $this->createFriendlyAdminURL("action=edititem&id={$result[$i]['id']}"); 
            }
        }
        return $result;
    }
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        $response_schema[] = array('key' => 'cid', 'parser' => 'number');
        return $response_schema;
    } 

    //_________________________________________________________________________//
    public function loadApplicationJavascript()
    {
        parent::loadApplicationJavascript();
        $this->CSS('menus.css'); 
    }

    /**
     * Modify data before save item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {

        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);

        /*if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']);*/

        return $datavalues;
    }
//_________________________________________________________________________//

    protected function getMenuItemParentCategoryForMenuItemSelection($appname, $item_or_cat_id)
    {
        if (!in_array($appname,$this->reserved_menu_types))
        {
        //if ($appname != 'external_link' && $appname != 'home') {
            $class_name = '\\App\\'.$appname;
            $temp_app = new $class_name;
            $current_id = substr($item_or_cat_id, 1); // e.g: c1, i1
            if (strpos($item_or_cat_id, 'c') !== false) {
                if (method_exists($temp_app, 'getCategoryByID')) {
                    $temp_cat = $temp_app->getCategoryByID($current_id);
                    $parent_id = $temp_cat['parent_id'];
                }
            }
            else if (strpos($item_or_cat_id, 'i') !== false) {
                if (method_exists($temp_app, 'getItemByID')) {
                    $temp_item = $temp_app->getItemByID($current_id);
                    $parent_id = $temp_item['category_id'];
                }
            }
            return $parent_id;
        }
    }

    //_________________________________________________________________________//
    /**
     * Get the list of frontend subtemplates
     *
     * @return array of subtemplates
     */
    protected function getListOfFrontendSubtemplates()
    {
        $templates = new \App\Core_ThemeManager_Admin();
        $subtemplates = $templates->getListOfSubtemplatesInCurrentDefaultTheme();
        $array_subtemplates = [];
        if ($subtemplates)
            
            foreach ($subtemplates as $subtemplate)
            {
                $array_subtemplates[] = array('label' => ($subtemplate === 'index' ? ___('Default Template (index)') : $subtemplate), 'value' => $subtemplate);
            }
        return $array_subtemplates;
    }

    //_________________________________________________________________________//
    protected function getDefaultFrontendThemeID()
    {
        
        $templates = new Core_ThemeManager();
        $id = $templates->getDefaultFrontendThemeID();
        return $templates->getItemByID($id);
    }

//_________________________________________________________________________//
    public function SortMenus($parent_id)
    {
        global $SystemDB;

        // Step 1 - determine which menu block this thing belongs to
        $current_cat_id = $this->getCurrentCategoryIDFromCookie();
        if ($current_cat_id == 0)
            return false;


        $sql = "SELECT {$this->field_id},sort_order FROM {$this->table_items} where category_id = {$current_cat_id} and parent_id = {$parent_id} order by parent_id, sort_order";
        $menu_items = $SystemDB->getQueryResultArray($sql);

        $max_menu_items = sizeof($menu_items);
        for ($i = 0; $i < $max_menu_items; $i++)
        {
            $current_id = $menu_items[$i]['id'];
            $new_sort_order = $i * 2;
            $sql = "UPDATE {$this->table_items} SET sort_order = {$new_sort_order} WHERE id = {$current_id}";
            $SystemDB->query($sql);
        }

//		OLD CODE - don't delete - maybe useful again in different case
        /* 	$sql = "SELECT DISTINCT parent_id from {$this->table_items} order by parent_id";
          $SystemDB->query($sql);
          $array_parent_ids  = $SystemDB->get_result_as_array();
          foreach ($array_parent_ids as $parent_id) $parent_ids[] = $parent_id['parent_id'];
          // parents : 0, 3, 5, etc...
         */
        //echo 'Sorting '.$catid;
        /*
          $current_parent_id = intval($catid);
          $sql = "SELECT id,sort_order FROM {$this->table_items} where category_id = {$catid} and parent_id = {$current_parent_id}";
          $SystemDB->query($sql);
          $categories  = $SystemDB->get_result_as_array();
          $i=0;
          $maxcat = sizeof($categories);
          for ($i = 1; $i <= $maxcat; $i++)
          {
          $current_id = $categories[$i-1]['id'];
          $specified_sort_order = $_POST['sort_c'.$current_id];
          $categories[$i-1]['specified'] = $specified_sort_order;
          }

          foreach ($categories as $key => $row) {
          $cat_id[$key]  = $row['id'];
          $cat_sort_order[$key] = $row['sort_order'];
          $cat_specified[$key] = $row['specified'];
          }
          if ($cat_specified)
          array_multisort ($cat_specified, SORT_NUMERIC, SORT_ASC, $cat_id, SORT_NUMERIC, SORT_ASC, $cat_sort_order, SORT_NUMERIC, SORT_ASC);

          // Done, sort by the specified sort order, but set the sort order to the sort ordering instead of the number specified
          for ($i = 0; $i < $maxcat; $i++)
          {
          $sortnumber = $i+1;
          if ($cat_sort_order[$i] != $sortnumber)
          {
          $sql = "UPDATE {$this->table_items} SET sort_order={$sortnumber} WHERE id = {$cat_id[$i]}";
          $SystemDB->query($sql);
          }
          } */
    }

    //_________________________________________________________________________//
    protected function getMultipleItemParentIDs($cat_id)
    {
        global $SystemDB;
        $current_id = $cat_id;
        $last_id = -1;

        while ($last_id != 0)
        {
            $sql = "SELECT parent_id FROM {$this->table_items} where id = '{$current_id}'";

            $id_r = $SystemDB->getQueryResultArray($sql);
            $last_id = $id_r [0]['parent_id'];
            $all_parent_id [] = $last_id;
            $current_id = $last_id;
        }
        return $all_parent_id;
    }

//_________________________________________________________________________//
    protected function setAllChildrenCategory($parentid, $new_category_id)
    {
        global $SystemDB;

        $sql = "SELECT * FROM {$this->table_items} where parent_id = {$parentid}";
        $children = $SystemDB->getQueryResultArray($sql);
        if ($children) {
            foreach ($children as $child)
            {
                $sql = "UPDATE {$this->table_items} SET category_id = {$new_category_id} where id = '{$child['id']}'";
                $SystemDB->query($sql);
                $this->setAllChildrenCategory($child['id'], $new_category_id);
            }
        }
    }
    //_________________________________________________________________________//
    private function getAppChoicesInFolder($app_path)
    {
        $forbidden_listing = ['.', '..', 'admin'];

        $app_array = [];
        $dir_handle = @opendir($app_path);
        $i = 0;
        $app_manager = new \App\Core_ApplicationManager();
        while ($file = readdir($dir_handle))
        {
            if (!in_array($file, $forbidden_listing) && file_exists($app_path . $file . '/' . $file . '.class.php') && file_exists($app_path . $file . '/' . $file . '.admin.class.php')) {
                
                try 
                {
                    $class_name = '\\App\\'.$file.'_Admin';
                    $temp_admin_app = new $class_name;
                    $menu_info = $temp_admin_app->getMenuInfo();

                    if (is_array($menu_info['public_methods']) && ___c($menu_info['public_methods']) > 0 && !$temp_admin_app->frontendApp()->isFrontendRuntimeDisabled())
                    {
                        $app_desc = $temp_admin_app->frontendApp()->getOriginalApplicationDescription(); 
                        if (empty($app_desc))
                            $app_desc = ucwords($file).'*';
                        $app_array[] = array('value' => $file, 'label' =>  $app_desc);
                        if ($file == 'html')
                            $app_array[$i]['label'] = ___('Web Pages');
                        $app_array[$i]['icon'] = \App\Core_ApplicationManager::getApplicationIcon($file);
                        $i++;
                    }
                    $sub_apps = $app_manager->getAllSubApplications($file);
                    if ($sub_apps)
                    {
                        foreach ($sub_apps as $sub_app)
                        {
                            $sub_app_prefix = $app_path . $file . '/' . $sub_app.'/'.$file.'.'.$sub_app;
                            if (!in_array($file, $forbidden_listing) && file_exists($sub_app_prefix . '.class.php') && file_exists($sub_app_prefix . '.admin.class.php')) 
                            {

                                $sub_class_name = '\\App\\'.$file.'_'.$sub_app.'_Admin';
                                $tmp_sub_class = new $sub_class_name;
                                $menu_info = $tmp_sub_class->getMenuInfo();

                                if (is_array($menu_info['public_methods']) && ___c($menu_info['public_methods']) > 0 && !$tmp_sub_class->frontendApp()->isFrontendRuntimeDisabled())
                                {

                                    $sub_app_desc = $tmp_sub_class->frontendApp()->getOriginalApplicationDescription(); 
                                    if (empty($sub_app_desc))
                                        $sub_app_desc = ucwords($file).'*';
                                    $app_array[] = ['value' => $file.'.'.$sub_app, 'label' =>  ' - '.$sub_app_desc];
                                    $i++;
                                }
                            }



                        }
                }
                } catch (\Exception $exc)
                {
                    
                }
                $temp_admin_app = null;
            }
        }

        closedir($dir_handle);
        return $app_array;    
        
    }
    //_________________________________________________________________________//
    public function getApplicationChoices()
    { // mixed item = categories + items but doesn't apply in this case

        $app_array = [];
        
        $app_array[] = ['value' => 'home', 'label' => ___('Home')];
        
        $sys_app_array = $this->getAppChoicesInFolder(SCHLIX_SYSTEM_PATH . '/apps/');
        $user_app_array = $this->getAppChoicesInFolder(SCHLIX_SITE_PATH. '/apps/');
        
        if (is_array($sys_app_array))
            $app_array = array_merge($app_array,$sys_app_array);
        
        if (is_array($user_app_array))
            $app_array = array_merge($app_array,$user_app_array);
        
        $app_array[] = ['value' => '--', 'label' => '--'];
        $app_array[] = ['value' => 'external_link', 'label' => ___('External Link')];
        $app_array[] = ['value' => 'menu_placeholder', 'label' => ___('Placeholder for Submenu')];
        $app_array[] = ['value' => 'menu_divider', 'label' => ___('Menu Divider')];
        return $app_array;
    }

    //_________________________________________________________________________//
    public function drawApplicationChoices($answer)
    {
        $question = $this->getApplicationChoices();
        //
        $inputname = 'application';
        $total_count = ___c($question);
        $str = '';
        for ($i = 0; $i < $total_count; $i++)
        {
            if ($question[$i]['value'] == '--')
            {
                $str.= \__HTML::HR();
            } else
            {
                $checked = ( ($answer) && ($answer == $question[$i]['value']));
                $attr = [
                    'class' => 'schlix-menu-item-choice',
                    'data-app-target' => $question[$i]['value'],
                    'id' => "schlix-app-choice-{$question[$i]['value']}",
                    'required' => "required",

                    ];
                if ($i == 0)
                    $attr['title'] = ___('Please select an application');
                $checkbox = \INPUT::RADIO($inputname, $question[$i]['value'], $checked, $attr);
                /////
                $img = array_key_exists('icon', $question[$i]) ? \__HTML::IMG($question[$i]['icon'], ['class' => 'app-icon-menu-select', 'alt' => $question[$i]['value']]) : '';
                $str .= \__HTML::DIV_start(['class' => 'radio']);
                $str .= \__HTML::LABEL($img.' '.$question[$i]['label'], $checkbox, false);
                $str .= \__HTML::DIV_end();
            }
        }
        return $str;
    }

    //_________________________________________________________________________//
    public function ajaxMoveObjects($mixed_items_to_move, $destination)
    {  
        global $SystemDB;
                
        check_csrf_halt_on_error(true);
        if (strpos($mixed_items_to_move, 'i') !== false) {
            $mixed_items_to_move = str_replace('i', 'menu_', $mixed_items_to_move);
        }
        $pos = strrpos($destination, "_");
        $destination_id = (int) substr($destination, $pos + 1, strlen($destination) - $pos);
        $destination_position = substr($destination, 4, $pos - 4);
        //Feb 18, 2012
        if (str_starts_with($destination,'c')) {
            //$strfolderpos = strlen($this->app_name . 'gwp_');
            $destination_id = (int) substr($destination, 1, strlen($destination) -1);
            $destination_position = 'leftfolder';
        }
        if (strpos($mixed_items_to_move, 'folder') > 0) {
            return ajax_reply(400, 'Cannot move menu block');
        }
        else if ($destination_id == 0) {
            return ajax_reply(400, 'Cannot move menu item to a non-existing menu block');
        }
        {
            $mixed_items_array = explode(',', $mixed_items_to_move);
            foreach ($mixed_items_array as $mixed_item)
            {
                $item = $mixed_item;
                $pos = strrpos($item, "_");
                $source_id = substr($item, $pos + 1, strlen($item) - $pos);
                $source_itemnumbers[] = (int) $source_id;
            } // end foreach
        } //endif
        $error = false;
        $parent_id_array = $this->getMultipleItemParentIDs($destination_id);
        foreach ($source_itemnumbers as $source_id)
            if (in_array($source_id, $parent_id_array))
                $error = true;

        if (!$error) {
            $source_itemstrs = implode(",", $source_itemnumbers);
            $destination_item = $this->app->getItemByID($destination_id);
            //echo "moving {$source_itemstrs} to *{$destination_position}* of {$destination_id}";
            switch ($destination_position)
            {
                case 'top': $prev_sort_order = $destination_item['sort_order'] - 1;
                    $sql = "UPDATE  {$this->table_items} SET parent_id = '{$destination_item['parent_id']}',sort_order = {$prev_sort_order} WHERE id IN  ({$source_itemstrs})";
                    break;
                case 'bottom': $next_sort_order = $destination_item['sort_order'] + 1;
                    $sql = "UPDATE  {$this->table_items} SET parent_id = '{$destination_item['parent_id']}',sort_order = {$next_sort_order} WHERE id IN  ({$source_itemstrs})";
                    break;
                case 'leftfolder': 
                    
                    $sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_id}', parent_id = 0 WHERE id IN  ({$source_itemstrs})";
                    foreach ($source_itemnumbers as $source_id)
                        $this->setAllChildrenCategory($source_id, $destination_id);
                    break;
                case 'next':
                default:
                    if (array_search($destination_id, $source_itemnumbers, true))
                        return false;
                    $sql = "UPDATE  {$this->table_items} SET parent_id = '{$destination_id}' WHERE id IN ({$source_itemstrs}) AND {$destination_id} NOT IN ({$source_itemstrs})";
                    $this->SortMenus($destination_item['id']);
                    break;
            }
            $SystemDB->query($sql);
            $this->SortMenus($destination_item['parent_id']);
            return ajax_reply(200, 'OK');
        }
        else
            return ajax_reply(400, 'Your move operation request cannot be completed');
    }

    public function duplicateItem($source_item_id, $destination_catnumber)
    {
        global $SystemDB;

        //echo "Copy $source_item_id to $destination_catnumber\n";
        $item = $this->app->getItemByID($source_item_id);
        unset($item['id']);
        $item['category_id'] = $destination_catnumber;
        $item['title'].= '_copy';
        $item['parent_id'] = 0; // Dec 10, 2011 - reset to 0 and let the user reorder - if it's not set to zero, sub-items won't appear
        $SystemDB->simpleInsertInto($this->table_items, $item);        
    }
                
//_________________________________________________________________________//
    public function refreshMenuLinks()
    {
        $this->app->refreshAllMenuLinks(true);
    }

//_________________________________________________________________________//
    public function ajaxGetMenuBlocks()
    {
        global $SystemDB;
        $sql = "SELECT * FROM {$this->table_categories} order by sort_order, cid";
        $blocks = $SystemDB->getQueryResultArray($sql);
        return ajax_reply(200, $blocks);
    }

//_________________________________________________________________________//

    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'getmenublocks': 
                return ajax_echo($this->ajaxGetMenuBlocks());
                break;
            default: return parent::Run();
        }
    }

}
            