/**
 * Core: ThemeManager - Javascript admin controller class
 * 
 * Core - ThemeManager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

var __zip_assigned = 0;

SCHLIX.CMS.ThemesAdmin = class extends SCHLIX.CMS.BaseController  {  
    
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.thememanager");
        this.is_admin = 0;
    };


    static formatDataTableCell_OptionBoxDesktopTemplate (elCell, oRecord, oColumn, oData) {
        var is_admin = oRecord.getData("is_admin") ;
        var prefix = is_admin ? 'backend' : 'frontend';
        elCell.innerHTML = '<div align="center"><input type="radio" id="default_' + prefix + '_' + oRecord.getData("id") + '" name="default_' + prefix + '_theme" ' +
                ' value="' + oRecord.getData("id") + '" class="theme_radio_option" data-mode="' + prefix + '" /></div>';
    };

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn (elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        if (oData === undefined)
        {
            elCell.innerHTML = "Invalid column!";
            return;
        }
        //  alert(this.parentControl.getTableFieldNameByRole('title'));
        var itemTitle = oData;// oRecord.getData("title");
        var itemLink = '';
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;

        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        if (itemTitle == '')
            itemTitle = '(Untitled)';
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
        var icon = "<i class =\"fas fa-tv fa-2x\"></i>";
        if (itemTitle)
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);        
        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        itemLink = this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        elCell.innerHTML = '<a class="open-viewlog" id="' + app_name + "-lnk-" + theValue + '" data-log-id="' + theValue + '" href="javascript:void(0)" data-log-message="' + oData + '">' + " " + icon + " " + itemTitle + '</a>';

    };

///////////////////////////////////////////////////////////
    onDOMReady ()
    {
        
        //this.getDefaultThemeListing();
        SCHLIX.Event.delegate('schlix-core-thememanager-admin', 'click', this.setDefaultTheme, 'input.theme_radio_option', this, true);                
        if (__zip_assigned !== 1)
        {
            __zip_assigned = 1;
            SCHLIX.Event.on('zipfileupload', 'change', this.previewFile, this, true);
        }        
    }; // end func

    ////////////////////////////////////////////////////////////
    
    previewFile ()
    {
        var file_input = document.getElementById('zipfileupload');
        var file_info = file_input.files[0];
        var file_name_placeholder = document.getElementById('zip_filename');
        var file_size_placeholder = document.getElementById('__file_size');
        var file_size_display=  document.getElementById('zip_filesize');
        
        file_size_placeholder.value = file_info.size;
        file_name_placeholder.innerHTML = '<i class="far fa-file-archive"></i> ' + file_info.name;
        
        var max_file_size = parseInt(document.getElementById('__max_file_size').value, 10);
        if (file_info.size > max_file_size)
        {
            var max_file_size_formatted = this.formatFileSize(max_file_size);
            SCHLIX.Alert.warning('File upload will fail since the file is larger than the maximum upload size on this server (' +max_file_size_formatted + ')');
        }
        
        file_size_display.innerHTML = '<strong>File size</strong>: ' + format_file_size(file_info.size);
    }; // end func 
    
    getDefaultThemeListing()
    {
        var action = (this.is_admin ? 'getdefaultbackendtheme' : 'getdefaultfrontendtheme');
        var request = SCHLIX.Ajax.GET( site_httpbase + "/admin/app/" + this.app_name + "?action=" + action, 
            {success: this.onReceiveDefaultTheme, failure: this.handleFailure, scope: this}
            );
        
    }; // end func
    
    reportSetDefaultTheme (o)
    {
        var which_one = (this.is_admin ? 'backend' : 'frontend' );
        var response = ajax_parse(o.responseText);
        if (response === false)
            SCHLIX.Alert.error('Cannot set default theme with the specified parameter');
        else
        {
           this.cms_control.refreshControls();
            SCHLIX.Alert.info('Default ' +  which_one+ ' theme has been changed');
        }
        // nothing
    }; // end func    
///////////////////////////////////////////////////////////
    setDefaultTheme (e)
    {
        var value = e.target.value;
        //var mode = e.target.getAttribute('data-mode');
        
        //var action = (this.is_admin ? 'setdefaultbackend' : 'setdefaultfrontend');
        
        var mode = this.is_admin ? 'backend' : 'frontend';
        
        var postData = '_csrftoken=' + _csrftoken + '&mode=' + mode + '&id=' + value;
        
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=setdefault", 
            {success: this.reportSetDefaultTheme, failure: this.handleFailure, scope: this}, postData
            );
        
    }; // end func
///////////////////////////////////////////////////////////
    onReceiveDefaultTheme (o)
    {
        
        var tmpl = ajax_parse(o.responseText);
        var prefix = this.is_admin ? 'backend' : 'frontend';
        
        var set_default_theme_fn = function()
        {
            var theme_frontend = document.getElementById('default_frontend_' + tmpl['default']);
            var theme_backend = document.getElementById('default_backend_' + tmpl['default']);
            if (theme_frontend !== null)
                theme_frontend.checked = true;
            if (theme_backend !== null)
                theme_backend.checked = true;
        };
        console.log('default_' + prefix +  '_' + tmpl['default']);
        SCHLIX.Event.onContentReady('default_' + prefix +  '_' + tmpl['default'],set_default_theme_fn);
        
    };  
    /**
     * Show the installer window
     */
    showInstallerWindow ()
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
        obj.show();
    }; // end func
    /**
     * Run command
     * @param {type} command
     * @returns {unresolved}
     */
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'datatable-refreshed':
                this.getDefaultThemeListing();
                return false;
                break;
            case 'reset-backend-theme':
                this.resetDefaultBackendTheme();
                break;
            case 'install':
                this.showInstallerWindow();
                break;
            case 'form-submit-ok':
                this.cms_control.refreshControls();
                break;
                
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};


/**
 * For backend
 */
SCHLIX.CMS.BackendThemesAdmin = class extends SCHLIX.CMS.ThemesAdmin  {  
    
    constructor()
    {
        super();
        this.is_admin = 1;
        
    }
  
///////////////////////////////////////////////////////////
    onDOMReady ()
    {
        
        //this.getDefaultThemeListing();
        SCHLIX.Event.delegate('schlix-backendthemes-admin', 'click', this.setDefaultTheme, 'input.theme_radio_option', this, true);                
    }; // end func
    
    
    resetDefaultBackendTheme()
    {
        if (confirm('Are you sure you want to reset the default admin theme?'))
        {
            var postData = '_csrftoken=' + _csrftoken + '&set=1';        
            var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=resetdefaultbackend", 
                {success: this.reportSetDefaultTheme, failure: this.handleFailure, scope: this}, postData
                );
            
        }
    }
    
    /**
     * Run command
     * @param {type} command
     * @returns {unresolved}
     */
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'reset-backend-theme':
                this.resetDefaultBackendTheme();
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
    
};