<?php
/**
 * Gallery - Config
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die('No Access');

    $watermark_files = [];
    $watermark_dir = $this->app->getDataDirectoryFullPath('watermark');
    $watermark_url = $this->app->getDataDirectoryURLPath('watermark');
    $watermark_iterator = new \GlobIterator($watermark_dir.'/*.png', \FilesystemIterator::KEY_AS_FILENAME);
    foreach ($watermark_iterator as $it) {
        $watermark_files[] = $it->getBasename(); //pathinfo($it->getBasename(), PATHINFO_FILENAME);
    }
    
    $watermark_pos = [
        ___('Centre') => WM_POSITION_CENTER,
        ___('Left') => WM_POSITION_LEFT,
        ___('Right') => WM_POSITION_RIGHT,        
        
        ___('Top Centre') => WM_POSITION_TOP,
        ___('Top Left') => WM_POSITION_TOP_LEFT,
        ___('Top Right') => WM_POSITION_TOP_RIGHT,
        
        ___('Bottom Centre') => WM_POSITION_BOTTOM,
        ___('Bottom Left') => WM_POSITION_BOTTOM_LEFT,
        ___('Bottom Right') => WM_POSITION_BOTTOM_RIGHT,        
        
        ];
    $image_sizes = $this->app->getImageSizeNames();
    $default_sizes = $this->app->getDefaultSizes();
    
?>
<!-- {top_menu} -->

<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.GalleryAdminController">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />


        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                <!--content -->
                <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                <schlix-config:app_description   />
                <schlix-config:checkbox config-key="bool_disable_app" label="<?=  ___('Disable application') ?>" />
                <!--config --> 
                

                <x-ui:row>
                    <?php foreach ($image_sizes as $size): ?>
                    <?php $ds = $default_sizes[$size]; ?>
                        <x-ui:column sm="6" >
                                     <fieldset  class="form-inline"><legend><?= ucwords($size) . ' ' . ___('Image Dimension (pixels)') ?></legend>
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon><?= ___('Width') ?></x-ui:input-group-addon>                                        
                                        <schlix-config:integerbox min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>"  config-key="int_<?= $size ?>_width" config-default-value="<?= $ds['width'] ?>" required="required" placeholder="<?= ___('Width') ?>"/>                            
                                    </x-ui:input-group>
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon><?= ___('Height') ?></x-ui:input-group-addon>
                                        <schlix-config:integerbox min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>"  config-key="int_<?= $size ?>_height" config-default-value="<?= $ds['height'] ?>" required="required" placeholder="<?= ___('Height') ?>" />
                                    </x-ui:input-group>
                                    <?= ___('pixels') ?>.   
                                     </fieldset>
                                
                                <schlix-config:integerbox min="10" max="100" label="<?= ___('Quality') ?>"  config-key="int_<?= $size ?>_quality" required="required" config-default-value="<?= $ds['quality'] ?>" />                                    
                                <schlix-config:checkbox config-key="bool_use_watermark_<?= $size ?>" label="<?=  ___('Use watermark') ?>" />
                                <schlix-config:dropdownlist config-key="str_watermark_image_<?= $size ?>" label="<?= sprintf(___('Watermark image (%s)'), $size) ?>" >
                                    <schlix-config:option value="0"><?= ___('Please select') ?></schlix-config:option>
                                    <?php foreach ($watermark_files as $wm): ?>
                                        <schlix-config:option value="<?= ___h($wm) ?>"><?= ___h($wm) ?></schlix-config:option>
                                    <?php endforeach ?>
                                </schlix-config:dropdownlist>   
                                <schlix-config:dropdownlist config-key="str_watermark_pos_<?= $size ?>" label="<?= ___('Watermark position') ?>" >
                                    <schlix-config:option value="0"><?= ___('Please select') ?></schlix-config:option>
                                    <?php foreach ($watermark_pos as $label => $value): ?>
                                        <schlix-config:option value="<?= ___h($value) ?>"><?= ___h($label) ?></schlix-config:option>
                                    <?php endforeach ?>
                                </schlix-config:dropdownlist>                             

                                
                                <!-- margin -->
                                <strong class="control-label"><?= ___('Watermark margins') ?></strong>
                                <x-ui:form-group class="form-inline">
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon>X</x-ui:input-group-addon>                                        
                                        <schlix-config:integerbox config-key='int_<?= $size ?>_wm_margin_x' config-default-value="0" />                            
                                    </x-ui:input-group>
                                    <x-ui:input-group>
                                        <x-ui:input-group-addon>Y</x-ui:input-group-addon>
                                        <schlix-config:integerbox config-key='int_<?= $size ?>_wm_margin_y' config-default-value="0" />
                                    </x-ui:input-group>
                                    <?= ___('pixels') ?>.                            
                                </x-ui:form-group>
                                <!-- end margin -->
                                
                                
                        </x-ui:column>
                    <?php endforeach ?>
                </x-ui:row>
                <hr />
<x-ui:alert type="info">
    
    <ul class="list-unstyled">
        <li><i class="fa fa-info-circle"></i> <?= sprintf(___('If you wish to upload a large file that is beyond this server maximum upload size of %dM, you can upload them via FTP or SSH to %s'), round(get_real_max_upload_size()/(1024*1024)), $this->app->getDataDirectoryFullPath('image_original') ) ?></li>
        <li><i class="fa fa-info-circle"></i> <?= sprintf(___('Watermark files should be uploaded to the following directory: %s'), $watermark_dir) ?></li>
    </ul>
</x-ui:alert>
                                               

                 
                <!-- Example Ends -->
            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_main_opt" fonticon="fa fa-newspaper" label="<?= ___('Default Main page Options') ?>"> 
                <!-- main page -->
                <x-ui:row>
                    <x-ui:column md="6">
                        <schlix-config:textbox config-key="str_mainpage_title" label="<?=  ___('Main page title') ?>"   />                        
                        <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Main page introduction text') ?>" class="wysiwyg" />

                <schlix-config:textbox config-key="str_meta_keywords" label="<?=  ___('Meta Keywords') ?>" />
                <schlix-config:textbox config-key="str_meta_description" label="<?=  ___('Meta Description') ?>" />
                        
                    </x-ui:column>
                    <!-- col -->
                    <x-ui:column md="6">
                        <schlix-config:integerbox config-key="int_mainpage_items_per_page" config-default-value="10" label="<?=  ___('Default maximum number of items to be displayed per page') ?>"   />
                        <schlix-config:main-page-meta-options config-key="array_mainpage_meta_options" item-per-column="5" column-count="1" />
                    </x-ui:column>
                </x-ui:row>

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_category_opt" fonticon="fas fa-folder" label="<?= ___('Default Category Options') ?>"> 

                <schlix-config:integerbox config-key="int_category_items_per_page" config-default-value="10" label="<?=  ___('Default maximum number of items to be displayed per page') ?>"   />
                <schlix-config:checkbox config-key="reset_category_items_per_page" label="<?=  ___('Reset the number of items per page for all categories') ?>" />
                <schlix-config:category-meta-options config-key="array_default_category_meta_options"  item-per-column="1" column-count="3" />
                <schlix-config:checkbox config-key="reset_category_options" label="<?=  ___('Reset all categories options') ?>" />
            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_item_opt" fonticon="fa fa-file-alt" label="<?= ___('Default Item Options') ?>"> 


                <schlix-config:item-meta-options config-key="array_default_item_meta_options" item-per-column="1" column-count="3" />
                <schlix-config:checkbox config-key="reset_item_options" label="<?=  ___('Reset all item options') ?>" />
            </x-ui:schlix-tab>
            <!-- hooks -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>                       
        </x-ui:schlix-tab-container>
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
