<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
?>
<?php global $SystemConfig, $CurrentUser; ?>

<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.HtmlAdmin">

<!-- end sidebar -->
        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                    <!--content -->
                    <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                    <schlix-config:app_description   />
                    <schlix-config:checkbox config-key="bool_disable_app" label="<?= ___('Disable application (for maintenance or any other reasons)') ?>" />                    
                    <p><em><?= ___('Note: It is recommended that you leave HTML (Web Pages) application unless you are only using Landing Pages application') ?></em></p>
                    <schlix-config:textbox config-key="str_meta_keywords" label="<?= ___('Default Meta Keywords') ?>"   config-fonticon="fa fa-hashtag" />
                    <schlix-config:textbox config-key="str_meta_description" label="<?= ___('Default Meta Description') ?>"   config-fonticon="fa fa-hashtag" />
                    <schlix-config:checkbox config-key="bool_convert_external_images" label="<?=  ___('Fetch external images and save it to your web server') ?>" />
                    <schlix-config:checkbox config-key="bool_enable_pageview_stats" label="<?=  ___('Enable page impression stats') ?>" />                    
                    <!-- end content -->
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_category_opt" fonticon="fas fa-folder" label="<?= ___('Default Category Options') ?>"> 
                    <!--content -->
                    <schlix-config:integerbox config-key="int_category_items_per_page" config-default-value="10" label="<?= ___('Default maximum number of items to be displayed per page') ?>"   />
                    <schlix-config:checkbox config-key="reset_category_items_per_page" label="<?=  ___('Reset the number of items per page for all categories') ?>" />                    
                    <schlix-config:category-meta-options config-key="array_default_category_meta_options"  item-per-column="1" column-count="3" />
                    <schlix-config:checkbox config-key="reset_category_options" label="<?=  ___('Reset all categories options') ?>" />
                    <!-- end content -->
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_item_opt" fonticon="fa fa-file-alt" label="<?= ___('Default Item Options') ?>"> 
                    <!--content -->
                   <schlix-config:item-meta-options config-key="array_default_item_meta_options" item-per-column="1" column-count="3" />             
                   <schlix-config:checkbox config-key="reset_item_options" label="<?=  ___('Reset all item options') ?>" />
                    <!-- end content -->
                </x-ui:schlix-tab>
                <!-- tab -->      
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
