<?php
namespace App;
/**
 * Landing Pages - Main Class
 * 
 * 
 * 
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *

 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Landing extends \SCHLIX\cmsApplication_CategorizedList {

    public function __construct() {
        parent::__construct(___('Landing Pages'), 'gk_landing_items', 'gk_landing_categories');
        $this->schema_org_type_item = '';
        $this->has_versioning = true;
        // For this class only
        $this->disable_app_description_in_page_title = ($this->app_name == 'html');        
    }

    
    /**
     * View Main Page
     * @param int $pg
     */
    public function viewMainPage($pg = 1)
    {        
        $default_category_id = $this->getDefaultCategoryID();
        $main_category = $this->getCategoryByID($default_category_id);
        if ($main_category)
            $this->viewCategoryByID($default_category_id);
        else
            echo ___('No page collection has been defined');

    } 
//_______________________________________________________________________________________________________________//
    public function getFullPathByCategoryID($cat_id)
    {
        global $SystemDB;

        $current_id = intval($cat_id);
        $path = '';
        $sql = "SELECT virtual_filename FROM {$this->table_categories} where {$this->field_category_id} = '{$current_id}'";
        $id_r = $SystemDB->getQueryResultSingleRow($sql);
        $dirname = isset($id_r['virtual_filename']) ? $id_r['virtual_filename'] : '';
        $path = $dirname . '.html' . $path;

        return '/' . $path;
    }
    //_______________________________________________________________________________________________________________//
    public function getFullPathByItemID($item_id)
    {
        global $SystemDB, $CurrentFrontendApplication;

        $item_id = intval($item_id);
        $sql = "SELECT virtual_filename, category_id FROM {$this->table_items} where {$this->field_id} = '{$item_id}'";
        $item = $SystemDB->getQueryResultSingleRow($sql, true);
        if (!$item)
            return false;
        $category_path = $this->getFullPathByCategoryID($item[$this->field_item_category_id]);
        $item_path = $item['virtual_filename'];
    
        $is_main_app_and_home = ($CurrentFrontendApplication == 'landing') && ($item['category_id'] == 1);
        
        return $is_main_app_and_home ? '#'.encode_url($item_path) :  encode_url(remove_multiple_slashes($category_path)).'#'.encode_url($item_path);
    }
    /*
    public function getItemOrCategoryToViewFromFullVirtualFilename($url, $enable_redirect_no_trailingslash_folder = false)
    {
        $path_parts = pathinfo($url);
        if ($path_parts['extension'] == 'html')
        {
            $url = $path_parts['filename'];
            
            return parent::getItemOrCategoryToViewFromFullVirtualFilename($url, false);
        } else 
        {
            return parent::getItemOrCategoryToViewFromFullVirtualFilename($url, $enable_redirect_no_trailingslash_folder);
        }

    }*/
    
    public function getItemOrCategoryToViewFromFullVirtualFilename($url, $enable_redirect_no_trailingslash_folder = false)
    {        
        define('SLASH_INDEX_DOT_HTML_LENGTH', 10); // '/index.html'
        $url = rawurldecode($url);
        $url_array = explode('/', $url);
//		DEBUG_ARRAY($url_array);
        $command = [];
        $folder_requestpage = 0;
        $found = false;
        $filetype = ''; // category = c, item = i
        $depth = ___c($url_array);
        $url_length = strlen($url);
        $request_filename = pathinfo($url, PATHINFO_BASENAME);
        $file_path_info = null;
        if ($request_filename)
            $file_path_info = pathinfo($request_filename);
        if (empty($url) || $url == 'index.html') {
            $command['action'] = 'main';
            return $command;
        }
        // Step 0 - Reset - clean up possible directory view mode with "/index.html"
        // possible /html/folder1/folder2 (but no trailing slash)
        if ( $file_path_info['extension'] == 'html' ) {

            $existing_category = $this->getCategoriesByVirtualFilename($file_path_info['filename']);

            if ($existing_category) {
                $command['action'] = 'viewcategory';
                $command['cid'] = $existing_category[0]['cid'];

                return $command;                
            }
            else 
            {
                return array('action' => '404error');
            }
        } 
        return array('action' => '404error');
    }    
    
    
                
    //_______________________________________________________________________________________________________________//
    /**
     * create SEO friendly URL. Format is action={...}&param1={....}&param2={...}
     * @param string $str
     * @return string
     */    
    public function createFriendlyURL($str)
    {
        /*
          input: index.php?app=html&action=view&id=c1
          input: index.php?app=html&action=view&id=i10
          input: index.php?app=users&action=register

          action=view&id=c5&page=10
          action=checkout
          action=login
         */
        global $CurrentFrontendApplication;
        
        $final_url = '';
        if (SCHLIX_SEF_ENABLED) {
            $app_alias = get_application_alias($this->app_name); // May 24, 2010            
            $command_array = [];
            parse_str($str, $command_array); // replaced with this- May 24, 2010
            $command_action = (array_key_exists('action', $command_array)) ? $command_array['action'] : '';
            switch ($command_action)
            {
                case 'viewcategory':
                    $final_url = encode_url($this->getFullPathByCategoryID($command_array[$this->field_category_id]));
                    $final_url = SCHLIX_SITE_HTTPBASE . '/' . $app_alias . $final_url; // delete - Oct 1, 2010                    break;
                case 'viewitem': 
                    $fpc = isset($command_array[$this->field_id]) ? $command_array[$this->field_id] : null;
                    $final_url = $this->getFullPathByItemID($fpc);
                    $is_main_app_and_home = ($CurrentFrontendApplication == 'landing');
                    $final_url = ($is_main_app_and_home && str_starts_with($final_url,'#'))  ? SCHLIX_SITE_HTTPBASE. '/' .$final_url : SCHLIX_SITE_HTTPBASE . '/' . $app_alias . $final_url; 
                    break;
                default:if (!empty($command_array) && array_key_exists('action', $command_array) && $command_array['action'] != '') {
                        if (array_key_exists('app', $command_array))
                            unset($command_array['app']);
                        foreach ($command_array as $key => $value)
                            $final_url.= "/{$key}/{$value}";
                    }
                    else
                        $final_url = '/'; // For the main app - Feb 4, 2012
                    $final_url = SCHLIX_SITE_HTTPBASE . '/' . $app_alias . $final_url; // delete - Oct 1, 2010
                    
                    break;
            }
        } else {
            parse_str("app={$this->app_name}&{$str}", $command_array);
            $array_keys = array_keys($command_array); // separate it
            foreach ($array_keys as $key)
                if (empty($command_array[$key]))
                    unset($command_array[$key]);
            $final_url = SCHLIX_SITE_HTTPBASE . '/' . "index.php?" . http_build_query($command_array);
        }
        $final_url = remove_multiple_slashes($final_url);
//		echo $final_url;
        return $final_url;
    }

    /**
     * View Page - only $id is used, all other parameters ignored for Brochure
     * @param int $id
     * @param int $pg
     * @param string $sortby
     * @param string $sortdirection
     * @param string $standard_criteria
     * @param bool $from_cache
     */
    public function viewCategoryByID($id = 1, $pg = 1, $sortby = '', $sortdirection = 'ASC', $standard_criteria = 'status > 0', $from_cache = false)
    {   
        $category = $this->getCategoryByID($id, $from_cache);
        
        $category_meta_options = $this->translateMetaOptions($category['options']);
        
        $items = $this->getItemsByCategoryID($id, '*', $standard_criteria, 0, 999, 'sort_order', 'ASC');
        $total_item_count =  ___c($items);
        $str_title = $category['title'];
        $this->setPagetitle($str_title);
            
        if (array_key_exists('meta_description', $category))
            $this->setPageMetaDescription ($category['meta_description']);
        if (array_key_exists('meta_key', $category))
            $this->setPageMetaKeywords ($category['meta_key']);

        $this->processDataOutputWithMacro($category, __FUNCTION__,array('category_meta_options'=>$category_meta_options));        

        $this->increaseCategoryPageView($category[$this->field_category_id]);
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile(($this->view_template_category_file), $local_variables);
    }
    
    //_______________________________________________________________________________________________________________//
    /**
     * View item - do nothing for brochure, only view category
     * @param int $id
     * @param bool $from_cache
     */
    public function viewItemByID($id = 1, $from_cache = false)
    {
        return false; // do nothing for brochure
    }
                
    /**
     * Returns the default category ID 
     * @return int
     */
    public function getDefaultCategoryID() {
        return 1;
    }  

    //_______________________________________________________________________________________________________________//
    /**
     * Returns an array containing on array of main page options. 
     * The values of the options will still be evaluated as a flat list array, 
     * however it is sectioned into array with the following keys:
     * header, value, type, and options.
     * - Label: section title (not used for any evaluation
     * - Type: checkboxgroup, dropdownlist, or none. If none, then it means there 
     *         are suboptions which contain another array of this
     * - Key: the key option. Please note that checkboxgroup doesn't have a key
     *        since the keys are in the options
     * - Options: an array with 2 keys: label and key
     * 
     * @return array
     */    
    
    public function getMainpageMetaOptionKeys() {
        return parent::getMainpageMetaOptionKeys();
    }
    //_______________________________________________________________________________________________________________//
    /**
     * Returns an array containing on array of main page options. In this base
     * class, the key is almost similar to getCategoryMetaOptionKeys
     * The values of the options will still be evaluated as a flat list array, 
     * however it is sectioned into array with the following keys:
     * header, value, type, and options.
     * - Label: section title (not used for any evaluation
     * - Type: checkboxgroup, dropdownlist, or none. If none, then it means there 
     *         are suboptions which contain another array of this
     * - Key: the key option. Please note that checkboxgroup doesn't have a key
     *        since the keys are in the options
     * - Options: an array with 2 keys: label and key
     * 
     * @return array
     */        
    public function getCategoryMetaOptionKeys() {
        return parent::getCategoryMetaOptionKeys();
    }
    
    //_______________________________________________________________________________________________________________//
    /**
     * Returns an array containing on array of item options.
     * The values of the options will still be evaluated as a flat list array, 
     * however it is sectioned into array with the following keys:
     * header, value, type, and options.
     * - Label: section title (not used for any evaluation
     * - Type: checkboxgroup, dropdownlist, or none. If none, then it means there 
     *         are suboptions which contain another array of this
     * - Key: the key option. Please note that checkboxgroup doesn't have a key
     *        since the keys are in the options
     * - Options: an array with 2 keys: label and key
     * 
     * @return array
     */
    public function getItemMetaOptionKeys() {
        return parent::getItemMetaOptionKeys();
    }

    
    /**
     * Run command passed by the main router
     * @param array $command
     * @return bool
     */
    public function Run($command) {
        switch ($command['action']) {
            case 'viewitem':
                $this->viewItemByID($command['id'], $this->cache);
                break;
            case 'viewcategory': $this->viewCategoryByID($command['cid'], $command['pg'], 'date_created', 'DESC', $this->cache);
                break;
            case 'main': $this->viewMainPage($command['pg']);
                break;

            default: return parent::Run($command);
        }

        return RETURN_FULLPAGE;
    }
}