<?php

namespace App;

class Search extends \SCHLIX\cmsApplication_Basic {

    protected $enabled_apps;

    public function __construct() {
        parent::__construct('Search');
        $this->enabled_apps = $this->getConfig('array_enabled_apps');
        
    }
    //_______________________________________________________________________________________________________________//

    public function viewOpenSearchXML()
    {
        header('Content-Type: application/xml; charset=UTF-8');
        $this->loadTemplateFile('opensearch.xml', null);
    }
    //_______________________________________________________________________________________________________________//
    public function viewMainPage() {
        $this->loadTemplateFile('view.main', ['is_mainpage' => true]);
    }
    
    
    public function interpretFriendlyURL($urlpath) {
        if (SCHLIX_SEF_ENABLED && !fget_string('app')) {
            $parsedurl = $this->probeFriendlyURLDestination($urlpath);
            $url = $parsedurl['url'];
            $command = [];
            $url_array = $parsedurl['url_array'];
            if ($url_array[0] == 'opensearchxml')
                $command['action'] = 'opensearchxml';
            elseif ($url_array[0] == 'action' && $url_array['1'] =='search')
            {
                
                $searchcmd = [];
                $query = parse_url($urlpath, PHP_URL_QUERY);                
                parse_str($query, $searchcmd); 
                
                $command['action'] = 'search';
                if(isset($searchcmd['keyword'])) {
                    $command['keyword'] = rawurlencode($searchcmd['keyword']); // preg_replace("/[^A-Za-z0-9\s\s+\.\:\-\/%+\(\)\*\&\$\#\!\@\"\';\n\t\r]/", '',
                }
                if (empty($command['keyword']))
                {
                    // backward compatibility fix - TODO fix this
                    $keyword_pos = array_search('keyword', $url_array);
                    if ($keyword_pos)
                    {
                        $command['keyword'] = $url_array[$keyword_pos  + 1];
                    }
                    $pg_pos = array_search('pg', $url_array);
                    if ($pg_pos)
                    {
                        $command['pg'] = $url_array[$pg_pos  + 1];
                    }
                    
                }
                
                return $command;
            } else return parent::InterpretFriendlyURL($urlpath);
            // main
        } else return parent::InterpretFriendlyURL($urlpath);
        return $command;
    }


    public function createFriendlyURL($str) {

        if (SCHLIX_SEF_ENABLED) {
            $command_array = [];
            parse_str($str, $command_array);
            $final_url = '';
            if (array_key_exists('action', $command_array))
            {
                switch($command_array['action'])
                {
                    case 'opensearchxml':
                        $final_url.='/opensearchxml';
                        break;
                    default:
                        return parent::createFriendlyURL($str);
                }
            } else return parent::createFriendlyURL ($str);
            $final_url = SCHLIX_SITE_HTTPBASE . '/' . $this->getFullApplicationAlias() . $final_url;
        } else
            return parent::createFriendlyURL($str);
        return remove_multiple_slashes($final_url);
    }
    
    //_______________________________________________________________________________________________________________//
    public function getObjectSearchResultsAndCount($keyword, $fieldnames = 'title,summary,description', $from_cache = true) {
        $forbidden_listing = array('admin', 'wysiwygeditors', 'mediamanager', 'mailqueue', 'logviewer');

        $allcount = 0;
        $all_apps = get_list_of_all_apps();

        $search_result_per_object = [];

        foreach ($all_apps as $search_app) {
            if (in_array($search_app, $this->enabled_apps) && !in_array($search_app, $forbidden_listing)) {

                $classname = $search_app;
                $fullclassname = '\\App\\' . $classname;
                $obj = new $fullclassname;
                $search_result_count = $obj->getItemTotalFullTextSearchResultCount($keyword, $fieldnames, 'status > 0');

                if ($search_result_count > 0)
                    $search_result_per_object[] = array('classname' => $classname, 'object' => $obj, 'start' => $allcount, 'end' => $allcount + $search_result_count, 'total' => $search_result_count);
                $allcount+=$search_result_count;
            }
        }

        return $search_result_per_object;
    }

    //_______________________________________________________________________________________________________________//
    private function getWhichObjectToLoad($object_results, $start) {
        if ($object_results) {
            $array_count = ___c($object_results);
            $position = 0;
            for ($i = 0; $i < $array_count; $i++) {
                $object_result = $object_results[$i];
                $position = $object_result['start'];
                //echo ' Position '.$position;
                if ($start >= $object_result['start'] && $start < $object_result['end']) {
                    //	echo "returning ".$object_result['classname'].' for start = '.$start.br().br();
                    return array('object' => $object_result['object'], 'position' => $position);
                }
            }
        } else
            return false;
    }

    //_______________________________________________________________________________________________________________//

    public function searchByKeyWord($keyword, $pg = 1, $sortby = '', $sortdirection = 'ASC', $from_cache = false, $standard_criteria = 'status=1') {
        $global_search_result_count = 0;

        if (strlen($keyword) < 1) {
            display_schlix_alert(___('Keyword must be four characters or more'));
            $this->viewMainPage();
            return false;
        }
        
        $str_title = ($keyword) ? ___('Searching for ') . " {$keyword}... - " : ___('Search');
        $this->setPageTitle($str_title);

        $perpage = $this->getNumberOfListingsPerPage();
        $object_results = $this->getObjectSearchResultsAndCount($keyword, 'title,summary,description,meta_key,meta_description', true);
        if ($object_results) {
            foreach ($object_results as $object_result) {
                $obj = $object_result['object'];
                $total = $object_result['total'];
                $global_search_result_count+=$total;
                //	echo $object_result['classname'].' start = '.$object_result['start'].' end = '.$object_result['end'].' total = '.$object_result['total'].br();
            }
            $pagination = $this->getStartAndEndForItemPagination($pg, $perpage, $global_search_result_count);

            $added_count = 0;
            $obj_count = 0;
            $items = [];
            while ($added_count < $perpage) {
                
                //	echo "Pagination [START] = {$pagination['start']} [END] = {$pagination['end']} [PERPAGE] = {$perpage} [ADD] = {$added_count}<br/><br/>";
                $objinfo = $this->getWhichObjectToLoad($object_results, $added_count + $pagination['start']);
                if (isset($objinfo['object'])) {
                    $obj = $objinfo['object'];
                    $position = $objinfo['position'];
                    $item_start = $pagination['start'] + $added_count - $position;
                    $item_end = $pagination['end'] - $position;
                    $idfield = $obj->getFieldID();
                    $search_obj_result = $obj->getItemFullTextSearchResult($keyword, 'status > 0', "{$idfield},title,summary,description,status,meta_key,meta_description", $item_start, $item_end, 'date_created', 'DESC');
                    $search_obj_result_count = ___c($search_obj_result);
                    if ($search_obj_result_count) {
                        for ($i = 0; $i < $search_obj_result_count; $i++) {
                            $search_obj_result[$i]['object'] = $obj;
                        }

                        if (___c($items) > 0)
                            $items = array_merge($items, $search_obj_result);
                        else
                            $items = $search_obj_result;
                        //	$result_count = ___c($items);
                        //if ($result_count < $item_start + $perpage) $item_end = $item_start + $result_count;
                        //echo '---> LOADING '.$obj->app_name.' start = '.$item_start.' end = '.$item_end.br();
                        ///	for ($i = 0; $i < $total_count; $i++) $items[$i]['object'] = $obj;
                        $added_count+=$search_obj_result_count;
                        $obj_count++;
                    } else
                        break;
                } else
                    break; // No More Items
                    
//echo 'Total added = '.$added_count.' '.$obj->app_name.br();
            }
        }
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.main', $local_variables);
    }

    //_______________________________________________________________________________________________________________//

    public function getNumberOfListingsPerPage() {
        return 15; // <--- TODO - please remove this hardcoding. Prana. Apr 2011.
    }

    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        switch ($command['action']) {
            case 'opensearchxml' :
                $this->viewOpenSearchXML();
                return false; // must be blank
                break;
            case 'search' : $_GET['keyword'] = str_limit($command['keyword'],127);
                $cpg = isset($command['pg']) ? $command['pg'] : 0;
                $this->searchByKeyWord(urldecode($command['keyword']), $cpg);
                break;
            default: return parent::Run($command);
        }
        return true;
    }

} 