<?php

/*
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */

namespace App;

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class SiteManager_Hosts_Admin extends \SCHLIX\cmsAdmin_List {

//_________________________________________________________________________//    
    public function __construct() {
        // Data: Item
        parent::__construct(true, []);
        //$this->search_field = 'description';
        $this->setItemFieldNamesForAjaxListing('id', 'category_id', 'hostname', 'status');
    }

    private function isValidDomainName($domain)
    {
        if(strpos($domain, '://') != 0)
        {
           return false;
        }
        if(stripos($domain, 'www.') === 0)
        {
            $domain = substr($domain, 4); 
        }
        $again = 'http://' . $domain;
        return filter_var ($again, FILTER_VALIDATE_URL) !== FALSE;
    }    
    
    
    public function domainNameAlreadyUsed($domain, $category_id)
    {
        global $SystemDB;
        
        $domain=strtolower($domain);
        $category_id = sanitize_string((int) $category_id);
        $sanitized_domain_name = sanitize_string($domain);
        $sql = "SELECT * FROM gk_sites_hosts WHERE LOWER(`hostname`) = {$sanitized_domain_name} AND category_id <> {$category_id}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return ___c($result) > 0;
    }
    
    /**
     * Update field
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return array
     */
    public function ajaxUpdateField()
    {
        global $SystemDB;

        $thefield = fpost_string('field', 32);
        $value = sanitize_string(fpost_string('value',255));
        $record_id = fpost_alphanumeric('id');
        $record_id_numtxt = substr($record_id, 1, strlen($record_id) - 1);
        $record_id_num = (int) $record_id_numtxt;
        if ($thefield == 'hostname')
        {
            $raw_domain_name =fpost_string('value');
            if ($this->isValidDomainName($raw_domain_name) == false)
            {
                return ajax_reply(201,___('Invalid domain name'));
            }
            if ($this->domainNameAlreadyUsed($raw_domain_name, $record_id))
            {
                return ajax_reply(201,___('The domain name has already been used by another website in the multisite configuration'));
            }
        }
        
        $thetable = $this->table_items;
        $thecolumn = $this->field_id;
        $error_msg = $this->validateUpdateItemField(($record_id_numtxt == "new") ? "new" : $record_id_num, $thefield, fpost_string('value'));
        if ($error_msg === true) {
            if ($record_id == "new")
            {
                $cat_id = fget_int('id');
                $sql = "INSERT INTO {$thetable} ({$thefield},category_id) VALUES({$value}, $cat_id)";
            }
            else
                $sql = "UPDATE {$thetable} SET {$thefield} = {$value} WHERE {$thecolumn} = {$record_id_num} ";
            $SystemDB->query($sql); //
            return ajax_reply(200, 'OK');
        } else {
            return ajax_reply(401, $error_msg);
        }
    }
    
    
}
