<?php
/**
 * Tag Manager - Config
 *
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

if (!defined('SCHLIX_VERSION')) die('No Access');
?>

<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.TagAdminController" data-model="<?= $this->getDataModelURL() ?>"  data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">

        <schlix-config:save-result />
        <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

            <schlix-config:action-buttons />
            <x-ui:csrf />

            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                        <!--config -->
                    <x-ui:row>
                        <x-ui:column md="6">
                            <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                            <schlix-config:app_description   />
                            <schlix-config:textbox config-key="str_meta_keywords" label="<?= ___('Default Meta Keywords') ?>"   config-fonticon="fa fa-hashtag" />
                            <schlix-config:textbox config-key="str_meta_description" label="<?= ___('Default Meta Description') ?>"   config-fonticon="fa fa-hashtag" />

                        </x-ui:column>
                        <x-ui:column md="6">
                            <schlix-config:textbox config-key="str_mainpage_title" label="<?= ___('Main Page Title') ?>"   />                        
                            <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Main page introduction text') ?>" class='wysiwyg' />

                        </x-ui:column>
                    </x-ui:row>
                        <!-- end config -->

                </x-ui:schlix-tab>
                <!-- tab -->
               <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>
                <!-- end -->
            </x-ui:schlix-tab-container>
            
        </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
 