<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Macro;

/**
 * Displays edit button 
 */
class FrontendEditControl extends \SCHLIX\cmsMacro {


    private static $executed;
    //_______________________________________________________________________________________________________________//
    public function getPagePublishingReadinessErrorArray($data)
    {
        global $CurrentUser;

        $error_list = array();

        // 2. Is item expired?
        if (!($data['date_expiry'] == NULL) && !( $data['date_expiry'] == NULL_DATE || days_difference_from_today($data['date_expiry']) > 0 ))
            $error_list[] = ___('This page is no longer published');
        // 3. Is publish date in the future?
        if (days_difference_from_today($data['date_available']) > 0)
            $error_list[] = ___('This page will be published in the future and not available at this time');
        // 4. Does current user have permission to read this item?
        //	if (!$CurrentUser->hasReadPermission($item['permission_read'])) { displayMessage('No Access','This page is not available for your user group.');return false;}
        if (array_key_exists('permission_read', $data))
        {
            $can_read = $CurrentUser->hasReadPermission($data['permission_read']);
            if (!$can_read)
                $error_list[] = ___('No read access');
        }
        return $error_list;
    }
    
    protected static function setExecutedFlag()
    {
        self::$executed = 'yes';
    }
    
    protected static function getExecutionFlag()
    {
        return self::$executed;
    }    
    //----------------------------------------------------------------------//
    /*
     * Run the macro
     * @global type $HTMLHeader
     * @param array|string $data
     * @param object $caller_object
     * @param string $caller_function
     * @param array $extra_info
     * @return bool
     */
    public function Run(&$data, $caller_object, $caller_function, $extra_info = NULL) {
        
        global $CurrentUser, $HTMLHeader;
        
        $text = '';
        
        if (!$CurrentUser->authenticated() || !$CurrentUser->hasPermission($this->config['array_groups_access']))
            return false;
        
        include_once(SCHLIX_ROOT_PATH.'/system/libs/schlix/admin_basic.class.php');
        include_once(SCHLIX_ROOT_PATH.'/system/libs/schlix/admin_basic_manager.class.php');
        
        
        $HTMLHeader->CSS($this->getURLofScript('frontendeditcontrol.css'));
        ///////////
        switch ($caller_function)
        {
            case 'viewCategoryByID':
            case 'viewChildCategory': 
            case 'viewMainPageCategory':                
                $edit_action = 'editcategory';
                $edit_pk = $caller_object->getFieldCategoryID();
                $edit_icon = 'fas fa-folder frontendeditcontrol-orange';
                if ($data == null ||  $data['cid'] == 0)
                    return;
                break;                                        
            case 'viewChildItem':                         
            case 'viewMainPageItem':                     
            case 'viewItemByID':
                $edit_action = 'edititem';    
                $edit_pk = $caller_object->getFieldID();
                $edit_icon = 'fas fa-file frontendeditcontrol-blue';
                if ($data == null || $data['id'] == 0)
                    return;                
                break;
            case 'viewBlock':
                break;
            default: return false;
        }
        
        // Control Bar
        if (!self::$executed)
        {
            start_output_buffer();
            $local_variables = compact(array_keys(get_defined_vars()));
            $this->loadTemplateFile('frontendeditcontrol-bar', $local_variables);
            self::$executed = 'yes';
            $text = end_output_buffer();
        }
        if (($caller_function == 'viewBlock'))
        {
            $show_block = fcookie_int('schlix_frontendedit_control_showblock');   
            if ($show_block == 2)
            {
                $has_write_permission = true;

                $local_variables = compact(array_keys(get_defined_vars()));
                //$this->loadTemplateFile('frontendeditcontrol-block', $local_variables);
                //self::$executed = 'yes';
                $obj_admin_class_instance = new \App\Core_BlockManager_Admin();
                $link = $obj_admin_class_instance->createFriendlyAdminURL("action=edititem&id={$extra_info['id']}");

                $prefix = \__HTML::DIV_start(array('class'=>'schlix_frontendedit_control-blockitem-container'));
                $prefix.= \__HTML::DIV_start(array('class'=>'schlix_frontendedit_control-blockitem-title')).
                            \__HTML::I('',array('class'=>'fas fa-cube')).' '.
                            $extra_info['title'].
                            \__HTML::A(
                            \__HTML::I('',array('class'=>'fas fa-cog schlix_frontendedit_control-blockitem-editlink')),$link,array('target'=>'_blank')).' '.
                            \__HTML::DIV_end();
                $suffix = \__HTML::DIV_end();
                $data = $text.$prefix.$data.$suffix;
                return true;
                //$text = end_output_buffer();
                //$data = $text;

                //$data = $text; //$this->appendBeforeArticleOuput($data, $text);        
            } else
            {
                $data.= $text;
                return true;
            }
            
        } else
        {
            $data_perm_write = isset($data['permission_write']) ? $data['permission_write'] : null;
            $has_write_permission = $CurrentUser->hasWritePermission($data_perm_write);
            if ($has_write_permission)
            {
                start_output_buffer();
                $local_variables = compact(array_keys(get_defined_vars()));
                $this->loadTemplateFile('frontendeditcontrol-doc', $local_variables);                
                $text.= end_output_buffer();
                $this->appendBeforeArticleOuput($data, $text);        
            }
        }
        return true;
    }
    
}

