<?php
/**
 * Gallery
 * 
 * Gallery to display your work. Similar to image gallery but has the capability to display additional media (image, video) inside each item
 *
 * @copyright SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    https://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php if ($album_images): ?>
    <?php 
    global $HTMLHeader;
    
    $image_gallery_app->CSS('gallery.css');
    $HTMLHeader->CSS('/system/js/glightbox/glightbox.css');
    $HTMLHeader->JAVASCRIPT('/system/js/glightbox/glightbox.js');    
    
$HTMLHeader->JAVASCRIPT_TEXT("
document.addEventListener('DOMContentLoaded', function(event) {
    var allimgs = document.getElementsByClassName('gallery-image');
    if (allimgs && allimgs.length > 0)
    {
        var lightbox = GLightbox();
    }
  
});"); 
?>
    <!-- note: This is a stock template file that you must customize on your own.  -->

        <div id="imagegallery-macro-<?= $image_gallery_id ?>" >
             <div  class="gallery-masonry">
                
                <?php foreach ($album_images as $child_item): ?>
                     
                        <div class="gallery-item">
                            <?php $link = $image_gallery_app->getGalleryImage('image_large', $child_item['url_media_file'], $child_item['category_id'], false) ?>
                            <a class="glightbox" href="<?= $link ?>"><img class="gallery-image" src="<?= $image_gallery_app->getGalleryImage('image_small', $child_item['url_media_file'], $child_item['category_id'], false) ?>" /></a>
                            <?php if ($child_item_title_text): ?>
                                <h2 class="title"> <?= ___h($child_item_title_text) ?></h2>
                            <?php endif ?>
                                <!-- text -->
                                <?php if ($category_meta_options['display_item_summary']): ?>
                                    <div class="imagegallery-thumbnails-summary"><?= $child_item['summary'] ?></div>
                                <?php endif; ?>
                                <!-- end text -->
                            
                        </div>
                <?php /*
                
                <div class="sp-slide">
                    <img class="sp-image" src="<?= $blank_gif ?>" 
                         data-src="<?= $image_gallery_app->getDataFileURLPath('image_medium', $image['url_media_file'])?>" 
                         data-small="<?= $image_gallery_app->getDataFileURLPath('image_small', $image['url_media_file'])?>"
                         data-medium="<?= $image_gallery_app->getDataFileURLPath('image_medium', $image['url_media_file'])?>"
                         data-large="<?= $image_gallery_app->getDataFileURLPath('image_large', $image['url_media_file'])?>"
                         data-retina="<?= $image_gallery_app->getDataFileURLPath('image_large', $image['url_media_file'])?>"/>
                    <?php if ($image['summary']): ?>
                    <div  class="sp-layer sp-black sp-padding" 
                       data-position="bottomLeft" data-width="100%" 
                       data-show-transition="up" data-show-delay="400">
                        <?= $image['summary'] ?>
                    </div>                    
                    <?php endif ?>
                </div>
                    */ ?>
                <?php endforeach ?>
                
            </div>
        </div>
    
<?php else: ?>
<!-- No Gallery Image found -->
<?php endif ?>