<?php
namespace Skin;


class bootstrap3 extends \SCHLIX\cmsSkin
{

    protected $carousel_item_css_class = 'item';
    protected $carousel_prev_css_class = 'left carousel-control';
    protected $carousel_next_css_class = 'right carousel-control';
    protected $carousel_prev_icon_css_class = 'icon-prev';
    protected $carousel_next_icon_css_class = 'icon-next';    
    protected $tab_count = 0;
    
    public function getDefaultCSS()
    {
        return get_system_or_user_url_path('/skins/bootstrap3/bootstrap.min.css');
    }
    /**
     * Standard pagination
     * @param array $page_array
     * @return string
     */    
    public function standard_pagination($page_array)
    {
        $s = '';
        if ($page_array)
        {
            $s = "<ul class='pagination'>";
            foreach ($page_array as $page)
            {
                $pg_type = $page['type'];
                $pg_url = $page['url'];
                $pg_num = $page['number'];
                $li_class = 'page-item';
                switch ($pg_type)
                {
                    case 'page':
                        $page_item = \__HTML::A($pg_num, $pg_url, ['class' => 'page-link']);
                        break;                    
                    case 'current':
                        $page_item = \__HTML::A($pg_num, $pg_url, ['class' => 'page-link']);
                        $li_class = 'page-item active';
                        break;                    
                    case 'first':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-fast-backward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'last':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-fast-forward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'next':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-step-forward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'prev':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-step-backward']), $pg_url, ['class' => 'page-link']);
                        
                        break;

                }
                $s.= "<li class=\"{$li_class}\">{$page_item}</li>";
            }
            $s.= "</ul>";
        } 
        return $s;
    }

    /**
     * Standard breadcrumb - called by $Application
     * @param array $breadcrumbs
     * @return string
     */
    public function standard_breadcrumb($breadcrumbs)
    {
        
        $total = ___c($breadcrumbs);
        $str = '';        
        if ($total)
        {
            $site_httpbase = (SCHLIX_SITE_HTTPBASE === '') ? '/' : SCHLIX_SITE_HTTPBASE;
            $str = \__HTML::DIV_start(['class'=>'breadcrumb-container']);
            $str.= \__HTML::UL_start(['class'=>'breadcrumb']);
            $str.= \__HTML::LI(\__HTML::A('<i class="fa fa-home"></i>', $site_httpbase,['class'=>'breadcrumb-home']) );
            for ($i = 0; $i < $total; $i++)
            {
                $crumb = $breadcrumbs[$i];
                $str.= \__HTML::LI(\__HTML::A($crumb['title'], $crumb['link']));                 
            }            
            $str.= \__HTML::UL_end();
            $str.= \__HTML::DIV_end();
            return $str;
        } else return '';
        
        
        $brcm[] = \__HTML::LI(\__HTML::A('Home', $site_httpbase, ['class'=>'breadcrumb-home'])) ;
        
        return $brcm;
        
    }
    
    /**
     * 
     * Data Explorer
     * @internal
     * @param \DOMElement $origin
     * @param string $element_name
     * @param string $type
     * @return \DOMElement
     */
    protected function internal_schlix_data_explorer(\DOMElement $origin, $element_name, $type='item')
    {
        $app_admin = $this->getApp();        
        if ($this->isAdminApp())
        {
            if ($element_name == 'schlix-config-data-editor')
            {
                $element_name = 'schlix-data-editor';
                $origin->setAttribute('type','config');
            }
            
            $el = $this->_elems($origin, $element_name);
            $data_model = $origin->getAttribute('data-model');
            
            $data_app = $origin->getAttribute('data-app');
            $data_desc = $origin->getAttribute('data-main-app-description');
            $data_type_label = $origin->getAttribute('data-type-desc');            
            
            $prefix = $origin->getAttribute('prefix');
            $description = $origin->getAttribute('description');
            //$type = $origin->getAttribute('type');
            $id = $origin->getAttribute('id');
            $set_id = false;
            $app_frontend = $this->getApp()->frontendApp();
            $app_name = $app_frontend->getOriginalFullApplicationAlias();            
            $orig_desc = $app_frontend->getOriginalApplicationDescription();
            //print_r($app_frontend->getOriginalFullApplicationAlias());die;
            if (empty($data_desc))
            {                
                if ($type == 'config')
                    $orig_desc.= ': '.___('Configuration');
                elseif ($description)
                    $orig_desc.= ': '.$description;                
                $el->setAttribute('data-main-app-description', $orig_desc);                
                $set_id = true;
            }
                
            if (empty($data_model))
            {                
                $el->setAttribute('data-model', $this->getApp()->getDataModelURL());
                $set_id = true;
            }
            if (empty($data_app))
            {
                $el->setAttribute('data-app', $app_name);
                $set_id = true;
            }
            
            if ($set_id && empty($id))
            {
                if ($prefix)
                    $the_id = "schlix-{$prefix}-{$app_name}-admin";
                else
                    $the_id = "schlix-{$app_name}-admin";
                $el->setAttribute('id', alpha_numeric_with_dash_underscore($the_id));
            }
            
            $el->setAttribute('class','schlix-data-explorer');
            $class = $element_name == 'schlix-data-editor' ? $element_name : 'schlix-data-explorer';
            $el->setAttribute('class', $class);
            if ($class == 'schlix-data-editor')
            {
                //fix for php8
                $editing_id = isset($this->data['id']) ? $this->data['id'] : 'none';
                
                $el->setAttribute('data-cancel-warning', 'true');//"true"
                $page_label = '';
                if ($type == 'category')
                {
                    $id = method_exists($app_frontend, 'getFieldCategoryID') ? call_user_func([$app_frontend, 'getFieldCategoryID']) : 'cid';
                    //echo $this->data['id'];die;
                    if (empty($data_desc))
                    {                        
                        $dl = $data_type_label ? $data_type_label : ___('category');
                        $page_label = ($editing_id == 'new') ? ___('New').' '.$dl : ___('Edit').' '.$dl.' #'.$editing_id;                            
                        $el->setAttribute('data-main-app-description', $orig_desc.': '.$page_label);
                    }
                } elseif ($type == 'item')
                {
                    $id = method_exists($app_frontend, 'getFieldID') ? call_user_func([$app_frontend, 'getFieldID']) : 'id';
                    if (empty($data_desc))
                    {                        
                        $dl = $data_type_label ? $data_type_label : ___('item');
                        $page_label = ($editing_id == 'new') ? ___('New').' '.$dl : ___('Edit').' '.$dl.' #'.$editing_id;
                        $el->setAttribute('data-main-app-description', $orig_desc.': '.$page_label);
                    }
                    
                }
                $el->setAttribute('data-field-id', $id);
            }

            return $el;
        }        
    }
    
    
    protected function xui_schlix_explorer_sub_application_header(\DOMElement $origin)
    {
        $subheader_guid = fget_string('sub-application-header', 63);
        if (!empty($subheader_guid))
        {
            
            $app_name_1 = $_SESSION['admin_menu_'.$subheader_guid];
            if (!empty($app_name_1))
            {
                $app_name_1 = preg_replace('/[^a-zA-Z0-9_]/', '_', $app_name_1);
                $other_app_admin_name = "\\App\\{$app_name_1}";
                $other_app_admin = new $other_app_admin_name;
                $html = $other_app_admin->getSubApplicationHeaderAsString();
                    
            }
            return $this->addCustomHTML($html);
        } else 
        {
            $html = $this->getApp()->getSubApplicationHeaderAsString();
        
            return $this->addCustomHTML($html);
        }
    }
    
    protected function xui_schlix_sub_application_toolbar(\DOMElement $origin)
    {
        return $this->internal_schlix_toolbar($origin, 'subapplication');
    }
    
    protected function xui_schlix_explorer_toolbar(\DOMElement $origin)
    {
        return $this->internal_schlix_toolbar($origin, 'toolbar');
    }
    
    protected function internal_schlix_toolbar(\DOMElement $origin, $role)
    {
        $extra_navbar_class = '';
        $schlix_id = '';
        if ($role == 'toolbar')
        {
            $schlix_id = 'toolbar';
            $extra_navbar_class = 'schlix-data-explorer-toolbar';
        } else 
        {
            $schlix_id = 'subapplication';
            $extra_navbar_class =  'schlix-subapplication-header';        
        }
        $parent = $origin->parentNode;
        $appname_only = isset($this->data['app_name_only']) ? $this->data['app_name_only'] : 'generic';
        $data_target = "#schlix-{$appname_only}-admin-toolbar";
        
        if ($parent)
        {
            $data_target = '#'. $parent->getAttribute('id').'-toolbar';
        }
        $opt = ['href' => 'javascript:void(0)', 'class' =>"navbar-toggle collapsed schlix-toolbar-toggle", 'data-toggle' =>"collapse", 'data-target' => $data_target];
        $node_btn = $this->_e('a', $opt);
        $node_sronly = $this->_e('span',['class' => 'sr-only'], 'Toggle navigation');
        $node_iconbar = $this->_e('span',['class' => 'icon-bar']);
        $node_btn->appendChild($node_sronly);
        for ($i = 0; $i < 3; $i++)
            $node_btn->appendChild($node_iconbar->cloneNode());
        
        $new_node = $this->_e('nav', ['class'=>"navbar navbar-default {$extra_navbar_class}", 'role'=>"navigation"]);
        $new_node->appendChild($this->_nl());
        $new_node->appendChild($node_btn);
        
        $navbar_collapse = $this->_e('div',['class' => 'collapse navbar-collapse', 'schlix-id' => $schlix_id ]);
        
        
        $this->cloneChildNodes($origin, $navbar_collapse);
        $new_node->appendChild($navbar_collapse);
        $new_node->appendChild($this->_nl());
        return $new_node;
    }
    

    
    protected function xui_schlix_explorer_toolbar_search(\DOMElement $origin) 
    {
/*                <div class="col-sm-3 col-md-3 schlix-toolbar-search-container">
                    <form schlix-id="search-form" class="navbar-form" role="search">
                        <div class="btn-group">
                            <input schlix-id="search-keyword" type="search" class="form-control border-left-none search-with-clear"  placeholder="<?= ___('Search...') ?>">
                        </div>                    
                    </form>
                </div>
*/        
        
        $n_container = $this->_el('div',['class' => 'col-sm-3 col-md-3 schlix-toolbar-search-container']);
        //$n_form = $this->_el('form',['schlix-id' => 'search-form', 'class' => 'navbar-form', 'role' => 'search']);
        $n_form = $this->_el('div',['schlix-id' => 'search-form', 'class' => 'navbar-form', 'role' => 'search']);
        $n_group = $this->_el('div',['class' => 'btn-group']);        
        $n_input = $this->_el('input',  ['type' => 'search', 'schlix-id'=> 'search-keyword', 'class' => 'form-control border-left-none search-with-clear', 'placeholder' => ___('Search...')]);
        $n_group->appendChild($n_input);
        $n_form->appendChild($n_group);
        $n_container->appendChild($n_form);
        return $n_container;
    }
    

    protected function schlix_toolbar_menu_folder(\DOMElement $origin)
    {
        $class_list = [ 'dropdown'];
        if ($origin->getAttribute('require-no-category'))
            $class_list[] = 'require-no-category';
        else
        if ($origin->getAttribute('require-category'))
            $class_list[] = 'require-category';
        
        $str_class_list = implode(" ", $class_list);
        $node_li = $this->_e('li', ['class' => $str_class_list]);
        $node_b = $this->_e('b', ['class' => 'caret']);
        $node_a = $this->_el('a', ['href' => 'javascript:void(0);', 'class' => 'dropdown-toggle', 'data-toggle' => 'dropdown'], $this->internal_icon_text($origin) );
        $node_a-> appendChild($this->_t(' '));
        $node_a-> appendChild($node_b);
        $node_li->appendChild($node_a);
        $node_li_ul = $this->_elems($origin, 'ul', ['class' => 'dropdown-menu']);
        $this->cleanUpAttributes($node_li_ul, ['sub-application','fonticon','label','schlix-id']);
        $node_li->appendChild($node_li_ul);        
        return $node_li;
    }        
    
    
    protected function schlix_toolbar_menu_item(\DOMElement $origin)
    {
        $sub_app_cmds = ['main-config','main-application','sub-application','custom-table-config', 'other-application', 'other-admin-application','frontend-application'];
        $fonticon = $origin->getAttribute('fonticon');
        $label = trim($origin->getAttribute('label'));
        $datacommand = $origin->getAttribute('data-schlix-command');
        $dataaction = $origin->getAttribute('data-schlix-app-action');
        $a_ct = $origin->getAttribute('data-custom-table');
        
        $app_admin = $this->getApp();
        if (empty($label))
            $label = 'Unknown';        
        $class_list = [];
        
        if ($origin->getAttribute('require-selected-items'))
            $class_list[] = 'require-selected-items';
        if ($origin->getAttribute('require-clipboard-items'))
            $class_list[] = 'require-clipboard-items';
        if ($origin->getAttribute('require-category'))
            $class_list[] = 'require-category';        
        if ($origin->getAttribute('require-no-category'))
            $class_list[] = 'require-no-category';
        $attrs['href'] = 'javascript:void(0)';
        $app_admin_cf = new \App\Core_CustomField_Admin();
        if (!empty($datacommand))
        {
            if (in_array($datacommand, $sub_app_cmds))
            {
                switch ($datacommand)
                {
                    
                    case 'custom-table-config':
                        $attrs['href'] = $app_admin_cf->createFriendlyAdminURL("action=modify&table={$a_ct}");
                        break;
                    case 'main-config':
                        $attrs['href'] = $app_admin->createFriendlyMainApplicationAdminURL('action=editconfig');
                        $attrs['class'] = 'sub-application'; 
                        break;
                    case 'main-application':
                        $attrs['href'] = $app_admin->createFriendlyMainApplicationAdminURL('');
                        $attrs['class'] = 'sub-application'; 
                        break;
                    case 'sub-application':
                        $attrs['href'] = $app_admin->createFriendlySubApplicationAdminURL($origin->getAttribute('sub-application'));
                        $attrs['class'] = 'sub-application'; 
                        break;
                    case 'frontend-application':                             
                        $other_app = $origin->getAttribute('application');
                        $sanitized_app_name = preg_replace('/[^a-zA-Z0-9_]/', '_', $other_app);
                        $other_app_name = "\\App\\{$sanitized_app_name}";
                        $other_app = new $other_app_name;
                        $app_action = $origin->getAttribute('application-action');
                        $str_action = !empty($app_action) ? "&action={$app_action}" : '';
                        $href = $other_app->createFriendlyURL($str_action);
                        $attrs['href'] = $href;
                        $attrs['class'] = 'sub-application';                         
                        break;
                    case 'other-admin-application':
                    case 'other-application': // backward compatibility
                        $other_app = $origin->getAttribute('application');
                        $sanitized_app_name = preg_replace('/[^a-zA-Z0-9_]/', '_', $other_app);
                        $other_app_admin_name = "\\App\\{$sanitized_app_name}_Admin";
                        $other_app_admin = new $other_app_admin_name;
                        $app_action = $origin->getAttribute('application-action');
                        //$uuid = $_SESSION[$nam];
                        
                        $app_name_2 = $other_app_admin->getFullApplicationName();
                        $app_name_1 = $this->getApp()->getFullApplicationName();
                        $combo = $app_name_1.'_'.$app_name_2;                        
                        $existing_guid = fsession_string($combo);  
                        if (empty($existing_guid))
                        {
                            $existing_guid = $_SESSION[$combo] = new_uuid_v4();
                            $_SESSION['admin_menu_'.$existing_guid] = $app_name_1 ;
                        }
                        
                        //$str_action = "sub-application-header={$app_admin->getApplicationName()}";
                        $str_action = "sub-application-header={$existing_guid}";
                        $str_action.= !empty($app_action) ? "&action={$app_action}" : '';
                        $href = $other_app_admin->createFriendlyAdminURL($str_action);
                        $attrs['href'] = $href;
                        $attrs['class'] = 'sub-application';                         
                        break;
                    default:
                        break;             
                }
            } else
            {
                $attrs['data-schlix-command'] = $datacommand;
                $class_list[] = 'schlix-command-button';
                $attrs['schlix-id'] = 'btn-'.$datacommand;
                
                $href = $origin->getAttribute('href');
                if (!empty($href))
                {
                    $attrs['href'] = $href;
                    $onw = $origin->getAttribute('open-new-window');
                    if ($onw == '1')
                    {
                        $attrs['target'] = '_blank';
                        $attrs['rel'] = 'noopener noreferrer';
                    }

                }
                if (!empty($dataaction))
                    $attrs['data-schlix-app-action'] = $dataaction;        
                
            }
        }
        
        $str_class_list = implode(" ", $class_list);
        if (!empty($str_class_list))
            $attrs['class'] = $str_class_list;
        
        $li = null;
        if ($origin->getAttribute('data-heading-only'))
        {
            $m = $this->_e('h4',null,$label);            
            $li = $this->_el('li',null,$m);
        } else 
        {
            $a = $this->_elems($origin, 'a', $attrs, '',  $this->internal_icon_text($origin) );
            $this->cleanUpAttributes($a, ['sub-application','fonticon','label','schlix-id', 'require-selected-items', 'require-clipboard-items', 'require-category', 'require-no-category', 'data-custom-table', 'other-application','application-action']);
            $li = $this->_el('li',null,$a);
            
        }
        
        return $li;
        
        
    }
    
    protected function xui_schlix_explorer_toolbar_menu(\DOMElement $origin)
    {
        $node_ul = $this->_e('ul');
        $this->copyAttributesFromNode($origin, $node_ul );
        $pos = $origin->attributes['data-position'];
        $class = 'nav navbar-nav';
        if ($pos->textContent == 'right')
        {
            $class.= ' navbar-right';
        }
        $node_ul->setAttribute('class', $class);
        $node_content = $this->traverseList($origin, 'schlix_toolbar_menu_folder', 'schlix_toolbar_menu_item', 'x-ui', 'schlix-explorer-menu-folder', 'schlix-explorer-menu-command');
        if ($node_content->hasChildNodes())
            $node_ul->appendChild($node_content);
        
        return $node_ul;
        
    }
    
    protected function xui_schlix_explorer_pagination(\DOMElement $origin)
    {
        return $this->_el('div', ['schlix-id'=> "datanav-paginator", 'class'=>"schlixui-pg-container"]);        
    }
    
    
    protected function xui_schlix_explorer_breadcrumb(\DOMElement $origin)
    {
        return $this->_el('schlix-data-breadcrumb', ['schlix-id'=> "breadcrumb"]);        
    }
    
    protected function xui_schlix_explorer_left_column(\DOMElement $origin)
    {        
        $new_node = $this->_e('div', ['class'=>"left-column", 'schlix-id'=>"left-column"]);        
        $this->cloneChildNodes($origin, $new_node);
        return $new_node;
    }
    
    protected function xui_schlix_explorer_right_column(\DOMElement $origin)
    {        
        $new_node = $this->_e('div', ['class'=>"right-column", 'schlix-id'=>"right-column"]);        
        $this->cloneChildNodes($origin, $new_node);
        return $new_node;
    }    
    
    protected function xui_schlix_explorer_row(\DOMElement $origin)
    {        
        $new_node = $this->_e('div', ['class'=>"schlix-data-container", 'schlix-id'=>"main-data-container"]);        
        $this->cloneChildNodes($origin, $new_node);
        return $new_node;
    }    


    protected function internal_label($icon, $text_label, $attr_id = '')
    {
        $label_attr = ['class' => 'control-label'];            
        if (!empty($attr_id))
            $label_attr['for'] = $attr_id;
        $el_label = $this->_e('label',$label_attr);
        if ($icon)
        {
            $el_label->appendChild (($this->_e('i', ['class' => $icon])));
            $el_label->appendChild (($this->_t(' ')));
        }
        if ($text_label)
            $el_label->appendChild (($this->_t($text_label)));
        //$inner_elems[] = $this->_e('label',$label_attr); 
        return $el_label;
    }
    
    protected function xui_schlix_document_title(\DOMElement $origin) 
    {
        $n_document_featured = $n_document_status = null;
        $attrs = [ 'required' => 1, 'maxlength' => 191];
        $attrs ['class'] = 'form-control input-lg';
        $input = $this->_input($origin, 'input', $attrs);
        $a_table_type = $origin->getAttribute('table-type');
        $this->cleanUpAttributes($input, ['data-field', 'table-type']);
        $attr_label = trim($input->getAttribute('label'));
        
        $attr_disable_change_home = trim($input->getAttribute('read-only-if-home'));
        $attr_id = trim($input->getAttribute('id'));
        $attr_name = trim($input->getAttribute('name'));
        $attr_data_field = trim($input->getAttribute('data-field'));
        $input->setAttribute('type','text');
        if (empty($attr_label))
            $attr_label = ___('Page Title');
        if (empty($attr_id))
            $input->setAttribute('id','title');
        if (empty($attr_name))
            $input->setAttribute('name','title');
        $inner_elems = [];     
        
        $v = $this->getFormdata('version') ;
        $inner_elems[] = $input;
        if ( (float) $v > 0)
            $inner_elems[] = $this->_es('span', ['class' => 'input-group-addon'], ___('Version') . ': ' .___h($v));

        $app_frontend = $this->getApp()->frontendApp();
        $current_view = $this->data['view'];
        $field_id = $current_view === 'category' ? $app_frontend->getFieldCategoryID() : $app_frontend->getFieldID();
        $fv = $this->data[$current_view][$field_id];

        $stt = !empty($this->data['status']) ? $this->data['status'] : null;
        $stf = !empty($this->data['featured']) ? $this->data['featured'] : null;
        $status_value = ($stt == 1 || $fv === 'new');
        $featured_value = $stf;
        
        
        //$featured_value =  $this->data['featured'] == 1;
        $exist_field_status = false;
        $exist_field_featured = false;
        if (!empty($a_table_type))
        {
            if ( $a_table_type === 'item' && $app_frontend instanceof \SCHLIX\cmsApplication_List)
            {
                $exist_field_status = $app_frontend->itemColumnExists('status');
                $exist_field_featured = $app_frontend->itemColumnExists('featured');
            } elseif ( $a_table_type === 'category' && $app_frontend instanceof \SCHLIX\cmsApplication_CategorizedList)
            {
                $exist_field_status = $app_frontend->categoryColumnExists('status');
                $exist_field_featured = $app_frontend->categoryColumnExists('featured');
            }                            
        } else
        {
            $exist_field_status = $this->formDataKeyExists('status');
            $exist_field_featured = $this->formDataKeyExists('featured');
        } 
        if ($exist_field_status)
        {
            $n_document_status = $this->_el('schlix-cms-document-status', ['data-value' => $status_value, 'data-input-name' =>"status", 'data-field' =>"status", 'data-icon-yes' =>"fa fa-check", 'data-icon-no' =>"fa fa-times", 'data-color-yes' =>"green", 'data-color-no' =>"red", 'data-text-yes' =>  ___S('Active & Published') , 'data-text-no' =>  ___('Inactive')] );
            $this->autoSetFormAttributeValue($n_document_status,'data-value');
        }
        if ($exist_field_featured)
        {
            $n_document_featured = $this->_el('schlix-cms-document-status', ['data-value' => $featured_value, 'data-input-name' =>"featured", 'data-field' =>"featured", 'data-icon-yes' =>"fa fa-star", 'data-icon-no' =>"fa fa-star", 'data-color-yes' =>"orange", 'data-color-no' =>"grey", 'data-text-yes' =>  ___('Featured Article') , 'data-text-no' =>  ___('Regular Article')] );
            $this->autoSetFormAttributeValue($n_document_featured,'data-value');
        }
        $this->autoSetFormAttributeValue($n_document_status,'data-value');
        
        

        if ($n_document_status)
        $inner_elems[] = $this->_el('span', ['class' => 'input-group-addon'], $n_document_status);
        if ($n_document_featured)
        $inner_elems[] = $this->_el('span', ['class' => 'input-group-addon'], $n_document_featured); 
        
        $input_group = $this->_el('div', ['class' => 'input-group'], $inner_elems);
        $fg = $this->_el('div', ['class' => 'form-group'], [$this->internal_label(null,$attr_label, $attr_id ), $input_group]);

        return $fg;
        
    }
    
    /**
     * Document virtual filename
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_document_virtual_filename(\DOMElement $origin) 
    {
        $type = null;
        $n_preview_link = null;
        
        if ($this->isAdminApp())
        {
            $attrs = [ 'required' => 1, 'maxlength' => 191];
            $attrs ['class'] = 'form-control';
            $orig_attr_data_field = trim($origin->getAttribute('data-field'));
            $attr_use_full_url =  $origin->getAttribute('full-url');

            if (empty($orig_attr_data_field))
            {
                $attrs['data-field'] = 'virtual_filename';
            }

            $input = $this->_input($origin, 'input', $attrs);
            
            $input->setAttribute('data-field','virtual_filename');
            $input = $this->autoSetFormAttributeValue($input);
            $this->cleanUpAttributes($input, ['data-field','full-url']);
            $attr_label = trim($input->getAttribute('label'));
            $attr_disable_change_home = trim($input->getAttribute('read-only-if-home'));            
            $attr_id = trim($input->getAttribute('id'));
            $attr_name = trim($input->getAttribute('name'));

            $input->setAttribute('type','text');
            if (empty($attr_id))
                $input->setAttribute('id','virtual_filename');
            if (empty($attr_name))
                $input->setAttribute('name','virtual_filename');

            if (empty($attr_label))
                $attr_label = ___('Search Engine Friendly Shortcut');

            $inner_elems = [];    

            $app_admin = $this->getApp();
            /*if ($app_admin instanceof \SCHLIX\cmsAdmin_CategorizedList)
            {

            }*/
            if ($app_admin instanceof \SCHLIX\cmsAdmin_CategorizedList)
            {
                $parent_category_text = null;
                $url_preview = null;
                $type = $this->data['view'];
                if ($type === 'category')
                {

                    $pk = $app_admin->frontendApp()->getFieldCategoryID();                
                    $url_preview = $app_admin->frontendApp()->createFriendlyURL("action=viewcategory&cid={$this->data['category'][$pk]}");
                    $parent_category_text = $app_admin->getCategoryParentURLPathPreviewLink($this->getFormDataArray());
                    if ($attr_use_full_url)
                        $parent_category_text = SCHLIX_SITE_URL. $parent_category_text;
                    
                    $n_parent_cat = $this->_t($parent_category_text);


                } else if ($type === 'item')
                {

                    $pk = $app_admin->frontendApp()->getFieldID();
                    $url_preview = $app_admin->frontendApp()->createFriendlyURL("action=viewitem&id={$this->data['item'][$pk]}");
                    if ($app_admin instanceof \SCHLIX\cmsAdmin_ManyToMany)
                    {
                        $parent_category_array = $app_admin->getItemParentURLPathMultiplePreviewLink($this->getFormDataArray());
                        if ($parent_category_array) 
                        {
                            $n_parent_cat = $this->_e('select', ['class' => 'schlix-vfn-selector']);
                            foreach ($parent_category_array as $parent_category)
                            {
                                if ($attr_use_full_url)
                                    $parent_category = SCHLIX_SITE_URL. $parent_category;
                                
                                $n_parent_cat->appendChild($this->_es('option', null, $parent_category));
                            }
                        }
                        else $n_parent_cat = $this->_t('---');
                        
                    } else 
                    {
                        $parent_category_text = $app_admin->getItemParentURLPathPreviewLink($this->getFormDataArray());
                        if ($attr_use_full_url)
                            $parent_category_text = SCHLIX_SITE_URL. $parent_category_text;
                        
                        $n_parent_cat = $this->_t($parent_category_text);
                    }
                }
    /* 
     *                                 <select style="border:none;background:transparent">                                    
                                        <?php if ($parent_category_array) foreach ($parent_category_array as $parent_category): ?>
                                        <option><?= $parent_category ?></option>
                                        <?php endforeach; ?>
                                     </select>

     */            


                if ($url_preview)
                $n_preview_link = $this->_el('a',['target' => 'blank', 'href' => $url_preview, 'rel' => 'noopener'], 
                    [
                        $this->_el('i',['class' => 'fa fa-eye']),
                        $this->_t(' '.___('Preview'))
                    ]);
                $inner_elems[] = $this->_el('span',['class' => 'input-group-addon'], $n_parent_cat);
            }

            $inner_elems[] = $input;
            if ($type === 'item')
            $inner_elems[] = $this->_es('span',['class' => 'input-group-addon'], '.html'); 
            
            if ($n_preview_link && $this->data['id'] !== 'new')
                $inner_elems[] = $this->_el('span',['class' => 'input-group-addon'], $n_preview_link); 
            $input_group = $this->_el('div', ['class' => 'input-group'], $inner_elems);
            $fg = $this->_el('div', ['class' => 'form-group'], [$this->internal_label(null, $attr_label, $attr_id ), $input_group]);

            return $fg;
        }
    }
    
    protected function xui_schlix_editor_form (\DOMElement $origin) 
    {
        //method="post" action="saveitem" enctype="multipart/form-data" initial-data-key="item"
        $n = $this->_elems($origin, 'form', ['id' => 'editor-form', 'method' => 'post']);
        $admin_action = $origin->getAttribute('admin-action');
        
        if (!empty($admin_action))
        {
            $app_admin = $this->getApp();
            if ($app_admin instanceof \SCHLIX\cmsAdmin_List)
            {
                $n->setAttribute('action', $app_admin->createFriendlyAdminURL("action={$admin_action}"));
            }
        }
        $n->setAttribute('enctype',"multipart/form-data");
        $div = $this->_e('div',['class' => 'content']);
        $div->appendChild($n);
        return $div;
    }
    
    /**
     * Editor Top Row
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_editor_top_row (\DOMElement $origin) 
    {
        return $this->_elems($origin, 'div', ['class' => 'row']);
    }
    
    /**
     * Editor column - top left (usually for page title and virtual filename)
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_editor_top_left (\DOMElement $origin) 
    {   
        return $this->_elems($origin, 'div', ['class' => 'col-md-8 col-lg-8']);        
    }
    
    /**
     * Editor column - top right (usually for save button)
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_editor_top_right (\DOMElement $origin) 
    {        
        return $this->_elems($origin, 'div', ['class' => 'col-md-4 col-lg-4 text-right', 'schlix-id'=>"data-editor-toolbar"]);
    }
    
    /**
     * Treeview tag
     * @param \DOMElement $origin
     * @return type
     */
    protected function xui_schlix_treeview(\DOMElement $origin)
    {
        $attrs = ['class' => 'schlix-cms-treeview'];  
        return $this->_elems($origin, 'div', $attrs);
    }
    
    /**
     * Return font icon
     * @param string $fonticon
     * @return \DOMElement
     */
    protected function internal_fonticon($fonticon, $classname = '')
    {
        $cn = $this->addNewClassNameToClassList($fonticon, $classname);
        return  $this->_e('i',['class' => $cn, 'aria-hidden' => 'true']);
    }    
    /**
     * Icon Font node, created with attribute label and font icon
     * @param \DOMElement $origin
     * @return array
     */
    protected function internal_icon_text(\DOMElement $origin)
    {
        $cn = [];        
        $label = $fonticon = '';
        if ($origin != null)
        {
            $label = $origin->getAttribute('label');
            $fonticon = $origin->getAttribute('fonticon');
            if ($fonticon)
            {
                $fi = $this->internal_fonticon($fonticon, $origin->getAttribute('class'));
                $this->cleanUpAttributes($fi, ['label','fonticon']);
                $cn[] = $fi;
                $label = !empty ($label) ? ' '.$label : '';
            }
            if ($label)
                $cn[] = $this->_t($label);        
        }        
        return $cn;
    }
    
    /**
     * Bootstrap 3 - button node. The type can be btn-info, btn-success, btn-danger, btn-warning, etc
     * @param \DOMElement $origin
     * @param string $type
     * @return \DOMElement
     */
    protected function internal_button(\DOMElement $origin, $type)
    {
        $cn = $this->internal_icon_text($origin);
        $arr_css_class = ['btn'];
        $arr_css_class[] = $type;
        
        if (is_value_true($origin->getAttribute('block')))
        {
            $arr_css_class[] = 'btn-block';
        }
        $size = $origin->getAttribute('size');
        if ($size == 'large')
        {
            $arr_css_class[] = 'btn-lg';
        } else
        if ($size == 'small')
        {
            $arr_css_class[] = 'btn-sm';
        }                
        //$this->addClassAttribute($type, $css_class);
        $str_css_class = implode(' ', array_unique($arr_css_class));
        
        $n = $this->_elems($origin, 'button', ['type' => 'button', 'class' => $str_css_class], '', $cn);        
        $n = $this->cleanUpAttributes($n, ['fonticon', 'label', 'size', 'block','fonticon']);
        return $n;
    }
    
    
    /**
     * Bootstrap 3 - href button. The type can be btn-info, btn-success, btn-danger, btn-warning, etc
     * @param \DOMElement $origin
     * @param string $type
     * @return \DOMElement
     */
    protected function internal_link_button(\DOMElement $origin, $type)
    {
        $cn = $this->internal_icon_text($origin);
        $arr_css_class = ['btn'];
        $arr_css_class[] = $type;
        $a_href = trim($origin->getAttribute('href'));
        if (empty($a_href))
            $a_href = 'javascript:void(0)';
        if (is_value_true($origin->getAttribute('block')))
        {
            $arr_css_class[] = 'btn-block';
        }
        $size = $origin->getAttribute('size');
        if ($size == 'large')
        {
            $arr_css_class[] = 'btn-lg';
        } else
        if ($size == 'small')
        {
            $arr_css_class[] = 'btn-sm';
        }                
        //$this->addClassAttribute($type, $css_class);
        $str_css_class = implode(' ', array_unique($arr_css_class));
        
        $n = $this->_elems($origin, 'a', ['href' => $a_href, 'class' => $str_css_class], '', $cn);        
        $n = $this->cleanUpAttributes($n, ['fonticon', 'label', 'size', 'block','fonticon']);
        return $n;
    }

    /**
     * Link button
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button (\DOMElement $origin) 
    {                       
        $translate_type = [
            'ok' => 'success',
            'cancel' => 'danger',
            'error' => 'danger',
            'ok' => 'success',
            'warning' => 'warning',
            'primary' => 'primary',
            'info' => 'primary',
            'default' => 'default'
            ];
        $var = 'button-type';
        $type = strtolower(alpha_numeric_only( $origin->getAttribute($var) ));
        if ($translate_type[$type] != null)
            $type = $translate_type[$type];
        $this->cleanUpAttributes($origin, [$var]);
        return $this->internal_button($origin, 'btn-'. $type);
    }
    
    /**
     * Button cancel
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_cancel (\DOMElement $origin) 
    {                       
        return $this->internal_button($origin, 'btn-danger');
    }
    
    /**
     * Button warning
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_warning (\DOMElement $origin) 
    {        
        return $this->internal_button($origin, 'btn-warning');

    }

    /**
     * Button - primary
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_primary (\DOMElement $origin) 
    {        
        return $this->internal_button($origin, 'btn-primary');

    }
    
    /**
     * Button - default
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_default (\DOMElement $origin) 
    {        
        return $this->internal_button($origin, 'btn-default');

    }     
    
    
    /**
     * Button - info
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_info (\DOMElement $origin) 
    {        
        return $this->internal_button($origin, 'btn-info');
    }
    
    /**
     * Button OK
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_button_ok (\DOMElement $origin) 
    {        
        return $this->internal_button($origin, 'btn-success');
    }
    
    /**
     * Link button
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button (\DOMElement $origin) 
    {                       
        $translate_type = [
            'ok' => 'success',
            'cancel' => 'danger',
            'error' => 'danger',
            'ok' => 'success',
            'success' => 'success'
            ];
        $var = 'button-type';
        $type = strtolower(alpha_numeric_only( $origin->getAttribute($var) ));
        if (isset($translate_type[$type]))
            $type = $translate_type[$type];

        $this->cleanUpAttributes($origin, [$var]);
        return $this->internal_link_button($origin, 'btn-'. $type);
    }
    
        
    /**
     * Button cancel
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_cancel (\DOMElement $origin) 
    {                       
        return $this->internal_link_button($origin, 'btn-danger');
    }
    
    /**
     * Button warning
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_warning (\DOMElement $origin) 
    {        
        return $this->internal_link_button($origin, 'btn-warning');

    }

    /**
     * Button - primary
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_primary (\DOMElement $origin) 
    {        
        return $this->internal_link_button($origin, 'btn-primary');

    }
    
    /**
     * Button - default
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_default (\DOMElement $origin) 
    {        
        return $this->internal_link_button($origin, 'btn-default');

    }         
    
    
    /**
     * Button - info
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_info (\DOMElement $origin) 
    {        
        return $this->internal_link_button($origin, 'btn-info');
    }
    
    /**
     * Button OK
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_link_button_ok (\DOMElement $origin) 
    {        
        return $this->internal_link_button($origin, 'btn-success');
    }
    

    
    protected function xui_container(\DOMElement $origin)
    {
        $cn = 'container';
        if ($origin->getAttribute('type') == 'fluid')
        {
            $cn.='-fluid';
        }
        return $this->_elems($origin, 'div', ['class' => $cn]);
    }
    
    protected function xui_well(\DOMElement $origin)
    {
        $cn = 'well';
        switch ($origin->getAttribute('size'))
        {
            case 'large' :
                $cn.= ' well-lg';break;
            case 'small' :
                $cn.= ' well-sm';break;            
        }
        return $this->_elems($origin, 'div', ['class' => $cn]);
    }  
    
    protected function xui_captcha(\DOMElement $origin)
    {
        /*<p class="captcha"><img src="<?= $captchaurl; ?>" alt="Captcha" id="siimage" class="captcha-image" /></p>*/
        
        $captchaurl = \App\Core_Captcha::getURL();
        $img = $this->_e('img', ['src' => $captchaurl, 'alt' => 'captcha', 'class' => 'captcha-image', 'id' => 'siimage']);
        $p = $this->_el('p', ['class' => 'captcha'], $img);
        
        /*<x-ui:textbox id="schlixcontact-verification" name="verification_code" fonticon="far fa-hand-paper fa-lg" placeholder="<?= ___('Please type the random text above') ?>" required="required" label="<?= ___('Human verification') ?>" />*/
        if (empty($origin->getAttribute('placeholder')))
            $origin->setAttribute('placeholder', ___('Please type the random text above'));        
        if (empty($origin->getAttribute('label')) && !is_value_true($origin->getAttribute('data-no-label')))
            $origin->setAttribute('label', ___('Human verification'));
        if (empty($origin->getAttribute('name')))
            $origin->setAttribute('name', 'verification_code');
        //$origin->setAttribute('required','required');        
        
        $textbox =  $this->internal_form_input($origin,'input');
        $w = $this->_e('div',['id' => 'captcha-field']);
        $w->appendChild($p);
        $w->appendChild($textbox);
        return $w;
        
    }
    
    protected  function xui_panel(\DOMElement $origin)
    {
        
        $type = $origin->getAttribute('type');
        $css_class = $type ? "panel {$type}" : 'panel';
        $dlg = $this->_e('div', ['class' => $css_class]);
        $this->copyAttributesFromNode($origin, $dlg);
        
        $c_head = $c_footer = $c_body = null;
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName == 'panel-heading' || $c->localName == 'panel-header')
                $c_head = $this->_elems($c,'div',['class' => 'panel-heading']);
            if ($c->localName == 'panel-body' || $c->localName == 'panel-body')
                $c_body = $this->_elems($c,'div',['class' => 'panel-body']);
            if ($c->localName == 'panel-footer' || $c->localName == 'panel-footer')
                $c_footer = $this->_elems($c,'div',['class' => 'panel-footer']);
        }
        if ($c_head) $dlg->appendChild($c_head); 
        if ($c_body) $dlg->appendChild($c_body);
        if ($c_footer) $dlg->appendChild($c_footer);
        
        $this->cleanUpAttributes($dlg, ['header-label', 'header-label','type']);

        return $dlg;
    }    
    /**
     * Grid - column
     * @param \DOMElement $origin
     */
    protected function xui_column(\DOMElement $origin)
    {
        $cl = []; $g = [];
        $attrs = ['xs','sm','md','lg','xs-offset','sm-offset','md-offset','lg-offset'];
        foreach ($attrs as $a)
            $g[$a] = (int) trim($origin->getAttribute($a));
          
        $cn = '';
        if (___c($g) > 0) 
        {
            foreach ($g as $k => $v) if ($v > 0) {$cl[] = 'col-'.$k.'-'.$v; $origin->removeAttribute($k);}
            $cn = implode(' ', $cl);
        }
        return $this->_elems($origin,'div',['class' => $cn]);
    }
    
    /**
     * Grid - row
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_row(\DOMElement $origin)
    {
        return $this->_elems($origin,'div',['class' => 'row']);
    }    
    
    protected  function xui_schlix_stat_box(\DOMElement $origin)
    {
        $a_css_class = $origin->getAttribute('class');
        $a_number = $origin->getAttribute('header');
        $a_title =  $origin->getAttribute('text');
        $a_icon =  $origin->getAttribute('fonticon');
        $a_href =  $origin->getAttribute('link-url');
        $a_text =  $origin->getAttribute('link-text');
        $a_text = $a_text ? $a_text : ___('More info');
        
        $inner = $this->_el('div', ['class' => 'inner'], 
                        [$this->_es('h3',[], ___h($a_number)),
                        $this->_es('p',null, ___h($a_title))]);
        
        $icon = $this->_el('div', ['class' => 'icon'], $this->_e('i',['class' => $a_icon])) ;
        $node_children = [$inner, $icon];
        if ($a_href)
            $node_children[] = $this->_el('a',['class' => 'small-box-footer', 'href' => $a_href], [ $this->_t($a_text.' '), $this->_e('i',['class' => 'fa fa-arrow-circle-right' ])]);
        $smallbox = $this->_el('div', ['class' => 'small-box '.$a_css_class], $node_children);
        return $smallbox;
                    
        
    }
    
    protected  function xui_schlix_info_box(\DOMElement $origin)
    {
        $a_css_class = $origin->getAttribute('class');
        $a_text =  $origin->getAttribute('link-text');
        $a_no_padding =  $origin->getAttribute('no-padding');
        $a_text = $a_text ? $a_text : ___('More info');
        $a_icon =  $origin->getAttribute('fonticon');
        $b_h = $this->_el('div', ['class' => 'box-header'], 
                        [$this->_el('h3',['class' => 'box-title'],
                                $this->internal_icon_text($origin))]);
        $b_b_class = 'box-body';
        if ($a_no_padding)
            $b_b_class.= ' no-padding';
        $b_b = $this->_elems( $origin, 'div',['class' => $b_b_class]);
        $b_w = $this->_el('div', ['class' => 'box '.$a_css_class ],[$b_h, $b_b]);
        //$smallbox = $this->_el('div', ['class' => 'small-box '.$a_css_class], $node_children);
        $this->cleanUpAttributes($b_b, ['no-padding','link-text']);
        return $b_w;
                    
        
    }
    
    /**
     * SCHLIX - Config action toolbar buttons
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function schlixconfig_action_buttons (\DOMElement $origin) 
    {        
        
        $row = $this->xui_row($origin);
        $df = $this->xui_column($this->_el('column',['md' => 4, 'md-offset' => 8, 'class' => 'text-right', 'schlix-id' => "data-editor-toolbar"]));
        
        //$df = $this->html_document->createDocumentFragment();
        $inner_elems = [];
        $action_suffix =  'item';//$this->getFormDataKey() === 'config' ;
        
        $inner_elems[] = $this->xui_button_ok($this->_el('button-ok', ['type' => 'submit', 'class' => 'schlix-command-button', 'data-schlix-command'=>"save-{$action_suffix}", 'name'=>"btn_save", 'fonticon'=>"fa fa-check", 'label'=> ___('Save')]));
        $inner_elems[] = $this->_nl();
        $inner_elems[] = $this->xui_button_cancel($this->_el('button-cancel', ['type' => 'submit', 'class' => 'schlix-command-button', 'data-schlix-command'=>"cancel-{$action_suffix}", 'name'=>"btn_cancel", 'fonticon'=>"fa fa-times", 'label'=> ___('Cancel')]));
        
        foreach ($inner_elems as $e)
        {
            $df->appendChild($e);
        }
        $row->appendChild($df);
        return $row;
                
    }    
    
    
    /**
     * Autocomplete element with hidden input (for ID). Query must have 2 columns: label and value
     * @param \DOMElement $origin
     * @return \DOMElement
     */    
    protected function xui_schlix_autocomplete_select(\DOMElement $origin) 
    {
        //$url_base = $app_admin_user->createFriendlyAdminURL("action=searchusers");
        //$url_query = "action=searchusers&keyword={keyword}";
        $current_real_input_value = $this->getInputValue($origin); 
        $current_display_value = '';
        if (!empty($current_real_input_value ))
        {
            $current_display_value = $origin->getAttribute('data-initial-display-value');
        }
         //echo "X$current_value;die;
        $df = $this->html_document->createDocumentFragment();
        $id = $origin->getAttribute('id');
        $required = $origin->getAttribute('required');
        $url_base  = $origin->getAttribute('data-url-base');
        $url_query = $origin->getAttribute('data-url-query');
        
        
        if (empty($id))
            throw new \Exception ("ID cannot be empty for user selection");
        if (empty($url_base))
            throw new \Exception ("data-url-base must be specified for {$id}");
        
        $attrs = [ 'class' => 'schlix-cms-autocomplete-select',
            'data-url-base' => $url_base,
            'data-force-select' => 1
            ];
        if (!empty($required))
            $attrs['required'] = 'required';
        $txt_hidden = $this->xui_hidden($this->_elems($origin, 'hidden', $attrs));
        $display_node = $this->_elems($origin, 'textbox');
        $display_node->setAttribute('id', $id.'_schlix_autocomplete_textbox');
        $display_node->setAttribute('value', $current_display_value);
        $display_node->removeAttribute('data-field');
        $display_node->removeAttribute('data-var');
        $display_node->removeAttribute('name');
        $display_node->removeAttribute('required');
        $txt_display = $this->xui_textbox($display_node);
        
        $ac_container = $this->_el('div', ['id' =>$id.'_schlix_autocomplete_container']);
        
        $this->cleanUpAttributes($txt_display, ['fonticon', 'label']);
         $this->cleanUpAttributes($txt_hidden, ['fonticon','label','prefix','suffix','suffix-fonticon','disable-form-group','has-warning','has-error','data-field','data-var','data-limit-width', 'input-size', 'input-group-size', 'help-text']);
         
        $df->appendChild($txt_display);
        $df->appendChild($txt_hidden);
        $df->appendChild($ac_container);
        return $df;
        
    }
    
    /**
     * User selection
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_user_select(\DOMElement $origin) 
    {
        global $CurrentUser;
        
        $app_admin_user = new \App\Users_Admin();
        $url_base = $app_admin_user->createFriendlyAdminURL("action=searchusers");
        $url_query = "action=searchusers&keyword={keyword}";
        $current_uid = (int) $this->getInputValue($origin); 
        $user_display_value = '';
        if ($current_uid > 0)
        {
            $user = $CurrentUser->getUserByID($current_uid);
            if ($user)
            {
                $user_display_value = $user['username'].' - '.$user['email_address'];
            }
        }
        
        $attrs = [
            'data-url-base' => $url_base,
            'data-url-query' => $url_query,            
        ];
        if (!empty($user_display_value))
            $attrs['data-initial-display-value'] = $user_display_value;
        
        $el = $this->xui_schlix_autocomplete_select($this->_elems($origin, 'xui-schlix-user-select', $attrs));
        return $el; 
    }
    
    
    /**
     * Tag box - for keywords, etc
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_tagbox(\DOMElement $origin)
    {        
        /*$n = $this->xui_textbox($this->_elems($origin, 'textbox', ['data-tagfield'=>"true" ]));
        $this->cleanUpAttributes($n, ['fonticon', 'label']);*/
        
        $app_admin_tag = new \App\Tag_Admin();
        
        $url_base = $app_admin_tag->createFriendlyAdminURL("action=searchtags");
        
        $df = $this->html_document->createDocumentFragment();
        $id = $origin->getAttribute('id');
        $required = $origin->getAttribute('required');
        
        
        if (empty($id))
            throw new \Exception ("ID cannot be empty for tag selection");
        
        $attrs = [ 'data-tagfield' => 'true',
            'data-url-base' => $url_base,
            ];
        if (!empty($required))
            $attrs['required'] = 'required'; 
        //$txt_display = $this->xui_textbox($);
        $txt_display =  $this->xui_textbox($this->_elems($origin, 'textbox', $attrs));
        
        $ac_container = $this->_el('div', ['id' =>$id.'_schlix_tagbox_container']);
        
        $this->cleanUpAttributes($txt_display, ['fonticon', 'label']);
            
         
        $df->appendChild($txt_display); 
        $df->appendChild($ac_container);
        return $df;

    }
    
    /**
     * SCHLIX - Editor action toolbar buttons
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_editor_action_buttons (\DOMElement $origin) 
    {        
        $app_admin = $this->getApp();
        if ($this->isAdminApp())        
        {
            $df = $this->html_document->createDocumentFragment();
            $inner_elems = [];
            $action_suffix = $this->getFormDataKey() === 'category' ? 'category' : 'item' ;

            //$a_legacy = is_value_true($origin->getAttribute('legacy'));
            $a_ajax_only = is_value_true($origin->getAttribute('data-force-ajax'));
            
            if (!$a_ajax_only)
            {
                $inner_elems[] = $this->xui_button_ok($this->_el('button-ok', ['type' => 'submit', 'class' => 'schlix-command-button', 'data-schlix-command'=>"save-{$action_suffix}", 'name'=>"btn_save", 'fonticon'=>"fa fa-check", 'label'=> ___('Save')]));
                $inner_elems[] = $this->_nl();
                $inner_elems[] = $this->xui_button_info($this->_el('button-info', ['type' => 'submit', 'class' => 'schlix-command-button', 'data-schlix-command'=>"apply-{$action_suffix}", 'name'=>"btn_save", 'fonticon'=>"far fa-caret-square-right", 'label'=> ___('Apply')]));
            } else 
            {
                $inner_elems[] = $this->xui_button_ok($this->_el('button-ok', ['type' => 'submit', 'class' => 'schlix-command-button', 'data-schlix-command'=>"apply-{$action_suffix}", 'name'=>"btn_save", 'fonticon'=>"fas fa-check", 'label'=> ___('Save')]));
            }
            $close_href = $app_admin->createFriendlyAdminURL('');
            $inner_elems[] = $this->_nl();
            $a_cancel_user_history = is_value_true($origin->getAttribute('data-close-button-back'));
            $cancel_attrs = ['href' => $close_href, 'class' => 'schlix-command-button', 'data-schlix-command'=>"cancel-{$action_suffix}", 'name'=>"btn_cancel", 'fonticon'=>"fa fa-times", 'label'=> ___('Close')];
            if ($a_cancel_user_history)
            {
                $cancel_attrs['data-close-button-back'] = 1;
            }
            $inner_elems[] = $this->xui_link_button_cancel($this->_el('button-cancel', $cancel_attrs));
            foreach ($inner_elems as $e)
                $df->appendChild($e);
        }
        return $df;
                
    }    

    protected function xui_schlix_editor_button_cancel (\DOMElement $origin) 
    {        
        $app_admin = $this->getApp();
        if ($this->isAdminApp())        
        {
            $action_suffix = $this->getFormDataKey() === 'category' ? 'category' : 'item' ;
            
            $df = $this->html_document->createDocumentFragment();
            $inner_elems = [];
            $close_href = $app_admin->createFriendlyAdminURL('');
            $inner_elems[] = $this->_nl();
            $a_cancel_user_history = is_value_true($origin->getAttribute('data-close-button-back'));
            $cancel_attrs = ['href' => $close_href, 'class' => 'schlix-command-button', 'data-schlix-command'=>"cancel-{$action_suffix}", 'name'=>"btn_cancel", 'fonticon'=>"fa fa-times", 'label'=> ___('Close')];
            if ($a_cancel_user_history)
            {
                $cancel_attrs['data-close-button-back'] = 1;
            }
            $inner_elems[] = $this->xui_link_button_cancel($this->_el('button-cancel', $cancel_attrs));
            foreach ($inner_elems as $e)
                $df->appendChild($e);
        }
        return $df;
                
    }    

    /**
     * Bootstrap 3 - radio or checkbox
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    private function internal_radio_checkbox(\DOMElement $origin, $standalone, $class_name, $field_value = '1', $add_default_hidden = true)
    {   
        $a_name = trim($origin->getAttribute('name'));
        $a_inline = is_value_true($origin->getAttribute('inline'));
        $a_no_wrapper = is_value_true($origin->getAttribute('no-wrapper'));
        $a_datafield = trim($origin->getAttribute('data-field'));
        $a_disabled = is_value_true($origin->getAttribute('disabled'));
        $a_label = $origin->getAttribute('label');
        $a_fonticon = $origin->getAttribute('fonticon');
        $a_inline = is_value_true($origin->getAttribute('inline'));
        $a_no_hidden = is_value_true($origin->getAttribute('no-hidden'));
        $a_has_warning = is_value_true($origin->getAttribute('has-warning'));
        $orig_value =  $origin->getAttribute('value');
        $css_class = $class_name;
        if ($a_inline)
            $css_class.= '-inline';                
        if (!empty($a_disabled))
            $css_class = $this->addNewClassNameToClassList ($css_class, 'disabled');
        if (!empty($a_datafield) && empty($a_name))
            $a_name = $a_datafield;

        if ($a_has_warning)
            $css_class = $this->addNewClassNameToClassList ($css_class, 'has-warning');
        $div = $a_no_wrapper ? $this->_n() : $this->_el('div', ['class' => $css_class]);
        if (!empty($a_name) && $add_default_hidden && !$a_no_hidden)
        {
            $h = $this->_e('input', ['type' => 'hidden', 'name' => $a_name,'value' => '0']);
            $div->appendChild($h);
        }
        $input_attr = ['type' => $class_name];        
        $is_checked = $this->getRadioCheckboxCheckedValue($origin, $standalone);
        if ($is_checked)
            $input_attr['checked'] = 'checked';
        $input = $this->_input($origin, 'input', $input_attr);
        $this->cleanUpAttributes($input, ['label', 'data-field','fonticon','has-warning','default-value','no-wrapper']);        
        
        $input->setAttribute('value', empty($input->getAttribute('value')) ? $field_value : $orig_value);
        
        if ($a_label || $a_fonticon)
        {
            $label = $this->_el('label');
            $label->appendChild($input);
            if ($a_fonticon)
            {
                $fonticon = $this->internal_fonticon($a_fonticon);
                $label->appendChild($fonticon);
            }
            $label->appendChild($this->_t(' '));
            $label->appendChild($this->_e('span', null,trim($a_label)));
            $div->appendChild($label);
            
            //$label = $this->_el('label', $attr_label.' ');
        } else 
        {
            $lbl = $this->_e('label');
            $lbl->appendChild($input);
            $this->cloneChildNodes($origin, $lbl);
            $div->appendChild($lbl);
            
        }
        return $div;
    }

    /**
     * Radio box
     * @param \DOMElement $origin
     * @return \DOMElement
     */    
    protected function xui_radio(\DOMElement $origin) 
    {
        return $this->internal_radio_checkbox($origin, true, 'radio');
    }

    /**
     * Checkbox
     * @param \DOMElement $origin
     * @return \DOMElement
     */    
    protected function xui_checkbox(\DOMElement $origin) 
    {
        return $this->internal_radio_checkbox($origin, true, 'checkbox');
    }       
    
    /**
     * Fieldset
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_fieldset(\DOMElement $origin)
    {
        
        $a_label = $origin->getAttribute('label');
        $parent = null;
        $fieldset = $this->_e('fieldset');
        if ($a_label)
        {            
            $legend = $this->_e('legend', null, $a_label);
            $fieldset->appendChild($legend);            
        }
        return $fieldset;
    }
    
    
    /**
     * @internal Internal function to generate radio/checkbox option. 
     * @param \DOMElement $origin
     * @param \DOMElement $parent
     * @param string $input_type
     * @param string $a_name
     * @param string $option_item_value
     * @param string $option_item_label
     * @param bool $is_multi
     * @param string|array $current_value
     * @param string|array $default_value
     * @param string|array $multi_default_value
     */
    private function internal_radio_checkbox_option($origin, $parent, $input_type, $a_name, $option_item_value, $option_item_label, $is_multi, $current_value, $default_value, $multi_default_value)
    {
        $new_node_attrs = ['name' => $a_name, 'value' => $option_item_value, 'label' => $option_item_label];
        $current_value = $is_multi ? $current_value : strval($current_value);
        $option_item_value = strval($option_item_value);
        
        $is_selected = $is_multi ? !isset($current_value) ? (___c($multi_default_value) > 0 ? in_array($option_item_value, $multi_default_value) : false) : (is_array($current_value) && in_array($option_item_value, $current_value)) : 
            (!isset($current_value) ? (!empty($default_value) && $default_value == $option_item_value) : ($current_value == $option_item_value));
        
        if ($is_selected)
            $new_node_attrs['checked'] = 'checked';

        if ($origin == null)
            $origin = $this->_e($input_type, $new_node_attrs);
        else 
        {
            foreach ($new_node_attrs as $k => $v)
                $origin->setAttribute ($k, $v);
        }
        $el_opt = $this->internal_radio_checkbox(  $origin, false, $input_type,  $option_item_value, false);
        $parent->appendChild($this->_nl());
        $parent->appendChild($el_opt);
        
    }
       /**
     * @internal Internal function to generate radio/checkbox option. 
     * @param \DOMElement $origin
     * @param \DOMElement $parent
     * @param string $input_type
     * @param string $a_name
     * @param string $option_item_value
     * @param string $option_item_label
     * @param bool $is_multi
     * @param string|array $current_value
     * @param string|array $default_value
     * @param string|array $multi_default_value
     */
    private function internal_select_option($origin, $parent, $a_name, $option_item_value, $option_item_label, $is_multi, $current_value, $default_value, $multi_default_value)
    {
        $new_node_attrs = ['name' => $a_name, 'value' => $option_item_value, 'label' => $option_item_label];
        
        $is_selected = $is_multi ? empty($current_value) ? (___c($multi_default_value) > 0 ? in_array($option_item_value, $multi_default_value) : false) : (is_array($current_value) && in_array($option_item_value, $current_value)) : 
            (empty($current_value) ? (!empty($default_value) && $default_value == $option_item_value) : ($current_value == $option_item_value));                
        if ($is_selected)
            $new_node_attrs['selected'] = 'selected';

        if ($origin == null)
        {
            $origin = $this->_e('option', $new_node_attrs);
        }
            
        $a_name = trim($origin->getAttribute('name'));
        $a_datafield = trim($origin->getAttribute('data-field'));
        $a_disabled = trim($origin->getAttribute('disabled'));
        $a_id = trim($origin->getAttribute('id'));
        $a_class = trim($origin->getAttribute('class'));
        if (!empty($a_id))
            $new_node_attrs['id'] = $a_id;
        if (!empty($a_class))
            $new_node_attrs['class'] = $a_class;       
        if (!empty($a_disabled))
            $new_node_attrs['disabled'] = 'disabled';
        if (!empty($a_datafield) && empty($a_name))
            $a_name = $a_datafield;
        
        $df = $this->_n();
        /*if (!empty($a_name) && $add_default_hidden)
        {
            $h = $this->_e('input', ['type' => 'hidden', 'name' => $a_name,'value' => '0']);
            $df->appendChild($h);
        }*/
        //$input_attr = ['value' => $option_item_value];                
        
        if ($is_selected)
              $new_node_attrs['selected'] = 'selected';
        //$input = $this->_e('option', $new_node_attrs, $option_item_label);
        $input = $this->_input($origin, 'option', $new_node_attrs, $option_item_label);
        $this->cleanUpAttributes($input, ['name', 'label']);
        
        $df->appendChild($input);
        
        $parent->appendChild($this->_nl());
        $parent->appendChild($df);
        
    }
 

    protected function schlixconfig_dropdownlist(\DOMElement $origin) {
        
        $tag_conf = $this->parseAttributes($origin);
        
        foreach ($tag_conf as $k => $v)
        {
            if ($k != 'attributes' && $k != 'default_value')
                $origin->setAttribute($k, $v);
        }
        foreach ($tag_conf['attributes'] as $k => $v)
        {
                $origin->setAttribute($k, $v);
        }
        
        if ($tag_conf['default_value'])        
            $origin->setAttribute('default-value',$tag_conf['default_value']);
        return $this->xui_select($origin);
        
        /* old code - TODO: remove
            $new_node_options = $this->parseAttributes($origin);
            $attr = $new_node_options['attributes'];
            $config_key = $new_node_options['name'];


            $config_value = $this->getFormData($config_key); // $this->getFormData($config_key);

            //$dd = $this->_elems($origin, 'select');

            $parent = $this->_e('div', array(
                'id' => 'select_' . $new_node_options['name'],
                'class' => 'select'));

            $select_elem = $this->_e('select', array(
                'id' => $new_node_options['name'],
                'class'=> 'form-control',
                'name' => $new_node_options['name'])
            );
            foreach ($attr as $key => $value) {
                $select_elem->setAttribute($key, $value);
            }
            $multi_select = isset($attr['multiple']);
            if ($origin->hasChildNodes()) {
                foreach ($origin->childNodes as $old_child_node) {
                    if ($old_child_node->nodeName === 'schlix-config:option') {
                        $newnode = $this->_e('option', array(
                            'value' => $old_child_node->getAttribute('value')), $old_child_node->nodeValue);

                        $is_selected = $multi_select ? (is_array($config_value) && in_array($old_child_node->getAttribute('value'), $config_value)) : ($config_value == $old_child_node->getAttribute('value'));
                        if ($is_selected) {
                            $newnode->setAttribute('selected', 'selected');
                        }
                        $select_elem->appendChild($newnode);
                    }
                }
                // Now the legend and fieldset

                if ($new_node_options['label']) {
                    $newnode_label = $this->_e('label', array('for' => $new_node_options['name']), $new_node_options['label']);
                    $parent->appendChild($newnode_label);
                }
                $parent->appendChild($select_elem);
                return $parent;
            }
         * 
         */
    }    
    /**
     * Select box
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_select(\DOMElement $origin)
    {
        $a_name = $this->safe_attribute_name( trim($origin->getAttribute('name')));
        //$a_datafield = trim($origin->getAttribute('data-field'));
        //$a_datavar = trim($origin->getAttribute('data-var'));
        $default_value = $origin->getAttribute('default-value');
        
        $multi_select = !empty($origin->getAttribute('multiple'));
        if ($multi_select && !str_ends_with($a_name, '[]'))
            $a_name.= '[]';
        
        $full_tag_parent = $this->internal_form_input($origin, 'select');
        
        $parent = null;        
        $f_tagname = isset($full_tag_parent->tagName) ? $full_tag_parent->tagName : '';
        if ($f_tagname != 'select')
        {
            foreach ($full_tag_parent->childNodes as $n)
            {
                if ($n->tagName == 'select')
                {                    
                    $parent = $n;
                    break;
                } else if ($n->tagName == 'div')
                {
                    foreach ($n->childNodes as $nnn) if ($nnn->tagName == 'select')
                    {
                        $parent = $nnn;break;
                    }
                }
                
            }
        } else $parent = $full_tag_parent;
        $current_value = $this->getInputValue($origin);  // this gets called twice. FIXME        
        
        $parent->appendChild($this->_nl());        
        
        $multi_default_value = [];
        $is_multi = str_ends_with($a_name, '[]');
        //$current_value = $this->getFormData($a_datafield);
        if (is_serialized($current_value) && $is_multi)
            $current_value = unserialize ($current_value);
        
        if ($is_multi && !empty($default_value))
        {
            // for checkboxgroup default values
            $trimmed_default_value = trim($default_value);
            if ($trimmed_default_value)
                $trimmed_default_value = preg_replace('#\s{1,}#', '', $trimmed_default_value);
            $multi_default_value = explode(',', trim($trimmed_default_value));
        }
        
        /// Iterate option nodes
        if ($origin->hasChildNodes()) {
            foreach ($origin->childNodes as $c) {
                //if ($c->nodeName === 'x-ui:option') {                 
                if ($c->localName === 'option') {   
                    $option_item_label = trim($c->getAttribute('label'));
                    $option_item_value = trim($c->getAttribute('value'));
                    if (empty($option_item_label))
                    {
                        $nv = trim($c->nodeValue);
                        
                        $option_item_label = $nv ? $nv : $option_item_value;
                    }
                    // set origin to c - 2019-06-28
                    $this->internal_select_option($c, $parent, $a_name, $option_item_value, $option_item_label, 
                            $is_multi, $current_value, $default_value, $multi_default_value);
                    
                } else
                if ($c->localName === 'optgroup') {
                    
                    $opt_group_label = trim($c->getAttribute('label'));
                    if ($c->hasChildNodes())
                    {
                        $optgroup = $this->_e('optgroup', ['label' => $opt_group_label]);
                        $parent->appendChild($optgroup);
                        foreach ($c->childNodes as $d)
                        {
                            if ($d->localName === 'option') {   
                            $option_item_label = trim($d->getAttribute('label'));
                            $option_item_value = trim($d->getAttribute('value'));
                            if (empty($option_item_label))
                                $option_item_label = $option_item_value;
                            $this->internal_select_option($d, $optgroup, $a_name, $option_item_value, $option_item_label, 
                                    $is_multi, $current_value, $default_value, $multi_default_value);
                            }
                            
                        }
                    }
                }
            }
        } else 
        {
            $fld_label = 'label';
            $fld_value = 'value';
            $a_data_options_var = $origin->getAttribute('data-options-var');
            if (array_key_exists($a_data_options_var, $this->data))
            {
                
                $arr_options = $this->data[$a_data_options_var];
                if (___c($arr_options) > 0)
                {                    
                    $first_val = array_values($arr_options)[0];
                    if (is_array($first_val) && array_key_exists($fld_label, $first_val) && array_key_exists($fld_value, $first_val))
                    {
                        foreach ($arr_options as $the_option)
                        {
                            $option_item_label = $the_option[$fld_label];
                            $option_item_value = $the_option[$fld_value];
                            $this->internal_select_option(null, $parent, $a_name, $option_item_value, $option_item_label, 
                                    $is_multi, $current_value, $default_value, $multi_default_value);
                        }
                    } elseif (is_string($first_val) || is_int($first_val))
                    {
                        foreach ($arr_options as $option_item_value => $option_item_label)
                        {
                            $this->internal_select_option(null, $parent, $a_name, $option_item_value, $option_item_label, 
                                    $is_multi, $current_value, $default_value, $multi_default_value);
                        }
                        
                    }
                    
                }
                
            }
            
        }
        
        
        return $full_tag_parent;
    }
        
    

    /**
     * Generates radio/checkbox group
     * @param \DOMElement $origin
     * @param string $input_type
     * @return \DOMElement
     */
    
    protected function internal_radio_checkbox_group(\DOMElement $origin, $input_type)
    {
        $a_name = $this->safe_attribute_name( trim($origin->getAttribute('name')));
        if ($input_type == 'checkbox' && !str_ends_with($a_name, '[]'))
            $a_name.= '[]';
        //$a_datafield = trim($origin->getAttribute('data-field'));
        $a_inline = is_value_true($origin->getAttribute('inline'));
        $a_label = $origin->getAttribute('label');
        $default_value = $origin->getAttribute('default-value');
        
        $a_data_options_var = $origin->getAttribute('data-options-var');
        $a_data_options_label_field = $origin->getAttribute('data-options-label-field');
        $a_data_options_value_field = $origin->getAttribute('data-options-value_field');
        $parent = !empty($a_label) ?  $this->xui_fieldset($origin) : $this->_n();
        $parent->appendChild($this->_nl());
        
        $multi_default_value = [];
        $is_multi = $input_type == 'checkbox'; // str_ends_with($a_name, '[]');
        $current_value = $this->getInputValue($origin); 
        
        if (is_serialized($current_value) && $is_multi)
            $current_value = unserialize ($current_value);
        if ($is_multi && !empty($default_value))
        {
            
            // for checkboxgroup default values
            $trimmed_default_value = trim($default_value);
            if ($trimmed_default_value)
                $trimmed_default_value = preg_replace('#\s{1,}#', '', $trimmed_default_value);
            $multi_default_value = explode(',', trim($trimmed_default_value));
        }
        /// Iterate option nodes
        if ($origin->hasChildNodes()) {
            foreach ($origin->childNodes as $c) {
                $c_tag_name = isset($c->tagName) ? $c->tagName : '';
                if ($c->localName === 'option' || $c_tag_name) {   
                    
                    $option_item_label = trim($c->getAttribute('label'));
                    $option_item_value = trim($c->getAttribute('value'));
                    
                        
                    if ($a_inline)
                        $c->setAttribute('inline','true');
                    /*if (empty($option_item_label))
                        $option_item_label = $c->nodeValue;*/
                    $this->internal_radio_checkbox_option($c, $parent, $input_type, $a_name, $option_item_value, $option_item_label, 
                            $is_multi, $current_value, $default_value, $multi_default_value);
                    
                }
            }
        } else 
        {
            $fld_label = $a_data_options_label_field ? $a_data_options_label_field : 'label';
            $fld_value = $a_data_options_value_field ? $a_data_options_value_field : 'value';
            $a_data_options_var = $origin->getAttribute('data-options-var');
            if (array_key_exists($a_data_options_var, $this->data))
            {
                
                $arr_options = $this->data[$a_data_options_var];
                if (___c($arr_options) > 0)
                {                    
                    $first_val = array_values($arr_options)[0];
                    if (is_array($first_val) && array_key_exists($fld_label, $first_val) && array_key_exists($fld_value, $first_val))
                    {
                        foreach ($arr_options as $the_option)
                        {
                            $option_item_label = $the_option[$fld_label];
                            $option_item_value = $the_option[$fld_value];
                            $this->internal_radio_checkbox_option(null, $parent, $input_type, $a_name, $option_item_value, $option_item_label, 
                                    $is_multi, $current_value, $default_value, $multi_default_value);
                        }
                    } elseif (is_string($first_val) || is_int($first_val))
                    {
                        foreach ($arr_options as $option_item_value => $option_item_label)
                        {
                            $this->internal_radio_checkbox_option(null, $parent, $input_type, $a_name, $option_item_value, $option_item_label, 
                                    $is_multi, $current_value, $default_value, $multi_default_value);
                        }
                        
                    }
                    
                }
                
            }
            
        }
        
        if ($is_multi)
        {
            $h = $this->_e('input', ['type' => 'hidden', 'name' => $a_name,'value' => '']);
            $parent->appendChild($this->_nl());
            $parent->appendChild($h);
            $parent->appendChild($this->_nl());
        }
        
        
        return $parent;
        
    }

    /**
     * Radio group
     * @param \DOMElement $origin
     * @return \DOMElement
     */    
    protected function xui_radio_group(\DOMElement $origin)
    {
        return $this->internal_radio_checkbox_group($origin, 'radio');
        
    }
    /**
     * Checkbox group
     * @param \DOMElement $origin
     * @return \DOMElement
     */

    protected function xui_checkbox_group(\DOMElement $origin)
    {
        return $this->internal_radio_checkbox_group($origin, 'checkbox');
    }
    

    /**
     * Text Area
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_wysiwyg(\DOMElement $origin) 
    {
        $input = $this->internal_form_input($origin, 'textarea', 'wysiwyg');
        return $input;
    }
    
    /**
     * Text Area
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_textarea(\DOMElement $origin) 
    {
        $input = $this->internal_form_input($origin, 'textarea', 'form-control');
        return $input;
    }
    
    /**
     * Datetime picker with SCHLIX UI - to be changed
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_datetime_picker(\DOMElement $origin) {
        $orig_id = $origin->getAttribute('id');
        $n = $this->xui_textbox($this->_elems($origin, 'textbox', ['suffix-fonticon' => 'fas fa-calendar-alt', 'data-limit-width' => 200, 'class' => 'schlix-datetime-picker']));
        foreach ($n->childNodes as $c) {
            $str_class = $c->getAttribute('class');
            $arr_class = explode(' ', $str_class);
            
            if (___c($arr_class) > 0 && in_array('input-group', $arr_class)) {

                foreach ($c->childNodes as $b) {
                    if ($b->getAttribute('class') == 'input-group-addon') {

                        $class_name = $this->addNewClassNameToClassList($b->getAttribute('class'), 'schlix-datetime-picker-handle');
                        $b->setAttribute('class', $class_name);
                        $b->setAttribute('data-target', $orig_id);
                        return $n;
                    }
                }
            } else // DONT DELETE for cases where there is no form-group (1 level)
            if ($c->getAttribute('class') == 'input-group-addon') {

                $class_name = $this->addNewClassNameToClassList($c->getAttribute('class'), 'schlix-datetime-picker-handle');
                $c->setAttribute('class', $class_name);
                $c->setAttribute('data-target', $orig_id);
                return $n;
            }
        }
        return $n;
    }

    /**
     * Editor control - user selection
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_user_selection(\DOMElement $origin)
    {
        if ($this->isAdminApp())
        {
            $datafield = $origin->getAttribute('data-field');
            $html =  \INPUT::UserNameSelectionField($datafield, $this->getFormData($datafield), $origin->getAttribute('label'), array('class'=>'form-control'));
            return $this->html2node($html);
        }
        return null;

        
    }
    
    /**
     * Editor control - read permission
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_permission_read(\DOMElement $origin)
    {
        //$app_admin = $this->getApp();
        if ($this->isAdminApp())
        {
            $datafield = $origin->getAttribute('data-field');
            $label = $origin->getAttribute('label');
            if (empty($label))
                $label = ___('Who can read this page?');
            $header = '<fieldset id="fieldset_permission_read"><legend>'.$label.'</legend>';
            $html =  \INPUT::UserGroupReadPermissionCheckboxGroup('read', $this->getFormData($datafield));
            $footer = '</fieldset>';
            return $this->addCustomHTML($header.$html.$footer);
        }
        return null;
        
    }

    /**
     * Editor control - write permission
     * @param \DOMElement $origin
     * @return \DOMElement
     */    
    protected function xui_schlix_permission_write(\DOMElement $origin)
    {
        global $CurrentUser;
        
        //return null;
        if ($this->isAdminApp())
        {
            $datafield = $origin->getAttribute('data-field');
            $label = $origin->getAttribute('label');
            if (empty($label))
                $label = ___('Who can modify this page?');            
            $header = '<fieldset id="fieldset_permission_write"><legend>'.$label.'</legend>';
            //<?= \INPUT::UserGroupWritePermissionCheckboxGroup('write', $category['permission_write'], $CurrentUser->getCurrentUserGroupIDs(), false) 
            $html =  \INPUT::UserGroupWritePermissionCheckboxGroup('write', $this->getFormData($datafield), $CurrentUser->getCurrentUserGroupIDs(), false);
            $footer = '</fieldset>';
            return $this->addCustomHTML($header.$html.$footer);
        }
        
    }
    
    
    protected function xui_members_mainpage_column_box(\DOMElement $origin)
    {
/* <x-ui:column md="4" sm="4">          
 *  <x-ui:well size="small">
                <h4>
                    <span class="fa-stack fa-3x">
                        <i class="far fa-circle fa-stack-2x"></i>
                        <i class="fa fa-user fa-stack-1x"></i>
                    </span>    
                    <?= $user['firstname'] ?>&nbsp;<?= $user['lastname'] ?></h4>
                <hr />
                
            </x-ui:well>
*/   
        $url = $origin->getAttribute('url');
        $lg = $origin->getAttribute('large');
        $md = $origin->getAttribute('medium');
        $sm = $origin->getAttribute('small');
        $large_label = $origin->getAttribute('large-label');
        $small_label = $origin->getAttribute('small-label');
        $large_icon = $origin->getAttribute('large-icon');
        $small_icon = $origin->getAttribute('small-icon');
        
        $maintext = null;
        foreach ($origin->childNodes as $cn)
        {
            if ($cn->tagName === 'x-ui:inner-text')
            {
                $maintext = $this->_n();
                $this->cloneChildNodes($cn, $maintext);
            }
        }
        
        $col_class = [];
        if (!empty($lg)) $col_class[] = "col-lg-{$lg}";
        if (!empty($md)) $col_class[] = "col-md-{$md}";
        if (!empty($sm)) $col_class[] = "col-sm-{$sm}";
        if (count($col_class) == 0)
        {
            $col_class[] = 'col-md-4';
            $col_class[] = 'col-sm-4';
        }
        $str_col_class = implode(' ', $col_class);
        $column = $this->_e('div',['class' => $str_col_class]);
        $well = $this->_e('div', ['class' => 'well well-sm']);
        $h4 = null;
        
        if ($large_label)
        {
            $h4 = $this->_e('h4');
            if ($large_icon)
            {
                $span = $this->_e('span',['class' => 'fa-stack fa-3x']);
                $icon1 = $this->internal_fonticon('far fa-circle fa-stack-2x');
                $icon2 = $this->internal_fonticon($large_icon.' fa-stack-1x');
                $span->appendChild($icon1);
                $span->appendChild($icon2);
                $h4->appendChild($span);    
                $h4->appendChild($this->_nl());
            }   
            $h4->appendChild($this->_t($large_label));
            $well->appendChild($h4);
        } else if ($maintext != null)
        {
            $h4 = $this->_el('h4', null, $maintext);
            $well->appendChild($h4);
        }
        if ($large_label && $small_label)
            $well->appendChild($this->_e('hr'));
        /*<div class="text-right" ><a href="<?= $this->createFriendlyURL('action=myprofile'); ?>"><i class="fa fa-edit"></i> <?= ___('Edit Profile'); ?></a></div>*/
        $footer = null;
        if ($small_label)
        {
            $footer = $this->_el('div',['class' => 'text-right']);
            $url_label = $this->internal_icon_text( $this->_el('div',['label' => $small_label, 'fonticon' => $small_icon]) );
            $urlnode = $this->_el('a',['href' => $url], $url_label);
            $footer->appendChild($urlnode);
            $well->appendChild($footer);
        }
        if ($small_label && !$large_label)
        {
            $well->setAttribute('class', '');
        }
        $column->appendChild($well);
        return $column;

    }
    
    /**
     * Versioning control
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_versioning_control(\DOMElement $origin)
    {
        
        $app_admin = $this->getApp();
        if ($this->isAdminApp())
        {
            ob_start();
            $version_admin_app = new \App\Core_Versioning_Admin();
            $version_admin_app->viewApplicationVersioning($app_admin->frontendApp()->getApplicationNameOnly(), $this->getFormData('guid'));
            // old version
            //\App\Core_Versioning_Admin::displayVersioningGrid($app_admin->frontendApp()->getApplicationNameOnly(), $this->getFormData('guid'));
            $html = ob_get_contents();
            
            ob_end_clean();
            
            return $this->addCustomHTML($html);            
        }
    }
    
    
    /**
     * Returns item meta options
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected  function xui_schlix_editor_item_meta_options(\DOMElement $origin)
    {
        $app_admin = $this->getApp();
        if ($this->isAdminApp())
        {
            $meta_option_keys = $app_admin->frontendApp()->getItemMetaOptionKeys();
            $default_values = $app_admin->frontendApp()->getDefaultItemMetaOptionKeys();
            $max_item_per_column = $origin->getAttribute('max-item-per-column');
            $column_count = $origin->getAttribute('column');
            $datafield = $origin->getAttribute('name');
            $current_value = $this->getInputValue($origin);
            $html = \INPUT::CMSObjectOptions($datafield, $meta_option_keys, $current_value, $default_values, $max_item_per_column, $column_count); 

            return $this->addCustomHTML($html);
        }
        return null;
    }
    
    /**
     * Returns item meta options
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected  function xui_schlix_editor_category_meta_options(\DOMElement $origin)
    {
        $app_admin = $this->getApp();
        if ($this->isAdminApp())
        {
            $meta_option_keys = $app_admin->frontendApp()->getCategoryMetaOptionKeys();
            $default_values = $app_admin->frontendApp()->getDefaultCategoryMetaOptionKeys();
            $max_item_per_column = $origin->getAttribute('max-item-per-column');
            $column_count = $origin->getAttribute('column');
            $datafield = $origin->getAttribute('name');
            $current_value = $this->getInputValue($origin);
            $html = \INPUT::CMSObjectOptions($datafield, $meta_option_keys, $current_value, $default_values, $max_item_per_column, $column_count); 

            return $this->addCustomHTML($html);
        }
        return null;
    }    
    
            
    protected function schlix_multi_category_tree_editor_ul($parent, $depth)
    {
        $attrs = ['class' => 'schlix-list-no-style'];  
        return $this->_e('ul', $attrs);
    } 
                
    /**
     * 
     * @param array $data
     * @param \DOMElement $childnodes
     * @param string $field_id
     * @param string $field_cid
     * @param string $field_title
     * @param bool $has_primary_category
     * @return \DOMElement
     */
    protected function schlix_multi_category_tree_editor_li_with_primary_category($data, $childnodes, $field_id, $field_cid, $field_title = 'title', $primary_category_text = 'Primary Category', $has_primary_category = false)
    {
        $attrs = null;
        $icontext = $this->internal_icon_text($this->_e('i', ['label' => $data[$field_title], 'fonticon' => 'fa fa-folder', 'class' => 'text-orange']));
        //foreach ($icontext as $it) $lbl->appendChild($it);
        //$li = $this->_es('li', $attrs, $data['title']);
        $li = $this->_e('li', $attrs);
        $cid = (int) $data[$field_cid];
        $data_field_id = !empty($data[$field_id]) ? $data[$field_id] : 0;
        $checked =  $data_field_id > 0;
        if ($this->data[$field_id] == 'new')
        {
            $browse_cat_id =  fcookie_int($this->getApp()->frontendApp()->getApplicationNameOnly() . '_currentCategory');   
            if ($browse_cat_id > 0 && $cid == $browse_cat_id)
                $checked = true;
        }
        
        ///$this->getApp()->frontendApp()->isItemInCategoryID($data[$field_id], $cid);
        $chkattrs = ['type' => 'checkbox', 'name' => '__category_ids[]',  'value' => $cid, 'data-required-one'=>'required'];
        
        if ($checked)
            $chkattrs['checked'] = 'checked';
        $input = $this->_e('input', $chkattrs);
        $nc = [$input];
        foreach ($icontext as $it) $nc[] = $it;
        
        $leaf_attrs = ['id' => '__category_id_'.$cid,'data-checkbox-class'=> "chk_category_assoc", 'data-input-name'=> "__category_ids[]", 'data-value'=> $checked, 'data-input-value'=>$cid , 'data-icon-yes'=> "fa fa-folder-open fa-2x", 'data-icon-no'=> "far fa-folder fa-2x", 'data-color-yes'=> "orange", 'data-color-no'=> "gray", 'data-text-yes'=> "", 'data-text-no'=> ""
            ];         
        
        $leaf = $this->_e('schlix-cms-document-status', $leaf_attrs);
        
        if ($has_primary_category)
        {
            $chk_has_primary_category = !empty($data['is_primary']) ? $data['is_primary'] : false;
            if ( ($this->data[$field_id] == 'new') && $checked)
                $chk_has_primary_category = true;

            //radio
            $ra = ['type' => 'radio', 'name' => 'primary_cid', 'class' => 'schlix-primary-category-radiobox', 'id' => '__radio_category_id_'.$cid, 'value' => $cid];
            if ($chk_has_primary_category)  $ra['checked'] = 'checked';
            $input_radiobox_primary_cid =  $this->_e('input',$ra);
        }
        //$radio_wrap = $this->_el('div',['class' => 'radio'], $input_radiobox_primary_cid);
        //text
        $text = $this->_es('span', ['class' => 'multi-category-editor-text'], $data[$field_title]);
        $pcat_text = $this->_es('span', ['class' => 'multi-category-editor-selected-text'],$primary_category_text);
        $li->appendChild($leaf);
        
        if ($has_primary_category)
        {
        
            $radio_wrap = $this->_el('label',['class' => 'multi-category-editor-label'], [$text, $this->_nl(), $input_radiobox_primary_cid, $pcat_text]);
            $li->appendChild($radio_wrap);
            
        } else 
        {
            $radio_wrap = $this->_el('label',['class' => 'multi-category-editor-label'], [$text, $this->_nl()]);
        }
        //$li->appendChild($text);
        $li->appendChild($radio_wrap);
        if ($childnodes)
        {            
            $li->appendChild($childnodes);
        }
        $attrs = null;
        return $li;
    }
            

    /**
     * Multi-category document selector
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_schlix_document_multi_category_selector(\DOMElement $origin)
    {
        $method = 'schlix_multi_category_tree_editor_li_no_primary_category';
        if ($this->isAdminApp())
        {
            $pkf = $this->getApp()->frontendApp()->getFieldID();   
            $pkc = $this->getApp()->frontendApp()->getFieldCategoryID();
            $fpcid = $this->getApp()->frontendApp()->getFieldCategoryParentID();
            $div = $this->_el('div',['id' => 'schlix-non-ajax-category-edit']);
            
            $a_label = trim($origin->getAttribute('label'));
            $a_helptext = trim($origin->getAttribute('help-text'));
            $a_field_title = trim($origin->getAttribute('field-title'));
            $field_title = !empty($a_field_title) ? $a_field_title : 'title';
            
            $a_df = trim($origin->getAttribute('data-field'));
            $a_primary_cat_text = trim($origin->getAttribute('primary-category-text'));
            $has_primary_category = is_value_true($origin->getAttribute('enable-primary-category'));
            $method = 'schlix_multi_category_tree_editor_li_with_primary_category';
            
            if ($has_primary_category)
            {
                
                $h_attrs = ['type' => 'hidden'];
                if (!empty($a_df))
                {                                   
                    $h_attrs['value'] = 1; // $this->getApp()->frontendApp()->getItemPrimaryCategory($this->getFormData($pkf));                                    
                }
                $input = $this->_elems( $origin, 'input', $h_attrs);
                $this->cleanUpAttributes($input, ['label', 'data-field','enable-primary-category']);
                $div->appendChild($input);                 
            } 
            $inner_div = $this->_e('id', ['id' => 'schlix-'.$this->getApp()->frontendApp()->getApplicationNameOnly().'-edit-categories-associations']);
                       
            
            $all_categories = $this->getApp()->frontendApp()->getAllCategoriesWithAssociationToItem($this->data['id']);            
                    
            $node_content =  $this->traverseArray ($all_categories, 'schlix_multi_category_tree_editor_ul',$method, 0, 0, $pkf, $pkc,$fpcid, $field_title, $a_primary_cat_text, $has_primary_category);
    //$this->traverseList($origin, 'schlix_toolbar_menu_folder', 'schlix_toolbar_menu_item', 'x-ui', 'schlix-explorer-menu-folder', 'schlix-explorer-menu-command');
            if ($node_content)
                $inner_div->appendChild($node_content);            
            
            if (!empty($a_label))
                $div->appendChild($this->_es('label', null, $a_label));
            if (!empty($a_helptext))
                $div->appendChild($this->_es('p', null, $a_helptext));
            $div->appendChild($inner_div); 
            
            return $div;
        }
        return null;
    }
    
    
    /**
     * Save result
     * @param \DOMElement $origin
     * @return 
     */
    protected function schlixconfig_save_result(\DOMElement $origin)
    {
        $app_admin = $this->getApp();
        if ($app_admin instanceof \SCHLIX\cmsAdmin_Basic)
        {
            //ob_start();
            $retval = $app_admin->getLastConfigSaveResult();
            if (is_array($retval) && (___c($retval['errors']) > 0))
            {
                $lis = [];
                foreach ($retval['errors'] as $err)
                {
                    $lis[] = $this->_el('li',null,  $this->internal_icon_text($this->_e('div',['label' => $err, 'fonticon' => 'fa fa-times'])));
            }
            $ul = $this->_el('ul', ['class' => 'list-unstyled'], $lis);
            $h4 =  $this->_el('h4', null, $this->internal_icon_text($this->_e('div',['label' => ___('Error'), 'fonticon' => 'fa fa-exclamation-triangle'])));
            $alert = $this->xui_alert($this->_el('div',['type' => 'error'], [$h4, $ul]));
            return $alert;
            //$save_result = ob_get_contents();
            //ob_end_clean();
            //$panel =$this->_n();
            
            
            //return $this->addCustomHTML( $save_result);
            }
        }
        return null;
    }
    
    
    /**
     * Save result
     * @param \DOMElement $origin
     * @return 
     */
    protected function xui_schlix_document_save_result(\DOMElement $origin)
    {
        $app_admin = $this->getApp();
        
        if ($app_admin instanceof \SCHLIX\cmsAdmin_Basic)
        {
            ob_start();
            $app_admin->displayLastSaveResult();
            $save_result = ob_get_contents();
            ob_end_clean();
            
            return $this->addCustomHTML( $save_result);
        }
        return null;
    }
    
    /**
     * XUI - Textbox
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    
    protected function xui_textbox(\DOMElement $origin) 
    {
        return $this->internal_form_input($origin, 'input');
    }
    
    
    /**
     * XUI - Textbox
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    
    protected function xui_password(\DOMElement $origin) 
    {
        $origin->setAttribute('type', 'password');
        return $this->internal_form_input($origin, 'input');
    }    
    
    /**
     * XUI - Textbox/select
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function internal_form_input(\DOMElement $origin, $input_tag, $custom_class = '') 
    {
        $nv_input_tags = ['select','textarea'];
        $attrs = ['class' => 'form-control'];
        
        if (!empty($custom_class))
            $attrs['class'] = $this->addNewClassNameToClassList ($attrs['class'], $custom_class);
        
        $attr_input_size = trim($origin->getAttribute('input-size'));
        $input_sizes = ['large' => 'lg', 'small' => 'sm'];
        if (array_key_exists($attr_input_size, $input_sizes))
        {
            
            $attrs['class'] = $this->addNewClassNameToClassList ($attrs['class'],'input-'.$input_sizes[$attr_input_size]);
            //$input->setAttribute('')
        }
        
        $input = $this->_input($origin, $input_tag, $attrs);
        $fonticon = trim($input->getAttribute('fonticon'));
        $attr_type = strtolower(trim($input->getAttribute('type')));
        $attr_limit_width = strtolower(trim($input->getAttribute('data-limit-width')));
        $extra_type_input_class =  '';
        if ($attr_type == 'number' || $attr_limit_width > 0)
        {
            $num = $attr_limit_width ? $attr_limit_width : 200;
            $extra_type_input_class= ' input-width-'.$num;
        }

        $attr_label = trim($input->getAttribute('label'));
        $attr_prefix = trim($input->getAttribute('prefix'));
        $attr_suffix = trim($input->getAttribute('suffix'));
        $attr_has_warning = is_value_true($input->getAttribute('has-warning'));
        $attr_has_error = is_value_true($input->getAttribute('has-error'));
        $attr_help_block = trim($input->getAttribute('help-text'));
        $attr_input_group_size = trim($input->getAttribute('input-group-size'));
        
        
        $attr_class_input_size = $attr_input_group_size == 'large' ? 'input-group-lg' : ($attr_input_group_size == 'small' ? 'input-group-sm' : '');
        
        $attr_suffixinternal_fonticon = trim($input->getAttribute('suffix-fonticon'));
        $attr_disableformgroup = trim($input->getAttribute('disable-form-group'));        
        $attr_id = trim($input->getAttribute('id'));
        
        if (empty($attr_type) && $input_tag == 'input')
            $input->setAttribute('type','text');
        if (in_array($input_tag, $nv_input_tags))
        {
            $input->removeAttribute('value');
            if ($input_tag == 'textarea')
            {
                if ($origin->hasChildNodes())
                    $this->cloneChildNodes ($origin, $input);
            }
        }        
        $this->cleanUpAttributes($input, ['fonticon','label','prefix','suffix','suffix-fonticon','disable-form-group','has-warning','has-error','data-field','data-var','data-limit-width', 'input-size', 'input-group-size', 'help-text']);
        
        $h_suffixinternal_fonticon = !empty($attr_suffixinternal_fonticon);
        $h_suffix = !empty($attr_suffix);
        $h_prefix = !empty($attr_prefix);
        $hinternal_fonticon = !empty ($fonticon);
        $h_label = !empty($attr_label);
        $rq_ig =   $hinternal_fonticon || $h_prefix || $h_suffix || $h_suffixinternal_fonticon || $attr_has_warning || $attr_has_error;
        $inner_elems = [];    
        $input_group = null;
        
        $el_label = null;
        $class_input_group_addon = 'input-group-addon';
        //$df = $this->_n();
        if (!empty($attr_label))
        {
            $icon = '';
            if ($attr_has_error)
                $icon = 'fa fa-times';
            else if ($attr_has_warning)
                $icon = 'fa fa-exclamation-triangle';
            $el_label = $this->internal_label($icon,$attr_label, $attr_id );
        }

        $el_help_block = null;
        if (!empty($attr_help_block))
        {
            $el_help_block = $this->_e('span',['class' => 'help-block'], null, [$this->_t($attr_help_block)]);
            if(!empty($attr_id))
            {
                $help_block_id = $attr_id.'__helpBlock';
                $input->setAttribute('aria-describedby', $help_block_id);
                $el_help_block->setAttribute('id', $help_block_id);
            }
        }
        if ($rq_ig)
        {
            
            if ($hinternal_fonticon && $h_prefix)
            {
                $n_icon = $this->_e('i',['class' => $fonticon]);
                $n_prefix = $this->_t(' '.$attr_prefix);
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon], null, [$n_icon, $n_prefix]);
                
            } else 
            {
                if ($hinternal_fonticon)
                {                    
                    $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon], null, $this->_e('i',['class' => $fonticon]));
                } else if ($h_prefix)
                {
                    $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon], $attr_prefix); 
                }
            }
            $inner_elems[] = $input;
            if ($h_suffix)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon], $attr_suffix); 
            } elseif ($attr_suffixinternal_fonticon)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon], null, $this->_e('i',['class' => $attr_suffixinternal_fonticon]));
            }
            $ig_class = 'input-group'.$extra_type_input_class;
            if (!empty($attr_class_input_size))
                $ig_class.= ' '.$attr_class_input_size;
            $input_group = $this->_e('div', ['class' => $ig_class], null, $inner_elems);
                        
        }
        // add form group if necessary
        $this->cleanUpAttributes($input, ['data-field', 'data-var', 'default-value','fonticon','label']);
        if ((($rq_ig && $h_label && !$attr_disableformgroup) || ($attr_has_error || $attr_has_warning) ) && !$attr_disableformgroup)
        {
            $el_insert = [$el_label];
            $fg_class = 'form-group';
            $add_inner_elems_only = true;
            if ($attr_has_warning)
            {
                $fg_class.= ' has-warning';
            } else if ($attr_has_error)
            {
                $fg_class.= ' has-error';
            }/* else --- the commented code below conflicts with str_alias
            {
                $el_insert[] = $input_group;
                $add_inner_elems_only = false;
            }*/
            $el_insert[] = $input_group;
            $add_inner_elems_only = false;
            
            
            if ($add_inner_elems_only && ___c($inner_elems) > 0)
                $el_insert = array_merge ($el_insert, $inner_elems);
            else
            if ($el_insert[0] == null)
            {
                $el_insert = $inner_elems;
            }
            if ($el_help_block)
                $el_insert[] = $el_help_block;
            $fg = $this->_e('div', ['class' => $fg_class], null, $el_insert);
            
            return $fg;
        } else if ($rq_ig)
        {
            return $input_group;
        }
        else if ($h_label)
        {
            $tn = $this->html_document->createDocumentFragment();
            $tn->appendChild($el_label);
            if (!empty($extra_type_input_class))
            {
                $class = $input->getAttribute('class');
                $class = $this->addNewClassNameToClassList ($class, $extra_type_input_class);                
                $input->setAttribute('class', $class);
            }

            $tn->appendChild($input);
            if($el_help_block)
                $tn->appendChild($el_help_block);
            return $tn;
        } 
        return $input;
    }    
    
    
    protected function xui_accordion(\DOMElement $origin)
    {
        
        
        $tab_count = 0;
        $t_container_id = $origin->getAttribute('id');
        if (empty($t_container_id))
            throw new \Exception ('Accordion ID cannot be empty');
        $t_container = $this->_e('div',['class' => 'panel-group','id' => $t_container_id]);
        $content_id_prefix = $t_container_id.'_accordion_tab_';
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName === 'accordion-content')
            {
                
                $x = $tab_count + 1;
                $acc_id = $content_id_prefix.'_body_'.$x;
                $ph_id = $content_id_prefix.'_head_'.$x;
                $pc_id = $content_id_prefix.'_container_'.$x;
                
                $panel_container = $this->_el('div',['id' => $pc_id, 'class' => 'panel panel-default']);
                
                $ph_h4_a = $this->_el('a',['role' => 'button', 'data-toggle' => 'collapse', 'data-parent' => '#'. $t_container_id, 'href' => '#'.$acc_id],  $this->internal_icon_text($c) );
                $ph_h4 = $this->_el('h4',['class' => 'panel-title'], $ph_h4_a);
                $panel_heading = $this->_el('div',['class' => 'panel-heading','role' => 'tab', 'id' => $ph_id], $ph_h4);

                $pc_collapse_class_extra = ($tab_count == 0) ? ' in' : '';
                $body_id = $content_id_prefix.'_body_'.$x;
                $panel_collapse = $this->_el('div',['id'=> $body_id,'class' => 'panel-collapse collapse'.$pc_collapse_class_extra, 'role' => 'tabpanel', 'aria-labelledby' => $ph_id]);
                $panel_body = $this->_elems($c,'div', ['class' => 'panel-body']);
                $panel_collapse->appendChild(($panel_body));
                
                $panel_container->appendChild( $this->_comment('accordion-content'));
                $panel_container->appendChild( $this->_comment('accordion-head'));
                $panel_container->appendChild( $this->_nl());
                $panel_container->appendChild($panel_heading);
                $panel_container->appendChild( $this->_nl());
                $panel_container->appendChild( $this->_comment('accordion-body'));
                $panel_container->appendChild($panel_collapse);
                $panel_container->appendChild( $this->_nl());
                
                $t_container->appendChild($panel_container);
                $tab_count++;
            }
        }
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild( $this->_comment('Accordion Content'));
        $t_container->appendChild( $this->_nl());
         
        //$t_container->appendChild($t_content);

        return $t_container;
    }    
    
    
    protected function xui_tab_container(\DOMElement $origin)
    {
        
        $t_container = $this->_e('div',['class' => 'nav-tabs-custom']);
        $t_header = $this->_e('ul',['class' => 'nav nav-tabs']);
        $t_content = $this->_e('div',['class' => 'tab-content']);
        $tab_count = 0;
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName === 'tab')
            {
                $t_id = $c->getAttribute('id');
                $tinternal_fonticon = $c->getAttribute('fonticon');
                $t_label = $c->getAttribute('label');
                // Tab Header
                $li_attr = [];
                if ($tab_count === 0)
                    $li_attr['class'] = 'active';
                $t_emlbl = $this->_e('em');
                
                $a_href = $this->_el('a',['data-toggle' => 'tab', 'href' => '#'.$t_id],  $this->_el('em', null, $this->internal_icon_text($c)));
                
                $li = $this->_el('li', $li_attr, $a_href );                
                
                $t_header->appendChild($li);
                $t_header->appendChild( $this->_nl());
                // Tab content
                $this->cleanUpAttributes($c, ['fonticon', 'label']);
                $tab_pane_class = ($tab_count == 0) ? 'tab-pane active': 'tab-pane';
                
                $t_c_content = $this->_elems($c, 'div',['id' => $t_id, 'class' =>  $tab_pane_class]);
                
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild( $this->_comment('tab'));
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild($t_c_content);
                $t_content->appendChild( $this->_nl());
                
                //$t_c_content =  $this->cloneChildNodes($c, $t_c_content);*/
                $tab_count++;
            }
        }
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild($t_header);
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild( $this->_comment('Tab Content'));
        $t_container->appendChild( $this->_nl());
         
        $t_container->appendChild($t_content);

        return $t_container;
    }    
    
    protected function xui_schlix_tab_container(\DOMElement $origin)
    {
        $this->tab_count++;
        $a_id = $origin->getAttribute('id');
        if (empty($a_id))
            $a_id = 'scms_tab_'.$this->tab_count;
            
        $t_container = $this->_e('div',['class' => 'schlixui-tabcontainer']);
        $t_header = $this->_e('ul',['class' => 'schlixui-tabheader']);
        $t_content = $this->_e('div',['class' => 'schlixui-tabcontent']);
        $tab_count = 0;
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName === 'schlix-tab')
            {
                $t_id = $c->getAttribute('id');
                $tinternal_fonticon = $c->getAttribute('fonticon');
                $t_label = $c->getAttribute('label');
                // Tab Header
                $li_attr = [];
                if ($tab_count === 0)
                    $li_attr['class'] = 'selected';
                $t_emlbl = $this->_e('em');
                
                $a_href = $this->_el('a',['href' => '#'.$t_id],  $this->_el('em', null, $this->internal_icon_text($c)));
                
                $li = $this->_el('li', $li_attr, $a_href );                
                
                $t_header->appendChild($li);
                $t_header->appendChild( $this->_nl());
                // Tab content
                $this->cleanUpAttributes($c, ['fonticon', 'label']);
                $t_c_content = $this->_elems($c, 'div',['id' => $t_id, 'class' => 'schlixui-childtab']);
                
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild( $this->_comment('tab'));
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild($t_c_content);
                $t_content->appendChild( $this->_nl());
                
                //$t_c_content =  $this->cloneChildNodes($c, $t_c_content);*/
                $tab_count++;
            }
        }
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild($t_header);
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild( $this->_comment('Tab Content'));
        $t_container->appendChild( $this->_nl());
        $t_container->setAttribute('id', $a_id);
        $t_container->appendChild($t_content);
        return $t_container;
    }

    protected function xui_hidden(\DOMElement $origin)
    {
        return $this->_input($origin, 'input', ['type' => 'hidden']);
    }
    
    /**
     * CSRF hidden input
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_csrf(\DOMElement $origin)
    {
        return $this->_input($origin, 'input', ['type' => 'hidden', 'name' => '_csrftoken', 'value' => get_csrf_token()]);
    }
    
    /**
     * Returns SCHLIX Explorer - divider li tag
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    
    protected function xui_schlix_explorer_menu_command_divider(\DOMElement $origin)
    {
        return $this->_e('li',['class' => 'menu-divider']);
    }    
    
    /**
     * Returns div clear:both
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_clearfix(\DOMElement $origin) 
    {
        return $this->_e('div',['class' => 'clearfix']);
    }
    
    
    /**
     * Returns div clear:both
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function xui_clearboth(\DOMElement $origin) 
    {
        return $this->_e('div',['class' => 'clearboth']);
    }
    
    protected function xui_input_group(\DOMElement $origin)
    {
        return $this->_elems($origin, 'div', ['class' => 'input-group']);
    }

    protected function xui_form(\DOMElement $origin)
    {
        $a_inline = is_value_true($origin->getAttribute('inline'));
        $attr = []; //
        if ($a_inline)
            $attr['class'] = 'form-inline';
        $form = $this->_elems($origin, 'form', $attr);
        return $form;
    }
    
    protected function xui_form_simple_ajax(\DOMElement $origin)
    {
        
        $a_class = $this->addNewClassNameToClassList($origin->getAttribute('class'), 'schlix-form-simple');
        $origin->setAttribute('class', $a_class);
        $form = $this->xui_form($origin);
        return $form;
    }
    
    
    protected function xui_file_upload(\DOMElement $origin)
    {
        $a_fonticon = $origin->getAttribute('fonticon');
        $a_label = $origin->getAttribute('label');
        $a_max_file_size=  $origin->getAttribute('max-file-size');
        $label_class = 'btn btn-default btn-file';
        $label = $this->_e('label', ['class' => $label_class]);
        if ($a_fonticon)
        { 
            $label->appendChild($this->internal_fonticon($a_fonticon));
        }
        $a_label = $a_label ? ' '.$a_label : ' '.___('Select file');
        $label->appendChild($this->_t($a_label));
        $f = $this->_input($origin,'input',['type' => 'file','style' => 'display:none']);
        if ((int) $a_max_file_size > 0)
        {
            
            $h = $this->_e('input',['type' => 'hidden', 'name' => 'MAX_FILE_SIZE', 'value' => $a_max_file_size]);
            $label->appendChild($h);
        }
        $label->appendChild($f);
        return $label;
        /* 
         <label class="btn btn-default btn-file"><i class="far fa-folder-open"></i> <?= ___("Change avatar/picture") ?>
             <input type="hidden" id="__max_file_size" name="MAX_FILE_SIZE" value="<?= min(get_real_max_upload_size(), 200000) ?>" />     
             <input  type="file" name="user_avatar" id="user_avatar" style="display:none" />
        </label> */ 
        
    }
    
    protected function xui_form_group(\DOMElement $origin)
    {
        return $this->_elems($origin, 'div', ['class' => 'form-group']);
    }
    
    protected function xui_input_group_addon(\DOMElement $origin)
    {
        return $this->xui_input_addon($origin);
    }
    
    protected function xui_input_addon(\DOMElement $origin)
    {
        $a_label = $origin->getAttribute('label');
        $a_fonticon = $origin->getAttribute('fonticon');
        $attrs = ['class' => 'input-group-addon'];
        if ($a_label || $a_fonticon) 
            $div = $this->_el('div', $attrs, $this->internal_icon_text($origin));
        else
            $div = $this->_elems($origin, 'div', $attrs);
        return $div;
    }
    
    protected function xui_input_addon_button(\DOMElement $origin)
    {
        return $this->_elems($origin, 'div', ['class' => 'input-group-btn']);
    }
    
    
    protected  function xui_schlix_document_status(\DOMElement $origin)
    {
        $node = $this->_elems($origin, 'schlix-cms-document-status');
        $node = $this->autoSetFormAttributeValue($node, 'data-value');
        return $node;
    }    

    protected  function xui_schlix_document_version(\DOMElement $origin)
    {
        $v = $this->getSanitizedFormData('version');
        if ($v > 0)
            return $this->_t(___('Version') . ': ' .___h($v));
                                
    }
    
    protected function xui_schlix_cms_dialog_button_submit(\DOMElement $origin)
    {
        $lbl = $this->internal_icon_text($origin);
        $btn = $this->_elems($origin, 'button', ['type' => 'submit', 'data-schlix-command' => 'dialog-submit', 'class' => 'btn btn-success'], '', $lbl);
        $this->cleanUpAttributes($btn, ['fonticon','label']);
        return $btn;
    }
    
    protected function xui_schlix_cms_dialog_button_cancel(\DOMElement $origin)
    {
        $lbl = $this->internal_icon_text($origin);
        $btn = $this->_elems($origin, 'button', ['type' => 'submit', 'data-schlix-command' => 'dialog-close', 'class' => 'btn btn-danger'], '', $lbl);
        $this->cleanUpAttributes($btn, ['fonticon','label']);
        return $btn;        

    } 
    
    protected  function xui_schlix_cms_common_dialog(\DOMElement $origin)
    {
        if ($this->isAdminApp())
        {
            $a_data_model = $origin->getAttribute('data-model');
            $a_header_label = $origin->getAttribute('header-label');
            $a_form_method = strtolower(trim($origin->getAttribute('form-method')));
            $a_data_action = strtolower(trim($origin->getAttribute('data-action')));
            $a_id = $origin->getAttribute('id');
            
            $dlg = $this->_e('div', ['class' => 'schlix-cms-common-dialog']);
            $this->copyAttributesFromNode($origin, $dlg);
            if (empty($a_data_model))                         
                $dlg->setAttribute('data-model', $this->getApp()->getDataModelURL());
            $dlg->appendChild($this->_nl());
            if (!empty($a_header_label))
                $dlg->appendChild($this->_es('div',['class' =>'panel-header'], $a_header_label));
            $dlg->appendChild($this->_nl());
            $body = $this->_e('div', ['class' => 'panel-body']);
            if (!empty($a_form_method) && !empty($a_data_action))
            {
                //method="post" id="frm_install" class="schlix-form-install" inline="1" enctype="multipart/form-data"
                $a_inline = is_value_true($origin->getAttribute('form-inline'));
                $method = $a_form_method == 'get' ? 'get' : 'post';
                $form_id = $a_id.'-form-'.$method;
                $f_attrs = ['method' => $method, 'id' => $form_id, 'data-action' => $a_data_action];                
                if ($method === 'post')
                    $f_attrs['enctype'] = 'multipart/form-data';
                if ($a_inline)
                    $f_attrs['class'] = 'form-inline';
                $form = $this->_e('form', $f_attrs);
                $this->cloneChildNodes($origin, $form);
                $body->appendChild($form);
            } else
            {
                $this->cloneChildNodes($origin, $body);
            }
            
            $this->whitelistAttributes($body, ['class']);
            $dlg->appendChild($body);
            $this->cleanUpAttributes($origin, ['header-label', 'form-method','data-action']);
            
            return $dlg;
        }
    }
    
    protected  function xui_schlix_file_upload(\DOMElement $origin)
    {
/*            <label class="btn btn-default btn-file"><i class="far fa-folder-open"></i> <?= ___('Select a ZIP file') ?>
               <input id="zipfileupload" class="form-control" type="file" name="zipfileupload" accept=".zip" required="required" />
           </label>*/
            $max_number_of_files_upload = ini_get('max_file_uploads');
        
            $a_label = trim($origin->getAttribute('label'));
            $a_fonticon = trim($origin->getAttribute('fonticon'));
            $a_max_file_size = trim($origin->getAttribute('max-file-size'));
            $a_id = trim($origin->getAttribute('id'));
            $e_df = $this->_n();
            $lbl = $this->_e('label', ['class' => 'btn btn-default btn-file']);
            if ($a_fonticon)
                $lbl->appendChild($this->_e('i',['class' => $a_fonticon]));
            if ($a_label)
                $lbl->appendChild($this->_t($a_label));
            //$df = $this->internal_icon_text($origin);
            
            //$df[0]->setAttribute('class', 'btn btn-default btn-file');
            
            
            $input = $this->_input($origin,'input', ['type' => 'file', 'class' => 'form-control schlix-file-uploader']);
            $lbl->appendChild($input);
            
            $max_file_size = (int) $a_max_file_size;
            $max_upload_size = __convert_unit_prefix_to_bytes( get_real_max_upload_size () );
            if ($max_file_size > 0 )
                $max_file_size = min($max_file_size, $max_upload_size);
            else 
                $max_file_size = $max_upload_size;           
            
            $h_max = $this->_e('input',['type' => 'hidden', 'name' => 'MAX_FILE_SIZE', 'id' => $a_id.'__max_file_size', 'value' => $max_file_size]);
            $h_total = $this->_e('input',['type' => 'hidden', 'name' => $a_id.'__total_file_size', 'id' => $a_id.'__total_file_size', 'value' => '0']);
            $h_max_file_upload = $this->_e('input',['type' => 'hidden', 'name' => $a_id.'__max_file_count', 'id' => $a_id.'__max_total_file_count', 'value' => $max_number_of_files_upload]);
            
            
            $div_file_list = $this->_e('div',[ 'class' => 'schlix-file-upload-filelist'] );
            $ul_file_list =  $this->_e('ul',[ 'id' => $a_id.'__filelist', 'class' => 'list-unstyled schlix-file-upload-ul'] );
            $div_file_list->appendChild($ul_file_list);
            $p = $this->_e('p', ['id' => $a_id.'__info-totalsize', 'style' =>'display:none']);
            $div_warning = $this->_e('div', ['id' => $a_id.'__info-warning', 'style' =>'display:none', 'class' => 'alert alert-danger']);
            $sp1 = $this->_es('span',['id' => $a_id.'__prefix-totalsize'], ___('Total').': ');
            $sp2 = $this->_e('span',['id' => $a_id.'__view-totalsize']);
            $sp3 = $this->_e('span',['id' => $a_id.'__view-totalfilecount']);
            $p->appendChild($sp1);
            $p->appendChild($sp2);
            $p->appendChild($this->_t('('));
            $p->appendChild($sp3);
            $p->appendChild($this->_t(' '.___('files').')'));
            $e_df->appendChild($lbl);
            $e_df->appendChild($this->_nl());
            $e_df->appendChild($div_file_list);
            $e_df->appendChild($h_max);
            $e_df->appendChild($h_total);
            $e_df->appendChild($h_max_file_upload);
            $e_df->appendChild($p);
            $e_df->appendChild($div_warning);
            
/*
            
                    <input type="hidden" id="__max_file_size" name="MAX_FILE_SIZE" value="<?= get_real_max_upload_size() ?>" />                     
                    <input type="hidden" id="__total_file_size" name="__total_file_size" value="0" />                     

 *                     <div style="max-height:100px;overflow: auto">
                    <ul id="filelist" class="list-unstyled" ></ul>
                    </div>
                    <p><span id="filelist-prefix-totalsize"></span>&nbsp;<span id="filelist-display-totalsize"></span></p>
*/            
            
            return $e_df;
    }   
    
    /**
     * Alert text (danger, info, success, warning, error)
     * @param \DOMElement $origin
     * @return string
     */
    
    protected function xui_alert(\DOMElement $origin)
    {
        $a_type = $origin->getAttribute('type');        
        if (in_array($a_type, ['danger','info','success','warning','error']))
        {
            $a_icon = $origin->getAttribute('fonticon');
            $a_var = $origin->getAttribute('var');
            if ($a_type == 'error') $a_type = 'danger';
            $d = is_value_true($origin->getAttribute('dismissable'));
            $alert_class = "alert alert-{$a_type}";
            if ($d)
                $alert_class.= ' alert-dismissable';
            $el =  $this->_elems($origin, 'div', ['class' => $alert_class]);
            
            if (array_key_exists($a_var, $this->data))
            {
                $v = $this->data[$a_var];
                if (is_string($v))
                {
                    
                } elseif (___c($v) > 0)
                {
                    foreach ($v as $l)
                    {
                        if ($a_icon)
                        {
                            $i = $this->internal_fonticon($a_icon);
                            $el->appendChild($i);
                            $el->appendChild($this->_t(' '));
                        }
                        $w = $this->_t($l);
                        
                        $el->appendChild($w);
                        $el->appendChild($this->_e('br'));
                    }
                }
            }            
            $this->cleanUpAttributes($el, ['var','fonticon']);
            return $el;
        }
    }
    
    protected function xui_schlix_gallery_view(\DOMElement $origin) 
    {
        $cl = []; $g = [];
        $attrs = ['xs','sm','md','lg','xs-offset','sm-offset','md-offset','lg-offset'];
        foreach ($attrs as $a)
            $g[$a] = (int) trim($origin->getAttribute($a));
          
        $cn = '';
        if (___c($g) > 0) 
        {
            foreach ($g as $k => $v) if ($v > 0) {$cl[] = 'col-'.$k.'-'.$v; $origin->removeAttribute($k);}
            $cl[] = 'schlix-cms-data-gallery-column';
            $cn = implode(' ', $cl);
        }
        return $this->_elems($origin,'div',['data-row-class' => 'schlix-cms-data-gallery-row row', 'data-column-class' => $cn]);
        
    }
    
    
    protected function xui_schlix_document_image_uploader(\DOMElement $origin)
    {
        if ($this->isAuthenticated())
        {
            $a_id = trim($origin->getAttribute('id'));
            $wrapper = $this->_e('div',['class' => 'schlix-uploader-wrapper','id' => $a_id.'_schlix_uploader_wrapper']);
            $wrapper->appendChild($this->_comment('Image uploader'));
            $arr_inpt = $this->internal_icon_text($origin);
            $a_data_preview_url = $origin->getAttribute('data-preview-url');

            $a_ddk = trim($origin->getAttribute('data-dir-key'));
            $a_df = trim($origin->getAttribute('data-field'));            
            $a_nodel = trim($origin->getAttribute('data-no-del'));
            $a_accept = $origin->getAttribute('accept');
    //        $a_name = trim($origin->getAttribute('name'));
            $preview_id = 'preview_'.$a_id;
            $attrz = ['type' => 'file', 'style' => 'display:none', 'class' => 'schlix-document-img-uploader form-control', 'data-preview-image' => $preview_id];
            if ($a_accept)
                $attrz['accept'] = $a_accept;
            $input = $this->_e('input', $attrz);

            $this->copyAttributesFromNode($origin, $input, ['id','name']);
            $arr_inpt[] = $input;
            $lbl = $this->_el('label',['class' => 'btn btn-default btn-file'], $arr_inpt);
            $filename = $this->getFormData($a_df);
            
            $dh = '';
            if ($a_data_preview_url)
                $dh = $a_data_preview_url;
            else
                $dh = $this->isAdminApp() ? $this->getApp()->frontendApp()->getDataFileURLPathWithHash($a_ddk, $filename) : $this->getApp()->getDataFileURLPathWithHash($a_ddk, $filename);
            $img_src = $filename ? $dh : '';
            $img = $this->_e('img', ['id' => $preview_id, 'class' => 'schlix-preview-img', 'src' => $img_src, 'onerror' => "this.style.display='none'"]);
            
            $wrapper->appendChild($lbl);
            $wrapper->appendChild($this->_e('div', ['class' => 'clearboth']));
            $wrapper->appendChild($img);
            
            if (!empty($filename) && !$a_nodel)
            {
                $ds = $this->_e('schlix-cms-document-status', ['id'=> "delete_{$a_id}" , 'data-input-name'=> "delete_{$a_id}",  'data-value'=> "", 'data-icon-yes'=> "fa fa-times-circle", 'data-icon-no'=> "fa fa-check", 'data-color-yes'=> "red",'data-color-no'=> "green", 'data-text-yes'=>  ___('Delete this picture'), 'data-text-no'=> ___('Use this picture')]);
                $wrapper->appendChild($this->_e('div',['class' => 'clearboth']));
                $wrapper->appendChild($ds);
            }
            $wrapper->appendChild($this->_e('div', ['class' => 'clearboth']));
            $wrapper->appendChild($this->_comment('Image uploader end'));
            
            return $wrapper;
        }
        return null;
    }  
    
    protected function internal_file_url_selector(\DOMElement $origin, $control_type = 'file') {
        
        $ig = $this->xui_input_group($this->_e('div'));
        
        $id = $origin->getAttribute('id');
        $a_df = $origin->getAttribute('data-field');
        $a_label = $origin->getAttribute('label');
        $a_id = trim($origin->getAttribute('id'));
        $a_file_exts = trim($origin->getAttribute('data-file-extensions'));
        $a_url_allow_variable_dimension = is_value_true($origin->getAttribute('data-allow-url-variable-dimension'));
        $preview_width = (int) $origin->getAttribute('data-preview-width');
        $preview_height = (int) $origin->getAttribute('data-preview-height');
        $preview_img_id = $a_id.'_container_preview_img';
        $preview_video_id = $a_id.'_container_preview_video';
        $preview_video_wrapper_id = $a_id.'_container_preview_video_wrapper';
        $preview_video_source_id = $a_id.'_container_preview_video_source';
        $fg_id = $a_id.'_container';
        
        if (!empty($a_file_exts))
        {
            $file_exts = explode(',',$a_file_exts);
            $exts = [];
            foreach ($file_exts as $e) 
            {
                 $e = alpha_numeric_only($e);
                 if (!empty($e))
                     $exts[] = $e;
            }
            
        }
        else $exts = ['png','jpg','jpeg','mp4'];
        $approved_exts = implode('|', $exts);
        if (!$a_label)
            $a_label = ___('Please select an image');
        $lbl = $this->_es('label',['for' => $id, 'class' => 'control-label'], $a_label);
        //$iga = $this->xui_input_addon($this->_el('span', null, $this->internal_fonticon('fa fa-image')));        
        $origin->removeAttribute('label');
        $origin->setAttribute('class','schlix-media-select-input');
        
        $fg = $this->xui_form_group($this->_e('div',['class' => 'schlix-image-picker schlix-image-picker-'.$control_type,'data-selector-type' => $control_type, 'data-input-id' => $a_id, 'id' => $fg_id]));
        $fg->appendChild($lbl);
        
        $input_attrs = ['placeholder'=>  ___('Image URL/path') ];
        
        if ($control_type == 'file')
        {
            $iga_button = $this->xui_input_addon($this->_el('span', null, $this->_el('a', ['href' => 'javascript:void(0)', 'class' => 'schlix-media-select', 'data-target' => $id], $this->internal_icon_text( $this->_e('span', ['label' =>___('Browse'), 'fonticon' => 'fa fa-image'] )))));
            
            $input_attrs['pattern'] = '^\/([A-z0-9-_+]+\/)*([A-z0-9\-_]+\.('.$approved_exts.'))$';
        } else 
        {
            $input_attrs['type'] = 'url';
            $input_attrs['title'] = sprintf( ___('Please specify full URL with valid file extensions: %s'), implode(', ', $exts));
            /*if (!$a_url_allow_variable_dimension)
                $input_attrs['pattern'] = '^https?:\/\/\w+(\.\w+)*(:[0-9]+)?\/?([A-z0-9-_+]+\/)*([A-z0-9\-_]+\.('.$approved_exts.'))$';*/
            $iga_button = $this->xui_input_addon($this->_el('span', null, $this->internal_icon_text( $this->_e('span', ['label' =>___('URL'), 'fonticon' => 'fa fa-image'] ))));
        }
        $ig->appendChild($iga_button);
        $input = $this->xui_textbox($this->_elems($origin, 'input', $input_attrs ));
        
        $ig->appendChild($input);
        $fg->appendchild($ig);
        
        $img_src = $this->getFormData($a_df);
        
        if (is_null($img_src))
            $img_src = ''; // PHP8.2 fix
        $file_ext = pathinfo($img_src, PATHINFO_EXTENSION);
        
        $video_attrs = ['controls' => '1',  'id' => $preview_video_id, 'class' => 'schlix-preview-video'];
        $video_wrapper_attrs = ['class' => 'embed-responsive embed-responsive-16by9', 'id' => $preview_video_wrapper_id];
        $is_video = false;
        if ($file_ext == 'webm' || $file_ext == 'mp4')
        {
            $video_attrs['src'] = $img_src;
            $is_video = true;            
        } else 
        {
            //$video_attrs['style'] = 'display:none';    
            $video_wrapper_attrs['style']= 'display:none';            
            if (strlen($img_src) > 8) //arbitrary number
            {
                if ($a_url_allow_variable_dimension && str_contains($img_src, '{$width}') && str_contains($img_src, '{$height}') && $preview_width > 0 && $preview_height > 0)
                {
                    $img_src = str_replace(['{$width}', '{$height}'], [strval($preview_width), strval($preview_width)], $img_src);
                }
            }
        }
        $video =  $this->_e('video', $video_attrs);
        $video_wrapper = $this->_e('div', $video_wrapper_attrs);
        $video_wrapper->appendChild($video);            
        $img = $this->_e('img', ['id' => $preview_img_id, 'class' => 'schlix-preview-img', 'src' => $img_src, 'display' => $is_video ? 'none' : '', 'onerror' => "this.style.display='none'"]);
        
        
        $fg->appendchild($img);
        $fg->appendchild($video_wrapper);
        return $fg;
        
    }
        
    
    protected function xui_file_select(\DOMElement $origin) {
        
        
        return $this->internal_file_url_selector($origin, 'file');
    }
    
    protected function xui_url_select(\DOMElement $origin) {
        
       return $this->internal_file_url_selector($origin, 'url');
        
    }
    
    protected function xui_schlix_multi_source_media_uploader(\DOMElement $origin) {
                
        // 1) Radio Group
        $a_df = $origin->getAttribute('data-field');
        $a_is_hook = is_value_true($origin->getAttribute('data-hook'));
        $a_uploaded_path = $origin->getAttribute('data-uploaded-path');
        
        $a_uploaded_url = $origin->getAttribute('data-uploaded-url');
        $a_preview_width = (int) $origin->getAttribute('data-preview-width');
        $a_preview_height = (int) $origin->getAttribute('data-preview-height');
        $a_disable_existing_file = is_value_true($origin->getAttribute('data-disable-option-existing-file'));
        $a_disable_option_none = is_value_true($origin->getAttribute('data-disable-option-none'));
        $a_disable_file_upload = is_value_true($origin->getAttribute('data-disable-option-file-upload'));
        $a_disable_url = is_value_true($origin->getAttribute('data-disable-option-url'));
        $a_url_allow_variable_dimension = is_value_true($origin->getAttribute('data-allow-url-variable-dimension'));        
        $a_id = $origin->getAttribute('id');
        $a_name = $origin->getAttribute('name');
        $a_ddk = $origin->getAttribute('data-dir-key');
        $a_exts = $origin->getAttribute('data-file-extensions');
        $a_label = $origin->getAttribute('label');
        if (empty($a_label))
            $a_label = ___('Select media source');
        $wrapper = $this->_e('div',['class' => 'schlix-media-upload-multi-source', 'id' => $a_id.'_schlix_media_upload_multi_source_container']);
        $rg = $this->_e('div',['data-field' => $a_df, 'name' => $a_name.'_selection', 'id' =>$a_id ,'label' => $a_label ]);
                    
        $value = $this->getFormData($a_df);                        
        // check values
        // 1. file upload
        $uploaded_file_ddk = '';
        if ($a_uploaded_path && $a_uploaded_url)
        {
            $uploaded_file_ddk = $a_uploaded_path;
        } else 
        {
            $uploaded_file_ddk = $this->isAdminApp() ? $this->getApp()->frontendApp()->getDataFileFullPath($a_ddk, $value) : $this->getApp()->getDataFileFullPath($a_ddk, $value);                            
        }
        $file_is_uploaded = is_readable_file($uploaded_file_ddk);
        // 2. file is existing
        if (is_null($value)) $value = '';
        $file_is_path = str_starts_with($value, '/') && !$uploaded_file_ddk && is_readable_file(realpath($_SERVER['DOCUMENT_ROOT'].$value));
        // 3. file is URL
        $file_is_url = false;
        if (!$file_is_path && !$file_is_uploaded)
        {
            $file_is_url = str_starts_with($value,  'https://') || str_starts_with($value,  'http://');
        }
        //echo $file_is_uploaded;die;
        $opts = [];
        if (!$a_disable_option_none)
            $opts['none'] = ['class' => 'schlix-upload-multi-source-opt', 'value' => '', 'data-id' => $a_id, 'label' => ___('None')];
        if (!$a_disable_file_upload)
            $opts ['upload'] = ['class' => 'schlix-upload-multi-source-opt', 'value' => 'upload', 'data-id' => $a_id, 'label' => ___('File upload')];
        
        if (!$a_disable_existing_file)
            $opts['existingpath'] = ['class' => 'schlix-upload-multi-source-opt', 'value' => 'path', 'data-id' => $a_id, 'label' => ___('An existing file on this site')];
        if (!$a_disable_url)
            $opts['url'] = ['class' => 'schlix-upload-multi-source-opt', 'value' => 'url', 'data-id' => $a_id, 'label' => ___('External URL')];
        
        if ($file_is_uploaded)
            $opts['upload']['checked'] = 'checked';
        elseif ($file_is_path)
            $opts['existingpath']['checked'] = 'checked';
        elseif ($file_is_url)
            $opts['url']['checked'] = 'checked';
        elseif (!$a_disable_option_none) 
            $opts['none']['checked'] = 'checked';
        
        foreach ($opts as $o)
            $rg->appendChild($this->_e('x-ui:option', $o));
        $xselector = $this->xui_radio_group($rg);
        
        
        // 2. File uploader
        $uploader_id = $a_id.'_upload';
        
        $uploader_attrs = ['fonticon' => 'far fa-image', 'data-no-del' => '1', 'name'=> $uploader_id, 'id' => $uploader_id, 'label' => ___('Upload'), 'data-dir-key' => $a_ddk, 'accept' => 'image/png, image/jpeg, image/gif'];
        if ($file_is_uploaded)
        {
            if ($a_uploaded_url)
            {                
                $uploader_attrs['data-preview-url'] = $a_uploaded_url;
            }
            $uploader_attrs['data-field'] = $a_df;            
        }
        $uploader = $this->_e('div', $uploader_attrs );
        $xupload = $this->xui_schlix_document_image_uploader($uploader);
        if (!$file_is_uploaded)
            $xupload->setAttribute('style', 'display:none');
        
        // 3. Path select
        $path_selector_id = $a_id.'_path';
        $path_selector_attrs = [ 'name'=> $path_selector_id, 'id' => $path_selector_id, 'name' => $path_selector_id, 'data-file-extensions' => $a_exts, 'label' => ___('Choose an existing file on this site'), 'placeholder' => CURRENT_SUBSITE_URL_PATH.'/images/example.jpg' ];
        if ($file_is_path)
            $path_selector_attrs['data-field'] = $a_df;            
        $path_selector = $this->_e('div', $path_selector_attrs);
        $xpath_selector = $this->xui_file_select($path_selector);
        if (!$file_is_path)
        {
            $xpath_selector->setAttribute('style', 'display:none');
        }
        
        // 4. URL select
        $url_selector_id = $a_id.'_url';
        $url_selector_attrs =[ 'name'=> $url_selector_id, 'id' => $url_selector_id, 'name' => $url_selector_id, 'data-file-extensions' => $a_exts, 'label' => ___('Specify source from an external URL'), 'placeholder' => SCHLIX_SITE_URL.CURRENT_SUBSITE_URL_PATH.'/images/example.jpg' ];
        if ($file_is_url)
            $url_selector_attrs['data-field'] = $a_df;            
        if ($a_url_allow_variable_dimension)
            $url_selector_attrs['data-allow-url-variable-dimension'] = true;
        if ($a_preview_width > 0)
            $url_selector_attrs['data-preview-width'] = $a_preview_width;        
        
        if ($a_preview_height > 0)
            $url_selector_attrs['data-preview-height'] = $a_preview_height;        
        $url_selector = $this->_e('div', $url_selector_attrs);
        $xurl_selector = $this->xui_url_select($url_selector);
        if (!$file_is_url)
            $xurl_selector->setAttribute('style', 'display:none');        
        
        
        /*$column_left = $this->xui_column($this->_e('div',['xs' => 3]));
        $column_right = $this->xui_column($this->_e('div', ['xs' => 9]));
                
        $column_left->appendChild($xselector);
        
        $column_right->appendChild($xupload);
        $column_right->appendChild($xpath_selector);
        $column_right->appendChild($xurl_selector);
        
        $wrapper->appendChild($column_left);
        $wrapper->appendChild($column_right);*/
        
        $wrapper->appendChild($xselector);
        $wrapper->appendChild($xupload);
        $wrapper->appendChild($xpath_selector);
        $wrapper->appendChild($xurl_selector);
        // 2) Upload
        return $wrapper;
    }
    
    private function internal_slideshow_content (\DOMElement $n, $el_container)
    {
        if ($n->hasChildNodes())
        {

            $large_text = null;
            $regular_text = null;
            
            //$others = null;
            foreach ($n->childNodes as $cn)
            {
                
                if ($cn->localName == 'slide-text')
                {   

                    $regular_text = $this->_elems($cn, 'div', ['class' => 'slide_text']);
                } else if ($cn->localName == 'slide-header')
                {

                    $large_text = $this->_elems($cn, 'h1');
                } else
                {
                    $el_container->appendChild($cn);
                }
            }
            if ($large_text || $regular_text)
            {
                $div_container = $this->_e('div', ['class' => 'container']);
                $div_carousel_caption = $this->_e('div', ['class' => 'carousel-caption']);
                if ($large_text)
                    $div_carousel_caption->appendChild($large_text);
                if ($regular_text)
                    $div_carousel_caption->appendChild($regular_text);
                $div_container->appendChild($div_carousel_caption);
                $el_container->appendChild($div_container);
            }
        }
        return $el_container;
        
    }
    
    protected function xui_generic_slideshow(\DOMElement $origin)
    {

        $a_id = trim($origin->getAttribute('id'));
        
        $i = 0;
        /* <div id="<?= $slideshow_css_id ?>" class="carousel slide bootstrap-slideshow" data-ride="carousel"> */
        $el_main = $this->_el('div', ['id' => $a_id, 'class' => 'carousel slide bootstrap-slideshow', 'data-ride' => 'carousel']);
        
        $el_indicator = $this->_el('ol', ['class' => 'carousel-indicators']);
        $el_slides = $this->_el('div', ['class' => 'carousel-inner', 'role' => 'listbox']);
        $slide_content = [];
        if ($origin->hasChildNodes())
        {
            foreach ($origin->childNodes as $n)
            {
                if ($n->localName == 'slide-content')
                {
                    //$slide = ['i' => $i, $content => $this->_elems($n, 'div', $attr)];
                    /* <li data-target="#<?= $slideshow_css_id ?>" data-slide-to="<?= $i ?>" <?= ($i == 0) ? 'class="active"' : '' ?>></li> */
                    $li_attrs = ['data-target' => $a_id, 'data-slide-to' => $i];                    
                    if ($i === 0)
                        $li_attrs['class'] = ' active';
                    $li = $this->_el('li', $li_attrs);
                    $el_indicator->appendChild($li);
                    $el_indicator->appendChild($this->_nl());
                    /* <div class="item <?= $i == 0 ? 'active' : '' ?>"> */
                    $content_attrs = ['class' => $this->carousel_item_css_class];
                    if ($i === 0)
                        $content_attrs['class'].= ' active';
                    
                    //$this->internal_slideshow_content($n, $el_container);
                    if ($n->hasChildNodes())
                    {
                        $large_text = null;
                        $regular_text = null;
                        $el_container = $this->_el('div', $content_attrs);
                        
                        foreach ($n->childNodes as $cn)
                        {

                            if ($cn->localName == 'slide-text')
                            {   

                                $regular_text = $this->_elems($cn, 'div', ['class' => 'slide_text']);
                            } else if ($cn->localName == 'slide-header')
                            {

                                $large_text = $this->_elems($cn, 'h1');
                            } else if (!empty($cn->localName))
                            {
                                $el_container->appendChild($cn->cloneNode());
                            }
                        }
                        
                        if ($large_text || $regular_text)
                        {
                            $div_container = $this->_e('div', ['class' => 'container']);
                            $div_carousel_caption = $this->_e('div', ['class' => 'carousel-caption']);
                            if ($large_text)
                                $div_carousel_caption->appendChild($large_text);
                            if ($regular_text)
                                $div_carousel_caption->appendChild($regular_text);
                            $div_container->appendChild($div_carousel_caption);
                                $el_container->appendChild($div_container);
                        }
                        
                        if ($cn->localName == 'img')
                                    $el_container->appendChild($cn);
                    }
                    $el_slides->appendChild($el_container);
                    $el_slides->appendChild($this->_nl());
                    $i++;
                }
            }
                        
            $el_main->appendChild($el_indicator);
            $el_main->appendChild($el_slides);
/*        <a class="left carousel-control" href="#<?= $slideshow_css_id ?>" role="button" data-slide="prev">
            <span class="icon-prev"></span>
            <span class="sr-only"><?= ___('Prev') ?></span>
        </a>
        <a class="right carousel-control" href="#<?= $slideshow_css_id ?>" role="button" data-slide="next">
            <span class="icon-next"></span>
            <span class="sr-only"><?= ___('Next') ?></span>
        </a>
     protected $carousel_prev_css_class = 'left carousel-control';
    protected $carousel_next_css_class = 'icon-prev';
    protected $carousel_prev_icon_css_class = 'right carousel-control';
    protected $carousel_next_icon_css_class = 'icon-next';    
* 
*/
            $a_prev = $this->_el('a', ['class' => $this->carousel_prev_css_class, 'href' => "#{$a_id}", 'role' => 'button', 'data-slide' => 'prev'],
                    [$this->_el('span', ['class' => $this->carousel_prev_icon_css_class]), $this->_es('span',['class' => 'sr-only'], ___('Prev')) ]);
            $a_next = $this->_el('a', ['class' => $this->carousel_next_css_class, 'href' => "#{$a_id}", 'role' => 'button', 'data-slide' => 'next'],
                    [$this->_el('span', ['class' => $this->carousel_next_icon_css_class]), $this->_es('span',['class' => 'sr-only'], ___('Next')) ]);
            $el_main->appendChild($a_prev);
            $el_main->appendChild($a_next);
            return $el_main;
        }
        return null;
    }

}

