<?php
namespace Skin;

class bootstrap4 extends \Skin\bootstrap3
{

    protected $carousel_item_css_class = 'carousel-item';
    
     protected $carousel_prev_css_class = 'carousel-control-prev';
    protected $carousel_next_css_class = 'carousel-control-next';
    protected $carousel_prev_icon_css_class = 'carousel-control-prev-icon';
    protected $carousel_next_icon_css_class = 'carousel-control-next-icon';    
    
    
    public function getDefaultCSS()
    {
        return get_system_or_user_url_path('/skins/bootstrap4/bootstrap.min.css');
    }
    /**
     * Standard pagination
     * @param array $page_array
     * @return string
     */
    public function standard_pagination($page_array)
    {
        $s = '';
        if ($page_array)
        {
            $s = "<ul class='pagination'>";
            foreach ($page_array as $page)
            {
                $pg_type = $page['type'];
                $pg_url = $page['url'];
                if(isset($page['number'])) {
                    $pg_num = $page['number'];
                }
                switch ($pg_type)
                {
                    case 'page':
                        $page_item = \__HTML::A($pg_num, $pg_url, ['class' => 'page-link']);
                        break;                    
                    case 'current':
                        $page_item = \__HTML::A($pg_num, $pg_url, ['class' => 'page-link']);
                        break;                    
                    case 'first':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-fast-backward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'last':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-fast-forward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'next':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-step-forward']), $pg_url, ['class' => 'page-link']);
                        break;
                    case 'prev':
                        $page_item = \__HTML::A(\__HTML::I('',['class' => 'fas fa-step-backward']), $pg_url, ['class' => 'page-link']);
                        
                        break;

                }
                $s.= "<li class=\"page-item\">{$page_item}</li>";
            }
            $s.= "</ul>";
        } 
        return $s;
    }
    
    
    /**
     * Standard breadcrumb - called by $Application
     * @param array $breadcrumbs
     * @return string
     */
    public function standard_breadcrumb($breadcrumbs)
    {
        
        $total = ___c($breadcrumbs);
        $str = '';        
        if ($total)
        {
            $site_httpbase = (SCHLIX_SITE_HTTPBASE === '') ? '/' : SCHLIX_SITE_HTTPBASE;
            $str = \__HTML::DIV_start(['class'=>'breadcrumb-container']);
            $str.= \__HTML::OL_start(['class'=>'breadcrumb']);
            $str.= \__HTML::LI(\__HTML::A('<i class="fa fa-home"></i>', $site_httpbase,['class'=>'breadcrumb-home']),  ['class'=>'breadcrumb-item'] );
            for ($i = 0; $i < $total; $i++)
            {
                $crumb = $breadcrumbs[$i];
                $str.= \__HTML::LI(\__HTML::A($crumb['title'], $crumb['link']), ['class'=>'breadcrumb-item']);
            }            
            $str.= \__HTML::OL_end();
            $str.= \__HTML::DIV_end();
            return $str;
        } else return '';
        
        
        $brcm[] = \__HTML::LI(\__HTML::A('Home', $site_httpbase, ['class'=>'breadcrumb-home'])) ;
        
        return $brcm;
        
    }
    
    protected function xui_input_addon(\DOMElement $origin)
    {
        $a_label = $origin->getAttribute('label');
        $a_fonticon = $origin->getAttribute('fonticon');
        $attrs = ['class' => 'input-group-prepend'];
        
        if ($a_label || $a_fonticon) 
        {
            $inner = $this->_el('span',['class' => 'input-group-text']);
            $it = $this->internal_icon_text($origin);            
            foreach ($it as $i)
                $inner->appendChild($i);
            $div = $this->_el('div', $attrs, $inner);
        }
        else
        {
            //$inner = $this->_el('span',['class' => 'input-group-text']);
            $inner = $this->_elems($origin,'span',['class' => 'input-group-text']);
            $div = $this->_el('div', $attrs, $inner);
        }
        return $div;
    }
    
    
    /**
     * Grid - column
     * @param \DOMElement $origin
     */
    protected function xui_column(\DOMElement $origin)
    {
        $cl = []; $g = [];
        $attrs = ['xs','sm','md','lg','xs-offset','sm-offset','md-offset','lg-offset'];
        foreach ($attrs as $a)
            $g[$a] = (int) trim($origin->getAttribute($a));
          
        $cn = '';
        if (___c($g) > 0) 
        {
            foreach ($g as $k => $v) if ($v > 0) {
                $kv = ($k == 'xs') ?  $v : $k.'-'.$v;
                $cl[] = 'col-'.$kv; $origin->removeAttribute($k);                
            }
            $cn = implode(' ', $cl);
        }
        return $this->_elems($origin,'div',['class' => $cn]);
    }

    
    protected function xui_accordion(\DOMElement $origin)
    {
        
        
        $tab_count = 0;
        $t_container_id = $origin->getAttribute('id');
        $header_class_attr = $origin->getAttribute('data-header-class');
        $header_elem_attr = $origin->getAttribute('data-header-element');       
        $disable_auto_show = is_value_true($origin->getAttribute('data-disable-autoshow'));
        if (empty($t_container_id))
            throw new \Exception ('Accordion ID cannot be empty');
        $t_container = $this->_e('div',['class' => 'accordion','id' => $t_container_id]);
        $content_id_prefix = $t_container_id.'_accordion_tab_';
        
        $active_tab = $this->getChildWithBooleanAttribute($origin, 'accordion-content', 'data-active');
        $active_tab_id = $active_tab != null ?  $active_tab->getAttribute('id') : null;
        //echo $active_tab_id;die;
        //print_r($get_active_tab);die;
        $header_class = !empty($header_class_attr) ? $header_class_attr : 'btn btn-link';
        $header_elem_type = !empty($header_elem_attr) ? $header_elem_attr : 'button';
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName === 'accordion-content')
            {
                
                $x = $tab_count + 1;
                $acc_id = $content_id_prefix.'_body_'.$x;
                $ph_id = $content_id_prefix.'_head_'.$x;
                $pc_id = $content_id_prefix.'_container_'.$x;
                $extra_class = $c->getAttribute('class');
                $c->removeAttribute('class');
                if ($extra_class)
                    $extra_class = ' '.$extra_class;
                
                $panel_container = $this->_el('div',['id' => $pc_id, 'class' => 'card'.$extra_class]);
                                
                $header_tag = $this->getFirstChildNode($c, 'accordion-header');
                $ph_h4_a = $this->_el($header_elem_type,['class' =>$header_class,'data-toggle' => 'collapse','data-target' => '#'.$acc_id]);
                if ($header_tag)
                {
                     $this->cloneChildNodes($header_tag, $ph_h4_a);
                     $c->removeChild($header_tag);
                     $ph_h4 = $ph_h4_a;
                } else 
                {
                    $header_elem = $this->internal_icon_text($c);
                    $ph_h4_a->appendChild($header_elem[0]);
                    $ph_h4 = $this->_el('h2',['class' => 'mb-0'], $ph_h4_a);
                }
                $panel_heading = $this->_el('div',['class' => 'card-header',  'id' => $ph_id], $ph_h4);
                $this->cleanUpAttributes($panel_heading, ['label', 'fonticon']);
                
                $curr_tab_id = $c->getAttribute('id');
                $is_active_tab = $active_tab_id != null ? ($curr_tab_id === $active_tab_id) : ($tab_count == 0);
                $pc_collapse_class_extra = $is_active_tab && !$disable_auto_show ? ' show' : '';
                $body_id = $content_id_prefix.'_body_'.$x;
                $panel_collapse = $this->_el('div',['id'=> $body_id,'class' => 'collapse'.$pc_collapse_class_extra,  'aria-labelledby' => $ph_id,  'data-parent' => '#'. $t_container_id, ]);
                $panel_body = $this->_elems($c,'div', ['class' => 'card-body']);
                $this->cleanUpAttributes($panel_body, ['label', 'fonticon']);
                
                $panel_collapse->appendChild(($panel_body));
                
                $panel_container->appendChild( $this->_comment('accordion-content'));
                $panel_container->appendChild( $this->_comment('accordion-head'));
                $panel_container->appendChild( $this->_nl());
                $panel_container->appendChild($panel_heading);
                $panel_container->appendChild( $this->_nl());
                $panel_container->appendChild( $this->_comment('accordion-body'));
                $panel_container->appendChild($panel_collapse);
                $panel_container->appendChild( $this->_nl());
                
                $t_container->appendChild($panel_container);
                $tab_count++;
            }
        }
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild( $this->_comment('Accordion Content'));
        $t_container->appendChild( $this->_nl());
         
        //$t_container->appendChild($t_content);

        return $t_container;
    }    
    
        
    /**
     * Panel/Card
     * @param \DOMElement $origin
     */
    
    protected  function xui_panel(\DOMElement $origin)
    {
        
        $type = $origin->getAttribute('type');
        $css_class = $type ? "card bg-{$type}" : 'card';
        $dlg = $this->_e('div', ['class' => $css_class]);
        $this->copyAttributesFromNode($origin, $dlg);
        
        $c_head = $c_footer = $c_body = null;
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName == 'panel-heading' || $c->localName == 'panel-header')
                $c_head = $this->_elems($c,'div',['class' => 'card-header']);
            if ($c->localName == 'panel-body' || $c->localName == 'panel-body')
                $c_body = $this->_elems($c,'div',['class' => 'card-body']);
            if ($c->localName == 'panel-footer' || $c->localName == 'panel-footer')
                $c_footer = $this->_elems($c,'div',['class' => 'card-footer']);
        }
        if ($c_head) $dlg->appendChild($c_head); 
        if ($c_body) $dlg->appendChild($c_body);
        if ($c_footer) $dlg->appendChild($c_footer);
        
        $this->cleanUpAttributes($dlg, ['header-label', 'header-label','type']);

        return $dlg;
    }    

    
    protected function xui_tab_container(\DOMElement $origin)
    {
        
        $t_container = $this->_e('div',['class' => 'nav-tabs-custom']);
        $t_header = $this->_e('ul',['class' => 'nav nav-tabs']);
        $t_content = $this->_e('div',['class' => 'tab-content']);
        $tab_count = 0;
        foreach ($origin->childNodes as $c)
        {
            if ($c->localName === 'tab')
            {
                $t_id = $c->getAttribute('id');
                $tinternal_fonticon = $c->getAttribute('fonticon');
                $t_label = $c->getAttribute('label');
                // Tab Header
                $li_attr = [];
                $li_attr['class'] = 'nav-item';
                $a_class = 'nav-link';
                if ($tab_count === 0)
                    $a_class = 'nav-link active';
                
                //$t_emlbl = $this->_e('em');
                
                $a_href = $this->_el('a',['class' => $a_class, 'data-toggle' => 'tab', 'href' => '#'.$t_id],  $this->internal_icon_text($c));
                
                $li = $this->_el('li', $li_attr, $a_href );                
                
                $t_header->appendChild($li);
                $t_header->appendChild( $this->_nl());
                // Tab content
                $this->cleanUpAttributes($c, ['fonticon', 'label']);
                $tab_pane_class = ($tab_count == 0) ? 'tab-pane active': 'tab-pane';
                
                $t_c_content = $this->_elems($c, 'div',['id' => $t_id, 'class' =>  $tab_pane_class]);
                
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild( $this->_comment('tab'));
                $t_content->appendChild( $this->_nl());
                $t_content->appendChild($t_c_content);
                $t_content->appendChild( $this->_nl());
                
                //$t_c_content =  $this->cloneChildNodes($c, $t_c_content);*/
                $tab_count++;
            }
        }
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild($t_header);
        $t_container->appendChild( $this->_nl());
        $t_container->appendChild( $this->_comment('Tab Content'));
        $t_container->appendChild( $this->_nl());
         
        $t_container->appendChild($t_content);

        return $t_container;
    }    
        
    /**
     * XUI - Textbox/select
     * @param \DOMElement $origin
     * @return \DOMElement
     */
    protected function internal_form_input(\DOMElement $origin, $input_tag, $custom_class = '') 
    {
        $nv_input_tags = ['select','textarea'];
        $attrs = ['class' => 'form-control'];
        if (!empty($custom_class))
            $attrs['class'] = $this->addNewClassNameToClassList ($attrs['class'], $custom_class);
        $input = $this->_input($origin, $input_tag, $attrs);
        $fonticon = trim($input->getAttribute('fonticon'));
        $attr_type = trim($input->getAttribute('type'));
        $attr_label = trim($input->getAttribute('label'));
        $attr_prefix = trim($input->getAttribute('prefix'));
        $attr_suffix = trim($input->getAttribute('suffix'));
        $attr_has_warning = is_value_true($input->getAttribute('has-warning'));
        $attr_has_error = is_value_true($input->getAttribute('has-error'));
        $attr_help_block = trim($input->getAttribute('help-text'));
        $attr_input_size = trim($input->getAttribute('input-group-size'));
        $attr_class_input_size = $attr_input_size == 'large' ? 'input-group-lg' : ($attr_input_size == 'small' ? 'input-group-sm' : '');
        
        $attr_suffixinternal_fonticon = trim($input->getAttribute('suffix-fonticon'));
        $attr_disableformgroup = trim($input->getAttribute('disable-form-group'));        
        $attr_id = trim($input->getAttribute('id'));
        
        if (empty($attr_type) && $input_tag == 'input')
            $input->setAttribute('type','text');
        if (in_array($input_tag, $nv_input_tags))
        {
            $input->removeAttribute('value');
            if ($input_tag == 'textarea')
            {
                if ($origin->hasChildNodes())
                    $this->cloneChildNodes ($origin, $input);
            }
        }        
        $this->cleanUpAttributes($input, ['fonticon','label','prefix','suffix','suffix-fonticon','disable-form-group','has-warning','has-error','data-field','data-var']);
        
        $h_suffixinternal_fonticon = !empty($attr_suffixinternal_fonticon);
        $h_suffix = !empty($attr_suffix);
        $h_prefix = !empty($attr_prefix);
        $hinternal_fonticon = !empty ($fonticon);
        $h_label = !empty($attr_label);
        $rq_ig =   $hinternal_fonticon || $h_prefix || $h_suffix || $h_suffixinternal_fonticon || $attr_has_warning || $attr_has_error;
        $inner_elems = [];    
        $input_group = null;
        
        $el_label = null;
        $class_input_group_addon_prefix = 'input-group-prepend';
        $class_input_group_addon_suffix = 'input-group-append';
        $icon = '';
        //$df = $this->_n();
        if (!empty($attr_label))
        {
            if ($attr_has_error)
                $icon = 'fa fa-times';
            else if ($attr_has_warning)
                $icon = 'fa fa-exclamation-triangle';
            $el_label = $this->internal_label($icon,$attr_label, $attr_id );
        }        
        if ($rq_ig)
        {
            
            if ($hinternal_fonticon && $h_prefix)
            {
                $n_icon = $this->_e('i',['class' => $fonticon]);
                $n_prefix = $this->_t(' '.$h_prefix);
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_prefix], null, [$n_icon, $n_prefix]);
                
            } else 
            {
                if ($hinternal_fonticon)
                {                   
                    $iga_text = $this->_el('span',['class' =>'input-group-text'], $this->_e('i',['class' => $fonticon])); 
                    $inner_elems[] = $this->_el('span',['class' => $class_input_group_addon_prefix], $iga_text);
                } else if ($h_prefix)
                {
                    $iga_text = $this->_es('span',['class' =>'input-group-text'], $attr_prefix); 
                    $inner_elems[] = $this->_el('span',['class' => $class_input_group_addon_prefix], $iga_text); 
                }
            }
            $inner_elems[] = $input;
            if ($h_suffix)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_suffix], null, $this->_e('span', ['class' => 'input-group-text'], $attr_suffix));
            } elseif ($attr_suffixinternal_fonticon)
            {
                $inner_elems[] = $this->_e('span',['class' => $class_input_group_addon_suffix], null, $this->_e('i',['class' => $attr_suffixinternal_fonticon]));
            }
            $ig_class = 'input-group';            
            if (!empty($attr_class_input_size))
                $ig_class.= ' '.$attr_class_input_size;
            $input_group = $this->_e('div', ['class' => $ig_class], null, $inner_elems);
                        
        }
        // add form group if necessary
        $this->cleanUpAttributes($input, ['data-field', 'data-var', 'default-value','fonticon','label']);
        if ((($rq_ig && $h_label && !$attr_disableformgroup) || ($attr_has_error || $attr_has_warning) ) && !$attr_disableformgroup)
        {
            $el_insert = [$el_label];
            $fg_class = 'form-group';
            $add_inner_elems_only = true;
            if ($attr_has_warning)
            {
                $fg_class.= ' has-warning';
            } else if ($attr_has_error)
            {
                $fg_class.= ' has-error';
            }/* else --- the commented code below conflicts with str_alias
            {
                $el_insert[] = $input_group;
                $add_inner_elems_only = false;
            }*/
            $el_insert[] = $input_group;
            $add_inner_elems_only = false;
            
            
            if ($add_inner_elems_only && ___c($inner_elems) > 0)
                $el_insert = array_merge ($el_insert, $inner_elems);
            else
            if ($el_insert[0] == null)
            {
                $el_insert = $inner_elems;
            }
            $fg = $this->_e('div', ['class' => $fg_class], null, $el_insert);
            
            return $fg;
        } else if ($rq_ig)
        {
            return $input_group;
        }
        else if ($h_label)
        {
            $tn = $this->html_document->createDocumentFragment();
            $tn->appendChild($el_label);
            $tn->appendChild($input);
            return $tn;
        } 
        return $input;
    }    
     
}

