<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */

  if (!defined('SCHLIX_VERSION')) die('No Access');
  global $CurrentUser;
?>

<div id="<?= $this->block_name; ?>" class="news-block">
  <div class="news-block__heading">
    <h3><?= ___h($block_title) ?></h3>
  </div>
  <div class="news-block__content">
    <div class="row">
      <?php for ($i=0; $i < $items_count;$i++ ): ?>
        <?php
          $item=$items[$i];
          $entry = $item['date_created'];
          // you can customize your own stuff here
          $link = $obj->createFriendlyURL("action=viewitem&id={$item['id']}");
          $entrydate = date("j.M.Y",strtotime($item['date_created']));
          $entrytitle = $item['title'];
          $secondary_headline = $item['summary_secondary_headline'] ? $item['summary_secondary_headline'] : substr(strip_tags($item['summary']), 0, 120) . '...';
          $thumb_filename = $obj->getBlogImage('image_small', $item['summary_intro_image']);
          $caption_text = empty($item['summary_intro_image_caption']) ? $item['title'] : $item['summary_intro_image_caption'];
          if ($item['status'] == 1 && $CurrentUser->hasReadPermission($item['permission_read']) && ($item['date_expiry']  === NULL || $item['date_expiry'] == NULL_DATE || days_difference_from_today($item['date_expiry']) > 0 )):
        ?>
          <div class="col-xs-12 col-sm-6 col-md-4">
            <div class="news-row news-row--bg">
              <a href="<?= $link; ?>" class="overlay-links"></a>
              <div class="news-row__images overlay-images overlay-images--black">
                <img src="<?= $thumb_filename ?>" alt="<?= ___h($caption_text) ?>" />
              </div>
              <div class="news-row__title">
                <h3><?= ___h($entrytitle); ?></h3>
                <!-- <p><?= ___h($secondary_headline) ?></p> -->
              </div>
            </div>
          </div>
        <?php endif; ?>
      <?php endfor; ?>
    </div>
  </div>
</div>
