<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */
?>
<!doctype html>
<head>
    <title><?= \SCHLIX\cmsPageOutput::HTMLPageTitle() ?> - <?= ___h(SCHLIX_SITE_NAME) ?></title>
    <?php include('header.inc.php'); ?>
</head>
<body>
  <div class="page-wrapper">
    <div class="page-content">
      <!--- header  -->
      <?php include('header_nav.inc.php'); ?>

      <?php
        /**********************************************************************
         * Custom header image needs to be placed in the THEME template file
         * if the template has 1 or more sidebar (2 or 3 column)
         * Otherwise the header image will not be displayed properly.
         * To do this, you will need to specify 2 global variables inside your
         * APP template file: $_custom_header_image and $_custom_header_title.
         * The name is arbitrary but must be the same declaration
         *
         * In this example, the blog will be set to using the regular template
         * if it's displayed on the main page, but on subsequent page it will
         * switch to 2 column (two-column-right-sidebar.template.php)
         * because on its MENU item, the inner pages subtemplate is set to
         * two-column-right-sidebar.template.php.
         *
         * You can change this behaviour if you prefer to use a single column
         * template
         **********************************************************************/
        global $_custom_header_image, $_custom_header_title, $_custom_header_extra_class;

        ?>
      <?php if ($_custom_header_image): ?>
        <div class="media-header-full-width <?= $_custom_header_extra_class ?>" style="background-image: url('<?= $_custom_header_image ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="name"><?= $_custom_header_title ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      <?php endif ?>
        <!-- End Page Title -->

        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
            <div class="breadcrumb-bg">
                <div class="container">
                    <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
                </div>
            </div>



        <div class="container-fluid pb-4 pt-4 paddding">
          <section id="display-page" class='container'>
            <div class='row'>
              <div class='col-xs-12 col-md-8'>
                <?= SCHLIX\cmsPageOutput::ApplicationBody() ?>
              </div>
              <div class='col-xs-12 col-md-4'>
                <?= SCHLIX\cmsPageOutput::BlockCategory('sidebar') ?>
              </div>
            </div>
          </section>
        </div>
      </div>


    <!-- end body -->
    <?php include('footer.inc.php'); ?>
  </div>
</body>
</html>
