<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.
 * License: MIT
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */ ?>
<!doctype html>
<head>
<meta charset="UTF-8">
<title><?= ___h(SCHLIX_SITE_NAME) ?> - <?= \SCHLIX\cmsPageOutput::HTMLPageTitle()  ?></title>
<?php include('header.inc.php'); ?>
<?= \SCHLIX\cmsPageOutput::HTMLHeader(); ?>
</head>
<body>
     <div class="navbar-wrapper">
        <div class="container">
            <a class="top_company_logo" href="<?= SCHLIX_SITE_HTTPBASE.'/' ?> "><img src="<?= CURRENT_THEME_URL_PATH; ?>/images/sample_logo_colour.png" alt="logo"></a>
            <div class='top_search_box pull-right'><?= \SCHLIX\cmsPageOutput::BlockCategory('search') ?></div>
            <div style="clear:both"></div>
            <nav class="navbar navbar-default navbar-static-top">
                <div class="container">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="<?= SCHLIX_SITE_HTTPBASE.'/' ?> "><img src="<?= CURRENT_THEME_URL_PATH; ?>/images/sample_logo_colour.png" alt="logo" ></a>

                    </div>
                    <div id="navbar" class="navbar-collapse collapse">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_top') ?>
                    </div>
                </div>
            </nav>

        </div>
    </div>


    <div style="clear:both"></div>
    <section id="display-page" class='container'>
        <div class='row'>
            <div class='col-md-9'>
                    <?= \SCHLIX\cmsPageOutput::ApplicationBody() ?>
            </div>
            <div class='col-md-3'>
                <?= \SCHLIX\cmsPageOutput::BlockCategory('sidebar') ?>
                
            </div>            
        </div>
    </section><!--/#error-->

    <section id="bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer1') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer2') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                       <?= \SCHLIX\cmsPageOutput::BlockCategory('footer3') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer4') ?>
                    </div>    
                </div><!--/.col-md-3-->
            </div>
        </div>
    </section><!--/#bottom-->


    <footer id="footer">
        <div class="container">
            <div class="row">
                <div class="col-sm-6">
                    &copy; <?= date('Y') ?> <a target="_blank" href="<?= SCHLIX_SITE_URL ?>" title="Demo theme">My Company Name</a>. All Rights Reserved.
                </div>
                <div class="col-sm-6">
                    <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_bottom') ?>
                </div>
            </div>
        </div>
    </footer><!--/#footer-->

    <!-- end body -->
</body>
</html>