<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */


 /********* MUST DECLARE SCHLIX_THEME_SKIN, DO NOT DELETE !!! ***********/
if (!defined ('SCHLIX_THEME_SKIN')) define('SCHLIX_THEME_SKIN','bootstrap4');

global $HTMLHeader;
?>

<!doctype html>
<head>
  <meta charset="UTF-8">
      <title><?= \SCHLIX\cmsPageOutput::HTMLPageTitle() ?> - <?= ___h(SCHLIX_SITE_NAME) ?></title>
      <?php include('header.inc.php'); ?>
  </head>
  <body>
    <div class="page-wrapper">
      <div class="page-content">
        <!--- header  -->
        <?php include('header_nav.inc.php'); ?>

        <?php if (SCHLIX\cmsPageOutput::BlockCountInCategory('news_headline') > 0): ?>
        <section class="section-row hero-section">
          <div class="container">
            <?= \SCHLIX\cmsPageOutput::BlockCategory('news_headline') ?>
          </div>
        </section>
        <?php endif ?>

        <!-- ROW 1 -->
        <?php if (SCHLIX\cmsPageOutput::BlockCountInCategory('news_row1') > 0): ?>
          <?= \SCHLIX\cmsPageOutput::BlockCategory('news_row1') ?>
        <?php endif ?>

        <!-- ROW 2 -->
        <?php if (SCHLIX\cmsPageOutput::BlockCountInCategory('news_row2') > 0): ?>
          <section class="section-row news-section news-section--bg">
            <div class="overlay-bg overlay-images overlay-images--black">
                <img src="https://static-demo.schlix.website/images/static/sample2/demo/blue-sea-sunrise2.jpg" alt="Change this text!">
            </div>
            <div class="container">
              <?= \SCHLIX\cmsPageOutput::BlockCategory('news_row2') ?>
            </div>
          </section>
        <?php endif ?>

        <!-- ROW 3 -->
        <?php if (SCHLIX\cmsPageOutput::BlockCountInCategory('news_row3') > 0): ?>
          <?= \SCHLIX\cmsPageOutput::BlockCategory('news_row3') ?>
        <?php endif ?>
        <!-- end news row intros -->
        <div class="clearfix"></div>

        <!-- main page -->
        <section id="display-page" class="section-row">
          <div class="container">
            <?= SCHLIX\cmsPageOutput::ApplicationBody() ?>
          </div>
        </section>
        <!-- end main page -->
      </div>

      <!-- end body -->
      <?php include('footer.inc.php'); ?>
    </div>

  </body>
</html>