<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.
 * License: MIT
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license MIT
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */ ?>
<!doctype html>
<head>
<meta charset="UTF-8">
<title><?= ___h(SCHLIX_SITE_NAME);?> - <?= \SCHLIX\cmsPageOutput::HTMLPageTitle()  ?>
</title>
<?php include('header.inc.php'); ?>
</head>
<body> 
    <!-- topmenu -->
    <div class="navbar-wrapper header-sticky">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
                <div class="container">
                    <a class="navbar-brand" href="<?= SCHLIX_SITE_HTTPBASE.'/' ?> "><img src="<?= CURRENT_THEME_URL_PATH; ?>/images/sample_logo_1_colour.png" alt="Company Name"></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#main-navbar-menu" aria-controls="main-navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="main-navbar-menu">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_top'); ?>
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('search'); ?>
                    </div>
                </div>
            </nav> 
        </div>
    </div>
    <!-- end topmenu -->

    <section id="display-page">
        <div class="container">

        <div class="row">
            <!-- main -->
            <?php 
                global $CurrentUser;
                $is_authenticated = $CurrentUser->authenticated();
            ?>
            <?php if ($is_authenticated): ?>
            <div class="col-sm-3 pull-right float-right" >
                <?= SCHLIX\cmsPageOutput::BlockCategory('sidebar_members') ?>
            </div>                        
            <?php endif ?>
            <!-- sidebar -->
            <div class="<?= $is_authenticated ? 'col-sm-9' : 'col-sm-12' ?>">
                <?= SCHLIX\cmsPageOutput::ApplicationBody() ?>
            </div>
            
        </div>
            

        </div>
        <div class="clearfix"></div>
    </section><!--/#error-->

    <section id="bottom">
        <?= \SCHLIX\cmsPageOutput::BlockCategory('testimonials') ?>
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer1') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer2') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                       <?= \SCHLIX\cmsPageOutput::BlockCategory('footer3') ?>
                    </div>    
                </div><!--/.col-md-3-->

                <div class="col-md-3 col-sm-6">
                    <div class="widget">
                        <?= \SCHLIX\cmsPageOutput::BlockCategory('footer4') ?>
                    </div>    
                </div><!--/.col-md-3-->
            </div>
        </div>
    </section><!--/#bottom-->


    <footer id="footer">
        <div class="container">
            <div class="row">
                <div class="col-sm-6">
                    &copy; <?= date('Y') ?> <a target="_blank" href="<?= SCHLIX_SITE_URL ?>" title="Demo theme">My Company Name</a>. All Rights Reserved.
                </div>
                <div class="col-sm-6">
                    <?= \SCHLIX\cmsPageOutput::BlockCategory('menu_bottom') ?>
                </div>
            </div>
        </div>
    </footer><!--/#footer-->
    <?php include('footer.inc.php'); ?>
    <!-- end body -->
</body>
</html>