<?php
/* 
 * Upgrade function - for the auto upgrader (installed separately)
 * 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * License: GPLv3 
 *
 * Please read the LICENSE.txt for details
 */

/**
 * Upgrade
 * @ignore
 * @param string $from_version
 * @param string $db_host
 * @param string $db_database
 * @param string $db_username
 * @param string $db_password
 */
function upgrade_schlix ($from_version, $db_host, $db_database, $db_username, $db_password, $db_port = NULL, $db_socket  = NULL, $db_use_ssl = NULL, $db_ssl_ca = NULL)
{    
    $messages = array();
    $errors = array();
        
    $mydb = new \SCHLIX\cmsDatabase($db_host,$db_database, $db_username,$db_password, $db_port, $db_socket, $db_use_ssl, $db_ssl_ca);
    
    $mydb->query("SET SQL_MODE=''");
    $mydb->query("DELETE FROM `gk_cache_items` WHERE cache_key = 'table_columns' OR cache_key = 'table_pks'");
    // v2.0.0 BETA 5
    if (!$mydb->tableColumnExists('gk_user_items', 'avatar'))
        $mydb->query('ALTER TABLE `gk_user_items` ADD `avatar` VARCHAR(255) NULL DEFAULT NULL AFTER `display_name`;');
    if (!$mydb->tableColumnExists('gk_menu_items', 'subtemplate_mobile'))
        $mydb->query('ALTER TABLE `gk_menu_items` ADD `subtemplate_mobile` VARCHAR(64) NULL DEFAULT NULL AFTER `subtemplate`;');
    
    // v2.0.0 RC1
    // SCHLIX updater
    $result = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_app_items` WHERE `title` = 'schlixupdater'");
    if ($result)
    {
        $sql = "UPDATE `gk_app_items` SET `app_alias` =  'schlixupdater', show_in_app_menu = '0' WHERE  `title` = 'schlixupdater'";
    } else
    {
        $sql = "INSERT INTO `gk_app_items` (`title`, `app_alias`, `app_description`, `description`, `has_frontend`, `has_backend`, `show_left_to_adminmenu`, `show_right_to_adminmenu`, `show_in_app_menu`, `show_in_main`, `status`, `sort_order`, `date_modified`) VALUES ( 'schlixupdater', 'schlixupdater', 'SCHLIX Updater', NULL, 1, 1, 0, 0, 0, NULL, 0, 0, NOW())";
    }
    $mydb->query($sql);
    
    
    // v2.0.0 STABLE
    if ($mydb->tableColumnExists('gk_menu_items', 'right_font_icon_css_class'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` CHANGE `right_font_icon_css_class` `use_font_icon_only_no_text` TINYINT(1) NULL DEFAULT NULL; ');
    }
    if ($mydb->tableColumnExists('gk_menu_items', 'left_font_icon_css_class'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` CHANGE `left_font_icon_css_class` `font_icon` VARCHAR(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL; ');    
    }
    
    if ($mydb->tableColumnExists('gk_menu_items', 'right_glyph_icon_css_class'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` CHANGE `right_glyph_icon_css_class` `use_font_icon_only_no_text` TINYINT(1) NULL DEFAULT NULL; ');
    }
    if ($mydb->tableColumnExists('gk_menu_items', 'left_glyph_icon_css_class'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` CHANGE `left_glyph_icon_css_class` `font_icon` VARCHAR(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL; ');    
    }
    
    //quirk
    if (!$mydb->tableColumnExists('gk_menu_items', 'use_font_icon_only_no_text'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` ADD `use_font_icon_only_no_text` TINYINT(1) NULL DEFAULT NULL ;');    
    }
    if (!$mydb->tableColumnExists('gk_menu_items', 'font_icon'))
    {
        $mydb->query('ALTER TABLE `gk_menu_items` ADD `font_icon` VARCHAR(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;');    
    }
    // v2.0.1
    if (!$mydb->tableColumnExists('gk_email_queue_items', 'store_folder'))
    {
        $mydb->query('ALTER TABLE `gk_email_queue_items` ADD `store_folder` VARCHAR(255) NOT NULL AFTER `attachments`; ');
    }
    // v2.0.1 fix cron
    $mydb->query("update `gk_cronscheduler_items` set command_internal = :new_command WHERE command_internal = :old_command", ['new_command' => '\\SCHLIX\\cmsLogger::processRunCleanupLog', 'old_command' => '\\cmsLogger::processRunCleanupLog']);
    
    // v2.0.3
    $mydb->query("update`gk_theme_items` set status = 1");
    
    if (!$mydb->tableColumnExists('gk_theme_items', 'options'))
    {
        $mydb->query('ALTER TABLE `gk_theme_items` ADD `options` MEDIUMTEXT NULL DEFAULT NULL AFTER `subtemplates`; ');
    }
    
    // Frontend Edit Control
    $result = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_macro_items` WHERE `title`='frontendeditcontrol' ");
    if (!$result)
    {
        $mydb->query("INSERT INTO `gk_macro_items` (`title`, `description`, `status`, `sort_order`, `display_in_apps`, `display_in_blocks`, `date_modified`, `enabled_apps`, `enabled_blocks`) VALUES  ( 'frontendeditcontrol', '', 1, 0, 1, 1, NOW(),NULL,NULL)");
        
        $macro_config_exists = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_macro_config` WHERE `section`='frontendeditcontrol' AND `key` ='array_groups_access' ");
        if (!$macro_config_exists)
        {
            $mydb->query("INSERT INTO `gk_macro_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('frontendeditcontrol', 'array_groups_access', 'a:1:{i:0;s:1:\"1\";}', NOW(), 0);");
        }        
    }
    /// end v2.0.3
    
    // v2.0.5
    
    
    if (!$mydb->tableColumnExists('gk_sites_websites', 'db_host'))
    {
        $mydb->query('ALTER TABLE `gk_sites_websites` ADD `mail_default_sender` VARCHAR(255) NULL DEFAULT NULL AFTER `mail_default_email`, ADD `db_host` VARCHAR(255) NULL DEFAULT NULL AFTER `mail_default_sender`, ADD `db_database` VARCHAR(255) NULL DEFAULT NULL AFTER `db_host`, ADD `system_timezone` VARCHAR(255) NULL DEFAULT NULL AFTER `db_database`;');
    }
    
    // v2.0.6
    if (!$mydb->tableExists('gk_theme_config'))
    {
        $mydb->query("CREATE TABLE `gk_theme_config` (
                    `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `value` text COLLATE utf8mb4_unicode_ci,
                    `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    `modified_by_id` bigint(20) NOT NULL DEFAULT '0',
                    UNIQUE KEY `primary_key` (`section`,`key`) 
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        
    }
    ////////////////////////////////////////
    // v2.0.9 (no public release, and v2.1.0
    ////////////////////////////////////////
    // Drop unusued table columns
    if ($mydb->tableColumnExists('gk_blog_items', 'close_commenting'))
        $mydb->query("ALTER TABLE `gk_blog_items` DROP `close_commenting`;");
    if ($mydb->tableColumnExists('gk_blog_items', 'close_pingback'))
        $mydb->query("ALTER TABLE `gk_blog_items` DROP `close_pingback`;");
    if ($mydb->tableColumnExists('gk_blog_items', 'hide_comments'))
        $mydb->query("ALTER TABLE `gk_blog_items` DROP `hide_comments`;");
    // 2.1.0 - add gk_landing_categories
    if (!$mydb->tableExists('gk_landing_categories'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_landing_categories` (
                    `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `date_available` datetime DEFAULT NULL,
                    `date_expiry` datetime DEFAULT NULL,
                    `sort_order` int(3) unsigned DEFAULT NULL,
                    `status` tinyint(1) NOT NULL DEFAULT '1',
                    `featured` tinyint(1) NOT NULL DEFAULT '0',
                    `version` decimal(20,2) NOT NULL DEFAULT '1.00',
                    `pageview` bigint(20) NOT NULL DEFAULT '0',
                    `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) unsigned DEFAULT NULL,
                    `locked_by_id` bigint(20) DEFAULT NULL,
                    `meta_key` text COLLATE utf8mb4_unicode_ci,
                    `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `custom_css` mediumtext COLLATE utf8mb4_unicode_ci,
                    `custom_javascript` mediumtext COLLATE utf8mb4_unicode_ci,
                    `custom_header` mediumtext COLLATE utf8mb4_unicode_ci,
                    `permission_write` text COLLATE utf8mb4_unicode_ci,
                    `permission_read` text COLLATE utf8mb4_unicode_ci,
                    `options` text COLLATE utf8mb4_unicode_ci,
                    `tags` text COLLATE utf8mb4_unicode_ci,

                    PRIMARY KEY (`cid`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `sort_order` (`sort_order`),
                    KEY `status` (`status`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `modified_by_id` (`modified_by_id`),
                    UNIQUE KEY `guid` (`guid`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }
    // 2.1.0 - add gk_landing_items
    if (!$mydb->tableExists('gk_landing_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_landing_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `summary` mediumtext COLLATE utf8mb4_unicode_ci,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `date_available` datetime DEFAULT NULL,
                    `date_expiry` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `locked_by_id` bigint(20) DEFAULT NULL,
                    `permission_write` text COLLATE utf8mb4_unicode_ci,
                    `permission_read` text COLLATE utf8mb4_unicode_ci,
                    `meta_key` text COLLATE utf8mb4_unicode_ci,
                    `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `pageview` bigint(20) NOT NULL DEFAULT '0',
                    `status` int(11) NOT NULL DEFAULT '0',
                    `featured` tinyint(1) NOT NULL DEFAULT '0',
                    `version` decimal(20,2) NOT NULL DEFAULT '1.00',
                    `sort_order` int(11) NOT NULL DEFAULT '0',
                    `options` text COLLATE utf8mb4_unicode_ci,
                    `tags` text COLLATE utf8mb4_unicode_ci,

                    PRIMARY KEY (`id`),
                    KEY `category_id` (`category_id`),
                    KEY `title` (`title`),
                    KEY `id_category_id` (`id`,`category_id`),
                    KEY `id_category_id_status` (`id`,`category_id`,`status`),
                    KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
                    KEY `virtual_filename` (`virtual_filename`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `modified_by_id` (`modified_by_id`),
                    KEY `status` (`status`),
                    KEY `sort_order` (`sort_order`),
                    UNIQUE KEY `guid` (`guid`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");    
    }
    // 2.1.0 - add table  gk_blog_categories_items
    if (!$mydb->tableExists('gk_blog_categories_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_blog_categories_items` (
                    `id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `cid` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `is_primary` tinyint(1) unsigned NOT NULL DEFAULT '0',
                    PRIMARY KEY (`id`,`cid`),
                    KEY `is_primary` (`is_primary`),
                    UNIQUE KEY `primary_category` (`id`,`cid`,`is_primary`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");        
        // now upgrade blog and migrate it to multi-category
        $mydb->query("INSERT INTO gk_blog_categories_items (id, cid, is_primary)
            SELECT id, category_id as cid, 1 as is_primary
            FROM gk_blog_items;");
        // now drop category_id after migration
        if ($mydb->tableColumnExists('gk_blog_items', 'category_id'))
            $mydb->query("ALTER TABLE `gk_blog_items` DROP `category_id`;");
        
    }    
    // 2.1.0 - gk_blog_items - add new columns - summary
    if (!$mydb->tableColumnExists('gk_blog_items', 'summary_secondary_headline'))
        $mydb->query("ALTER TABLE `gk_blog_items` ADD `summary_secondary_headline` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `summary`; ");
    if (!$mydb->tableColumnExists('gk_blog_items', 'summary_intro_image'))
        $mydb->query('ALTER TABLE `gk_blog_items` ADD `summary_intro_image` VARCHAR(255) NULL DEFAULT NULL AFTER `summary_secondary_headline`;');
    if (!$mydb->tableColumnExists('gk_blog_items', 'summary_intro_image_caption'))
        $mydb->query("ALTER TABLE `gk_blog_items` ADD `summary_intro_image_caption` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `summary_intro_image`; ");
    // 2.1.0  - gk_blog_items - add new columns - description    
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_alternative_title'))
        $mydb->query("ALTER TABLE `gk_blog_items` ADD `description_alternative_title` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `description`; ");    
    
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_secondary_headline'))
        $mydb->query("ALTER TABLE `gk_blog_items` ADD `description_secondary_headline` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `description_alternative_title`; ");
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_intro_image'))
        $mydb->query('ALTER TABLE `gk_blog_items` ADD `description_intro_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description_secondary_headline`;');
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_background_image'))
        $mydb->query('ALTER TABLE `gk_blog_items` ADD `description_background_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description_intro_image`;');    
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_intro_image_caption'))
        $mydb->query('ALTER TABLE `gk_blog_items` ADD `description_intro_image_caption` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `description_background_image`;');
    if (!$mydb->tableColumnExists('gk_blog_items', 'description_custom_html_code'))
        $mydb->query('ALTER TABLE `gk_blog_items` ADD `description_custom_html_code` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL AFTER `description_intro_image_caption`;');

    // 2.1.0 - gk_blog_categories - add new columns - summary
    if (!$mydb->tableColumnExists('gk_blog_categories', 'summary_intro_image'))
        $mydb->query('ALTER TABLE `gk_blog_categories` ADD `summary_intro_image` VARCHAR(255) NULL DEFAULT NULL AFTER `summary`;');
    // 2.1.0 - gk_blog_categories - add new columns - summary    
    if (!$mydb->tableColumnExists('gk_blog_categories', 'description_intro_image'))
        $mydb->query('ALTER TABLE `gk_blog_categories` ADD `description_intro_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description`;');
    if (!$mydb->tableColumnExists('gk_blog_categories', 'description_background_image'))
        $mydb->query('ALTER TABLE `gk_blog_categories` ADD `description_background_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description_intro_image`;');    
    
    
    // 2.1.0 - gk_html_categories - add new columns - description
    if (!$mydb->tableColumnExists('gk_html_categories', 'description_background_image'))
        $mydb->query('ALTER TABLE `gk_html_categories` ADD `description_background_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description`;');    
    // 2.1.0 - gk_html_items - add new columns - description
    if (!$mydb->tableColumnExists('gk_html_items', 'description_background_image'))
        $mydb->query('ALTER TABLE `gk_html_items` ADD `description_background_image` VARCHAR(255) NULL DEFAULT NULL AFTER `description`;');    
    
    // 2.1.0 - add table  gk_tag_categories
    if (!$mydb->tableExists('gk_tag_categories'))
    {
            $mydb->query("CREATE TABLE IF NOT EXISTS `gk_tag_categories` (
                        `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                        `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                        `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                        `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                        `date_created` datetime DEFAULT NULL,
                        `date_modified` datetime DEFAULT NULL,
                        `date_available` datetime DEFAULT NULL,
                        `date_expiry` datetime DEFAULT NULL,
                        `sort_order` int(3) unsigned DEFAULT NULL,
                        `status` tinyint(1) NOT NULL DEFAULT '1',
                        `featured` tinyint(1) NOT NULL DEFAULT '0',
                        `pageview` bigint(20) NOT NULL DEFAULT '0',
                        `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
                        `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                        `modified_by_id` bigint(20) unsigned DEFAULT NULL,
                        `locked_by_id` bigint(20) DEFAULT NULL,
                        `meta_key` text COLLATE utf8mb4_unicode_ci,
                        `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                        `summary` mediumtext COLLATE utf8mb4_unicode_ci,
                        `description` mediumtext COLLATE utf8mb4_unicode_ci,
                        `permission_write` text COLLATE utf8mb4_unicode_ci,
                        `permission_read` text COLLATE utf8mb4_unicode_ci,
                        `options` text COLLATE utf8mb4_unicode_ci,

                        PRIMARY KEY (`cid`),
                        KEY `date_created` (`date_created`),
                        KEY `date_modified` (`date_modified`),
                        KEY `sort_order` (`sort_order`),
                        KEY `status` (`status`),
                        KEY `created_by_id` (`created_by_id`),
                        KEY `modified_by_id` (`modified_by_id`),
                        UNIQUE KEY `guid` (`guid`)
                      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");        
    }    
    
    // 2.1.0 - add table  gk_tag_categories
    if (!$mydb->tableExists('gk_tag_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_tag_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `date_created` datetime DEFAULT NULL,
                    `internalurl` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
                    `application` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',

                    PRIMARY KEY (`id`),
                    KEY `category_id` (`category_id`),
                    KEY `application` (`application`),
                    KEY `guid` (`guid`),
                    UNIQUE KEY `guid_category_id` (`guid`, `category_id`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");        
    }
    // 2.1.0 - add gk_menu_items -  subtemplate_inner_pages
    
    if (!$mydb->tableColumnExists('gk_menu_items', 'subtemplate_inner_pages'))
        $mydb->query('ALTER TABLE `gk_menu_items` ADD `subtemplate_inner_pages` VARCHAR(64) NULL DEFAULT NULL AFTER `subtemplate`; ');    
    
    // Tag
    $result = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_app_items` WHERE `title` = 'tag'");
    if (!$result)
    {        
        $mydb->query("INSERT INTO `gk_app_items` (`title`, `app_alias`, `app_description`, `description`, `has_frontend`, `has_backend`, `show_left_to_adminmenu`, `show_right_to_adminmenu`, `show_in_app_menu`, `show_in_main`, `status`, `sort_order`, `date_modified`) VALUES ( 'tag', 'tag', 'Tags', NULL, 1, 1, 0, 0, 0, NULL, 0, 0, NOW())");
    }
    
    // Landing
    $result = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_app_items` WHERE `title` = 'landing'");
    if (!$result)    
    {        
        $mydb->query("INSERT INTO `gk_app_items` (`title`, `app_alias`, `app_description`, `description`, `has_frontend`, `has_backend`, `show_left_to_adminmenu`, `show_right_to_adminmenu`, `show_in_app_menu`, `show_in_main`, `status`, `sort_order`, `date_modified`) VALUES ( 'landing', 'lp', 'Landing Pages', NULL, 1, 1, 0, 0, 1, NULL, 0, 0, NOW())");
    }
    
    // 2.1.0 Fix menus that don't suppose to be listed
    $mydb->query("UPDATE `gk_app_items` SET show_in_app_menu = '0' WHERE  `title` IN ('schlixupdater','simplesitemap','tag');");
    // end 
    /*
     * Not necessary
    if (!$mydb->tableColumnExists('gk_cronscheduler_items', 'date_lastrun_for'))
    {
        $mydb->query('ALTER TABLE `gk_cronscheduler_items` ADD `date_lastrun_for` DATETIME NULL DEFAULT NULL AFTER `date_lastrun_end`; ');
    }*/
    // v2.1.1-1 - WYSIWYG profiles
    if (!$mydb->tableExists('gk_wysiwyg_profiles'))
    {
        // warning - do not change this even if editor_id isn't being used.
        $mydb->query("CREATE TABLE `gk_wysiwyg_profiles` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `editor_id` bigint(20) NOT NULL,
            `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
            `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `sort_order` int(11) NOT NULL DEFAULT '0',           
            `date_created` datetime NOT NULL,
            `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `permission_read` text COLLATE utf8mb4_unicode_ci,
            `permission_write` text COLLATE utf8mb4_unicode_ci,
            `options` text COLLATE utf8mb4_unicode_ci,
            `is_system` tinyint(1) NOT NULL DEFAULT '0',
            PRIMARY KEY (`id`),
            KEY `editor_id` (`editor_id`),
            KEY `title` (`title`),
            KEY `is_system` (`is_system`)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
          ");
        
        $mydb->query("
        INSERT INTO `gk_wysiwyg_profiles` (`id`, `editor_id`, `title`, `virtual_filename`, `sort_order`, `date_created`, `date_modified`, `permission_read`, `permission_write`, `options`, `is_system`) VALUES
        (1, 1, 'Blank Text Area', 'blank', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (2, 2, 'TinyMCE4 Full Featured', 'tinymce4-full', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (3, 2, 'TinyMCE4 Simple', 'tinymce4-simple', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (4, 2, 'TinyMCE4 Limited (No Media Manager)', 'tinymce4-limited', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (5, 3, 'CKEditor4 Full Featured', 'ckeditor4-full', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (6, 3, 'CKEditor4 Simple', 'ckeditor4-simple', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (7, 3, 'CKEditor4 Limited (No Media Manager)', 'ckeditor4-limited', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (8, 4, 'CodeMirror PHP', 'codemirror-php', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (9, 4, 'CodeMirror HTML', 'codemirror-html', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (10, 4, 'CodeMirror Javascript', 'codemirror-js', 0, NOW(), NOW(), NULL, NULL, NULL, 1),
        (11, 4, 'CodeMirror CSS', 'codemirror-css', 0, NOW(), NOW(), NULL, NULL, NULL, 1);
        ");        
    }
    
    // v2.1.1-1 - WYSIWYG Config and profiles
    if (!$mydb->tableExists('gk_wysiwyg_config'))
    {
        $mydb->query("CREATE TABLE `gk_wysiwyg_config` (
                    `section` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `key` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `value` text COLLATE utf8mb4_unicode_ci,
                    `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    `modified_by_id` bigint(16) NOT NULL DEFAULT '0',
                    UNIQUE KEY `primary_key` (`section`,`key`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
            // TinyMCE4 full
            $mydb->query("INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES
            ('tinymce4-full', 'array_menubar_top', 'a:7:{i:0;s:4:\"file\";i:1;s:4:\"edit\";i:2;s:6:\"insert\";i:3;s:4:\"view\";i:4;s:6:\"format\";i:5;s:5:\"table\";i:6;s:5:\"tools\";}', NOW(), 0),
            ('tinymce4-full', 'array_plugins', 'a:37:{i:0;s:7:\"advlist\";i:1;s:6:\"anchor\";i:2;s:8:\"autolink\";i:3;s:10:\"autoresize\";i:4;s:7:\"charmap\";i:5;s:4:\"code\";i:6;s:10:\"codemirror\";i:7;s:10:\"codesample\";i:8;s:11:\"colorpicker\";i:9;s:11:\"contextmenu\";i:10;s:8:\"compat3x\";i:11;s:14:\"directionality\";i:12;s:9:\"emoticons\";i:13;s:11:\"fontawesome\";i:14;s:10:\"fullscreen\";i:15;s:2:\"hr\";i:16;s:5:\"image\";i:17;s:10:\"imagetools\";i:18;s:14:\"insertdatetime\";i:19;s:4:\"link\";i:20;s:5:\"lists\";i:21;s:5:\"media\";i:22;s:11:\"nonbreaking\";i:23;s:11:\"noneditable\";i:24;s:9:\"pagebreak\";i:25;s:5:\"paste\";i:26;s:7:\"preview\";i:27;s:5:\"print\";i:28;s:4:\"save\";i:29;s:13:\"searchreplace\";i:30;s:5:\"table\";i:31;s:8:\"template\";i:32;s:9:\"textcolor\";i:33;s:11:\"textpattern\";i:34;s:12:\"visualblocks\";i:35;s:11:\"visualchars\";i:36;s:9:\"wordcount\";}', NOW(), 0),
            ('tinymce4-full', 'array_toolbar1', 'a:22:{i:0;s:4:\"undo\";i:1;s:4:\"redo\";i:2;s:1:\"|\";i:3;s:11:\"styleselect\";i:4;s:9:\"forecolor\";i:5;s:9:\"backcolor\";i:6;s:1:\"|\";i:7;s:6:\"insert\";i:8;s:1:\"|\";i:9;s:4:\"link\";i:10;s:6:\"unlink\";i:11;s:6:\"anchor\";i:12;s:5:\"image\";i:13;s:5:\"media\";i:14;s:5:\"table\";i:15;s:1:\"|\";i:16;s:7:\"charmap\";i:17;s:11:\"fontawesome\";i:18;s:1:\"|\";i:19;s:12:\"visualblocks\";i:20;s:1:\"|\";i:21;s:10:\"codesample\";}', NOW(), 0),
            ('tinymce4-full', 'array_toolbar2', 'a:22:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:9:\"underline\";i:3;s:13:\"strikethrough\";i:4;s:9:\"subscript\";i:5;s:11:\"superscript\";i:6;s:1:\"|\";i:7;s:12:\"removeformat\";i:8;s:1:\"|\";i:9;s:9:\"alignleft\";i:10;s:11:\"aligncenter\";i:11;s:10:\"alignright\";i:12;s:12:\"alignjustify\";i:13;s:1:\"|\";i:14;s:7:\"bullist\";i:15;s:7:\"numlist\";i:16;s:7:\"outdent\";i:17;s:6:\"indent\";i:18;s:10:\"blockquote\";i:19;s:2:\"hr\";i:20;s:1:\"|\";i:21;s:4:\"code\";}', NOW(), 0),
            ('tinymce4-full', 'bool_config_allow_conditional_comments', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_autoresize_on_init', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_elementpath', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_end_container_on_empty_block', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_fix_list_elements', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_force_hex_style_colors', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_image_advtab', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_image_dimensions', '', NOW(), 0),
            ('tinymce4-full', 'bool_config_importcss_append', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_statusbar', '1', NOW(), 0),
            ('tinymce4-full', 'bool_config_typeahead_urls', '1', NOW(), 0),
            ('tinymce4-full', 'bool_forced_root_block', '1', NOW(), 0),
            ('tinymce4-full', 'str_config_autoresize_max_height', '800', NOW(), 0),
            ('tinymce4-full', 'str_config_autoresize_min_height', '400', NOW(), 0),
            ('tinymce4-full', 'str_config_extended_valid_elements', 'strike,span[class|style|id],i[class],div[class],div,div[id|class|style],script[language|type|src]', NOW(), 0),
            ('tinymce4-full', 'str_config_importcss_groups', '[ {title: \'Image styles\', filter: /^(img)\\./},\n       {title: \'Heading styles\', filter: /^(h1|h2|h3|h4|h5|h6)\\./},\n       {title: \'Table styles\', filter: /^(table|td|tr)\\./},\n       {title: \'List styles\', filter: /^(ul|li)\\./},\n       {title: \'Block styles\', filter: /^(div|p)\\./},\n       {title: \'Link styles\', filter: /^(a)\\./},\n       {title: \'Generic styles\'} ]', NOW(), 0),
            ('tinymce4-full', 'str_config_init_instance_callback', 'function (inst) { \n         //  inst.execCommand(\'mceAutoResize\'); // please enable the autoresize plugin\n         }', NOW(), 0),
            ('tinymce4-full', 'str_config_schema', 'html5', NOW(), 0),
            ('tinymce4-full', 'str_config_selector', 'textarea.wysiwyg', NOW(), 0),
            ('tinymce4-full', 'str_config_setup', 'function (editor) {\n           editor.on(\'change\', function () {\n               tinymce.triggerSave(); // this function is necessary for SCHLIX CMS - DO NOT REMOVE THIS LINE!\n           });\n       }', NOW(), 0),
            ('tinymce4-full', 'str_config_width', '100%', NOW(), 0),
            ('tinymce4-full', 'str_media_manager', 'schlix', NOW(), 0),
            ('tinymce4-full', 'str_media_manager_image_list', 'schlix', NOW(), 0),
            ('tinymce4-full', 'str_media_manager_link_list', 'schlix', NOW(), 0),
            ('tinymce4-full', 'str_media_manager_media_list', 'schlix', NOW(), 0),
            ('tinymce4-full', 'str_media_permission', 'full', NOW(), 0);");

            //TinyMCE4-simple
            $mydb->query("
            INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES
            ('tinymce4-simple', 'bool_config_menubar', '', NOW(), 0),
            ('tinymce4-simple', 'array_plugins', 'a:17:{i:0;s:7:\"advlist\";i:1;s:8:\"autolink\";i:2;s:5:\"lists\";i:3;s:4:\"link\";i:4;s:5:\"image\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:7:\"preview\";i:8;s:6:\"anchor\";i:9;s:13:\"searchreplace\";i:10;s:12:\"visualblocks\";i:11;s:14:\"insertdatetime\";i:12;s:5:\"media\";i:13;s:5:\"table\";i:14;s:11:\"contextmenu\";i:15;s:5:\"paste\";i:16;s:10:\"codemirror\";}', NOW(), 0),
            ('tinymce4-simple', 'array_toolbar1', 'a:22:{i:0;s:4:\"undo\";i:1;s:4:\"redo\";i:2;s:1:\"|\";i:3;s:6:\"insert\";i:4;s:1:\"|\";i:5;s:11:\"styleselect\";i:6;s:1:\"|\";i:7;s:4:\"bold\";i:8;s:6:\"italic\";i:9;s:1:\"|\";i:10;s:9:\"alignleft\";i:11;s:11:\"aligncenter\";i:12;s:10:\"alignright\";i:13;s:12:\"alignjustify\";i:14;s:1:\"|\";i:15;s:7:\"bullist\";i:16;s:7:\"numlist\";i:17;s:7:\"outdent\";i:18;s:6:\"indent\";i:19;s:1:\"|\";i:20;s:4:\"link\";i:21;s:5:\"image\";}', NOW(), 0),
            ('tinymce4-simple', 'bool_config_allow_conditional_comments', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_autoresize_on_init', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_elementpath', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_end_container_on_empty_block', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_fix_list_elements', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_force_hex_style_colors', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_image_advtab', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_image_dimensions', '', NOW(), 0),
            ('tinymce4-simple', 'bool_config_importcss_append', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_statusbar', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_config_typeahead_urls', '1', NOW(), 0),
            ('tinymce4-simple', 'bool_forced_root_block', '1', NOW(), 0),
            ('tinymce4-simple', 'str_config_autoresize_max_height', '800', NOW(), 0),
            ('tinymce4-simple', 'str_config_autoresize_min_height', '400', NOW(), 0),
            ('tinymce4-simple', 'str_config_extended_valid_elements', 'strike,span[class|style|id],i[class],div[class],div,div[id|class|style],script[language|type|src]', NOW(), 0),
            ('tinymce4-simple', 'str_config_importcss_groups', '[ {title: \'Image styles\', filter: /^(img)\\./},\n       {title: \'Heading styles\', filter: /^(h1|h2|h3|h4|h5|h6)\\./},\n       {title: \'Table styles\', filter: /^(table|td|tr)\\./},\n       {title: \'List styles\', filter: /^(ul|li)\\./},\n       {title: \'Block styles\', filter: /^(div|p)\\./},\n       {title: \'Link styles\', filter: /^(a)\\./},\n       {title: \'Generic styles\'} ]', NOW(), 0),
            ('tinymce4-simple', 'str_config_init_instance_callback', 'function (inst) { \n         //  inst.execCommand(\'mceAutoResize\'); // please enable the autoresize plugin\n         }', NOW(), 0),
            ('tinymce4-simple', 'str_config_schema', 'html5', NOW(), 0),
            ('tinymce4-simple', 'str_config_selector', 'textarea.wysiwyg', NOW(), 0),
            ('tinymce4-simple', 'str_config_setup', 'function (editor) {\n           editor.on(\'change\', function () {\n               tinymce.triggerSave(); // this function is necessary for SCHLIX CMS - DO NOT REMOVE THIS LINE!\n           });\n       }', NOW(), 0),
            ('tinymce4-simple', 'str_config_width', '100%', NOW(), 0),
            ('tinymce4-simple', 'str_media_manager', 'schlix', NOW(), 0),
            ('tinymce4-simple', 'str_media_manager_image_list', 'schlix', NOW(), 0),
            ('tinymce4-simple', 'str_media_manager_link_list', 'schlix', NOW(), 0),
            ('tinymce4-simple', 'str_media_manager_media_list', 'schlix', NOW(), 0),
            ('tinymce4-simple', 'str_media_permission', 'limited', NOW(), 0);");
            // TinyMCE4-limited
            $mydb->query("INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES            
            ('tinymce4-limited', 'bool_config_menubar', '', NOW(), 0),
            ('tinymce4-limited', 'array_plugins', 'a:16:{i:0;s:7:\"advlist\";i:1;s:8:\"autolink\";i:2;s:5:\"lists\";i:3;s:4:\"link\";i:4;s:5:\"image\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:7:\"preview\";i:8;s:6:\"anchor\";i:9;s:13:\"searchreplace\";i:10;s:12:\"visualblocks\";i:11;s:14:\"insertdatetime\";i:12;s:5:\"table\";i:13;s:11:\"contextmenu\";i:14;s:5:\"paste\";i:15;s:10:\"codemirror\";}', NOW(), 0),
            ('tinymce4-limited', 'array_toolbar1', 'a:22:{i:0;s:4:\"undo\";i:1;s:4:\"redo\";i:2;s:1:\"|\";i:3;s:6:\"insert\";i:4;s:1:\"|\";i:5;s:11:\"styleselect\";i:6;s:1:\"|\";i:7;s:4:\"bold\";i:8;s:6:\"italic\";i:9;s:1:\"|\";i:10;s:9:\"alignleft\";i:11;s:11:\"aligncenter\";i:12;s:10:\"alignright\";i:13;s:12:\"alignjustify\";i:14;s:1:\"|\";i:15;s:7:\"bullist\";i:16;s:7:\"numlist\";i:17;s:7:\"outdent\";i:18;s:6:\"indent\";i:19;s:1:\"|\";i:20;s:4:\"link\";i:21;s:5:\"image\";}', NOW(), 0),
            ('tinymce4-limited', 'bool_config_allow_conditional_comments', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_autoresize_on_init', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_elementpath', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_end_container_on_empty_block', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_fix_list_elements', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_force_hex_style_colors', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_image_advtab', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_image_dimensions', '', NOW(), 0),
            ('tinymce4-limited', 'bool_config_importcss_append', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_statusbar', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_config_typeahead_urls', '1', NOW(), 0),
            ('tinymce4-limited', 'bool_forced_root_block', '1', NOW(), 0),
            ('tinymce4-limited', 'str_config_autoresize_max_height', '800', NOW(), 0),
            ('tinymce4-limited', 'str_config_autoresize_min_height', '400', NOW(), 0),
            ('tinymce4-limited', 'str_config_extended_valid_elements', 'strike,span[class|style|id],i[class],div[class],div,div[id|class|style],script[language|type|src]', NOW(), 0),
            ('tinymce4-limited', 'str_config_init_instance_callback', 'function (inst) { \n       //    inst.execCommand(\'mceAutoResize\'); // please enable the autoresize plugin\n         }', NOW(), 0),
            ('tinymce4-limited', 'str_config_schema', 'html5', NOW(), 0),
            ('tinymce4-limited', 'str_config_selector', 'textarea.wysiwyg', NOW(), 0),
            ('tinymce4-limited', 'str_config_setup', 'function (editor) {\n           editor.on(\'change\', function () {\n               tinymce.triggerSave(); // this function is necessary for SCHLIX CMS - DO NOT REMOVE THIS LINE!\n           });\n       }', NOW(), 0),
            ('tinymce4-limited', 'str_config_width', '100%', NOW(), 0);");

            // CKEditor4-full
            $mydb->query("INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES
            ('ckeditor4-full', 'array_plugins', 'a:53:{i:0;s:11:\"basicstyles\";i:1;s:10:\"blockquote\";i:2;s:9:\"clipboard\";i:3;s:11:\"codesnippet\";i:4;s:11:\"colorbutton\";i:5;s:11:\"colordialog\";i:6;s:11:\"contextmenu\";i:7;s:14:\"copyformatting\";i:8;s:12:\"dialogadvtab\";i:9;s:3:\"div\";i:10;s:12:\"elementspath\";i:11;s:8:\"enterkey\";i:12;s:8:\"entities\";i:13;s:11:\"filebrowser\";i:14;s:4:\"find\";i:15;s:13:\"floatingspace\";i:16;s:4:\"font\";i:17;s:6:\"format\";i:18;s:14:\"horizontalrule\";i:19;s:10:\"htmlwriter\";i:20;s:6:\"iframe\";i:21;s:12:\"iframedialog\";i:22;s:5:\"image\";i:23;s:11:\"indentblock\";i:24;s:10:\"indentlist\";i:25;s:7:\"justify\";i:26;s:8:\"language\";i:27;s:4:\"link\";i:28;s:4:\"list\";i:29;s:9:\"liststyle\";i:30;s:9:\"magicline\";i:31;s:8:\"maximize\";i:32;s:8:\"onchange\";i:33;s:9:\"pagebreak\";i:34;s:13:\"pastefromword\";i:35;s:9:\"pastetext\";i:36;s:7:\"preview\";i:37;s:12:\"removeformat\";i:38;s:6:\"resize\";i:39;s:4:\"save\";i:40;s:9:\"selectall\";i:41;s:10:\"showblocks\";i:42;s:11:\"showborders\";i:43;s:10:\"sourcearea\";i:44;s:11:\"specialchar\";i:45;s:11:\"stylescombo\";i:46;s:3:\"tab\";i:47;s:5:\"table\";i:48;s:10:\"tabletools\";i:49;s:7:\"toolbar\";i:50;s:4:\"undo\";i:51;s:6:\"widget\";i:52;s:11:\"wysiwygarea\";}', NOW(), 0),
            ('ckeditor4-full', 'array_extra_plugins', 'a:3:{i:0;s:10:\"codemirror\";i:1;s:11:\"fontawesome\";i:2;s:16:\"schlixcmsbrowser\";}', NOW(), 0),
            ('ckeditor4-full', 'array_toolbar1', 'a:25:{i:0;s:3:\"Cut\";i:1;s:4:\"Copy\";i:2;s:5:\"Paste\";i:3;s:9:\"PasteText\";i:4;s:13:\"PasteFromWord\";i:5;s:1:\"|\";i:6;s:4:\"Find\";i:7;s:7:\"Replace\";i:8;s:4:\"Undo\";i:9;s:4:\"Redo\";i:10;s:1:\"|\";i:11;s:6:\"Format\";i:12;s:6:\"Styles\";i:13;s:9:\"TextColor\";i:14;s:7:\"BGColor\";i:15;s:1:\"|\";i:16;s:9:\"CreateDiv\";i:17;s:5:\"Table\";i:18;s:1:\"|\";i:19;s:11:\"SpecialChar\";i:20;s:11:\"FontAwesome\";i:21;s:1:\"|\";i:22;s:10:\"ShowBlocks\";i:23;s:1:\"|\";i:24;s:11:\"CodeSnippet\";}', NOW(), 0),
            ('ckeditor4-full', 'array_toolbar2', 'a:28:{i:0;s:4:\"Bold\";i:1;s:6:\"Italic\";i:2;s:9:\"Underline\";i:3;s:6:\"Strike\";i:4;s:9:\"Subscript\";i:5;s:11:\"Superscript\";i:6;s:1:\"|\";i:7;s:12:\"RemoveFormat\";i:8;s:1:\"|\";i:9;s:11:\"JustifyLeft\";i:10;s:13:\"JustifyCenter\";i:11;s:12:\"JustifyRight\";i:12;s:12:\"JustifyBlock\";i:13;s:1:\"|\";i:14;s:12:\"NumberedList\";i:15;s:12:\"BulletedList\";i:16;s:1:\"|\";i:17;s:7:\"Outdent\";i:18;s:6:\"Indent\";i:19;s:10:\"Blockquote\";i:20;s:14:\"HorizontalRule\";i:21;s:1:\"|\";i:22;s:4:\"Link\";i:23;s:6:\"Unlink\";i:24;s:6:\"Anchor\";i:25;s:5:\"Image\";i:26;s:1:\"|\";i:27;s:6:\"Source\";}', NOW(), 0),
            ('ckeditor4-full', 'str_media_permission', 'full', NOW(), 0),
            ('ckeditor4-full', 'str_file_browser', 'schlix', NOW(), 0),
            ('ckeditor4-full', 'str_image_browser', 'schlix', NOW(), 0),
            ('ckeditor4-full', 'str_donot_remove_these_elements', 'strike,span,b,i,div,script', NOW(), 0),
            ('ckeditor4-full', 'str_config_filebrowserWindowHeight', '500', NOW(), 0),
            ('ckeditor4-full', 'str_config_filebrowserWindowWidth', '800', NOW(), 0),
            ('ckeditor4-full', 'str_config_autoGrow_bottomSpace', '', NOW(), 0),
            ('ckeditor4-full', 'str_config_autoGrow_maxHeight', '800', NOW(), 0),
            ('ckeditor4-full', 'str_config_autoGrow_minHeight', '400', NOW(), 0),
            ('ckeditor4-full', 'bool_config_resizeEnabled', '1', NOW(), 0),
            ('ckeditor4-full', 'str_config_height', '200', NOW(), 0),
            ('ckeditor4-full', 'str_config_width', 'auto', NOW(), 0),
            ('ckeditor4-full', 'str_config_removeDialogTabs', 'link:upload;image:upload', NOW(), 0),
            ('ckeditor4-full', 'bool_config_disableNativeTableHandles', '1', NOW(), 0),
            ('ckeditor4-full', 'bool_config_autoGrow_onStartup', '1', NOW(), 0),
            ('ckeditor4-full', 'bool_config_toolbarStartupExpanded', '1', NOW(), 0),
            ('ckeditor4-full', 'bool_config_toolbarCanCollapse', '', NOW(), 0),
            ('ckeditor4-full', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('ckeditor4-full', 'str_schlix_function_init', '// please keep this function so you can save with Apply button\nfor (var instance in CKEDITOR.instances )\n{  \n    CKEDITOR.instances[instance].on( \'change\', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);\n}', NOW(), 0);");

            // CKEditor4-simple
            $mydb->query("INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES
            ('ckeditor4-simple', 'array_plugins', 'a:52:{i:0;s:11:\"basicstyles\";i:1;s:10:\"blockquote\";i:2;s:9:\"clipboard\";i:3;s:11:\"colorbutton\";i:4;s:11:\"colordialog\";i:5;s:11:\"contextmenu\";i:6;s:14:\"copyformatting\";i:7;s:12:\"dialogadvtab\";i:8;s:3:\"div\";i:9;s:12:\"elementspath\";i:10;s:8:\"enterkey\";i:11;s:8:\"entities\";i:12;s:11:\"filebrowser\";i:13;s:4:\"find\";i:14;s:13:\"floatingspace\";i:15;s:4:\"font\";i:16;s:6:\"format\";i:17;s:14:\"horizontalrule\";i:18;s:10:\"htmlwriter\";i:19;s:6:\"iframe\";i:20;s:12:\"iframedialog\";i:21;s:5:\"image\";i:22;s:11:\"indentblock\";i:23;s:10:\"indentlist\";i:24;s:7:\"justify\";i:25;s:8:\"language\";i:26;s:4:\"link\";i:27;s:4:\"list\";i:28;s:9:\"liststyle\";i:29;s:9:\"magicline\";i:30;s:8:\"maximize\";i:31;s:8:\"onchange\";i:32;s:9:\"pagebreak\";i:33;s:13:\"pastefromword\";i:34;s:9:\"pastetext\";i:35;s:7:\"preview\";i:36;s:12:\"removeformat\";i:37;s:6:\"resize\";i:38;s:4:\"save\";i:39;s:9:\"selectall\";i:40;s:10:\"showblocks\";i:41;s:11:\"showborders\";i:42;s:10:\"sourcearea\";i:43;s:11:\"specialchar\";i:44;s:11:\"stylescombo\";i:45;s:3:\"tab\";i:46;s:5:\"table\";i:47;s:10:\"tabletools\";i:48;s:7:\"toolbar\";i:49;s:4:\"undo\";i:50;s:6:\"widget\";i:51;s:11:\"wysiwygarea\";}', NOW(), 0),
            ('ckeditor4-simple', 'array_extra_plugins', 'a:2:{i:0;s:10:\"codemirror\";i:1;s:16:\"schlixcmsbrowser\";}', NOW(), 0),
            ('ckeditor4-simple', 'array_toolbar1', 'a:26:{i:0;s:4:\"Bold\";i:1;s:6:\"Italic\";i:2;s:9:\"Underline\";i:3;s:6:\"Strike\";i:4;s:9:\"Subscript\";i:5;s:11:\"Superscript\";i:6;s:1:\"|\";i:7;s:12:\"RemoveFormat\";i:8;s:1:\"|\";i:9;s:11:\"JustifyLeft\";i:10;s:13:\"JustifyCenter\";i:11;s:12:\"JustifyRight\";i:12;s:12:\"JustifyBlock\";i:13;s:1:\"|\";i:14;s:12:\"NumberedList\";i:15;s:12:\"BulletedList\";i:16;s:1:\"|\";i:17;s:7:\"Outdent\";i:18;s:6:\"Indent\";i:19;s:10:\"Blockquote\";i:20;s:14:\"HorizontalRule\";i:21;s:1:\"|\";i:22;s:4:\"Link\";i:23;s:6:\"Unlink\";i:24;s:6:\"Anchor\";i:25;s:5:\"Image\";}', NOW(), 0),
            ('ckeditor4-simple', 'array_toolbar2', 'a:0:{}', NOW(), 0),
            ('ckeditor4-simple', 'array_toolbar3', 'a:0:{}', NOW(), 0),
            ('ckeditor4-simple', 'array_toolbar4', 'a:0:{}', NOW(), 0),
            ('ckeditor4-simple', 'str_media_permission', 'limited', NOW(), 0),
            ('ckeditor4-simple', 'str_file_browser', 'schlix', NOW(), 0),
            ('ckeditor4-simple', 'str_image_browser', 'schlix', NOW(), 0),
            ('ckeditor4-simple', 'str_donot_remove_these_elements', 'strike,span,b,i,div', NOW(), 0),
            ('ckeditor4-simple', 'str_config_filebrowserWindowHeight', '500', NOW(), 0),
            ('ckeditor4-simple', 'str_config_filebrowserWindowWidth', '800', NOW(), 0),
            ('ckeditor4-simple', 'str_config_autoGrow_bottomSpace', '', NOW(), 0),
            ('ckeditor4-simple', 'str_config_autoGrow_maxHeight', '800', NOW(), 0),
            ('ckeditor4-simple', 'str_config_autoGrow_minHeight', '400', NOW(), 0),
            ('ckeditor4-simple', 'bool_config_resizeEnabled', '1', NOW(), 0),
            ('ckeditor4-simple', 'str_config_height', '200', NOW(), 0),
            ('ckeditor4-simple', 'str_config_width', 'auto', NOW(), 0),
            ('ckeditor4-simple', 'str_config_removeDialogTabs', 'link:upload;image:upload', NOW(), 0),
            ('ckeditor4-simple', 'bool_config_disableNativeTableHandles', '1', NOW(), 0),
            ('ckeditor4-simple', 'bool_config_autoGrow_onStartup', '1', NOW(), 0),
            ('ckeditor4-simple', 'bool_config_toolbarStartupExpanded', '1', NOW(), 0),
            ('ckeditor4-simple', 'bool_config_toolbarCanCollapse', '', NOW(), 0),
            ('ckeditor4-simple', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('ckeditor4-simple', 'str_schlix_function_init', '// please keep this function so you can save with Apply button\nfor (var instance in CKEDITOR.instances )\n{  \n    CKEDITOR.instances[instance].on( \'change\', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);\n}', NOW(), 0);");
            // CKEditor4-limited
            $mydb->query("INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES            
            ('ckeditor4-limited', 'array_plugins', 'a:50:{i:0;s:11:\"basicstyles\";i:1;s:10:\"blockquote\";i:2;s:9:\"clipboard\";i:3;s:11:\"colorbutton\";i:4;s:11:\"colordialog\";i:5;s:11:\"contextmenu\";i:6;s:14:\"copyformatting\";i:7;s:12:\"dialogadvtab\";i:8;s:3:\"div\";i:9;s:12:\"elementspath\";i:10;s:8:\"enterkey\";i:11;s:8:\"entities\";i:12;s:11:\"filebrowser\";i:13;s:4:\"find\";i:14;s:13:\"floatingspace\";i:15;s:4:\"font\";i:16;s:6:\"format\";i:17;s:14:\"horizontalrule\";i:18;s:10:\"htmlwriter\";i:19;s:6:\"iframe\";i:20;s:12:\"iframedialog\";i:21;s:11:\"indentblock\";i:22;s:10:\"indentlist\";i:23;s:7:\"justify\";i:24;s:8:\"language\";i:25;s:4:\"list\";i:26;s:9:\"liststyle\";i:27;s:9:\"magicline\";i:28;s:8:\"maximize\";i:29;s:8:\"onchange\";i:30;s:9:\"pagebreak\";i:31;s:13:\"pastefromword\";i:32;s:9:\"pastetext\";i:33;s:7:\"preview\";i:34;s:12:\"removeformat\";i:35;s:6:\"resize\";i:36;s:4:\"save\";i:37;s:9:\"selectall\";i:38;s:10:\"showblocks\";i:39;s:11:\"showborders\";i:40;s:10:\"sourcearea\";i:41;s:11:\"specialchar\";i:42;s:11:\"stylescombo\";i:43;s:3:\"tab\";i:44;s:5:\"table\";i:45;s:10:\"tabletools\";i:46;s:7:\"toolbar\";i:47;s:4:\"undo\";i:48;s:6:\"widget\";i:49;s:11:\"wysiwygarea\";}', NOW(), 0),
            ('ckeditor4-limited', 'array_extra_plugins', 'a:2:{i:0;s:11:\"fontawesome\";i:1;s:16:\"schlixcmsbrowser\";}', NOW(), 0),
            ('ckeditor4-limited', 'array_toolbar1', 'a:23:{i:0;s:4:\"Bold\";i:1;s:6:\"Italic\";i:2;s:9:\"Underline\";i:3;s:6:\"Strike\";i:4;s:9:\"Subscript\";i:5;s:11:\"Superscript\";i:6;s:1:\"|\";i:7;s:12:\"RemoveFormat\";i:8;s:1:\"|\";i:9;s:11:\"JustifyLeft\";i:10;s:13:\"JustifyCenter\";i:11;s:12:\"JustifyRight\";i:12;s:12:\"JustifyBlock\";i:13;s:1:\"|\";i:14;s:12:\"NumberedList\";i:15;s:12:\"BulletedList\";i:16;s:1:\"|\";i:17;s:7:\"Outdent\";i:18;s:6:\"Indent\";i:19;s:1:\"|\";i:20;s:6:\"Anchor\";i:21;s:1:\"|\";i:22;s:6:\"Source\";}', NOW(), 0),
            ('ckeditor4-limited', 'array_toolbar2', 'a:0:{}', NOW(), 0),
            ('ckeditor4-limited', 'array_toolbar3', 'a:0:{}', NOW(), 0),
            ('ckeditor4-limited', 'array_toolbar4', 'a:0:{}', NOW(), 0),
            ('ckeditor4-limited', 'str_media_permission', '', NOW(), 0),
            ('ckeditor4-limited', 'str_file_browser', 'none', NOW(), 0),
            ('ckeditor4-limited', 'str_image_browser', 'none', NOW(), 0),
            ('ckeditor4-limited', 'str_config_filebrowserWindowHeight', '500', NOW(), 0),
            ('ckeditor4-limited', 'str_config_filebrowserWindowWidth', '800', NOW(), 0),
            ('ckeditor4-limited', 'str_config_autoGrow_bottomSpace', '', NOW(), 0),
            ('ckeditor4-limited', 'str_config_autoGrow_maxHeight', '800', NOW(), 0),
            ('ckeditor4-limited', 'str_config_autoGrow_minHeight', '400', NOW(), 0),
            ('ckeditor4-limited', 'bool_config_resizeEnabled', '1', NOW(), 0),
            ('ckeditor4-limited', 'str_config_height', '200', NOW(), 0),
            ('ckeditor4-limited', 'str_config_width', 'auto', NOW(), 0),
            ('ckeditor4-limited', 'str_config_removeDialogTabs', 'link:upload;image:upload', NOW(), 0),
            ('ckeditor4-limited', 'bool_config_disableNativeTableHandles', '1', NOW(), 0),
            ('ckeditor4-limited', 'bool_config_autoGrow_onStartup', '1', NOW(), 0),
            ('ckeditor4-limited', 'bool_config_toolbarStartupExpanded', '1', NOW(), 0),
            ('ckeditor4-limited', 'bool_config_toolbarCanCollapse', '', NOW(), 0),
            ('ckeditor4-limited', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('ckeditor4-limited', 'str_schlix_function_init', '// please keep this function so you can save with Apply button\nfor (var instance in CKEDITOR.instances )\n{  \n    CKEDITOR.instances[instance].on( \'change\', SCHLIX.CMS.WysiwygHelper.fixAutoUpdateForm);\n}', NOW(), 0);");

            // CodeMirror
            $mydb->query("
            INSERT INTO `gk_wysiwyg_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES
            ('codemirror-php', 'bool_config_autoCloseBrackets', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_autoCloseTags', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_autoFormatOnStart', '', NOW(), 0),
            ('codemirror-php', 'bool_config_autoFormatOnUncomment', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_continueComments', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_enableCodeFolding', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_enableCodeFormatting', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_enableSearchTools', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_highlightMatches', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_indentWithTabs', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_lineNumbers', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_lineWrapping', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_matchBrackets', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_matchTags', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_showAutoCompleteButton', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_showSearchButton', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_showTrailingSpace', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_showUncommentButton', '1', NOW(), 0),
            ('codemirror-php', 'bool_config_styleActiveLine', '1', NOW(), 0),
            ('codemirror-php', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('codemirror-php', 'str_config_theme', 'mbo', NOW(), 0),
            ('codemirror-php', 'str_config_mode', 'php', NOW(), 0),
            ('codemirror-html', 'bool_config_autoCloseBrackets', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_autoCloseTags', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_autoFormatOnStart', '', NOW(), 0),
            ('codemirror-html', 'bool_config_autoFormatOnUncomment', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_continueComments', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_enableCodeFolding', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_enableCodeFormatting', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_enableSearchTools', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_highlightMatches', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_indentWithTabs', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_lineNumbers', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_lineWrapping', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_matchBrackets', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_matchTags', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_showAutoCompleteButton', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_showSearchButton', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_showTrailingSpace', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_showUncommentButton', '1', NOW(), 0),
            ('codemirror-html', 'bool_config_styleActiveLine', '1', NOW(), 0),
            ('codemirror-html', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('codemirror-html', 'str_config_theme', 'mbo', NOW(), 0),
            ('codemirror-html', 'str_config_mode', 'htmlmixed', NOW(), 0),
            ('codemirror-js', 'bool_config_autoCloseBrackets', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_autoCloseTags', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_autoFormatOnStart', '', NOW(), 0),
            ('codemirror-js', 'bool_config_autoFormatOnUncomment', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_continueComments', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_enableCodeFolding', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_enableCodeFormatting', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_enableSearchTools', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_highlightMatches', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_indentWithTabs', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_lineNumbers', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_lineWrapping', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_matchBrackets', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_matchTags', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_showAutoCompleteButton', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_showSearchButton', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_showTrailingSpace', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_showUncommentButton', '1', NOW(), 0),
            ('codemirror-js', 'bool_config_styleActiveLine', '1', NOW(), 0),
            ('codemirror-js', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('codemirror-js', 'str_config_theme', 'mbo', NOW(), 0),
            ('codemirror-js', 'str_config_mode', 'js', NOW(), 0),
            ('codemirror-css', 'bool_config_autoCloseBrackets', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_autoCloseTags', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_autoFormatOnStart', '', NOW(), 0),
            ('codemirror-css', 'bool_config_autoFormatOnUncomment', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_continueComments', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_enableCodeFolding', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_enableCodeFormatting', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_enableSearchTools', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_highlightMatches', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_indentWithTabs', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_lineNumbers', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_lineWrapping', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_matchBrackets', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_matchTags', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_showAutoCompleteButton', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_showSearchButton', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_showTrailingSpace', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_showUncommentButton', '1', NOW(), 0),
            ('codemirror-css', 'bool_config_styleActiveLine', '1', NOW(), 0),
            ('codemirror-css', 'str_config_schlix_selector', 'wysiwyg', NOW(), 0),
            ('codemirror-css', 'str_config_theme', 'mbo', NOW(), 0),
            ('codemirror-css', 'str_config_mode', 'css', NOW(), 0);");
            
        
    }
    // v2.1.1-4 - set default WYSIWYG
    
    $result = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_config` WHERE `section` = 'wysiwygeditors' AND `key` = 'int_default_full_privilege_wysiwyg_profile_id'");
    if (!$result)
    {
        $mydb->query("INSERT INTO `gk_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('wysiwygeditors', 'int_default_full_privilege_wysiwyg_profile_id', '2', NOW(), 1)");
    }
    
    // v2.1.3
    if (!$mydb->tableColumnExists('gk_email_queue_items', 'hourly_marker'))
    {
        $mydb->query('ALTER TABLE `gk_email_queue_items` ADD `hourly_marker` VARCHAR(13) NOT NULL AFTER `queue_marker`; ');
        $mydb->query('ALTER TABLE `gk_email_queue_items` ADD INDEX `status_hourly_marker` (`status`, `hourly_marker`)');
        $mydb->query('ALTER TABLE `gk_email_queue_items` ADD INDEX `hourly_marker` ( `hourly_marker`)');
    }
    
    // v2.1.6
    // Fix upgrade error from v2.1.0.x Tag
    $result = $mydb->getQueryResultArray("SELECT * FROM `gk_app_items` WHERE `title` = 'tag'");
    if (is_array($result) && count($result) > 1)
    {        
        $preserve_id = $result[0]['id'];
        $mydb->query("DELETE FROM `gk_app_items` WHERE `title` ='tag' AND id <> {$preserve_id}");
    } 
    
    // v2.2.0 - August 2019 - lots of new tables
    if (!$mydb->tableColumnExists('gk_user_sessions', 'session_uid') && !$mydb->tableColumnExists('gk_user_sessions', 'session_uid'))
    {
        $mydb->query('ALTER TABLE `gk_user_sessions` ADD `session_uid` CHAR(40) NULL DEFAULT NULL AFTER `session_cookie`; ');
        $mydb->query("ALTER TABLE `gk_user_sessions` ADD `valid` tinyint(1) NOT NULL DEFAULT '0' AFTER `session_uid`; ");
        $mydb->query("ALTER TABLE `gk_user_sessions` ADD `date_created` datetime NULL DEFAULT NULL AFTER `valid`; ");
        $mydb->query("ALTER TABLE `gk_user_sessions` ADD `date_last_seen` datetime NULL DEFAULT NULL AFTER `date_created`; ");

        $mydb->query('ALTER TABLE `gk_user_sessions` ADD INDEX `user_id` (`user_id`)');
        $mydb->query('ALTER TABLE `gk_user_sessions` ADD INDEX `session_cookie` ( `session_cookie`)');
        $mydb->query('ALTER TABLE `gk_user_sessions` ADD INDEX `session_uid` ( `session_uid`)');
        $mydb->query('ALTER TABLE `gk_user_sessions` ADD INDEX `valid` ( `valid`)');
        $mydb->query('ALTER TABLE `gk_user_sessions` ADD INDEX `session_lookup` (`session_cookie`,`session_uid`, `valid`)');
        // must delete all other ones otherwise there will be an error since the session table has changed
        $uid = (int)  $_SESSION['userid'];
        if ($uid > 0) // in case it's a manual upgrade
        {
            $mydb->query("UPDATE gk_user_sessions SET valid = 1, date_created = :date_created, date_last_seen = :date_created, session_uid = :current_user_id WHERE session_string = :session_id", ['date_created' => get_current_datetime(), 'current_user_id' => $uid,  'session_id' => session_id()]);
            $mydb->query("DELETE FROM gk_user_sessions WHERE session_string <> :session_id", ['session_id' => session_id()]);
        } else 
        {
            $mydb->query("TRUNCATE TABLE gk_user_sessions");
        }
    }
    
    if (!$mydb->tableExists('gk_rate_limit'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_rate_limit` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `user_id` bigint(20) unsigned DEFAULT NULL,
                    `date_created` datetime DEFAULT NULL,
                    `ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `action` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
                    `action_details` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,  
                    `status` tinyint(1) NOT NULL DEFAULT '0',
                    `retry_count` int(11) NOT NULL DEFAULT '0',
                    PRIMARY KEY (`id`),
                    KEY `user_id` (`user_id`),
                    KEY `ip_address` (`ip_address`),
                    KEY `date_created` (`date_created`),
                    KEY `rate_limit_lookup` (`date_created`,`ip_address`,`action`, `status`)

                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }

    if (!$mydb->tableExists('gk_hook_functions'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_hook_functions` (
                    `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `function_name` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
                    `status` tinyint(1) NOT NULL DEFAULT '1',
                    `date_created` datetime DEFAULT NULL,
                    PRIMARY KEY (`cid`),
                    UNIQUE KEY `function_name` (`function_name`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        $mydb->query("INSERT INTO `gk_hook_functions` (`cid`, `function_name`, `status`, `date_created`) VALUES
                    (1, 'getApplicationAdminExtraToolbarMenuItem', 1, NOW()),
                    (2, 'getApplicationAdminExtraEditItemTab', 1, NOW()),
                    (3, 'getApplicationAdminExtraEditCategoryTab', 1, NOW()),
                    (4, 'getApplicationAdminExtraEditConfigTab', 1, NOW()),
                    (5, 'onAfterSaveItem', 1, NOW()),
                    (6, 'modifyDataValuesBeforeSaveItem', 1, NOW()),
                    (7, 'modifyDataValuesBeforeSaveCategory', 1, NOW()),
                    (8, 'getItemByIDWithExtraData', 1, NOW()),
                    (9, 'getCategoryByIDWithExtraData', 1, NOW()),
                    (10, 'saveConfig', 1, NOW()),
                    (11, 'editConfig', 1, NOW()),
                    (12, 'getValidationErrorListBeforeSaveItem', 1, NOW()),
                    (13, 'getSaveConfigValidationErrorList', 1, NOW()),
                    (14, 'getValidationErrorListBeforeSaveCategory', 1, NOW()),
                    (15, 'onAfterSaveCategory', 1, NOW());");
    }


    if (!$mydb->tableExists('gk_hook_classes'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_hook_classes` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `date_created` datetime DEFAULT NULL,
                    `sort_order` int(11) unsigned DEFAULT NULL,
                    `status` tinyint(1) NOT NULL DEFAULT '1',
                    `class_name` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',

                    PRIMARY KEY (`id`),
                    KEY `category_id` (`category_id`),
                    KEY `category_status` (`category_id`,`status`),
                    KEY `class_name` (`class_name`),
                    UNIQUE KEY `category_id_class_name` (`category_id`, `class_name`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        
        $mydb->query('INSERT INTO `gk_hook_classes` (`id`, `category_id`, `date_created`, `sort_order`, `status`, `class_name`) VALUES
(1, 5, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(2, 15, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(3, 8, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(4, 9, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(5, 12, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(6, 14, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(7, 13, NOW(), 9700, 1, \'App\\\\Core_MediaHeader\'),
(8, 3, NOW(), 9700, 1, \'App\\\\Core_MediaHeader_Admin\'),
(9, 2, NOW(), 9700, 1, \'App\\\\Core_MediaHeader_Admin\'),
(10, 10, NOW(), 9700, 1, \'App\\\\Core_MediaHeader_Admin\'),
(11, 11, NOW(), 9700, 1, \'App\\\\Core_MediaHeader_Admin\'),
(12, 4, NOW(), 9700, 1, \'App\\\\Core_MediaHeader_Admin\'),
(13, 3, NOW(), 9900, 1, \'App\\\\Core_Versioning_Admin\'),
(14, 2, NOW(), 9900, 1, \'App\\\\Core_Versioning_Admin\'),
(15, 5, NOW(), 9900, 1, \'App\\\\Core_Versioning\'),
(16, 6, NOW(), 9900, 1, \'App\\\\Core_Versioning\'),
(17, 15, NOW(), 9900, 1, \'App\\\\Core_Versioning\'),
(18, 7, NOW(), 9900, 1, \'App\\\\Core_Versioning\'),
(19, 3, NOW(), 9800, 1, \'App\\\\Core_CustomField_Admin\'),
(20, 2, NOW(), 9800, 1, \'App\\\\Core_CustomField_Admin\'),
(21, 4, NOW(), 9500, 1, \'App\\\\Users_Admin\'),
(22, 3, NOW(), 9500, 1, \'App\\\\Users_Admin\'),
(23, 2, NOW(), 9500, 1, \'App\\\\Users_Admin\'),
(24, 6, NOW(), 9500, 1, \'App\\\\Users\'),
(25, 5, NOW(), 9300, 1, \'App\\\\Tag\'),
(26, 7, NOW(), 9500, 1, \'App\\\\Users\');');
        
    }
    
    if (!$mydb->tableColumnExists('gk_wysiwyg_profiles','category_id'))
    {
        $mydb->query('ALTER TABLE `gk_wysiwyg_profiles` ADD `category_id` INT(11) NOT NULL AFTER `id` ');
        $mydb->query('UPDATE `gk_wysiwyg_profiles` SET `category_id` = editor_id');
    }
    

    if (!$mydb->tableExists('gk_wysiwyg_categories'))
    {
        $mydb->query("CREATE TABLE `gk_wysiwyg_categories` (
                    `cid` int(11) NOT NULL AUTO_INCREMENT,
                    `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `status` int(11) NOT NULL DEFAULT '0',
                    `sort_order` int(11) NOT NULL DEFAULT '0',
                    `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    `is_default_backend` tinyint(1) DEFAULT NULL,
                    `is_default_frontend` tinyint(1) DEFAULT NULL,
                    PRIMARY KEY (`cid`),
                    UNIQUE KEY `title` (`title`),
                    UNIQUE KEY `virtual_filename` (`virtual_filename`),
                    KEY `status` (`status`),
                    KEY `sort_order` (`sort_order`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    
    
    $cat_wysiwyg_count = $mydb->getQueryResultSingleRow("SELECT count(*) AS total_count FROM `gk_wysiwyg_categories` ");
    $total_cat_wysiwyg_count =  $cat_wysiwyg_count['total_count'];
    if ($total_cat_wysiwyg_count == 0)
    {
        $mydb->query("INSERT INTO `gk_wysiwyg_categories` (`cid`, `title`, `virtual_filename`, `status`, `sort_order`, `date_modified`, `is_default_backend`, `is_default_frontend`) VALUES
                (1, 'blank', 'blank', 0, 0, NOW(), 0, 0),
                (2, 'tinymce4', 'tinymce4', 1, 0, NOW(), 1, 1),
                (3, 'ckeditor4', 'ckeditor4', 1, 0, NOW(), 0, 0),
                (4, 'codemirror', 'codemirror', 1, 0, NOW(), 0, 0);");        
    }
    if (!$mydb->tableExists('gk_media_header_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_media_header_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `app_class` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
                    `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `parent_dir` text COLLATE utf8mb4_unicode_ci NOT NULL,
                    `url_file_media` text COLLATE utf8mb4_unicode_ci,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',

                    PRIMARY KEY (`id`),
                    KEY `app_class` (`app_class`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `modified_by_id` (`modified_by_id`),
                    UNIQUE KEY `app_class_guid` (`app_class`, `guid`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    }
    
    if (!$mydb->tableExists('gk_customfield_tables'))
    {
        $mydb->query("CREATE TABLE `gk_customfield_tables` (
                    `cid` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `table_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    PRIMARY KEY (`cid`),
                    KEY `table_name` (`table_name`)

                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    

    if (!$mydb->tableExists('gk_customfield_items'))
    {
        $mydb->query("CREATE TABLE `gk_customfield_items` (
                    `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `category_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
                    `field_label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `field_type` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `field_box_ui` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                    `field_unsigned` tinyint(1) NOT NULL,
                    `field_length` bigint(20) NOT NULL DEFAULT '0',
                    `field_precision` smallint(6) NOT NULL,
                    `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `field_null` tinyint(1) NOT NULL DEFAULT '0',
                    `field_default` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
                    `field_choices` text COLLATE utf8mb4_unicode_ci,
                    `field_choices_use_sql` tinyint(1) NOT NULL,
                    `field_choices_sql` text COLLATE utf8mb4_unicode_ci,
                    `field_regex_validation` text COLLATE utf8mb4_unicode_ci,
                    `field_required` tinyint(1) NOT NULL DEFAULT '0',
                    `field_placeholder` text COLLATE utf8mb4_unicode_ci NOT NULL,
                    `field_hint` text COLLATE utf8mb4_unicode_ci NOT NULL,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',

                    PRIMARY KEY (`id`),
                    KEY `category_id` (`category_id`),
                    KEY `field_name` (`field_name`),
                    UNIQUE KEY `category_id_field_name` (`category_id`,`field_name`)

                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    

    if (!$mydb->tableExists('gk_gallery_categories'))
    {
        $mydb->query("CREATE TABLE `gk_gallery_categories` (
                    `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `date_available` datetime DEFAULT NULL,
                    `date_expiry` datetime DEFAULT NULL,
                    `sort_order` int(3) unsigned DEFAULT NULL,
                    `status` tinyint(1) NOT NULL DEFAULT '1',
                    `featured` tinyint(1) NOT NULL DEFAULT '0',
                    `version` decimal(20,2) NOT NULL DEFAULT '1.00',
                    `pageview` bigint(20) NOT NULL DEFAULT '0',
                    `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) unsigned DEFAULT NULL,
                    `locked_by_id` bigint(20) DEFAULT NULL,
                    `meta_key` text COLLATE utf8mb4_unicode_ci,
                    `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
                    `summary` mediumtext COLLATE utf8mb4_unicode_ci,
                    `description` mediumtext COLLATE utf8mb4_unicode_ci,
                    `permission_write` text COLLATE utf8mb4_unicode_ci,
                    `permission_read` text COLLATE utf8mb4_unicode_ci,
                    `options` text COLLATE utf8mb4_unicode_ci,
                    `tags` text COLLATE utf8mb4_unicode_ci,
                    `non_public` tinyint(1) NOT NULL DEFAULT '0',
                    `processed` tinyint(1) NOT NULL,
                    `thumbnail_width` int(11) unsigned NOT NULL DEFAULT '0',
                    `thumbnail_height` int(11) unsigned NOT NULL DEFAULT '0',
                    `thumbnail_quality` int(11) unsigned NOT NULL DEFAULT '0',
                    `small_width` int(11) unsigned NOT NULL DEFAULT '0',
                    `small_height` int(11) unsigned NOT NULL DEFAULT '0',
                    `small_quality` int(11) unsigned NOT NULL DEFAULT '0',
                    `medium_width` int(11) unsigned NOT NULL DEFAULT '0',
                    `medium_height` int(11) unsigned NOT NULL DEFAULT '0',
                    `medium_quality` int(11) unsigned NOT NULL DEFAULT '0',
                    `large_width` int(11) unsigned NOT NULL DEFAULT '0',
                    `large_height` int(11) unsigned NOT NULL DEFAULT '0',
                    `large_quality` int(11) unsigned NOT NULL DEFAULT '0',
                    PRIMARY KEY (`cid`),
                    KEY `parent_id` (`parent_id`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `sort_order` (`sort_order`),
                    KEY `status` (`status`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `modified_by_id` (`modified_by_id`),
                    UNIQUE KEY `vfn_parent_id` (`parent_id`, `virtual_filename`),
                    UNIQUE KEY `guid` (`guid`),
                    KEY `non_public` (`non_public`)

                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    

    if (!$mydb->tableExists('gk_gallery_items'))
    {
        $mydb->query("CREATE TABLE `gk_gallery_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
                    `summary` mediumtext COLLATE utf8mb4_unicode_ci,
                    `description` mediumtext COLLATE utf8mb4_unicode_ci,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `date_available` datetime DEFAULT NULL,
                    `date_expiry` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `locked_by_id` bigint(20) DEFAULT NULL,
                    `permission_write` text COLLATE utf8mb4_unicode_ci,
                    `permission_read` text COLLATE utf8mb4_unicode_ci,
                    `meta_key` text COLLATE utf8mb4_unicode_ci,
                    `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
                    `pageview` bigint(20) NOT NULL DEFAULT '0',
                    `status` int(11) NOT NULL DEFAULT '0',
                    `featured` tinyint(1) NOT NULL DEFAULT '0',
                    `version` decimal(20,2) NOT NULL DEFAULT '1.00',
                    `sort_order` int(11) NOT NULL DEFAULT '0',
                    `options` text COLLATE utf8mb4_unicode_ci,
                    `tags` text COLLATE utf8mb4_unicode_ci,
                    `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                    `parent_dir` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                    `url_media_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                    `size` bigint(20) NOT NULL,
                    `crop_x` int(11) NOT NULL DEFAULT '0',
                    `crop_y` int(11) NOT NULL DEFAULT '0',
                    `crop_w` int(11) NOT NULL DEFAULT '0',
                    `crop_h` int(11) NOT NULL DEFAULT '0',
                    `crop_img_width` int(11) NOT NULL DEFAULT '0',
                    `crop_img_height` int(11) NOT NULL DEFAULT '0',
                    `exif_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,

                    PRIMARY KEY (`id`),
                    KEY `category_id` (`category_id`),
                    KEY `title` (`title`),
                    KEY `id_category_id` (`id`,`category_id`),
                    KEY `id_category_id_status` (`id`,`category_id`,`status`),
                    KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
                    KEY `virtual_filename` (`virtual_filename`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `modified_by_id` (`modified_by_id`),
                    KEY `status` (`status`),
                    KEY `sort_order` (`sort_order`),
                    KEY `parent_dir` (`parent_dir`),
                    UNIQUE KEY `vfn_category_id` (`category_id`, `virtual_filename`),
                    UNIQUE KEY `guid` (`guid`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
                  ");
    }    
    
    if (!$mydb->tableExists('gk_redirection_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_redirection_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `type` int(11) NOT NULL DEFAULT '301',
                    `path` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
                    `redirect_to` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
                    `description` text COLLATE utf8mb4_unicode_ci,
                    `date_created` datetime DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
                    `hits` int(11) NOT NULL DEFAULT '0',
                    `status` smallint(1) NOT NULL DEFAULT '0',
                    `version` decimal(20,2) NOT NULL DEFAULT '1.00',

                    PRIMARY KEY (`id`),
                    UNIQUE KEY `path` (`path`),
                    KEY `redirect_to` (`redirect_to`),
                    KEY `date_created` (`date_created`),
                    KEY `date_modified` (`date_modified`),
                    KEY `created_by_id` (`created_by_id`),
                    KEY `status` (`status`),

                    UNIQUE KEY `guid` (`guid`)

                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    

    if (!$mydb->tableExists('gk_404_error_items'))
    {
        $mydb->query("CREATE TABLE `gk_404_error_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `path` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
                    `date_modified` datetime DEFAULT NULL,
                    `hits` int(11) DEFAULT '0',
                    PRIMARY KEY (`id`),
                    UNIQUE KEY `path` (`path`)
                  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
                  ");
    }    

    if (!$mydb->tableExists('gk_gdpr_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_gdpr_items` (
                    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    `guid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `email_address` varchar(253) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
                    `filename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `request_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `request_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `confirmed_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `confirmed_ip_address` varchar(46) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                    `request_type` smallint(2) NOT NULL DEFAULT '0',  
                    `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
                    `auth_code` int(11) unsigned NOT NULL DEFAULT '0',  
                    `reason` text COLLATE utf8mb4_unicode_ci,  
                    `date_created` datetime DEFAULT NULL,
                    `date_confirmed` datetime DEFAULT NULL,  
                    `date_expiry` datetime DEFAULT NULL,
                    `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
                    `status` int(11) NOT NULL DEFAULT '0',


                    PRIMARY KEY (`id`),
                    KEY `email_address` (`email_address`),
                    KEY `user_id` (`user_id`),
                    KEY `date_created` (`date_created`),
                    KEY `date_confirmed` (`date_confirmed`),  
                    KEY `status` (`status`),
                    UNIQUE KEY `guid` (`guid`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
                  ");
        // disable gdpr by default
        $gdpr_config_row = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_config` WHERE `section` = 'personaldatarequest' AND `key` = 'bool_disable_app'");
        if (!$gdpr_config_row)
        {
            $mydb->query("INSERT INTO `gk_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('personaldatarequest', 'bool_disable_app', '1', NOW(), 0)");
        }
        $core_editor_manager_1 = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_config` WHERE `section` = 'core.editormanager' AND `key` = 'int_default_full_privilege_wysiwyg_profile_id'");
        if (!$core_editor_manager_1)
            $mydb->query("INSERT INTO `gk_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('core.editormanager', 'int_default_full_privilege_wysiwyg_profile_id', '2', NOW(), 0)");
        $core_editor_manager_2 = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_config` WHERE `section` = 'core.editormanager' AND `key` = 'int_default_limited_privilege_wysiwyg_profile_id'");
        if (!$core_editor_manager_2)
            $mydb->query("INSERT INTO `gk_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('core.editormanager', 'int_default_limited_privilege_wysiwyg_profile_id', '4', NOW(), 0)");
        
        
    }    
    $apps_to_remove = ['applications','bannedip','blocks','cronscheduler','emailqueue','emailtemplates','help','httperror','logviewer','macros','mediamanager','menus','schlixupdater','themes','versioning','wysiwygeditors'];
    
    // 2.2.0-6 - fix hook upgrades
    // hook - modifyDataValuesBeforeSaveItem
    $fn_modify_item =  $mydb->getQueryResultSingleRow("SELECT * FROM `gk_hook_functions` WHERE `function_name` = 'modifyDataValuesBeforeSaveItem'");
    $fn_modify_item_cid = (int) $fn_modify_item['cid'];
    if ($fn_modify_item_cid > 0) 
    {
        $cl_modify_item = $mydb->getQueryResultSingleRow('SELECT * FROM `gk_hook_classes` WHERE `class_name` = \'App\\\\Users_Admin\' AND `category_id` = :the_id ', ['the_id' =>$fn_modify_item_cid]);
        if (isset($cl_modify_item['id']) && $cl_modify_item['id'] > 0)
        {
            $mydb->query('UPDATE `gk_hook_classes` SET  `class_name` = \'App\\\\Users\' WHERE `id` = :the_id', ['the_id' => $cl_modify_item['id']]);
        }
    }
    // hook - modifyDataValuesBeforeSaveCategory
    $fn_modify_cat = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_hook_functions` WHERE `function_name` = 'modifyDataValuesBeforeSaveCategory'");
    $fn_modify_cat_cid = isset($fn_modify_cat) ? (int) $fn_modify_cat['cid'] : 0;
    if ($fn_modify_cat_cid > 0)
    {
        $cl_modify_cat = $mydb->getQueryResultSingleRow('SELECT * FROM `gk_hook_classes` WHERE `class_name` = \'App\\\\Users\' AND `category_id` = :the_id ', ['the_id' =>$fn_modify_cat_cid]);
        if (!$cl_modify_cat)
        {
            $mydb->query('INSERT INTO `gk_hook_classes` (`category_id`, `date_created`, `sort_order`, `status`, `class_name`) VALUES 
        (7, NOW(), 9500, 1, \'App\\\\Users\');');

        }
    }
    // 2.2.1
    // New extension gallery
    if (!$mydb->tableExists('gk_extgallery_categories'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_extgallery_categories` (
        `cid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
        `date_created` datetime DEFAULT NULL,
        `date_modified` datetime DEFAULT NULL,
        `sort_order` int(3) unsigned DEFAULT NULL,
        `status` tinyint(1) NOT NULL DEFAULT '1',
        `featured` tinyint(1) NOT NULL DEFAULT '0',
        `version` decimal(20,2) NOT NULL DEFAULT '1.00',
        `pageview` bigint(20) NOT NULL DEFAULT '0',
        `items_per_page` int(11) unsigned NOT NULL DEFAULT '10',
        `summary` mediumtext COLLATE utf8mb4_unicode_ci,
        `description` mediumtext COLLATE utf8mb4_unicode_ci,

        PRIMARY KEY (`cid`),
        KEY `parent_id` (`parent_id`),
        KEY `date_created` (`date_created`),
        KEY `date_modified` (`date_modified`),
        KEY `sort_order` (`sort_order`),
        KEY `status` (`status`),
        UNIQUE KEY `guid` (`guid`)
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    
    if (!$mydb->tableExists('gk_extgallery_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_extgallery_items` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `category_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `category_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `virtual_filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `url_icon` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
        `summary` mediumtext COLLATE utf8mb4_unicode_ci,
        `description` mediumtext COLLATE utf8mb4_unicode_ci,
        `date_created` datetime DEFAULT NULL,
        `date_modified` datetime DEFAULT NULL,
        `created_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `modified_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `locked_by_id` bigint(20) DEFAULT NULL,
        `permission_write` text COLLATE utf8_unicode_ci,
        `permission_read` text COLLATE utf8_unicode_ci,
        `meta_key` text COLLATE utf8_unicode_ci,
        `meta_description` mediumtext COLLATE utf8mb4_unicode_ci,
        `pageview` bigint(20) NOT NULL DEFAULT '0',
        `status` int(11) NOT NULL DEFAULT '0',
      `sort_order` int(11) NOT NULL DEFAULT '0',
        `featured` tinyint(1) NOT NULL DEFAULT '0',
       `is_app` tinyint(1) NOT NULL,
       `is_block` tinyint(1) NOT NULL,
       `is_macro` tinyint(1) NOT NULL,
       `is_theme` tinyint(1) DEFAULT NULL,
       `is_wysiwyg` tinyint(1) DEFAULT NULL,

        PRIMARY KEY (`id`),
        KEY `category_id` (`category_id`),
        KEY `category_guid` (`category_guid`),
        KEY `title` (`title`),
        KEY `id_category_id` (`id`,`category_id`),
        KEY `id_category_id_status` (`id`,`category_id`,`status`),
        KEY `id_category_id_status_sort_order` (`id`,`category_id`,`status`,`sort_order`),
        KEY `virtual_filename` (`virtual_filename`),
        KEY `date_created` (`date_created`),
        KEY `date_modified` (`date_modified`),
        KEY `created_by_id` (`created_by_id`),
        KEY `modified_by_id` (`modified_by_id`),
        KEY `status` (`status`),
        KEY `sort_order` (`sort_order`),
        UNIQUE KEY `guid` (`guid`)
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    
    if (!$mydb->tableExists('gk_extgallery_downloads'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_extgallery_downloads` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `item_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `ext_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `url_download` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
        `download_filename` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
        `change_log` mediumtext COLLATE utf8mb4_unicode_ci,
        `sha1_hash` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `file_size` bigint(20) unsigned NOT NULL DEFAULT '0',
        `min_schlix_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `max_schlix_version` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `date_created` datetime DEFAULT NULL,
        `date_modified` datetime DEFAULT NULL,
        `download_count` bigint(20) NOT NULL DEFAULT '0',
        `is_current_stable` tinyint(1) NOT NULL DEFAULT '0',
        `status` int(11) NOT NULL DEFAULT '0',

        PRIMARY KEY (`id`),
        KEY `item_id` (`item_id`),
        KEY `item_guid` (`item_guid`),
        KEY `date_created` (`date_created`),
        KEY `date_modified` (`date_modified`),
        KEY `download_filename` (`download_filename`),
        KEY `sha1_hash` (`sha1_hash`),
        UNIQUE KEY `guid` (`guid`)
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    
    if (!$mydb->tableExists('gk_extgallery_screenshots'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_extgallery_screenshots` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
        `guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `item_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
        `url_image_small` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
        `url_image_large` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'untitled',
        `date_created` datetime DEFAULT NULL,
        `date_modified` datetime DEFAULT NULL,
        `download_count` bigint(20) NOT NULL DEFAULT '0',
        `status` int(11) NOT NULL DEFAULT '0',

        PRIMARY KEY (`id`),
        KEY `item_id` (`item_id`),
        KEY `item_guid` (`item_guid`),
        KEY `title` (`title`),
        KEY `date_created` (`date_created`),
        KEY `date_modified` (`date_modified`),
        UNIQUE KEY `guid` (`guid`)
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
    }    
    
    if (!$mydb->tableExists('gk_extmanager_items'))
    {
        $mydb->query("CREATE TABLE IF NOT EXISTS `gk_extmanager_items` (
        `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        `ext_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `version_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL,
        `date_created` datetime DEFAULT NULL,
        `date_modified` datetime DEFAULT NULL,
        `installed_by_id` bigint(20) unsigned NOT NULL DEFAULT '0',  
        `is_outdated` tinyint(1) NOT NULL DEFAULT '0',  
        `file_list` mediumtext COLLATE utf8mb4_unicode_ci,  

        PRIMARY KEY (`id`),
        KEY `date_created` (`date_created`),
        KEY `date_modified` (`date_modified`),
        KEY `is_outdated` (`is_outdated`),
        UNIQUE KEY `ext_guid` (`ext_guid`),
        UNIQUE KEY `ext_guid_version` (`ext_guid`,`version_guid`)
      ) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        
    }
    // 2.2.1-5 - Fix changed name in cron scheduler entries
    // must use parameterized query instead of direct string because of the \\ becomes \\\\ if the table is utf8mb4. Some are still on utf8 instead of utf8mb4
    $mydb->query("UPDATE gk_cronscheduler_items SET command_internal = REPLACE (command_internal, :old_command, :new_command) ", ['old_command' => '\\App\\cronScheduler', 'new_command' => '\\App\\Core_CronScheduler'  ]);
    $mydb->query("UPDATE gk_cronscheduler_items SET command_internal = REPLACE (command_internal,  :old_command, :new_command) ", ['old_command' => '\\App\\EmailQueue', 'new_command' => '\\App\\Core_EmailQueue'  ]);
    
    /////////////
    // 2.2.3
    /////////////
    if (!$mydb->tableExists('gk_composer_lib'))
    {
        $mydb->query("CREATE TABLE `gk_composer_lib` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'untitled',
  `initial_requestor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `status` tinyint NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
        
    }
    ////////////////////
    // 2.2.4
    ////////////////////
    if (!$mydb->tableColumnExists('gk_email_template_items', 'master_template_id'))
    {
        $mydb->query('ALTER TABLE `gk_email_template_items` ADD `master_template_id` INT(11) NULL DEFAULT NULL AFTER `id`;');
        
        $old_signature = $mydb->getQueryResultSingleRow("SELECT * FROM `gk_email_template_items` WHERE `id` = '1' AND `virtual_filename` = 'default-email-signature'");
        if ($old_signature)
        {
            $body_text = '{$text_email_header_preview}'."\r\n\r\n".'{$text_email_content}'."\r\n\r\n".'{$text_email_footer}'."\r\n\r\n".'{$site_name} - {$site_url}';
            $body_html = "
<!doctype html><html><head><meta name=\"viewport\" content=\"width=device-width\"/><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/><style>img{border:0;-ms-interpolation-mode:bicubic;max-width:100%}body{background-color:#f6f6f6;font-family:sans-serif;-webkit-font-smoothing:antialiased;font-size:14px;line-height:1.4;margin:0;padding:0;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}table{border-collapse:separate;mso-table-lspace:0;mso-table-rspace:0;width:100%}table td{font-family:sans-serif;font-size:14px;vertical-align:top}.body{background-color:#f6f6f6;width:100%}.container{display:block;margin:0 auto!important;max-width:580px;padding:10px;width:580px}.content{box-sizing:border-box;display:block;margin:0 auto;max-width:580px;padding:10px}.main{background:#fff;border-radius:3px;width:100%}.wrapper{box-sizing:border-box;padding:20px}.content-block{padding-bottom:10px;padding-top:10px}.footer{clear:both;margin-top:10px;text-align:center;width:100%}.footer td,.footer p,.footer span,.footer a{color:#999;font-size:12px;text-align:center}h1,h2,h3,h4{color:#000;font-family:sans-serif;font-weight:400;line-height:1.4;margin:0;margin-bottom:30px}h1{font-size:35px;font-weight:300;text-align:center;text-transform:capitalize}p,ul,ol{font-family:sans-serif;font-size:14px;font-weight:normal;margin:0;margin-bottom:15px}p li,ul li,ol li{list-style-position:inside;margin-left:5px}a{color:#3498db;text-decoration:underline}.btn{box-sizing:border-box;width:100%}.btn>tbody>tr>td{padding-bottom:15px}.btn table{width:auto}.btn table td{background-color:#fff;border-radius:5px;text-align:center}.btn a{background-color:#fff;border:solid 1px #3498db;border-radius:5px;box-sizing:border-box;color:#3498db;cursor:pointer;display:inline-block;font-size:14px;font-weight:bold;margin:0;padding:12px 25px;text-decoration:none;text-transform:capitalize}.btn-primary table td{background-color:#3498db}.btn-primary a{background-color:#3498db;border-color:#3498db;color:#fff}.last{margin-bottom:0}.first{margin-top:0}.align-center{text-align:center}.align-right{text-align:right}.align-left{text-align:left}.clear{clear:both}.mt0{margin-top:0}.mb0{margin-bottom:0}.preheader{color:transparent;display:none;height:0;max-height:0;max-width:0;opacity:0;overflow:hidden;mso-hide:all;visibility:hidden;width:0}.powered-by a{text-decoration:none}hr{border:0;border-bottom:1px solid #f6f6f6;margin:20px 0}@media only screen and (max-width:620px){table[class=body] h1{font-size:28px!important;margin-bottom:10px!important}table[class=body] p,table[class=body] ul,table[class=body] ol,table[class=body] td,table[class=body] span,table[class=body] a{font-size:16px!important}table[class=body] .wrapper,table[class=body] .article{padding:10px!important}table[class=body] .content{padding:0!important}table[class=body] .container{padding:0!important;width:100%!important}table[class=body] .main{border-left-width:0!important;border-radius:0!important;border-right-width:0!important}table[class=body] .btn table{width:100%!important}table[class=body] .btn a{width:100%!important}table[class=body] .img-responsive{height:auto!important;max-width:100%!important;width:auto!important}}@media all{.ExternalClass{width:100%}.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%}.apple-link a{color:inherit!important;font-family:inherit!important;font-size:inherit!important;font-weight:inherit!important;line-height:inherit!important;text-decoration:none!important}#MessageViewBody a{color:inherit;text-decoration:none;font-size:inherit;font-family:inherit;font-weight:inherit;line-height:inherit}.btn-primary table td:hover{background-color:#34495e!important}.btn-primary a:hover{background-color:#34495e!important;border-color:#34495e!important}}</style></head><body class=\"\"><span class=\"preheader\">".'{$html_email_header_preview}'."</span><table class=\"body\" role=\"presentation\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td>&nbsp;</td><td class=\"container\"><div class=\"content\"><table class=\"main\" role=\"presentation\"><tbody><tr><td class=\"wrapper\"><table role=\"presentation\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td>".'{$html_email_content}'."</td></tr></tbody></table></td></tr></tbody></table><div class=\"footer\"><table role=\"presentation\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td class=\"content-block\">".'{$html_email_footer}'."</td></tr><tr><td class=\"content-block powered-by\">".'{$site_name} - {$site_url}'."</td></tr></tbody></table></div></div></td><td>&nbsp;</td></tr></tbody></table></body></html>";
            $mydb->query("UPDATE `gk_email_template_items` SET `title` = 'Default master email template',`purpose` = 'Default master email template', `virtual_filename` = 'master-template', `body_html` = :body_html, `body_text` = :body_text WHERE `id` = 1 ",
                    ['body_html' => $body_html, 'body_text' => $body_text]);
        }
        
    }
    // v2.2.5
    if (!$mydb->tableColumnExists('gk_composer_lib', 'status'))
    {
        $mydb->query("ALTER TABLE `gk_composer_lib` ADD `status` INT(11) NOT NULL DEFAULT '0' AFTER `date_created`;");
    }    
    
    /* pending for next release 2.2.5 in November
    $table_reduced_bigint_to_int_id = [
        'gk_contact_items',
        'gk_menu_items',
        'gk_landing_items',
        'gk_tag_items',
        'gk_hook_classes',
        'gk_customfield_items',
        'gk_gallery_items',
        'gk_redirection_items',
        'gk_404_error_items',
        'gk_extgallery_items',
        'gk_extgallery_downloads',
        'gk_extgallery_screenshots',
        'gk_extmanager_items',
        'gk_composer_lib',
    ];
    foreach ($table_reduced_bigint_to_int_id as $table)
    {
        $mydb->query("ALTER TABLE `{$table}` CHANGE `id` `id` INT UNSIGNED NOT NULL AUTO_INCREMENT;");
    }
     */
    
    try 
    {
        if (!class_exists("\\App\\CronScheduler"))
            class_alias('\\App\\Core_CronScheduler', '\\App\\CronScheduler');
        if (!class_exists("\\App\\schlixupdater"))
            class_alias('\\App\\Core_SCHLIXUpdater', '\\App\\schlixupdater');
    }
    catch (\Exception $ext)
    {
        
    }
    
    
    
    ///////////////////////////////////
    foreach ($apps_to_remove as $old_app)
        upgrade_remove_old_system_app ($old_app);
    set_db_to_current_version($mydb);
    $messages[] = ___('Upgrade completed');
    
    
    // Always delete table cache columns
    $mydb->query("DELETE FROM `gk_cache_items` WHERE cache_key = 'table_columns' OR cache_key = 'table_pks'");
    
    
    return array('messages' => $messages, 'errors' => $errors);
}

function upgrade_remove_old_system_app($app)
{
    $path = remove_multiple_slashes(SCHLIX_SYSTEM_PATH.'/apps/'.$app);
    if (is_dir($path))
    {
        __del_tree($path);
    }
}
/**
 * Update version
 * @param \SCHLIX\cmsDatabase $mydb
 * @ignore
 */
function set_db_to_current_version($mydb)
{
    $sql = "SELECT * FROM `gk_config` WHERE `section` = 'system' AND `key` = 'str_database_version'";
    $result = $mydb->getQueryResultSingleRow($sql);
    if ($result)
    {
        $sql = "UPDATE `gk_config` SET `value` =  :schlix_version WHERE  `section` = 'system' AND `key` = 'str_database_version'";
    } else
    {
        $sql = "INSERT INTO `gk_config` (`section`, `key`, `value`, `date_modified`, `modified_by_id`) VALUES ('system', 'str_database_version', :schlix_version, NOW(), 0)";
    }
    $mydb->query($sql, ['schlix_version' => SCHLIX_VERSION]);
    
    $datavalues = [];
    $datavalues['ip_address'] = get_user_real_ip_address();
    $datavalues['module'] = 'upgrade';
    $datavalues['type'] = 'info';
    $datavalues['referrer'] = '';
    $datavalues['user_agent'] = '';
    $datavalues['request_uri'] = '';
    $datavalues['description'] = "Completed upgrade to  ".SCHLIX_VERSION;
    $mydb->simpleInsertInto('gk_log_items', $datavalues);
    
}
