<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
$image_sizes = $this->app->getImageSizeNames();
$default_sizes = $this->app->getDefaultSizes();
?>

<schlix-config:data-editor data-schlix-controller="SCHLIX.CMS.BlogAdmin">
    <!-- end sidebar -->
    <schlix-config:save-result />
    <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

        <schlix-config:action-buttons />
        <x-ui:csrf />

        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                <schlix-config:app_description   />
                <schlix-config:checkbox config-key="bool_disable_app" label="<?= ___('Disable application (for maintenance or any other reasons)') ?>" />
                <schlix-config:textbox config-key="str_meta_keywords" label="<?= ___('Default Meta Keywords') ?>" config-fonticon="fa fa-hashtag" />
                <schlix-config:textbox config-key="str_meta_description" label="<?= ___('Default Meta Description') ?>"   config-fonticon="fa fa-hashtag" />
                <schlix-config:checkbox config-key="bool_convert_external_images" label="<?= ___('Fetch external images and save it to your web server') ?>" />
                <schlix-config:checkbox config-key="bool_enable_pageview_stats" label="<?= ___('Enable page impression stats') ?>" />
            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_rss" fonticon="fa fa-rss" label="<?= ___('RSS') ?>"> 

                <div class="alert alert-info">
                    <?php
                    $rss_url = $this->app->createFriendlyURL("action=rss");
                    $jsonfeed_url = $this->app->createFriendlyURL("action=jsonfeed");
                    ?>
                    <?= ___('RSS URL') ?>: <a href="<?= $rss_url ?>" target="_blank"><?= SCHLIX_SITE_URL . '/' . $rss_url ?></a><br />
                    <?= ___('JSON Feed URL') ?>: <a href="<?= $jsonfeed_url ?>" target="_blank"><?= SCHLIX_SITE_URL . '/' . $jsonfeed_url ?></a>
                </div>
                <schlix-config:textbox config-key="str_rss_title" label="<?= ___('RSS/JSON Feed Title') ?>"   />
                <schlix-config:textbox config-key="str_author_name" label="<?= ___('Blog Author') ?>"   />
                <schlix-config:textbox config-key="str_author_email" label="<?= ___('Blog Author\'s E-mail Address') ?>"   />
                <schlix-config:textbox config-key="str_description" label="<?= ___('Blog Description') ?>"   />
                <schlix-config:integerbox config-key="int_max_entries_in_rss" config-default-value="20" min="1" max="200"  label="<?= ___('Maximum number of entries to be displayed in the RSS file') ?>" />                        


            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_image" fonticon="fa fa-image" label="<?= ___('Image Size') ?>"> 

                <p><?= sprintf(___('When you upload intro image, it will be resized and uploaded to %s/media/articles'), CURRENT_SUBSITE_URL_PATH) ?></p>


                <?php foreach ($image_sizes as $size): ?>
                    <?php $ds = $default_sizes[$size]; ?>
                    <x-ui:row>
                        <x-ui:column sm="6" >
                            <fieldset  class="form-inline"><legend><?= ucwords($size) . ' ' . ___('Image Dimension (pixels)') ?></legend>
                                <x-ui:input-group>
                                    <x-ui:input-group-addon><?= ___('Width') ?></x-ui:input-group-addon>                                        
                                    <schlix-config:integerbox min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>"  config-key="int_<?= $size ?>_width" config-default-value="<?= $ds['width'] ?>" required="required" placeholder="<?= ___('Width') ?>"/>                            
                                    <x-ui:input-group-addon><?= ___('px') ?></x-ui:input-group-addon> 
                                    <x-ui:input-group-addon><?= ___('Height') ?></x-ui:input-group-addon>
                                    <schlix-config:integerbox min="<?= (int) ($ds['width'] / 10) ?>" max="<?= $ds['width'] * 5 ?>"  config-key="int_<?= $size ?>_height" config-default-value="<?= $ds['height'] ?>" required="required" placeholder="<?= ___('Height') ?>" />
                                    <x-ui:input-group-addon><?= ___('px') ?></x-ui:input-group-addon> 
                                    <x-ui:input-group-addon><?= ___('Quality') ?></x-ui:input-group-addon> 
                                    <schlix-config:integerbox min="10" max="100" config-key="int_<?= $size ?>_quality" required="required"  config-default-value="<?= $ds['quality'] ?>" />
                                    <x-ui:input-group-addon>%</x-ui:input-group-addon> 
                                </x-ui:input-group>
                            </fieldset>
                            <!-- end margin -->
                        </x-ui:column>
                    </x-ui:row>      
                <?php endforeach ?>

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_main_opt" fonticon="fa fa-newspaper" label="<?= ___('Default Main page Options') ?>"> 

                <div class="row">
                    <div class="col-md-6">

                        <schlix-config:textbox config-key="str_mainpage_title" label="<?= ___('Main page title') ?>" />                        
                        <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Main page introduction text') ?>" class='wysiwyg' />             
                    </div>
                    <!-- col -->
                    <div class="col-md-6">
                        <schlix-config:integerbox config-key="int_mainpage_items_per_page" config-default-value="10" label="<?= ___('Default maximum number of items to be displayed per page') ?>" />
                                                  <schlix-config:main-page-meta-options config-key="array_mainpage_meta_options" item-per-column="5" column-count="1" />
                </div>
            </div>
        </x-ui:schlix-tab>
        <!-- tab -->
        <x-ui:schlix-tab id="tab_category_opt" fonticon="fas fa-folder" label="<?= ___('Default Category Options') ?>"> 

            <schlix-config:integerbox config-key="int_category_items_per_page" config-default-value="10" label="<?= ___('Default maximum number of items to be displayed per page') ?>" />
                                      <schlix-config:checkbox config-key="reset_category_items_per_page" label="<?= ___('Reset the number of items per page for all categories') ?>" />
            <schlix-config:category-meta-options config-key="array_default_category_meta_options"  item-per-column="1" column-count="3" />
            <schlix-config:checkbox config-key="reset_category_options" label="<?= ___('Reset all categories options') ?>" />
        </x-ui:schlix-tab>
        <!-- tab -->
        <x-ui:schlix-tab id="tab_item_opt" fonticon="fa fa-file-alt" label="<?= ___('Default Item Options') ?>"> 


            <schlix-config:item-meta-options config-key="array_default_item_meta_options" item-per-column="1" column-count="3" />
            <schlix-config:checkbox config-key="reset_item_options" label="<?= ___('Reset all item options') ?>" />
        </x-ui:schlix-tab>
        <!-- tab -->
        <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>   
        <!-- end -->

    </x-ui:schlix-tab-container>

</x-ui:schlix-editor-form>
</schlix-config:data-editor>     
