<?php
/**
 * Core: Editor Manager - Main admin view template
 * 
 * Core - Editor Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-data-explorer-categorized-list data-schlix-controller="SCHLIX.CMS.Core_EditorManagerAdminController" data-enable-preview-link="true" data-default-item-icon="fas fa-pencil-alt-square fa-2x">
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            <x-ui:schlix-explorer-menu-command data-schlix-command="install" fonticon="fa fa-upload" label="<?= ___('Install a package') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />            
            <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />

            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />        
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Left Column -->
        <x-ui:schlix-explorer-left-column>
            <!-- treeview -->
            <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="false" ></x-ui:schlix-treeview>
            <!-- end column -->
        </x-ui:schlix-explorer-left-column>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.Core_EditorManagerAdminController.formatDataTableCell_CheckBox" sortable="false" />
                     <x-ui:schlix-data-table-column key="this.field_id" label="<?= ___('ID') ?>" sortable="true" formatter="number" />
                    <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.Core_EditorManagerAdminController.formatDataTableCell_DefaultTitleColumn" />
                    <x-ui:schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                   
                    <x-ui:schlix-data-table-column key="is_system" label="<?= ___('System') ?>" sortable="true" formatter="SCHLIX.CMS.Core_EditorManagerAdminController.formatDataTableCell_Status" />

                    <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                    <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-categorized-list>

<!-- Install Dialog -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Install Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-package-installer" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_EditorManagerAdminController" header-label="<?= ___('Install a package') ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=install" form-method="post">
    <!-- form -->
    <x-ui:csrf />
    <x-ui:alert type="warning">
        <p><?= ___('Please ensure that the application you are about to upload is from a trusted source') ?>.</p>
        <p><?= ___('SCHLIX is not responsible for any damage/security vulnerability/errors caused by 3rd party plugins') ?>.</p>
        <p><?= ___('Maximum file size') . ': ' . ' ' . round(get_real_max_upload_size() / (1024.0 * 1024.0), 2) . ' ' . ___('Mb') ?></p>
    </x-ui:alert>

    <x-ui:schlix-file-upload id="zipfileupload"  name="zipfileupload" accept=".zip" required="required" fonticon="far fa-folder-open" label="<?= ___('Select a ZIP file') ?>" />

    <x-ui:clearboth />
    <hr />
    <x-ui:textbox type="password" name="password" id="password" label="<?= ___('Please enter your password to authenticate this request') ?>" fonticon="fas fa-lock" />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>