<?php
namespace App;

/**
 * Core: Email Setup - Admin class
 * 
 * Core - Email Setup
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_EmailSetup_Admin extends \SCHLIX\cmsAdmin_Basic {

    public function __construct() {
        // Data: Item
        $methods = array('standard_main_app' => 'Main Page');

        parent::__construct('basic', null);      
    }
    
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'main':
                 $this->viewMainPage();
                return true;
            case 'result':
                 $this->viewResult();
                return true;
                
            case 'authxo2':
                return $this->viewAuthorizeXOAuth2();
                
            default: return parent::Run();
        }
    }
    
    public function viewResult()
    {
        
        
        $messages = [];
        $this->setPageTitle('OAUTH2 Result');
        $provider =  fsession_string('mail_oauth2_provider');
        $client_id = fsession_string('mail_oauth2_client_id');
        $secret = fsession_string('mail_oauth2_secret');
        $refresh_token = fsession_string('mail_oauth2_refresh_token');
        $success = fsession_string('mail_oauth2_setup_success');
        if (empty($provider))
            $messages[] = ___('Empty OAUTH2 provder name');
        if (empty($client_id))
            $messages[] = ___('Empty OAUTH2 client ID');
        if (empty($secret))
            $messages[] = ___('Empty OAUTH2 secret');
        if (!in_array($provider, ['google','microsoft','yahoo']))
            $messages[] = ___('Unsupported OAUTH2 provider');
        if ($success && empty($messages))
        {
            $alert_type = 'success';
            $messages[] = ___('OAUTH2 outgoing email server setup has been completed successfully');
            $messages[] = ___('Please save the following refresh token').' : '.$refresh_token;
            $messages[] = fsession_string('mail_oauth2_debug'); 
            
            $vars = [
                'SCHLIX_SMTP_OAUTH2_PROVIDER'  => $provider,
                'SCHLIX_SMTP_OAUTH2_CLIENT_ID' =>  fsession_string('mail_oauth2_client_id'),
                'SCHLIX_SMTP_OAUTH2_SECRET'    =>  fsession_string('mail_oauth2_secret'),
                'SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN' => $refresh_token];
            switch ($provider)
            {
                case 'google':
                    $vars['SCHLIX_SMTP_HOST'] = 'smtp.gmail.com';
                    $vars['SCHLIX_SMTP_PORT'] = 587;
                    $vars['SCHLIX_SMTP_SECURITY'] = 'tls';
                    break;
                case 'microsoft':
                    $vars['SCHLIX_SMTP_PORT'] = 587;
                    $vars['SCHLIX_SMTP_HOST'] = 'smtp.office365.com';
                    $vars['SCHLIX_SMTP_SECURITY'] = 'tls';
                    break;                
                
                case 'yahoo':
                    $vars['SCHLIX_SMTP_HOST'] = 'smtp.mail.yahoo.com';
                    $vars['SCHLIX_SMTP_PORT'] = 587;
                    $vars['SCHLIX_SMTP_SECURITY'] = 'tls';
                    break;         
                
            }
            $site_manager = new \App\SiteManager();
            $site_manager->changeSiteConfigDefinitions($vars);
            unset($_SESSION['mail_oauth2_client_id']);
            unset($_SESSION['mail_oauth2_provider']);
            unset($_SESSION['mail_oauth2_secret']);
            unset($_SESSION['mail_oauth2_refresh_token']);
            unset($_SESSION['mail_oauth2_setup_success']);
            $this->app->logInfo("Completed [{$provider}] OAUTH2 email setup with client ID [{$client_id}] and secret [{$secret}]");
            $oauth_debug =  fsession_string('mail_oauth2_debug');
            if (!empty($oauth_debug))
                $this->app->logInfo("Debug: ". $oauth_debug);
                
        } else
        {
            $alert_type = 'danger';
            if (!empty($_SESSION['mail_oauth2_error']))
            {
                $messages[] = $_SESSION['mail_oauth2_error'];
                $this->app->logError("Failed [{$provider}] OAUTH2 email setup - {$_SESSION['mail_oauth2_error']}");
            }
            else
            {
                $messages[] = ___('Empty refresh token. Please go to the console of your server provider, erase the credential, and redo the steps again');
                $messages[] = $_SESSION['mail_oauth2_debug']; 
                $this->app->logError("Failed [{$provider}] OAUTH2 email setup - must delete existing credential first from your provider's console");
            }
        }
        unset($_SESSION['mail_oauth2_setup_success']);
        unset ($_SESSION['mail_oauth2_error']);
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.result.admin', $local_variables, true);
        return true;
    }
    
    public function viewAuthorizeXOAuth2()
    {
        $are_deps_installed = \App\Core_EmailSetup::checkOAuthPackages();
        $this->setPageTitle('Authorize OAUTH2 connection');

        $url_redirect = $this->app->getURLRedirect();

        $sess_provider =  fsession_string('mail_oauth2_provider');
        $sess_client_id = fsession_string('mail_oauth2_client_id');
        $sess_secret = fsession_string('mail_oauth2_secret');
        
        
        $orig_oauth2_provider = defined ('SCHLIX_SMTP_OAUTH2_PROVIDER') ? SCHLIX_SMTP_OAUTH2_PROVIDER : '';
        $mail_oauth2_provider =  $sess_provider ? $sess_provider : $orig_oauth2_provider;
        $orig_oauth2_clientid = defined('SCHLIX_SMTP_OAUTH2_CLIENT_ID') ? SCHLIX_SMTP_OAUTH2_CLIENT_ID : '';
        $mail_oauth2_client_id = $sess_client_id ? $sess_client_id : $orig_oauth2_clientid;
        $orig_oauth2_secret = defined('SCHLIX_SMTP_OAUTH2_SECRET') ? SCHLIX_SMTP_OAUTH2_SECRET : '';
        $mail_oauth2_secret = $sess_secret ? $sess_secret : $orig_oauth2_secret;
        
        
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.authorize.admin', $local_variables, true);
        return true;
    }

    public function ajxp_TestEmail()
    {
        global $SystemConfig;
        $error_list = [];
        check_csrf_halt_on_error();
        $email_to  =fpost_string('msg_to', 255);
        $subject = fpost_string('msg_subject', 255);
        $message = fpost_string('msg_message', 4096);
        if (!is_valid_email_address(SCHLIX_MAIL_DEFAULT_EMAIL))
            $error_list[] = ___('Invalid email specified for SCHLIX_MAIL_DEFAULT_EMAIL');
        
        if (is_valid_email_address($email_to))
            $_SESSION['test_email_to'] = $email_to;
        else 
            $error_list[] = ___('Invalid email address');
        
        if (empty($error_list))
        {
            \App\Core_EmailQueue::setDebug(true);
            $dbconfig_timeout = $SystemConfig->get('emailqueue','int_smtp_timeout');
            $unq = new_uuid_v4();
            $result = \App\Core_EmailQueue::__sendEmailDirectly($dbconfig_timeout, $unq, $subject, SCHLIX_MAIL_DEFAULT_SENDER, SCHLIX_MAIL_DEFAULT_EMAIL, 
            $email_to, $email_to, null, null, 
            null, null, null, null,
            null, null, null,
            $message, $message, null);            
            $data = [
                'lines' => $result,
                'debug' => \App\Core_EmailQueue::getLastDebugOutput()
            ];            
            \App\Core_EmailQueue::setDebug(false);
            return ajax_reply_ok($data);
        } else 
        {
            return ajax_reply_error($error_list);
        }
    }
    
    public function getURLResult()
    {
        return $this->createFriendlySubApplicationAdminURL('emailsetup', 'action=result');
    }
    
    public function ajxp_SubmitConfig()            
    {
        $error_list = [];
        $data = [];
        
        check_csrf_halt_on_error();
        $mail_default_sender = fpost_string_noquotes_notags('mail_default_sender', 255);
        $mail_default_email = fpost_string('mail_default_email', 255);
        $smtp_host = fpost_string('smtp_host', 255);
        $smtp_port = fpost_int ('smtp_port');
        $smtp_secure_with = fpost_string('smtp_secure_with', 3);
        $smtp_use_auth = fpost_int('smtp_use_auth');
        $smtp_username = fpost_string('smtp_username', 255);
        $smtp_password = fpost_string('smtp_password', 255);
        $smtp_security_self_signed = fpost_int('smtp_security_self_signed');
        if (empty($mail_default_sender))
            $error_list[] = ___('Mail sender cannot be empty');
        if (!is_valid_email_address($mail_default_email, true ))
            $error_list[] = ___('Invalid email address');      
        if (!empty($smtp_host))
        {
            $valid_host = is_valid_hostname($smtp_host);
            if ($valid_host)
            {
                if ( ($smtp_port < 1) || ($smtp_port > 65535) )
                    $error_list[] = ___('Port must be between 1 and 65535');
                if (!empty($smtp_secure_with) && ($smtp_secure_with != 'tls') && ($smtp_secure_with != 'ssl'))
                    $error_list[] = ___('SMTP security can only be SSL or TLS');
                if ($smtp_use_auth)
                {
                    if (empty($smtp_username))
                        $error_list[] = ___('SMTP username must be specified if authentication is required');
                    /*if (empty($smtp_password))
                        $error_list[] = ___('SMTP password must be specified if authentication is required');                    */
                } else 
                {
                    // no need to blank out username/password
                }
                
            } else $error_list[] = ___('Invalid SMTP host name');
        } else 
        {
            $smtp_port = 0;
            $smtp_secure_with = '';
            $smtp_use_auth = false;
            $smtp_username = '';
            $smtp_password = '';
        }
        
        if (empty($error_list))
        {
            $vars = [
                'SCHLIX_MAIL_DEFAULT_SENDER' => $mail_default_sender,
                'SCHLIX_MAIL_DEFAULT_EMAIL' => $mail_default_email,
                'SCHLIX_SMTP_HOST' => $smtp_host,
                'SCHLIX_SMTP_PORT' => $smtp_port,
                'SCHLIX_SMTP_USE_AUTH' => $smtp_use_auth,
                'SCHLIX_SMTP_USERNAME' => $smtp_username,
                'SCHLIX_SMTP_PASSWORD' => $smtp_password,
                'SCHLIX_SMTP_SECURITY' => $smtp_secure_with,
                'SCHLIX_SMTP_SECURITY_SELF_SIGNED' => $smtp_security_self_signed
            ];
            
            $site_manager = new \App\SiteManager();
            $site_manager->changeSiteConfigDefinitions($vars);            
            $data['messages'] = [___('Configuration saved')];
        } else 
        {
            $data['messages'] = $error_list;
        }
        return empty($error_list) ? ajax_reply_ok($data) : ajax_reply_error($data);
    }
    
    public function ajxp_authorizeXOAUTH2()
    {        
        $error_list = [];
        check_csrf_halt_on_error();
        $approved_providers = ['google','yahoo','microsoft'];
        $provider  = fpost_alphanumeric('mail_oauth2_provider', 10);
        $clientid = fpost_string('mail_oauth2_client_id', 255);
        $secret = fpost_string('mail_oauth2_secret', 255);
        $are_deps_installed =  \App\Core_EmailSetup::checkOAuthPackages();
        if (!$are_deps_installed)
            $error_list[] = ___('Dependencies have not been installed');        
        if (!in_array($provider, $approved_providers))
            $error_list[] = ___('Invalid provider specified');
        if (($provider == 'google') && !str_ends_with($clientid, '.apps.googleusercontent.com'))
            $error_list[] = ___('Invalid Google Client ID');
        if (strlen($secret) < 5)
            $error_list[] = ___('Invalid secret key');
        
        if (empty($error_list))
        {
            $_SESSION['mail_oauth2_client_id'] = $clientid;
            $_SESSION['mail_oauth2_secret'] = $secret;
            $_SESSION['mail_oauth2_provider'] = $provider;
            
            try 
            {                
                $arr_oauth_provider_info = $this->app->getOAuthProviderObject($provider, $clientid, $secret);
                $oauth_provider = $arr_oauth_provider_info['provider'];
                $url_auth = $oauth_provider->getAuthorizationUrl($arr_oauth_provider_info['options']);
                $_SESSION['mail_oauth2_state'] = $oauth_provider->getState();

                $data = [
                    'url_redirect' =>  $url_auth
                ];
            }
            catch (\Exception $exc)
            {
                $error_list[] = $exc->getMessage();
            }
            
        }
        return empty($error_list) ? ajax_reply_ok($data) : ajax_reply_error($error_list);
    }

}
