<?php
/**
 * Core: Extension Gallery - Main page view template. Lists both categories and items with parent_id = 0 and category_id = 0 
 * 
 * Core - Extension Gallery
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die();
?>
<?php
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
    $current_category_id = $category[$field_cid];
    $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
    $str_mainpage_text =  $this->getConfig('str_mainpage_text');
     // OPTIONAL - feel free to uncomment
     // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <h1 class="main title"><?= ___h($str_mainpage_title); ?></h1>
    <?php if ($pg < 2) : ?>
        <?= $str_mainpage_text ?>
    <?php endif ?>

    <?php if ($categories): ?>
    <!-- ########################################################################### -->
    <!-- #######################  categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="main categories">
            <?php foreach ($categories as $category): ?>
                <?php if ($category['status'] > 0): ?>            
                <section class="child-category">    
                    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $category_id = $category[$field_cid];
                        $this->processDataOutputWithMacro($category, 'viewMainPageCategory', array('main_meta_options' => $main_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$category_id}");
                        $category_title = ___h($category['title']);
                        $category_title_text = ($category!= null) && ($main_meta_options['display_child_category_read_more_link']==false || $main_meta_options['display_link_title']==true) ? 
                            \__HTML::A($category_title,$link) : $category_title;
                    ?>
                    <?php if ($category_title_text): ?>
                        <h2 class="category title"><i class="fas fa-folder"></i> <?= $category_title_text; ?></h2>
                    <?php endif ?>

                    <!-- Macro - Pre -->
                    <?php if ($category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($main_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($category['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->
                    <?= $category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ######################## end categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?> 
    
    <?php if ($items):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="main items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item_id = $child_item[$this->field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewMainPageItem', array('main_meta_options' => $main_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($main_meta_options['display_child_item_read_more_link']==false || $main_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        
                    ?>
                    <?php if ($child_item_title_text): ?>
                        <h2 class="item title"><?= $child_item_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($main_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $child_item['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    
    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=main"); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div>
 