<?php
/**
 * Core - Redirection - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

global $CurrentUser;
if ($id == 'new') {
    $header_title = ___('New Redirect Rule');
    $existing_404_id = fget_int('url404id');
    if ($existing_404_id > 0)
    {
        $app_error_404 = new \App\Core_Error404();
        $item_404 = $app_error_404->getItemByID($existing_404_id);
        $item['path'] = $this->app->removePrecedingSlash($item_404['path']);
    }
    //$item['path'] = urldecode(fget_string('url404id')); // urldecode(fget_string('item_path'));
    $item['hostname'] = fget_string('item_hostname');
    if(empty($item['hostname'])) 
        $item['hostname'] = $_SERVER['HTTP_HOST'];
} else {
    $header_title = ___('Edit Redirect Rule').' #'.$id;
}

$server_host = $_SERVER['HTTP_HOST'];
$scheme = isCurrentRequestSSL() ? 'https' : 'http';
$host = $scheme.'://'.$server_host.SCHLIX_SITE_HTTPBASE.'/';
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-item-editor  data-type-desc="<?= ___('item') ?>" data-schlix-controller="SCHLIX.CMS.Core_RedirectionAdminController">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />            
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('Content') ?>">                     
                    <x-ui:clearboth />
                    
                <x-ui:form-group>
                    <x-ui:label for="path"><?= ___('From') ?></x-ui:label>
                    <x-ui:input-group>

                        <!-- Instance Of -->
                        <x-ui:input-addon>
                            <strong><?= ___h($host) ?></strong>
                        </x-ui:input-addon>
                        
                        <!-- title -->
                        <x-ui:textbox id="path" name="path" data-field="path" placeholder="blog/this-page-moved-somewhere-else" />


                        <!-- status -->
                        <x-ui:input-addon>
                            <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= (isset($item['status']) && ($item['status'] == 1)) || ($item['id'] == 'new') ?>" 
                                                        data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                        data-text-yes="<?= ___S('Active & Published') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>
                    
                    
                    
                    <x-ui:textbox id="redirect_to" name="redirect_to" data-field="redirect_to" label="<?= ___('To') ?>" placeholder="blog/new-page-url" <?php /* prefix="/" */ ?> />
                    <p class="small"><?= ___('You can type either full external URL or internal path') ?></p>
                    <x-ui:clearboth />
                    <x-ui:row>
                        <x-ui:column xs="3">
                        <x-ui:select id="type" name="type" data-field="type" label="<?= ___('Type') ?>">
                            <?php foreach ($this->typeOptions() as $value => $label): ?>
                                <?php $selected = isset($item['type']) &&  ($value == $item['type']); ?>
                                <x-ui:option value="<?= $value ?>" label="<?= ___h($label) ?>" <?= $selected ? ' selected="selected"' : '' ?> />
                            <?php endforeach ?>                        
                        </x-ui:select>
                            
                        </x-ui:column>
                        <x-ui:column xs="9">
                            <x-ui:textbox id="description" name="description" data-field="description" label="<?= ___('Description') ?>" placeholder="<?= ___('Optional description or note') ?>" />
                        </x-ui:column>                        
                    </x-ui:row>
                    

                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" name="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" name="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- hooks -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 