<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

if ($id != 'new') {
    $configvar = $this->parseSiteConfigFile($item['title']);
}

$system_timezone = $configvar['SCHLIX_SYSTEM_TIMEZONE'];
$user_classes = $this->getUsersClassArray();
$usergroup_selections = $this->getUserGroupsArray();

$userclass_selections = [];//$this->getUsersClassArray();

foreach ($user_classes as $u)
    $userclass_selections[$u] = $u;
$site_http_url = $configvar['SCHLIX_SITE_HTTP_URL'];
$site_https_url  = $configvar['SCHLIX_SITE_HTTPS_URL'];
if ($site_http_url === 'https://')
    $configvar['SCHLIX_SITE_HTTP_URL'] = '';
if ($site_https_url === 'https://')
    $configvar['SCHLIX_SITE_HTTPS_URL'] = '';
$config_file_location = SCHLIX_ROOT_PATH . '/web/' . $item['title'] . '/config.inc.php';
$fix_site_offline = null;
$fix_site_ssl_enabled = null;
$fix_force_ssl_admin_login = null;
$fix_sql_cache_enabled = null;
$fix_sql_enforce_row_limit = null;
$fix_smtp_use_auth= null;
$fix_db_use_ssl = null;
$fix_record_404_errors = null;
$str_checked = ' checked="checked" ';
 $fix_display_errors =  is_value_true(ini_get('display_errors')) || $was_new ? $str_checked : '';

if ($was_new) {
    $configvar['SCHLIX_DB_USERNAME'] = SCHLIX_DB_USERNAME;
    $configvar['SCHLIX_DB_PASSWORD'] = SCHLIX_DB_PASSWORD;
    $configvar['SCHLIX_DB_HOST'] = SCHLIX_DB_HOST;
    $configvar['SCHLIX_MAIL_DEFAULT_SENDER'] = SCHLIX_MAIL_DEFAULT_SENDER;
    $configvar['SCHLIX_MAIL_DEFAULT_EMAIL'] = SCHLIX_MAIL_DEFAULT_EMAIL;
    $configvar['SCHLIX_SESSION_LOGIN_TIME'] = 86400;
    $configvar['SCHLIX_SESSION_REMEMBER_COOKIE_TIME'] = 86400;
    $configvar['SCHLIX_DB_SOCKET'] = defined('SCHLIX_DB_SOCKET') ? SCHLIX_DB_SOCKET : '';
    $configvar['SCHLIX_DB_PORT'] = defined('SCHLIX_DB_PORT') ? (int) SCHLIX_DB_PORT : '';
    $configvar['SCHLIX_DB_USE_SSL'] =  defined('SCHLIX_DB_USE_SSL') ? (int)  SCHLIX_DB_USE_SSL : 0;
    $configvar['SCHLIX_DB_SSL_CA'] = defined('SCHLIX_DB_SSL_CA') ? SCHLIX_DB_SSL_CA : '';
    // oauth2
    $configvar['SCHLIX_SMTP_OAUTH2_PROVIDER'] = '';
    $configvar['SCHLIX_SMTP_OAUTH2_CLIENT_ID'] = '';
    $configvar['SCHLIX_SMTP_OAUTH2_SECRET'] = '';
    $configvar['SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN'] = '';
    if (isCurrentRequestSSL())
    {
        $fix_site_ssl_enabled = true;
        $fix_force_ssl_admin_login = true;
    }
} else 
{
    $fix_site_offline = defined('SCHLIX_SITE_OFFLINE') && is_value_true(SCHLIX_SITE_OFFLINE) ? $str_checked : '';//  1 : 0;
    $fix_site_ssl_enabled = defined('SCHLIX_SITE_SSL_ENABLED') && is_value_true(SCHLIX_SITE_SSL_ENABLED) ? $str_checked : '';//  1 : 0;
    $fix_force_ssl_admin_login = defined('SCHLIX_FORCE_SSL_ADMIN_LOGIN') && SCHLIX_FORCE_SSL_ADMIN_LOGIN ? $str_checked : '';    
    $fix_sql_cache_enabled = defined('SCHLIX_SQL_CACHE_ENABLED') && SCHLIX_SQL_CACHE_ENABLED ? $str_checked : '';
    $fix_sql_enforce_row_limit = defined('SCHLIX_SQL_ENFORCE_ROW_LIMIT') && SCHLIX_SQL_ENFORCE_ROW_LIMIT ? $str_checked : '';
    $fix_smtp_auth_allow_self_signed = defined('SCHLIX_SMTP_SECURITY_SELF_SIGNED') && SCHLIX_SMTP_SECURITY_SELF_SIGNED ? $str_checked : ''; 
    $fix_db_use_ssl = defined('SCHLIX_DB_USE_SSL') && SCHLIX_DB_USE_SSL ? $str_checked : ''; 
    $fix_record_404_errors = defined('SCHLIX_RECORD_404_ERRORS') && SCHLIX_RECORD_404_ERRORS ? $str_checked : '';  
   
}

    
$current_site_id = $this->getCurrentSiteID();
$is_editing_current_site = ((int) $id === (int) $current_site_id);
$tzdata = get_sorted_timezone_data(); 
$opt_session_times = [
    0 => ___('Please select'),
    900 => ___('15 minutes'),
    1800 => ___('30 minutes'),
    3600 => ___('1 hour'),
    7200 => ___('2 hours'),
    14400 => ___('4 hours'),
    28800 => ___('8 hours'),
    43200 => ___('12 hours'),
    86400 => ___('1 day'),
    172800 => ___('2 days'),
    604800 => ___('1 week'),
    1209600 => ___('2 weeks') 
    ];

$opt_sql_cache_time = [
    0 => ___('None'),
    900 => ___('15 minutes'),
    1800 => ___('30 minutes'),
    3600 => ___('1 hour'),
    7200 => ___('2 hours'),
    14400 => ___('4 hours'),
    28800 => ___('8 hours'),
    43200 => ___('12 hours')];
////////////////////////////////



$opt_error_reporting = $this->error_choices;

$current_error_reporting = $this->current_error_reporting;
?>

<div class="content">

    
    <?php if ($was_new): ?>
        <x-ui:alert type="info">
            <i class="far fa-lightbulb"></i>&nbsp;<?= ___('Administrator password on this new website will be set to your current password') ?>
        </x-ui:alert>
    <?php endif ?>

    <?php if ($id != 'new' && file_exists($config_file_location) && !is_writable($config_file_location)): ?>
    
        <x-ui:alert type="error">
            <h3><?= ___('Error') ?></h3>
            <i class="fa fa-times-circle"></i>&nbsp;<?= ___('Cannot write to configuration file').' '.$config_file_location ?>
        </x-ui:alert>
     
    <?php endif; ?>    
    <!-- row -->
    <x-ui:row>
        <!-- begin column -->
        <x-ui:column md="6" class="no-padding">
            <!-- box -->
            <x-ui:schlix-info-box class="box-info" fonticon="fa fa-desktop" label="<?= ___('Site') ?>" >
                <!-- field - sitename -->
                <x-ui:form-group>
                    <label for="site_name"><?= ___('Site Name') ?></label>
                    <x-ui:input-group>                        
                        <x-ui:input-addon fonticon="fas fa-university" />
                        <x-ui:textbox name="site_name" id='site_name' data-var="SCHLIX_SITE_NAME" title="<?= ___('Site Name is required') ?>" required="required" />

                        <x-ui:input-addon>
                            <x-ui:checkbox name="site_offline" id="site_offline" value="1" label="<?= ___('Offline / Under maintenance'); ?>" no-wrapper="1" <?= $fix_site_offline ?> />
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>

                <!-- form-group content -->
                <!-- field -->
                <?php if (!$was_new): ?>
                    <!-- field -->
                    <x-ui:textbox type="text" name="site_http_url" id="site_http_url" class="validate-http-domain required" data-var="SCHLIX_SITE_HTTP_URL" placeholder="http://.... <?= ___('Leave blank for auto configuration') ?>" fonticon="fa fa-unlock" label="<?= ___('Site HTTP URL') ?>" />
               
                <!-- SSL -->

                <x-ui:form-group>
                    <label for="site_https_url"><?= ___('Site HTTPS URL') ?> (SSL)</label>
                    <x-ui:input-group>
                        <x-ui:input-addon fonticon="fas fa-lock" />
                        <x-ui:textbox type="text" name="site_https_url" id="site_https_url" class="validate-https-domain" data-var="SCHLIX_SITE_HTTPS_URL" placeholder="https://... <?= ___('Leave blank for auto configuration') ?>" />
                        <x-ui:input-addon>                                
                            <x-ui:checkbox name="ssl_enabled" id="ssl_enabled" value="1" label="<?= ___('Enable SSL'); ?>" no-wrapper="1" <?= $fix_site_ssl_enabled ?> />
                        </x-ui:input-addon>
                        <x-ui:input-addon>
                            <x-ui:checkbox name="force_ssl_admin_login" id="force_ssl_admin_login" value="1" label="<?= ___('Force SSL login'); ?>" no-wrapper="1" <?= $fix_force_ssl_admin_login ?> />
                        </x-ui:input-addon>
                        
                    </x-ui:input-group>
                </x-ui:form-group>

                <?php endif ?>
                <!-- end SSL -->
                <!-- field -->
                <x-ui:select name="admin_login_time" required="required" label="<?= ___('Login session expiry') ?>" default-value="7200" fonticon="far fa-clock"  data-options-var="opt_session_times" data-var="SCHLIX_SESSION_LOGIN_TIME" />
                <x-ui:select name="remember_me_cookie_time" required="required" label="<?= ___('Remember login cookie expiry') ?>" default-value="172800" fonticon="far fa-clock"  data-options-var="opt_session_times" data-var="SCHLIX_SESSION_REMEMBER_COOKIE_TIME" />
                <!-- field -->
                <x-ui:select name="samesite_cookie_mode" required="required" label="<?= ___('Samesite Cookie') ?>" fonticon="fas fa-globe" default-value="none" data-var="SCHLIX_COOKIE_SAMESITE">
                    <x-ui:option label="None" value="none" />
                    <x-ui:option label="Lax" value="lax" />
                    <x-ui:option label="Strict" value="strict" />
                </x-ui:select>

                <!-- field -->
                <x-ui:select name="system_timezone" required="required" label="<?= ___('System Timezone') ?>" fonticon="fas fa-globe" default-value="UTC" data-var="SCHLIX_SYSTEM_TIMEZONE">
                    <?php foreach ($tzdata as $gmt_zone => $places): ?>
                        <x-ui:optgroup label="<?= ___h($gmt_zone) ?>">
                            <?php foreach ($places['places'] as $place): ?>
                                <x-ui:option label="<?= ___h($place) ?>" value="<?= ___h($place) ?>" />
                            <?php endforeach ?>
                        </x-ui:optgroup>
                    <?php endforeach ?>
                </x-ui:select>
                <!-- form-group content -->
            </x-ui:schlix-info-box>            
        </x-ui:column>
        <!-- end column -->

        <!-- begin column -->
        <x-ui:column md="6" >
            <!-- box -->
            <x-ui:schlix-info-box class="box-danger" fonticon="fa fa-envelope" label="<?= ___('E-mail') ?>" >
               
                <x-ui:textbox name="mail_default_sender" id="mail_default_sender" default-value="Webmaster" data-var="SCHLIX_MAIL_DEFAULT_SENDER" fonticon="fa fa-user-circle" label="<?= ___('Default Mail Sender Name') ?>" required="required" placeholder="Webmaster" />
                <x-ui:textbox type="email" name="mail_default_email" id='mail_default_email'  data-var="SCHLIX_MAIL_DEFAULT_EMAIL" fonticon="fa fa-envelope" label="<?= ___('Email address') ?>" required="required" placeholder="mail@example.com" />

                <fieldset>
                    <legend><?= ___('Outgoing SMTP server') ?></legend>
                        <em><?= (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN' && $configvar['SCHLIX_SMTP_HOST'] == '') ? ___('Please configure the SMTP server, otherwise registration/contact mail will not work') : ___('Leave the SMTP settings below blank to use the default settings') ?></em>
                        
                <!-- field -->
                <x-ui:form-group>
                    <x-ui:input-group>
                        <x-ui:input-addon label="<?= ___('Host') ?>" />
                        <x-ui:textbox name="smtp_host" id="smtp_host" data-var="SCHLIX_SMTP_HOST" placeholder="mail.example.com" />
                        <x-ui:input-addon>                                
                            <?= ___('Port') ?>
                        </x-ui:input-addon>
                        
                            <x-ui:textbox name="smtp_port" id="smtp_port" type="number" data-var="SCHLIX_SMTP_PORT" placeholder="25, 465 (SSL), <?= ___('or') ?> 587 (TLS)"  />
                        
                        <x-ui:input-addon>
                            <span><?= ___('Security')?>: </span>
                            
                            <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_none"  value="" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('none') ?>" no-wrapper="1" />
                            <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_ssl"  value="ssl" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('SSL') ?>" no-wrapper="1" />
                            <x-ui:radio name="smtp_secure_with" id="smtp_secure_with_tls"  value="tls" data-var="SCHLIX_SMTP_SECURITY" label="<?= ___('TLS') ?>" no-wrapper="1" />
                                                         
                        </x-ui:input-addon>
                            
                    </x-ui:input-group>
                    <x-ui:input-group>
                    <x-ui:checkbox name="smtp_security_self_signed" id="smtp_security_self_signed"  value="1" label="<?= ___('Allow self-signed certificate'); ?>" <?= $fix_smtp_auth_allow_self_signed ?> no-wrapper="1" />
                    </x-ui:input-group>
                </x-ui:form-group>
                        
                
                        <x-ui:select name="smtp_use_auth" id="smtp_use_auth" fonticon="fas fa-server" label="<?= ___('Use SMTP authentication') ?>" data-var="SCHLIX_SMTP_USE_AUTH">
                            <x-ui:option value="" label="-- <?= ___('No authentication') ?> --" />
                            <x-ui:option value="1" label="Regular password" />
                            <x-ui:option value="2" label="OAUTH2" />
                        </x-ui:select> 
                
                <div id="smtp_username_box">
                <x-ui:textbox name="smtp_username" id="smtp_username" data-var="SCHLIX_SMTP_USERNAME" fonticon="far fa-user" label="SMTP <?= ___('Username') ?>" autocomplete="off" placeholder="smtpuser@mail.example.com"   />
                </div>
                <div id="smtp_password_box">
                <x-ui:textbox type="password" name="smtp_password" id="smtp_password" data-var="SCHLIX_SMTP_PASSWORD" fonticon="fa fa-lock" label="SMTP <?= ___('Password') ?>"  autocomplete="off" placeholder="SMTP <?= ___('Password') ?>" /> 
                </div>
            </fieldset>         
                <?php if (isset($SCHLIX_SMTP_OAUTH2_PROVIDER)): ?>
                    <fieldset id="smtp_oauth2_box">
                        <legend><?= ___('OAUTH2 Settings') ?></legend>
                <x-ui:alert type="info">
                    <p><?= ___('Please navigate to Settings - Email Setup to authorize/re-authorize OAUTH2 connection') ?></p>
                </x-ui:alert>
                        
                        <x-ui:select name="mail_oauth2_provider" id="mail_oauth2_provider" fonticon="fas fa-server" label="<?= ___('Provider') ?>" data-var="SCHLIX_SMTP_OAUTH2_PROVIDER">
                            <x-ui:option value="" label="-- <?= ___('Please select') ?> --" />
                            <x-ui:option value="google" label="GMail/GSuite/Google Workspace" />
                            <x-ui:option value="yahoo" label="Yahoo" />
                            <x-ui:option value="microsoft" label="Microsoft" />
                        </x-ui:select> 

                        <x-ui:textbox name="mail_oauth2_client_id" id="mail_oauth2_client_id" fonticon="fa fa-user-circle" label="<?= ___('Client ID') ?>/<?= ___('Application ID') ?>" data-var="SCHLIX_SMTP_OAUTH2_CLIENT_ID" placeholder="1234567890-abcdef.apps.googleusercontent.com" />
                        <x-ui:textbox name="mail_oauth2_secret" id="mail_oauth2_secret"  fonticon="fas fa-key" label="<?= ___('Client Secret') ?>" placeholder="1234567890abcdef" data-var="SCHLIX_SMTP_OAUTH2_SECRET" />
                        <x-ui:textbox name="mail_oauth2_refresh_token"  id="mail_oauth2_refresh_token" data-var="SCHLIX_SMTP_OAUTH2_REFRESH_TOKEN" fonticon="fas fa-mask" label="<?= ___('Refresh Token') ?>" />
                    </fieldset>
                <?php endif ?>
            </x-ui:schlix-info-box>
        </x-ui:column>
        <!-- end column -->            

    </x-ui:row>
    <!-- row -->
    <x-ui:row>
        <!-- begin column -->
        <x-ui:column md="6" class="no-padding">
            <!-- box -->
            <x-ui:schlix-info-box class="box-info" fonticon="fa fa-database" label="<?= ___('Database') ?>" >
     
                    <!-- body -->
                    <x-ui:row>
                        <x-ui:column sm="12" md="8">
                    <?php if ($is_editing_current_site): ?>
                        <x-ui:alert type="info">
                            <?= ___('Database information cannot be changed when you are editing the current site configuration') ?>
                        </x-ui:alert>
                    <?php endif ?>
                    <?php if ($was_new): ?>
                        <x-ui:hidden name="db_tested" id='db_tested' value="0" />
                        <x-ui:alert type="warning">
                            <?= ___('Please ensure that you have created the database in MySQL before proceeding') ?>
                        </x-ui:alert>
                    <?php else: ?>
                        <x-ui:hidden name="db_tested" id='db_tested' value="yes" />
                    <?php endif ?>
                            
                            <?php $readonly_current_site = $is_editing_current_site ? 'readonly="readonly"' : ''; ?>
                            <!-- settings -->
                            <x-ui:textbox name="db_host" id="db_host" data-var="SCHLIX_DB_HOST" default-value="localhost" fonticon="fa fa-server" label="<?= ___('Host') ?>" autocomplete="off" required="required" pattern="^[A-Za-z0-9-_\.]{1,100}$" <?= $readonly_current_site ?>   />
                             
                            <!-- field -->
                            <x-ui:textbox name="db_database" id="db_database" data-var="SCHLIX_DB_DATABASE" fonticon="fa fa-database" label="<?= ___('Database Name') ?>" autocomplete="off" required="required" pattern="^[A-Za-z0-9-_]{1,63}$"  <?= $readonly_current_site ?> />
                             
                            <!-- field -->
                             <x-ui:textbox name="db_username" id="db_username" data-var="SCHLIX_DB_USERNAME" fonticon="far fa-user" label="<?= ___('Username') ?>" autocomplete="off" required="required" pattern="^[A-Za-z0-9- _]{1,63}$"  <?= $readonly_current_site ?> />
                             
                             <!-- field -->
                             <?php if ($was_new || ! $is_editing_current_site): ?>
                             <x-ui:textbox type="password" name="db_password" id="db_password" data-var="SCHLIX_DB_PASSWORD" fonticon="fa fa-lock" label="<?= ___('Password') ?>" autocomplete="off" required="required"  <?= $readonly_current_site ?> />                         
                             <?php else: ?>
                             <p><?= sprintf(___('To change the database password, please edit %s directly'), $config_file_location) ?></p>
                             <?php endif ?>
                            <!-- field -->                            
                            <x-ui:textbox name="db_socket" id="db_socket" data-var="SCHLIX_DB_SOCKET" placeholder="/var/run/mysqld/mysqld.sock" fonticon="fas fa-server" label="<?= ___('Socket') ?>" autocomplete="off" <?= $readonly_current_site ?> />
                            
                            <x-ui:form-group>
                                <label for="db_ssl_ca" class="control-label"><?= ___('Database connection uses SSL') ?></label>
                                <x-ui:input-group>
                                <x-ui:input-addon>
                                    
                                    <input type="checkbox" name="db_use_ssl" id="db_use_ssl" value="1" title="<?= ___('Usually this is required by Azure') ?>" <?= $fix_db_use_ssl ?> /><?= ___('Yes') ?>
                                </x-ui:input-addon>
                                    <x-ui:input-addon>
                                        <i class="fas fa-file"></i> <?= ___('SSL CA certificate file path') ?>
                                    </x-ui:input-addon>
                                    <x-ui:textbox placeholder="/var/www/mysql/ca.pem" name="db_ssl_ca"  id="db_ssl_ca" type="text" data-var="SCHLIX_DB_SSL_CA" <?= $readonly_current_site ?> />
                                </x-ui:input-group>
                            </x-ui:form-group>
 

                            <x-ui:form-group>
                                <label for="sql_cache_time"><?= ___('SQL Cache') ?></label>
                                <x-ui:input-group>
                                    <x-ui:input-addon><x-ui:checkbox name="enable_sql_cache" id="enable_sql_cache" value="1" label="<?= ___('Enable') ?>" no-wrapper="true" <?= $fix_sql_cache_enabled ?> /> </x-ui:input-addon>
                                    <x-ui:select name="sql_cache_time" id="sql_cache_time" required="required" fonticon="far fa-clock" data-options-var="opt_sql_cache_time" data-var="SCHLIX_SQL_CACHE_TIME" />
                                    <x-ui:input-addon label="<?= ___('seconds') ?>" />
                                </x-ui:input-group>
                            </x-ui:form-group>
                            
                            <x-ui:checkbox name="enforce_sql_row_limit" id="enforce_sql_row_limit" value="1" label="<?= ___('Enforce SQL Row Limit') ?> - (<?= ___('Recommended for small sites') ?>)" <?= $fix_sql_enforce_row_limit?> />
                            <!-- end settings -->
                            <?php if ($was_new|| 1): ?>
                                <a href="javascript:void(0)" class="btn btn-warning" id="btn_test_database">
                                    <i class="fa fa-database"></i> <?= ___('Test Connection') ?>
                                </a>
                                <div id="db_test_result"></div>
                            <?php endif ?>
                            
                        </x-ui:column>
                         
                    </x-ui:row>
                    <!-- end body --> 
            </x-ui:schlix-info-box>
        </x-ui:column>
        <!-- end column -->            
        <x-ui:column md="6" >
            <!-- box -->
            <x-ui:schlix-info-box class="box-success" fonticon="fa fa-gears" label="<?= ___('Other Settings') ?>" >
                

        <!-- begin content -->
                
                <div class="box-body">
                    <!-- body -->
                    <?php if ($userclass_selections): ?>
                    <x-ui:select name="default_user_class" id="default_user_class" required="required" fonticon="far fa-user" data-options-var="userclass_selections" data-var="SCHLIX_DEFAULT_USER_CLASS" label="<?= ___('Default User Class') ?>" />
                    <?php endif; ?>

                    <?php if ($usergroup_selections): ?>
                    <x-ui:select name="default_admin_group" id="default_admin_group" required="required" fonticon="fa fa-users" data-options-var="usergroup_selections" data-var="SCHLIX_DEFAULT_ADMIN_GROUP" label="<?= ___('Default Administrator Group') ?>" />
                        
                    <?php endif; ?>
                    <?php /*
                      <br />
                      <label><?= ___('SCHLIX Javascript Mode') ?>
                      <select id="schlix_js_mode" name="schlix_js_mode">
                      <option value="1" <?= intval($configvar['SCHLIX_JS_MODE']) == 3 ? 'selected': '' ?>><?= ___('Production (Minified, GZIP-ped)') ?></option>
                      <option value="2" <?= intval($configvar['SCHLIX_JS_MODE']) == 2 ? 'selected': '' ?>><?= ___('Minified only') ?></option>
                      <option value="3" <?= intval($configvar['SCHLIX_JS_MODE']) == 1 ? 'selected': '' ?>><?= ___('Debug') ?></option>
                      </select>
                      </label> */
                    ?>
                    <fieldset>
                        <legend><?= ___('Options') ?></legend>
                        <x-ui:checkbox name="display_errors" id="display_errors"  value="1" data-var="display_errors" label="<?= ___('Display PHP Errors') ?>"  <?= $fix_display_errors ?> />
                        <x-ui:checkbox name="record_404_errors" id="record_404_errors" value="1" data-var="SCHLIX_RECORD_404_ERRORS" label="<?= ___('Record 404 Errors in the database') ?>" <?= (is_value_true($configvar['SCHLIX_RECORD_404_ERRORS']) || $was_new) ? 'checked="checked"' : '' ?> />
                        <?php /*<x-ui:checkbox name="sef_enabled" id="sef_enabled" value="1" label="<?= ___('Enable Search Engine Friendly URL') ?>"  <?= (is_value_true($configvar['SCHLIX_SEF_ENABLED']) || $was_new) ? 'checked="checked"' : '' ?>  />*/ ?>
                        
                         

                    </fieldset>
                    <x-ui:checkbox-group name="error_report[]" data-options-var="opt_error_reporting" data-var="current_error_reporting" label="<?= ___('Error Reporting') ?>" />
                    
                    
                    
                    <!-- end body -->
                </div>
        <!-- end content -->            
            </x-ui:schlix-info-box>
        </x-ui:column>
        <!-- end column -->  
    </x-ui:row>
    <!-- row -->        
</div>
