<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $CurrentUser;

$users_in_this_category = $this->app->getItemsByCategoryID($category['cid']);

if ($id == 'new') {
    $category['permission_read'] = serialize('everyone');
    $category['items_per_page'] = 10;
    $header_title = ___('New User Group');
}
else {
    $id = (int) $id;
    $header_title = ___('Edit Group').' #'.___h($id);
}
?>
<x-ui:schlix-explorer-sub-application-header />

<x-ui:schlix-category-editor  data-schlix-controller="SCHLIX.CMS.UsersAdmin"   >    
        
        <x-ui:schlix-editor-form id="form-edit-category" method="post" admin-action="savecategory">
            
            <x-ui:csrf id="_csrftoken" />
            
            <x-ui:hidden id="cid" name="cid" data-field="cid" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                <x-ui:form-group>
                    <x-ui:label for="title"><?= ___('Group Name') ?></x-ui:label>
                    <x-ui:input-group>
                        <!-- title -->
                        <x-ui:textbox name="groupname" id="groupname" type="text" required="required" data-field="groupname" <?= ($category['groupname'] == 'Administrators') ? 'readonly="readonly"' : '' ?> /> 

                        <!-- status -->
                        <x-ui:input-addon>
                                <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= ($category['status'] == 1 || $category[$this->field_category_id] == 'new') ?>" 
                                data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                data-text-yes="<?= ___('Active') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>
                     
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <?php if ($category['groupname'] != 'Administrators'): ?>                    
                        <x-ui:schlix-editor-action-buttons />
                    <?php endif ?>
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="fa fa-users" label="<?= ___('Users in this group') ?>"> 
                        <?php if ($users_in_this_category): ?>
                            <h4><?= ___('List of users in this category'); ?></h4>
                            <ul class="list-unstyled">
                                <?php foreach ($users_in_this_category as $user): ?>
                                <li><i class="fa fa-user"></i> <a href="index.php?app=users&amp;action=edititem&amp;id=<?= (int) $user['id']; ?>"><?= ___h($user['username']) ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                </x-ui:schlix-tab>
                <!-- tab -->
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-category-editor>
