<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php
global $HTMLHeader;

$rate_limit_exceeded = rate_limit_and_halt('invalid_user_activation', 2, 4, 3600);
$enable_captcha_user_activation = $this->getConfig('bool_enable_captcha_user_activation');

?>
<div class="app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-activation_completed">
    <h1><?= ___('New User Activation'); ?></h1>
    <x-ui:row>
        <x-ui:column sm="6" md="4">
        <x-ui:form-simple-ajax method="post" data-action="<?= $this->createFriendlyURL('action=useractivation'); ?>" name="activation" id="activation" enctype="multipart/form-data" autocomplete="off">
            <x-ui:csrf />            
            <x-ui:hidden id="userid" name="userid" value="<?= ___h($userid); ?>" />
            <!-- col -->
            
                <x-ui:panel type="panel-default">
                    <x-ui:panel-body>
                        <x-ui:row>
                            <x-ui:column sm="12" >

                                <x-ui:form-group>

                                    <x-ui:textbox name="activation_string" id="activation_string" autofocus="autofocus" required="required" fonticon="fas fa-lock" placeholder="<?= ___('Auth Code') ?>" value="<?= ___h($token) ?>"   />
                                </x-ui:form-group>

                                <?php if ($enable_captcha_user_activation || $rate_limit_exceeded): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" />

                                <?php endif ?>
                                <x-ui:button button-type="ok"  type="submit" name="submit" id="btn-activate" data-form-submit="1"  value="Submit" label="<?= ___('Activate Account') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />


                            </x-ui:column>
                        </x-ui:row>
                    </x-ui:panel-body>
                    <x-ui:panel-footer>

                    </x-ui:panel-footer>
                </x-ui:panel>
            </x-ui:form-simple-ajax>
            
        </x-ui:column>
        
        <!-- col -->
        <x-ui:column sm="6" md="8">
            <!-- output for ajax message -->
            <div class="schlix-ajax-output"></div>
            <!-- end output -->
            <?php if ($activation_error): ?>
                <x-ui:alert type="error">
                    <p><?= $activation_error ?></p>
                </x-ui:alert>
            <?php endif; ?>

            <x-ui:echo-safe-config-value key="str_account_activation_text" />
        </x-ui:column>
    </x-ui:row>
</div>