<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    
    function generateTree($datas, $parent = 0, $depth = 0) {
        if ($depth > 100)
            return ''; // Make sure not to have an endless recursion
        $ul_css_class = 'nested-category-list';
        if ($depth > 0)
            $ul_css_class =  '';

        $subtree = array();
        $menu_count = ___c($datas);
        for ($i = 0; $i < $menu_count; $i++) {
            if ($datas[$i]['parent_id'] == $parent) {
                $childnodes = generateTree($datas, $datas[$i]['cid'], $depth + 1);
                $title = str_repeat('--', $depth).$datas[$i]['title'];
                $subtree[]= array('cid' => $datas[$i]['cid'], 'title' =>$title); 

                if (!empty($childnodes))
                    $subtree = array_merge($subtree, $childnodes);
            }
        } 
        return $subtree;
    }

            $tmp_blog = new \App\blog();
            $allcategories = $tmp_blog->getAllCategories("*",'status > 0',0,0,'title','ASC');    
            
            $html_category_choice = generateTree($allcategories)
?>
<schlix-config:textbox config-key="str_block_title" label="<?= ___('Header Text') ?>"   />
<schlix-config:textbox config-key="str_css_class_div" label="<?= ___('DIV wrapper CSS Class')  ?>"   />

<schlix-config:integerbox config-key="int_max_entries" min="0" max="100" label="<?= ___('Maximum number of post to be displayed (descending order)') ?>"   config-default-value="10" />
<schlix-config:dropdownlist   config-key="int_only_category" label="<?=  ___('Only display the following category') ?>">
    <schlix-config:option value=""><?= ___('(None)') ?> </schlix-config:option>
    <?php foreach ($html_category_choice as $choice): ?>
        <schlix-config:option value="<?= $choice['cid'] ?>"><?= ___h($choice['title']) ?> </schlix-config:option>
    <?php endforeach ?>
</schlix-config:dropdownlist>
<schlix-config:textbox config-key="int_cache_result_seconds" label="<?= ___("Cache result for (in seconds)") ?>"   config-default-value="120" />
<p class="small"><?= ___('Caching the result set will help with the performance of your website') ?></p>