<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die('No Access');

global $CurrentUser;
?>

<div id="<?= $this->block_name; ?>" class="frontpage-latestblog <?= $this->css_class_div ?>">
    <h3 class="frontpage-latestblog-category-title"><?= $block_title; ?></h3>
    <?php for ($i = 0; $i < $max_entries; $i++): ?>
        <?php
        $item = $items[$i];

        $entry = $item['date_created'];
        // you can customize your own stuff here
        $link = $blog->createFriendlyURL("action=viewitem&id={$item['id']}");
        $entrydate = date("j.M.Y", strtotime($item['date_created']));
        $entrytitle = $item['title'];
        /* <li><?= $entrydate; ?><br /><a href="<?= $link; ?>"><?= ___h($entrytitle); ?></a></li> */

        $secondary_headline = $this->getArticleExcerptFromObjectArray($item, 'summary_secondary_headline', 'summary', 100);

        //$thumb_filename = $item['summary_intro_image'] ? $blog->getDataFileURLPath('image_small', $item['summary_intro_image']) : '';
        $thumb_filename = $blog->getBlogImage('image_thumbnail', $item['summary_intro_image']);
        ?> 
        <?php if ($item['status'] == 1 && $CurrentUser->hasReadPermission($item['permission_read']) && ( $item['date_expiry'] == NULL || $item['date_expiry'] == NULL_DATE || days_difference_from_today($item['date_expiry']) > 0 )): ?>
            <h4 class="intro-title"><a href="<?= $link ?>"><?= ___h($entrytitle) ?></a></h4>
            <span class="intro-date"><?= $entrydate ?></span>
            <x-ui:row>
                <!-- col -->
                <?php if ($thumb_filename): ?>
                    <x-ui:column xs="5" sm="12" md="5" class="intro-image">
                        <!-- intro image -->
                            <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $thumb_filename ?>" alt="<?= ___h($item['summary_intro_image_caption']) ?>" /></a>
                        <!-- end intro image -->
                    </x-ui:column>
                <?php endif ?>
                <!-- col -->
                <!-- end col -->
                <x-ui:column xs="<?= $thumb_filename ? '7' : '12' ?>" class="intro-text">
                    <?= $secondary_headline ?>                    
                </x-ui:column>   
                <!-- end col -->
            </x-ui:row>

    <?php endif; ?>
    <?php endfor; ?>
</div>