<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */

if (!defined('SCHLIX_VERSION')) die('No Access');

 $config = $this->config;
 $css_class = $config['str_created_by_css_class'] ? $config['str_created_by_css_class'] : 'article-meta-created-by';
 
 $user_display_name = $user['display_name'] ? $user['display_name'] : $user['firstname'].' '.$user['lastname'];
 $user_profile_link = $config['bool_created_by_display_link'] ? $CurrentUser->createFriendlyURL("action=viewitem&id={$user['id']}") : '';
?>
<?php if ($config['bool_created_by_display_avatar']): ?>
<div class="<?= ___h($css_class) ?>">
    <div class="about_author">
        
        <h3>About the author</h3>
    </div>
    <x-ui:row>
        <x-ui:column xs="2">
        
            
            <?php if ($config['bool_created_by_display_link']) : ?> 
                <a class="user-profile-link" href="<?= $user_profile_link ?>"><img class="user-article-avatar" src="<?= $CurrentUser->getUserAvatarURLByExistingUserInfo($user, 'large') ?>" id="avatar"  align="top"  /></a>
            <?php else: ?>
                <img class="user-article-avatar" src="<?= $CurrentUser->getUserAvatarURLByExistingUserInfo($user, 'large') ?>" id="avatar"  align="top"  />
            <?php endif ?>
            
        </x-ui:column>
        <x-ui:column xs="10">
        
            <div class="user-displayname">
                <?php if ($config['bool_created_by_display_link']) : ?> 
                    <a href="<?= $user_profile_link ?>"><?= ___h($user_display_name) ?></a>
                <?php else: ?>
                    <?= ___h($user_display_name) ?>
                <?php endif ?>
                
            </div>
            <div class="user-intro"><?= $user['summary'] ?></div>
        </x-ui:column>
    </x-ui:row>
</div>
<?php else: ?>
<address class="<?= ___h($css_class) ?>">
    <span class="prefix"><?= $config['str_created_by_prefix'] ?></span> <span class="date"><?= date($date_format, $date) ?></span>
    <?php if ($config['bool_created_by_display_link']) : ?> 
        <a href="<?= $user_profile_link ?>"><?= ___h($user_display_name) ?></a>
    <?php else: ?>
        <?= ___h($user_display_name) ?>
    <?php endif ?>
</address>
<?php endif ?>