<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.
 * **** Try renaming this template to view.latestblog.template.php to see the effect
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */ 

global $CurrentUser;
global $ViewData;

?>
<div id="<?= $this->block_name; ?>" class="frontpage-latestblog col-sm-12">
    <h3 class="frontpage-latestblog-category-title"><?= $block_title; ?></h3>
    <ul class="hexgrid">

        <?php for ($i = 0; $i < $max_entries; $i++): ?>
            <?php
            $item = $items[$i];
            $entry = $item['date_created'];
            // you can customize your own stuff here
            $link = $blog->createFriendlyURL("action=viewitem&id={$item['id']}");
            $entrydate = date("j.M.Y", strtotime($item['date_created']));
            $entrytitle = $item['title'];
            /* <li><?= $entrydate; ?><br /><a href="<?= $link; ?>"><?= ___h($entrytitle); ?></a></li> */

            $secondary_headline = $this->getArticleExcerptFromObjectArray($item, 'summary_secondary_headline', 'summary', 240);   
            $thumb_filename = $blog->getBlogImage('image_thumbnail', $item['summary_intro_image']);
            //$thumb_filename = $item['summary_intro_image'] ? $blog->getDataFileURLPath('image_small', $item['summary_intro_image']) : '';
            ?> 


            <?php if ($item['status'] == 1 && $CurrentUser->hasReadPermission($item['permission_read']) && ($item['date_expiry'] == NULL_DATE || $item['date_expiry'] == NULL|| days_difference_from_today($item['date_expiry']) > 0 )): ?>
            <!-- begin hex -->
                <li class="hex">
                    <div class="hexin">
                        <a class="hexhref" href="<?= $link ?>" 
                        <?php if ($thumb_filename): ?>
                               style="background-image:url(<?= $intro_img_src ?>)"
                           <?php endif ?> >

                            <h4><?= ___h($entrytitle) ?></h4>
                            <p><?= $secondary_headline ?></p>
                        </a>
                    </div>
                </li> 
                <!-- end hex -->
            <?php endif; ?>
        <?php endfor; ?>
    </ul>
</div>