<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace WysiwygEditor;

class CodeMirror extends \SCHLIX\cmsWysiwygEditor {

    /**
     * Array of default profiles
     * @var array 
     */
    
    
    protected $default_profiles =
        ['codemirror-php' => ['title' => 'CodeMirror PHP', 'profile'=>'php'],
              'codemirror-html' => ['title' => 'CodeMirror HTML', 'profile'=>'html'],
             'codemirror-js' => ['title' => 'CodeMirror Javascript', 'profile'=>'js'],
             'codemirror-css' => ['title' => 'CodeMirror CSS', 'profile'=>'css'],
             //'codemirror-sql' => ['title' => 'CodeMirror SQL', 'profile'=>'sql']          
             ];
    
    /**
     * Returns a key/value array from the config. If the config key contains
     * a prefix of str_config_ or bool_config_ or int_config_, then it will
     * be moved into 'processed' key in the result array, otherwise it will be
     * moved to 'unprocessed' key
     * @return array
     */
    public function generateConfigurationArrayFromConfig()
    {
        $config = [];
        if ($this->config)
        {                     
            
            foreach ($this->config as $key => $value)
            {
                if (strpos ($key,'str_config_') !== FALSE)
                {
                    $new_key = remove_prefix_from_string($key, 'str_config_');
                    $trimmed_value = trim($value);
                    if ($trimmed_value)
                    {
                        $add_quote = true;                        
                        $config['processed'][$new_key] = $add_quote ? '"'.str_replace('"','\"', $trimmed_value).'"' : $trimmed_value;
                    }
                } elseif (strpos ($key,'bool_config_') !== FALSE)
                {
                    $new_key = remove_prefix_from_string($key, 'bool_config_');
                    $config['processed'][$new_key] = $value ? 'true' : 'false';
                } 
                elseif (strpos ($key,'int_config_') !== FALSE)
                {
                    $new_key = remove_prefix_from_string($key, 'int_config_');
                    $config['processed'][$new_key] = (int) $value;
                }                
                else
                {
                    $config['unprocessed'][$key] = $value;
                }

            }
            return $config;
        } else return NULL;
    }     
                
    /**
     * Given $array_config containing 2 keys: unprocessed and processed,
     * process them and move it to $array_config['processed']
     * @param string $array_config
     * @return string
     */
    public function modifyUnprocessedConfig($array_config)
    {
        $array_toolbar = [];
         return $this->forceDefaultConfigOptions($array_config['processed']);
    }

    /**
     * Returns an array of possible CSS files that can be used for content_css
     * @return array
     */
    public function getPossibleContentCSSFiles()
    {
                
        return $extra_css;
    }
    /**
     * The options specified here cannot be modified by user configuration
     * @param array $options
     * @return string
     */
    protected function forceDefaultConfigOptions($options)
    { 
        $options['viewportMargin'] = 'Infinity';
        $theme = (!empty( $this->config['str_config_theme']) &&  $this->config['str_config_theme'] != 'mbo')  ?  $this->config['str_config_theme'] : 'mbo';
        $options['config_theme_css'] =  "'". remove_multiple_slashes($this->getExtensionURLPath('system','css')."/{$theme}.css'") ; 
        return $options;
    }
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveConfig($datavalues) {
        $datavalues = parent::onModifyDataBeforeSaveConfig($datavalues);
        
        //$datavalues['options'] = serialize($datavalues['options']);
        return $datavalues;
    }
    
    /**
     * After config has been saved
     * @param int $profile_id
     */
    public function onAfterSaveConfig($profile_id) 
    {
        parent::onAfterSaveConfig($profile_id);
        return;
    }    
    
    /**
     * Returns an array of default config key/value array. Profile name can be simple, full, etc...
     * @param string $reset_profile_name
     * @return array
     */
    public function getDefaultProfileResetSettings($reset_profile_name)
    {
                
        $default_profile['php'] = $default_profile['html'] = 
        $default_profile['js'] = $default_profile['css'] = 
        $default_profile['sql'] = 
            [
            'bool_config_autoCloseBrackets' => true, 
            'bool_config_autoCloseTags' => true, 
            'bool_config_autoFormatOnStart' => false,
            'bool_config_autoFormatOnUncomment' => true, 
            'bool_config_continueComments' => true, 
            'bool_config_enableCodeFolding' => true, 
            'bool_config_enableCodeFormatting' => true, 
            'bool_config_enableSearchTools' => true, 
            'bool_config_highlightMatches' => true, 
            'bool_config_indentWithTabs' => true, 
            'bool_config_lineNumbers' => true, 
            'bool_config_lineWrapping' => true, 
            'bool_config_matchBrackets' => true, 
            'bool_config_matchTags' => true, 
            'bool_config_showAutoCompleteButton' => true, 
            'bool_config_showSearchButton' => true, 
            'bool_config_showTrailingSpace' => true, 
            'bool_config_showUncommentButton' => true, 
            'bool_config_styleActiveLine' => true,             
            'str_config_schlix_selector' => 'wysiwyg',
            'str_config_theme' => 'mbo'];
        
        $default_profile['php']['str_config_mode'] = 'php';
        $default_profile['html']['str_config_mode'] = 'htmlmixed';
        $default_profile['css']['str_config_mode'] = 'css';
        $default_profile['js']['str_config_mode'] = 'js';
        //$default_profile['sql']['str_config_mode'] = 'sql';
        
        
       return ($default_profile[$reset_profile_name]) ? $default_profile[$reset_profile_name] : [];
    }
            
    
    /**
     * Returns the configuration script, uncached
     * @return string
     */
    public function getUncachedConfigurationScript()
    {
        if ($this->config)
        {
            $array_config = $this->generateConfigurationArrayFromConfig();
            
            $processed_config = $this->modifyUnprocessedConfig($array_config);
            $config = $this->generateConfigurationScriptFromConfigArray($processed_config);
            return $config;
        } else return NULL;
    }
    /**
     * View init script
     * @return boolean
     */
    public function viewInitScript()
    {
        global $HTMLHeader;
        
        $this->config['str_replacement_config'] = array_key_exists('str_replacement_config', $this->config) ? trim ($this->config['str_replacement_config']) : '';
        if (empty($this->config['str_replacement_config']))
        {
            $config =  array_key_exists('str_generated_config', $this->config) ?  $this->config['str_generated_config'] : null;
            if (empty($config))
                $config = $this->getUncachedConfigurationScript();
            $config = $this->getUncachedConfigurationScript();
            if (array_key_exists('str_additional_config', $this->config))
                $config.= ",\n".trim($this->config['str_additional_config']);
        } else
        {
            $config = $this->config['str_replacement_config'];
        }
        $local_variables = compact(array_keys(get_defined_vars())); 
        $result = $this->loadTemplateFile('view.wysiwyg.init.js', $local_variables);
        if (!$result)
        {
            echo ___('Cannot load view.wysiwyg.init.js');
        }
        return false;
    }
    
    

}
