<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.

The view templates inside the apps and blocks  folder in this theme provide  you with ample amount of customization.
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
    $current_category_id = $category[$field_cid];
    $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
    $str_mainpage_text =  $this->getConfig('str_mainpage_text');
     // OPTIONAL - feel free to uncomment
     // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
    
/**********************************************************************
 * Custom header image needs to be placed in the THEME template file
 * if the template has 1 or more sidebar (2 or 3 column)
 * Otherwise the header image will not be displayed properly.
 * To do this, you will need to specify 2 global variables inside your
 * APP template file: $_custom_header_image and $_custom_header_title.
 * The name is arbitrary but must be the same declaration
 * 
 * In this example, the blog will be set to using the regular template
 * if it's displayed on the main page, but on subsequent page it will
 * switch to 2 column (two-column-right-sidebar.template.php)
 * because on its MENU item, the inner pages subtemplate is set to 
 * two-column-right-sidebar.template.php.
 * 
 * You can change this behaviour if you prefer to use a single column
 * template
 **********************************************************************/ 
global $_custom_header_image, $_custom_header_title;
$_custom_header_image = \App\Core_MediaHeader::getDefaultCustomHeader($this);
$_custom_header_title = $str_page_title; // $this->getConfig('str_mainpage_title');
    
?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <?php /*<h1 class="main title"><?= ___h($str_mainpage_title); ?></h1>
    <?php if ($pg < 2) : ?>
        <?= $str_mainpage_text ?>
    <?php endif */?>
    
    <?php if ($items):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="archives items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>" >    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewMainPageItem', array('main_meta_options' => $main_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($main_meta_options['display_child_item_read_more_link']==false || $main_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        $image_size = $main_meta_options['image_display_size'] ? 'image_medium' : 'image_small';

                        $secondary_headline = $this->getArticleExcerptFromObjectArray($child_item, 'summary_secondary_headline', 'summary', 240);

                        $continue_reading = ' <i class="fa fa-arrow-circle-right"></i> '.___('Continue Reading');
                        $secondary_headline.= __HTML::A($continue_reading,$link)
                    ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <?php if ($child_item_title_text): ?>
                                <h2 class="item title"><?= $child_item_title_text; ?></h2>
                            <?php endif ?>                            
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <!-- intro image -->
                            <?php $intro_img_src = $this->getBlogImage($image_size, $child_item['summary_intro_image']); ?>
                            <?php if ($main_meta_options['display_item_summary_intro_image'] && $intro_img_src): ?>
                                <div class="intro-image">
                                    <figure>
                                      <a href="<?= $link ?>"><img class="intro-image thumbnail" src="<?= $intro_img_src ?>" alt="<?= ___h($child_item['summary_intro_image_caption']) ?>"></a>
                                      <?php if ($main_meta_options['display_item_summary_intro_image_caption'] && $child_item['summary_intro_image_caption']): ?>
                                      <div class="intro-image"><?= $child_item['summary_intro_image_caption'] ?></div>
                                      <?php endif ?>
                                    </figure>                                             
                                </div>
                            <?php endif ?>                    
                            <!-- end intro image -->
                        </div>
                        <!-- columns -->
                        <div class="col-sm-8">
                            <?php if ($main_meta_options['display_item_summary']): ?>
                                <div class="secondary-headline">
                                    <?=  $secondary_headline ?>
                                </div>
                            <?php endif; ?>
                            
                        </div>                    
                    </div>
                    <!-- move it to below summary -->
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    
    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],$str_pagination_url); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div> 