<?php
/**
 * Blog - Edit Form: Category
 * 
 * @copyright (C)  SCHLIX Web Inc
 *
 * @license GPLv3
 *
 
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');



global $CurrentUser;
 
if ($id == 'new') {
    $category['permission_read'] = serialize('everyone');
    $category['items_per_page'] = 10;
    $header_title = ___('New Category');
}
else {
    $id = (int) $id;
    $preview_link = $this->app->createFriendlyURL("action=viewcategory&cid={$id}");
    $header_title = ___('Edit Category').' #'.___h($id);
}

$parent_category_text = $this->getCategoryParentURLPathPreviewLink($category); 
$max_upload_size = get_real_max_upload_size() / (1024 * 1024);
$preview_width = (int) $this->app->getConfig("int_medium_width", $ds['width']);
$preview_height = (int) $this->app->getConfig("int_medium_height", $ds['height']);


?>

<x-ui:schlix-category-editor  data-schlix-controller="SCHLIX.CMS.BlogAdmin">    
        
        <x-ui:schlix-editor-form id="form-edit-category" method="post" admin-action="savecategory">
            
            <x-ui:csrf id="_csrftoken" />
            
            <x-ui:hidden id="cid" name="cid" data-field="cid" />
            <x-ui:hidden id="parent_id" data-field="parent_id" name="parent_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     <x-ui:schlix-document-title id="title" maxlength="191"  required="required"  data-field="title" label="<?= ___('Category Title') ?>" table-type="category" />
                    <!-- Virtual Filename -->
                    <x-ui:schlix-document-virtual-filename id="virtual_filename" data-field="virtual_filename" name="virtual_filename" full-url="1" />
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_summary" fonticon="far fa-file-alt" label="<?= ___('Content') ?>"> 
                    
                    <?php /*
                    <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                    <x-ui:clearboth />
                    <h3><i class="far fa-image"></i> <?= ___('Intro image') ?></h3>
                    <p><?= ___('The first image of the article to be displayed on the list view as a thumbnail and/or as the first image in the detail view. If you want the image not to be displayed on the list view, simply insert the image to the WYSIWYG editor only. Uploaded image will be resized automatically') ?></p>
                    <x-ui:schlix-document-image-uploader label="<?= ___("Select a new intro Image") ?>" fonticon="far fa-image" name="summary_intro_image" id="summary_intro_image" data-field="summary_intro_image" data-dir-key="image_medium" />
                            
                    <x-ui:clearboth />*/ ?>
                <x-ui:row>
                    <x-ui:column  md="5">
                        <h3><i class="far fa-image"></i> <?= ___('Intro image') ?></h3>
                        <p><?= ___('The first image of the article to be displayed on the list view as a thumbnail and/or as the first image in the detail view. If you want the image not to be displayed on the list view, simply insert the image to the WYSIWYG editor only. Uploaded image will be resized automatically') ?></p>
                       
                     <x-ui:schlix-multi-source-media-uploader data-field="summary_intro_image" name="summary_intro_image" id="summary_intro_image" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" data-disable-option-existing-file="true" data-disable-option-none="true" data-allow-url-variable-dimension="true" data-preview-width="<?= $preview_width ?>" data-preview-height="<?= $preview_height ?>" />
                    
                     <p><?= sprintf(___('(Optional) You can specify the dimension of the image as %s and %s as variables in the URL. For example'),'<strong>{$width}</strong>','<strong>{$height}</strong>') ?>:</p>                     
                     <ul>
                         <li>https://via.placeholder.com/{$width}x{$height}</li>
                         <li>https://placeimg.com/{$width}/{$height}/arch</li>
                         <li>https://picsum.photos/{$width}/{$height}</li>
                     </ul>
                        
                    </x-ui:column>
                    <x-ui:column  md="7">

                        <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                    </x-ui:column>
                </x-ui:row>
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_description" fonticon="fa fa-file-alt" label="<?= ___('Description/Detail') ?>">    
                    
                    <?php /*<x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />
                    <h3><i class="far fa-image"></i> <?= ___('Alternative intro image') ?></h3>
                    <p><?= ___('If specified, the alternative intro image will be shown in the detail view.') ?></p>
                     <x-ui:schlix-document-image-uploader label="<?= ___("Select a new alternative intro image") ?>" fonticon="far fa-image" name="description_intro_image" id="description_intro_image" data-field="description_intro_image" data-dir-key="image_medium" />*/ ?>

                    <x-ui:row>
                        <x-ui:column  md="5">


                            <!-- image -->

                            <h3><i class="far fa-image"></i> <?= ___('Alternative intro image') ?></h3>
                            <p><?= ___('If specified, the alternative intro image will be shown in the detail view.') ?></p>
                            <?php /*<x-ui:schlix-document-image-uploader label="<?= ___("Select a new alternative intro image") ?>" fonticon="far fa-image" name="description_intro_image" id="description_intro_image" data-field="description_intro_image" data-dir-key="image_medium" />*/ ?>
                         <x-ui:schlix-multi-source-media-uploader data-field="description_intro_image" name="description_intro_image" id="description_intro_image" data-dir-key="image_medium" accept="image/png, image/jpeg, image/gif" data-disable-option-existing-file="true" data-disable-option-none="true" data-allow-url-variable-dimension="true" data-preview-width="<?= $preview_width ?>" data-preview-height="<?= $preview_height ?>" />

                         <p><?= sprintf(___('(Optional) You can specify the dimension of the image as %s and %s as variables in the URL. For example'),'<strong>{$width}</strong>','<strong>{$height}</strong>') ?>:</p>                     
                         <ul>
                             <li>https://via.placeholder.com/{$width}x{$height}</li>
                             <li>https://placeimg.com/{$width}/{$height}/arch</li>
                             <li>https://picsum.photos/{$width}/{$height}</li>
                         </ul>
 
                        </x-ui:column>
                        <x-ui:column  md="7">
                            <x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />

                        </x-ui:column>
                    </x-ui:row>
                     
                     
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_meta" fonticon="fa fa-hashtag" label="<?= ___('Meta') ?>">    
                    <x-ui:textbox id="meta_description" name="meta_description"  data-field="meta_description" label="<?= ___('Meta Description') ?>" />
                    <x-ui:textbox id="meta_key" name="meta_key" data-field="meta_key" label="<?= ___('Meta Keywords') ?>" />
                    <x-ui:tagbox id="tags" name="tags" data-field="tags" label="<?= ___('Tags') ?>" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                    <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_options" fonticon="fa fa-sliders-h" label="<?= ___('Options') ?>">
                    <x-ui:textbox type="number" min="1" max="10000" size="5"  id="items_per_page" name="items_per_page"  data-field="items_per_page" label="<?= ___('Maximum number of items to be displayed per page') ?>" class="schlix-input-auto-width"/>
                        
                    
                    <x-ui:schlix-editor-category-meta-options name="options" data-field="options" max-item-per-column="1" column="3" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditCategoryTab', $this, $category) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-category-editor>
