<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
	if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php 
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
    
global $HTMLHeader;

$location = array('city'=>'addressLocality','province'=>'addressRegion','postal'=>'postalCode','country'=>'addressCountry');
$HTMLHeader->JAVASCRIPT_SCHLIX_UI();
$this->CSS('contacts.css');
$this->JAVASCRIPT('contacts.js');
// as of 2019
//$HTMLHeader->CSS_EXTERNAL('https://map.schlix.website/1/leaflet.css','all');
//$HTMLHeader->JAVASCRIPT_EXTERNAL('https://map.schlix.website/1/leaflet.js');
// as of 2023
$this->CSS('leaflet/leaflet.css');
$this->JAVASCRIPT('leaflet/leaflet.js');
        

    
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$field_cid]; ?>" >   
    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>    
    <!-- ########################################################################### -->
    <!-- ####################### main info of this category  ####################### -->
    <!-- ########################################################################### -->
    <article class="main category">

        <?php if ($category['macro_processed_text_before_article']): ?>        
        <!-- Macro - Pre -->            
            <div class="meta before-article">        
            <?= $category['macro_processed_text_before_article'] ?>            
            </div>
        <!-- End Macro - Pre -->        
        <?php endif ?>
        <div class="text">
            <?= $category['summary'].$category['description'] ?>
        </div>
        <?php if (isset($category['macro_processed_text_after_article'])): ?>
        <!-- Macro - Post -->                
            <div class="meta after-article">
                <?= $category['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        <!-- End Macro - Post -->                
    </article>
    <!-- ########################################################################### -->
    <!-- ######################## end info of this category  ####################### -->
    <!-- ########################################################################### -->

    <?php if ($child_categories && $category_meta_options['display_child_categories']): ?>
    <!-- ########################################################################### -->
    <!-- ################## child categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="category child categories">
            <?php foreach ($child_categories as $child_category): ?>
                <?php if ($child_category['status'] > 0): ?>            
                <section class="child-category">
                    <?= $child_category['macro_processed_text_outside_article_top'] ?>
                    <?php 
                        $child_category_id = $child_category[$field_cid];
                        $this->processDataOutputWithMacro($child_category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$child_category_id}");
                        $child_category_title = ___h($child_category['title']);
                        $child_category_title_text = ($child_category!= null) && ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_category_title,$link) : $child_category_title;
                        
                    ?>
                    <?php if ($child_category_title_text): ?>
                        <h2 class="category title"><i class="fas fa-folder"></i> <?= $child_category_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_child_category_summary']): ?>
                        <div class="text">
                            <?= $child_category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if ($child_category['macro_processed_text_after_article']): ?>                
                        <div class="meta after-article">
                            <?= $child_category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                    <?= $child_category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ################## end child categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>

    <?php if ($items && $category_meta_options['display_items']):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="category child items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item"  itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        
                    ?>
                    <?php if ($child_item_title_text): ?>
                        <h2 class="item title" itemprop="headline"><i class="fa fa-map"></i> <?= $child_item_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <?php /*<div class="text">
                            <?= $child_item['summary'] ?>
                        </div>*/ ?>
                    <x-ui:row>
                        <x-ui:column sm="4">
                <?php if ($child_item['contact_person']): ?>
                <div class="contacts_info_label contact_person">
                    <i class="fa fa-user"></i> 
                    <?= ___h($child_item['contact_person']); ?>
                </div>
                <?php endif; ?>
                <?php if ($child_item['pobox'] || $child_item['branch'] || $child_item['street'] || $place_str): ?>
                <div itemprop="address"  itemtype="http://schema.org/PostalAddress">
                    <?php if ($child_item['branch']): ?>
                    <div class="contacts_info_label contact_buildingbranch">
                        <i class="fa fa-building"></i> 
                        <?= ___h($child_item['branch']); ?>
                    </div>
                    <?php endif; ?>
                    <?php if ($child_item['pobox']): ?>
                    <div class="contacts_info_label contact_pobox">
                        <i class="far fa-envelope"></i> 
                        <span itemprop=" postOfficeBoxNumber"><?= ___h($child_item['pobox']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if ($child_item['street']): ?>
                    <div class="contacts_info_label contact_street">
                        <i class="fa fa-road"></i> 
                        <span itemprop="streetAddress"><?= ___h($child_item['street']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if ($place_str): ?>
                    <div class="contacts_info_label contact_place">
                        <i class="fa fa-globe"></i> 
                        <?= $place_str; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php if ($child_item['tollfree']): ?>
                <div class="contacts_info_label contact_tollfree">
                    <i class="fa fa-phone-square"></i> 
                    <span itemprop="telephone"><?= ___h($child_item['tollfree']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($child_item['phone']): ?>
                <div class="contacts_info_label contact_phone">
                    <i class="fa fa-phone"></i> 
                    <span itemprop="telephone"><?= ___h($child_item['phone']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($child_item['fax']): ?>
                <div class="contacts_info_label contact_fax">
                    <i class="fa fa-fax"></i> 
                    <span itemprop="faxNumber"><?= ___h($child_item['fax']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($child_item['mobile']): ?>
                <div class="contacts_info_label contact_mobile">
                    <i class="fas fa-mobile-alt"></i> 
                    <span itemprop="telephone"><?= ___h($child_item['mobile']); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($child_item['email'] && $child_item['display_email']): ?>
                <div class="contacts_info_label contact_email">
                    <i class="fas fa-envelope"></i>
                    <?= ___h($child_item['email']); ?>
                </div>
                <?php endif; ?>            
                            
                    
</x-ui:column>
                        <!-- column -->
                        <?php if ($child_item['display_map']): ?>
                        <x-ui:column sm="8">

                            <?php
                            // map
                            $place_no_html = [];
                            foreach ($location as $element => $element_type)
                                if ($child_item[$element])
                                    $place_no_html[] = $child_item[$element];
                            $place_combined = implode(', ', $place_no_html);
                            ?>
                            <div class="schlix-contact-map schlix-contact-map-category-view" id="schlix-contact-map-<?= $child_item['id'] ?>" data-latitude="<?= $child_item['latitude'] ?>" data-longitude="<?= $child_item['longitude'] ?>" data-zoom="<?= $child_item['map_zoom'] ?>" data-address="<?= ___h($place_combined) ?>" data-title="<?= ___h($child_item['title']) ?>" />
                        </x-ui:column>
                        <?php endif ?>
                    </x-ui:row>       
                    <x-ui:link-button button-type="success"  href="<?= $link ?>"><?= ___('Send a message') ?></x-ui:link-button>                             
                    <hr />
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    <!-- pagination -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif ?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>