/**
 * Core: Error 404 - Javascript admin controller class
 * 
 * Core - Error 404 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_Error404AdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.error404");
    };

    static formatDataTableCell_404URL(elCell, oRecord, oColumn, oData) {

        elCell.innerHTML = site_httpbase + oData ;
    }

    ///////////////////////////////////////////////////////////

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {

        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        theID = app_name + '-select-id' + oRecord.getData("id");
        theValue = 'i' + oRecord.getData("id");
        elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    };
    
    static formatDataTableCell_RedirectButton (elCell, oRecord, oColumn, oData) {
        var url_edit_redirect = '';
        
        var btn = '<a href="' + url_edit_redirect +'" />';
        var app_name= this.parentControl.app_name;
        var theID = app_name + '-select-id' + oRecord.getData("id");
        var theValue = 'i' + oRecord.getData("id");
        
        var redirect_id = oRecord.getData('redirect_id');
        var edit_id = 0 ;
        var edit_text = '';
        var edit_color = '';
        if (redirect_id > 0)
        {
             edit_id = redirect_id;
             edit_text = 'Edit Rule';
             edit_color = 'btn-success';
        } else 
        {
            var url = oRecord.getData('id');
             edit_id = 'new' + '&url404id=' + url;
             edit_text = 'Fix this';            
             edit_color = 'btn-danger';
        }
        
        var edit_link = site_httpbase + '/admin/app/core.redirection?action=edititem&id=' + edit_id;
        
        elCell.innerHTML = '<a class="btn ' + edit_color +'" href="' + edit_link + '">' + edit_text  + '</a>';
    }
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'refresh':
                this.cms_control.refreshControls();
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};

