/**
 * Core: Extension Gallery - Javascript admin controller class
 * 
 * Core - Extension Gallery 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_ExtGalleryAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.extgallery");
    };
    
    static formatGallery(elCell, r, datatable)
    {
        var field_title = 'title';
        var field_has_image = '';
        var field_image = 'url_icon';
        var app_name = datatable.app_name;
        var class_link = '';

        var img = '';
        var title = r.title ? SCHLIX.Util.escapeHTML(r[field_title]) : 'Untitled';

        var id = '';
        var clearboth = '<div class="clearboth"></div>';
        var href = '';
        var data_dd_id = '';
        var pid = r.id > 0 ? 'i' + r.id : (r.cid > 0 ? 'c' + r.cid : '');


        var input_checkbox = '<div class="checkbox-inline"><input type="checkbox" name="' + app_name + '-chkselections[]" class="' + app_name + '-chkselections"  id="select-chk-gallery-' + pid + '" value="' + pid + '" /></div>';

        if (r.id > 0)
        {
            var imgsrc = r[field_image];
            var img = imgsrc ? '<img class="exticon" src="' + imgsrc + '" alt="' + title + '" >' : '<i class="fa fa-image fa-5x dragdrop schlix-gallery-view-no-image"></i>';
            title = r.title;
            id = app_name + '-lnk-i-' + r.id;
            data_dd_id = 'c' + r.id;
            href = site_httpbase + datatable.schlix_application_url + 'action=viewitem&id=' + r.id;
            data_dd_id = 'i' + r.id;

            elCell.innerHTML = '<a class="extgallery-ext" id="' + id + '" href="' + href + '">' + img + clearboth + title + '</a>' + clearboth;


        } else if (r.cid > 0)
        {
            data_dd_id = 'c' + r.cid;
            var data_category_id = r.cid;
            class_link = "datatable-folder dragdrop";
            href = 'javascript:void(0);';

            var edit_icon = "<i class =\"fas fa-pencil-alt\"></i> ";
            var url_edit_link = site_httpbase + datatable.schlix_application_url + '&action=editcategory&id=' + r.cid;

            img = '<i class="fas fa-folder fa-10x schlix-gallery-view-folder"></i>';
            title = r.title;
            id = app_name + '-lnk-c-' + r.cid;

            elCell.innerHTML =
                    '<a class="' + class_link + '" id="' + id + '" data-category-id="' + data_category_id + '" href="' + href + '">' + img + clearboth + title + '</a>';
        }

    };
    
    doBeforeDialogFormClose(o)
    {
        this.ajxh_reportInstallResult(o);
        return true;
    }
    
    
    ajxh_reportInstallResult(o)
    {
        var resp = JSON.parse(o.responseText);
        var response = resp.data;        
        if (response.status )
        {
            SCHLIX.Alert.info(response['message']);
        } else
        {
            if (response.message)
            {
                for (var i =0;i < response.message.length;i++)
                {
                    
                    console.log ( response.message[i]);
                    SCHLIX.Alert.error( response.message[i]);
                }                
            }            
        }
        if (response.force_reload )      
        {
            setTimeout(function(){ window.location.reload(); }, 1000);
        }
        
    }
    
    onDownloadInstallClick(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var value = target.value;
        
        var postData = "_csrftoken=" + _csrftoken + "&guid=" + value;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=extinstall",
                {success: this.ajxh_reportInstallResult, failure: this.handleFailure, scope: this}, postData);
        //this.ajaxRequestPOST('action=extinstall', this.ajxr_reportInstallResult, postData);
        
    };
    
    onUpgradeClick(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var value = target.value;
        
        /*var postData = "_csrftoken=" + _csrftoken + "&guid=" + value;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=extupgrade",
                {success: this.ajxh_reportInstallResult, failure: this.handleFailure, scope: this}, postData);*/
        var obj = SCHLIX.CMS.getObject('schlix-cms-upgrade-ext-dialog');
        if (obj)
        {
            var target = SCHLIX.Event.getTarget(e);
            SCHLIX.Dom.get('upgrade-title').innerHTML = target.getAttribute('data-title');
            var act_type = target.getAttribute('data-act');
            var hd = SCHLIX.Dom.get('schlix-cms-upgrade-ext-dialog_h');
            if (act_type == "1")
            {                
                hd.innerHTML = 'Downgrade confirmation';
            }
            else 
                hd.innerHTML = 'Upgrade confirmation';
            //SCHLIX.Dom.get('install_sample_data').checked = false;
            SCHLIX.Dom.get('upgrade-guid').value = target.value;
            obj.show();
        }
        
        
    };
    
    onUninstallClick(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var value = target.value;
        
        /*var postData = "_csrftoken=" + _csrftoken + "&guid=" + value;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=extupgrade",
                {success: this.ajxh_reportInstallResult, failure: this.handleFailure, scope: this}, postData);*/
        var obj = SCHLIX.CMS.getObject('schlix-cms-uninstall-ext-dialog');
        if (obj)
        {
            var target = SCHLIX.Event.getTarget(e);
            SCHLIX.Dom.get('uninstall-title').innerHTML =  target.getAttribute('data-title');
            //SCHLIX.Dom.get('install_sample_data').checked = false;
            SCHLIX.Dom.get('uninstall-guid').value = target.value;
            obj.show();
        }
        
        /*if (confirm('Are you sure you want to uninstall this extension?'))
        {
            var target = SCHLIX.Event.getTarget(e);
            var value = target.value;

            var postData = "_csrftoken=" + _csrftoken + "&guid=" + value;
            var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=extuninstall",
                    {success: this.ajxh_reportInstallResult, failure: this.handleFailure, scope: this}, postData);
        }*/
    };
    
    onFirstTimeInstallClick(e)
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-first-time-install-dialog');
        if (obj)
        {
            var target = SCHLIX.Event.getTarget(e);
            SCHLIX.Dom.get('install-title').innerHTML = target.getAttribute('data-title');
            //SCHLIX.Dom.get('install-title').innerHTML = target.getAttribute('data-title');
            //SCHLIX.Dom.get('install_sample_data').checked = false;
            SCHLIX.Dom.get('first-time-install-version-guid').value = target.value;
            obj.show();
        }
    };
    
    onDOMReady()
    {
        if (SCHLIX.Dom.get('ext-screenshots'))
        {            
            var lightbox = GLightbox();
        }
        SCHLIX.Event.on( '{.schlix-first-time-install-ext-button}', 'click', this.onFirstTimeInstallClick, this, true);
        SCHLIX.Event.on( '{.schlix-install-ext-button}', 'click', this.onUpgradeClick, this, true);
        SCHLIX.Event.on( '{.schlix-upgrade-ext-button}', 'click', this.onUpgradeClick, this, true);
        SCHLIX.Event.on( '{.schlix-uninstall-ext-button}', 'click', this.onUninstallClick, this, true);
        
    };
    /**
     * Datatable row format: item title
     * @static
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_Icon (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var odata_ext = oRecord.getData("extension");
        var file_exists = oRecord.getData("url_icon") != '';
        console.log(file_exists);
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.log("formatDataTableCell_Icon cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';

        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            var icon = file_exists ?  '<img data-media-id="' + odata_id + '" src="' + oRecord.getData('url_icon') + '" style="height:48px" /><br />' : '<i class="fa fa-image"></i> [No image]';

            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            

            
            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = "<i class=\"fa fa-eye\"></i> ";
                display_preview_link = '<div style="float:right;margin-left:4em">' +  '<a target="_blank" href="' + preview_link + '">' + preview_icon +  '</a>' + '</div>';
            }
            
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            

            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to view this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>' + display_preview_link;
        }
    };        
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn  (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            SCHLIX.log("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            var icon = "<i class =\"far fa-file-alt fa-2x\"></i>";

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = "<i class=\"fa fa-eye\"></i> ";
                display_preview_link = '<div style="float:right;margin-left:4em">' +  '<a target="_blank" href="' + preview_link + '">' + preview_icon +  '</a>' + '</div>';
            }
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            

            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>' + display_preview_link;
        }
    };
    
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                if (oRecord.getData("cid") > 0)
                {
                    theID = app_name + '-select-cid' + oRecord.getData("cid");
                    theValue = 'c' + oRecord.getData("cid");
                }
                else
                {
                    theID = app_name + '-select-id' + oRecord.getData("id");
                    theValue = 'i' + oRecord.getData("id");
                }

                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    };  
    
    runCommand (command, evt)
    {
        var open_in_new_window = is_rightclick_event(evt);
        
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;                                                
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            case 'installedexts':
                this.redirectToCMSCommand("installedexts",open_in_new_window);
                return true;
                break;            
            case 'main':
                this.redirectToCMSCommand("main",open_in_new_window);
                return true;
                break;
            default:
                return super.runCommand(command, evt);
                break;
        }
    };
};