/**
 * Core: LogViewer - Javascript admin controller class
 * 
 * Core - LogViewer 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_LogViewerAdminController = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.logviewer");
    };


    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_ViewLog (elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        if (oData === undefined)
        {
            elCell.innerHTML = "Invalid column!";
            return;
        }
        //  alert(this.parentControl.getTableFieldNameByRole('title'));
        var itemTitle = oData;// oRecord.getData("title");
        var itemLink = '';
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        if (itemTitle)
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);
        var app_name = this.parentControl.app_name;

        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        if (itemTitle == '')
            itemTitle = '(Untitled)';
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
        var the_icon;
        switch (oRecord.getData('type'))
        {
            case 'error' : 
                the_icon = 'fa-times-circle text-danger';                
                break;
            case 'warn' : 
                the_icon = 'fa-exclamation-triangle text-warning';
                break;
                    
            case 'info' :
            default: the_icon = 'fa-info-circle';
        }
        var icon = "<i class =\"fa " + the_icon + " \"></i>";
        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        itemLink = this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        elCell.innerHTML = '<a class="open-viewlog" id="' + app_name + "-lnk-" + theValue + '" data-log-id="' + theValue + '" href="javascript:void(0)" data-log-message="' + SCHLIX.Util.escapeHTML(oData) + '">' + " " + icon + " " + itemTitle + '</a>';
    };
 
    onDOMReady ()
    {
        SCHLIX.Event.delegate('schlix-core-logviewer-admin', 'click', this.onShowViewLogDialog, 'a.open-viewlog', this, true);
    }; // end func
    onShowViewLogDialog (e)
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-logviewer-dialog');
    var el = SCHLIX.Dom.get(e.target.id);
    var tgt_message = el.getAttribute('data-log-message');
        
        var message_content = SCHLIX.Dom.get('message-content');
        message_content.innerHTML = SCHLIX.Util.escapeHTML(tgt_message);
        obj.show();
    }; // end func
    
    
    runCommand (command, evt)
    {
        switch (command)
        {
            default:
                return super.runCommand(command, evt);
        }
    }
};

