<?php
/**
 * Core - Macro Manager - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

global $SystemConfig;

$app_list = $this->getListofApplicationsOrBlocks('apps');
$block_list = $this->getListofApplicationsOrBlocks('blocks');
$array_enabled_apps = unserialize($item['enabled_apps']);
$array_enabled_blocks = unserialize($item['enabled_blocks']);
/*
  $macro_config = new \SCHLIX\cmsConfigRegistry('gk_macro_config');
  //$config = $macro_config->get($item['title']);
  $macro_name = '\\Macro\\' . $item['title'];
  $the_macro = new $macro_name($macro_config);
  $the_macro->loadLanguageFile();
  $local_variables = array('filter_config' => $macro_config); */
?>
<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.Core_MacroManagerAdminController" data-model="<?= $this->getDataModelURL() ?>" data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">    

    <x-ui:schlix-editor-form id="macro_item_editor" method="post" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>" enctype="multipart/form-data" >

        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden name="id" id="id" value="<?= ___h($id) ?>" />

        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <!-- Page Title -->
                <x-ui:form-group>
                    <x-ui:label for="title"><?= ___('Macro Name') ?></x-ui:label>
                    <x-ui:input-group>
                        <!-- title -->
                        <x-ui:textbox name="title" id="title" type="text" maxlength="31"  required="required" data-field="title" readonly="readonly" /> 

                        <!-- status -->
                        <x-ui:input-addon>
                            <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= ($item['status'] == 1 || $item['id'] == 'new') ?>" 
                                                        data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                        data-text-yes="<?= ___S('Active & Published') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>


            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <br />
        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->

        <!-- begin tabs -->
        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_macro_config" fonticon="far fa-file-alt" label="<?= ___('Macro Configuration') ?>"> 

                <input type="hidden" name="id" id="id" value="<?= ___h($id) ?>" />
                <input type="hidden" name="display_in_apps_workaround" id="display_in_apps_workaround" value="<?= $item['display_in_apps']; ?>" />
                <input type="hidden" name="display_in_blocks_workaround" id="display_in_blocks_workaround" value="<?= $item['display_in_blocks']; ?>" />
                <div class="schlix_editor_main">
                    <?= \SCHLIX\cmsConfigRegistry::loadConfigFile('macros', $item, $item['title'], $item['title']) ?>
                </div>



            </x-ui:schlix-tab>
            <x-ui:schlix-tab id="tab_app_visiblity" fonticon="fa fa-puzzle-piece" label="<?= ___('Application Visibility') ?>"> 

                <p><?= ___('Please choose which application(s) should process this macro:') ?></p>
                <?php /*<x-ui:radio name="display_in_apps" id="apps_select_all" value="1" data-field="display_in_apps" label="<?= ___('All applications') ?>" />
                <x-ui:radio name="display_in_apps" id="apps_select_some" value="2" data-field="display_in_apps" label="<?= ___('Only on specified applications') ?>" />
                */ ?>
                <x-ui:radio-group name="display_in_apps" data-field="display_in_apps"  default-value="1" label="<?= ___('Please choose which application(s) should process this macro') ?>:">
                    <x-ui:option value="1" id="apps_select_all"  label="<?= ___('All applications') ?>" />
                    <x-ui:option value="2" id="apps_select_some"  label="<?= ___('Only on specified applications') ?>" />
                </x-ui:radio-group>
                <div id="app_selections">
                    <x-ui:checkbox-group name="enabled_apps[]" data-options-var="app_list" data-field="enabled_apps" label="<?= ___('Applications to be enabled') ?>" />
                </div>                

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_block_visiblity" fonticon="fa fa-cube" label="<?= ___('Block Visibility') ?>">    

                <p><?= ___('Please choose which block(s) should process this macro:') ?></p>
                <x-ui:radio-group name="display_in_blocks" data-field="display_in_blocks"  default-value="1" id="apps_select_all" label="<?= ___('Please choose which block(s) should process this macro') ?>:">
                    <x-ui:option value="1" id="blocks_select_all"  label="<?= ___('All blocks') ?>" />
                    <x-ui:option value="2" id="blocks_select_some"  label="<?= ___('Only on specified blocks') ?>" />
                </x-ui:radio-group>
                
                <div id="block_selections">
                    <x-ui:checkbox-group name="enabled_blocks[]" data-options-var="block_list" data-field="enabled_blocks" label="<?= ___('Blocks to be enabled') ?>" />
                </div>


            </x-ui:schlix-tab> 
            <!-- tab -->
            <x-ui:schlix-tab id="tab_options" fonticon="fa fa-question-circle" label="<?= ___('About') ?>">
                <?php include('edit.item.about.template.php'); ?>
            </x-ui:schlix-tab>

        <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
        <!-- end tabs -->
    </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 

