<?php
/**
 * Core: Media Manager - Main admin view template
 * 
 * Core - Media Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php $is_wysiwyg_mode = (fget_int('frame') > 0); ?>
<?php $app = alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias()); ?>


<script type='text/javascript'>
    var is_wysiwyg_mode = <?= $is_wysiwyg_mode ? 'true' : 'false' ?>;
    var schlix_cache_path = '<?=  CURRENT_SUBSITE_URL_PATH.'/cache/thumbnails' ?>';
</script>    

<div class="schlix-explorer" id="media-manager">
    <x-ui:schlix-file-manager id="schlix-<?= $app ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.MediaManager" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $app ?>" data-model="<?= $this->getDataModelURL() ?>">

        <!-- Toolbar -->
        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="upload" fonticon="fa fa-upload" label="<?= ___('Upload') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-folder" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Folder') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>
        </x-ui:schlix-explorer-toolbar>
        
        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Left Column -->
            <x-ui:schlix-explorer-left-column>
                <!-- treeview -->
                <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
                <!-- end column -->
            </x-ui:schlix-explorer-left-column>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                    <x-ui:schlix-data-table-columns>
                        <?php if (!$is_wysiwyg_mode): ?>

                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.MediaManager.formatDataTableCell_CheckBox" sortable="false" />                           
                        <?php endif; ?>
                        
                        <x-ui:schlix-data-table-column key="virtual_filename" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.MediaManager.formatDataTableCell_Filename" />
                        <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="true" formatter="text" />
                        <x-ui:schlix-data-table-column key="size" label="<?= ___('Size') ?>" sortable="true" formatter="SCHLIX.CMS.MediaManager.formatDataTableCell_FileSize" />
                        <x-ui:schlix-data-table-column key="permission" label="<?= ___('Permission') ?>" sortable="true" formatter="text"   />
                        <x-ui:schlix-data-table-column key="owner" label="<?= ___('Owner') ?>" sortable="false" formatter="text"  />
                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" />
                        <x-ui:schlix-data-table-column key="this.field_item_title" label="<?= ___('Action') ?>" sortable="false" formatter="SCHLIX.CMS.MediaManager.formatAction"   />
                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->
    </x-ui:schlix-file-manager>
</div>
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Upload Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

<x-ui:schlix-cms-common-dialog id="schlix-cms-upload-image-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.MediaManager" header-label="<?= ___('Upload images') ?>" data-button-submit-id="btn-upload-ok" data-button-cancel-id="btn-upload-cancel" data-action="action=upload" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <p class="upload-info"><?= ___("Upload to") ?> <strong>/web/<?= CURRENT_SUBSITE_NAME ?><span id="header-uploadstartpath"></span></strong></p>
    <x-ui:hidden name="uploadstartpath" id="text-uploadstartpath" required="required" />
    <x-ui:schlix-file-upload multiple="true"  id="filedata"  name="filedata[]" required="required" fonticon="far fa-folder-open" label="<?= ___('Select file(s)') ?>" />
    
    <x-ui:clearboth />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-upload-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-upload-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ New/Edit Category Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-new-folder-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.MediaManager" header-label="<?= ___('New folder') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-newfolder-ok" data-button-cancel-id="btn-newfolder-cancel" data-action="action=newfolder" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:form-group>
        <label for="text-newfolder"><?= ___('Create a new folder') ?></label>
        <x-ui:input-group>
            <x-ui:input-addon>
                <span id="text-newfolderstartpath"></span>
        </x-ui:input-addon>
        <x-ui:hidden name="newfolderstartpath" id="input-newfolderstartpath" />
        <x-ui:textbox name="foldername" id="text-newfolder" required="required" maxlength="63" 
                    placeholder="<?= ___('Folder Name') ?>" pattern="^[A-Za-z0-9_\-]{1,63}$" title="<?= ___('Alphanumeric with dash and space only') ?>" />
        </x-ui:input-group>
    </x-ui:form-group>
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-newfolder-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-newfolder-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>

 
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Rename Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->

<x-ui:schlix-cms-common-dialog id="schlix-cms-rename-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.MediaManager" header-label="<?= ___('Rename a file') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-rename-ok" data-button-cancel-id="btn-rename-cancel" data-action="action=rename" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="filetype"  readonly="true"  id="text-filetype" />
    <x-ui:hidden name="oldfilenameonly" id="text-oldfilenameonly" />
    <!-- input group -->
        <x-ui:textbox name="oldname" id="text-oldname" required="required" label="<?= ___('Full path') ?>" readonly="true" />
    <!-- input group -->
        <x-ui:textbox name="newname" id="text-newfilenameonly" required="required" maxlength="63" 
                    placeholder="<?= ___('New filename') ?>" label="<?= ___('New  name') ?>" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-rename-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-rename-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>