<?php
namespace App;

/**
 * Core: Redirection - Admin class
 * 
 * Core - Redirection
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  Roy <roy.hadrianoro@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Redirection_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     */
    public function __construct() {
        // Data: Item
        parent::__construct(true, array());
        // You can enable more items here        
        $this->setItemFieldNamesForAjaxListing('id', 'path', 'redirect_to',  'date_created', 'date_modified', 'description', 'hits' ,'status');
        $this->search_field = 'path';
    }
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        
        return $datavalues;
    }
    
    /**
     * Get associative array of possible options for type column with its label.
     * @return array
     */
    public function typeOptions() {
        return [
            301 => 'Permanent (301)',
            302 => 'Temporary (302)'
        ];
    }
    
    
}
