<?php
/**
 * Core - ThemeManager - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

$folder_full_path = CURRENT_SUBSITE_PATH.'/themes/'.$item['title'];
$url_relative = CURRENT_SUBSITE_URL_PATH.'/themes/'.$item['title'];

?>
<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.ThemesAdmin" data-model="<?= $this->getDataModelURL() ?>" data-field-id="<?= $this->app->getFieldID() ?>" data-cancel-warning="true">    

    <x-ui:schlix-editor-form id="macro_item_editor" method="post" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>" enctype="multipart/form-data" >

        <x-ui:csrf id="_csrftoken" />
        <x-ui:hidden name="id" id="id" value="<?= ___h($id) ?>" />

        <x-ui:schlix-editor-top-row>    
            <x-ui:schlix-editor-top-left>
                <!-- Page Title -->
                <x-ui:form-group>
                    <x-ui:label for="title"><?= ___('Theme Name') ?></x-ui:label>
                    <x-ui:input-group>
                        <!-- title -->
                        <x-ui:textbox name="title" id="title" type="text" maxlength="31"  required="required" data-field="title" readonly="readonly" /> 

                        <!-- status -->
                        <x-ui:input-addon>
                            <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= ($item['status'] == 1 || $item['id'] == 'new') ?>" 
                                                        data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                        data-text-yes="<?= ___S('Active & Published') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                        </x-ui:input-addon>
                    </x-ui:input-group>
                </x-ui:form-group>

                <x-ui:textbox fonticon="fas fa-folder text-orange" readonly="readonly" value="<?= ___h($folder_full_path) ?>" label="<?= ___('Full path') ?>" />
                <x-ui:textbox fonticon="fas fa-folder text-orange" readonly="readonly" value="<?= ___h($url_relative) ?>" label="<?= ___('Relative URL path') ?>" />
            </x-ui:schlix-editor-top-left>
            <x-ui:schlix-editor-top-right>
                <x-ui:schlix-editor-action-buttons />
            </x-ui:schlix-editor-top-right>            
        </x-ui:schlix-editor-top-row>

        <br />
        <!-- main -->
        <x-ui:clearboth />

        <x-ui:schlix-document-save-result />
        <!-- end main section -->

        <!-- begin tabs -->
        <x-ui:schlix-tab-container>
            <!-- tab -->
            <!-- tab -->
            <x-ui:schlix-tab id="tab_theme_config" fonticon="far fa-file-alt" label="<?= ___('Theme Configuration') ?>"> 

                <?php
                $filename = get_system_or_user_file("/themes/{$item['title']}/config.template.php", false); // SCHLIX_SITE_PATH . "/admin;
                if (file_exists($filename)) {
                    $admin_language = SCHLIX_DEFAULT_LANGUAGE;
                    if ($admin_language != 'en_us') {
                        $language_filename = get_system_or_user_file("/themes/{$item['original_block']}/lang_{$admin_language}.php", FALSE);
// SCHLIX_SITE_PATH . "/admin/blocks/{$item['original_block']}/lang_{$admin_language}.php";
                        if (file_exists($language_filename))
                            include_once($language_filename);
                    }

                    $block_config = new \SCHLIX\cmsConfigRegistry('gk_theme_config');
                    //$config = $block_config->get($this->app_name); // this is not necessary 
                    ob_start();
                    include_once ($filename);
                    $block_config_html = ob_get_contents();
                    ob_end_clean();
                    echo $block_config->processConfigTags($item['title'], $block_config_html);
                } else
                    echo \__HTML::P(___('This theme does not have a configuration file built-in:') . " {$item['title']}");
                ?>

            </x-ui:schlix-tab> 
            <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
        <!-- end tabs -->
    </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor> 