<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die('No Access');
?>
<?php $app = $this->app_name; ?>
<?php $this->app->createSitemapIfNotExist() ?>
<?php
$current_sitemap_content =  file_get_contents(CURRENT_SUBSITE_PATH . '/cache/sitemap.xml');
$enabled_apps_array = $this->app->getConfig('array_enabled_apps');

$urltest = $this->app->getSitemapXML();

$search_consoles = 
        [
            ['link' => 'https://www.google.com/webmasters/', 'label' => 'Google Search Console'],
            ['link' => 'https://www.bing.com/toolbox/webmaster', 'label' => 'Bing Webmaster Tools'],
            ['link' => 'https://webmaster.yandex.com', 'label' => 'Yandex Webmaster'],            
            ['link' => 'https://ziyuan.baidu.com/linksubmit/url', 'label' => 'Baidu'],
        ];

$all_links = '';
foreach ($search_consoles as $search_console)
{
    $all_links.= \__HTML::A($search_console['label'], $search_console['link'], ['target' => '_blank','rel' => 'noopener noreferrer']).',';
}
$all_links = rtrim($all_links, ',');
?>

<div class="schlix-explorer">
    <schlix-data-explorer-blank id="schlix-<?= $this->app->getApplicationNameOnly() ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.SitemapAdmin" data-main-app-description="<?= $this->app->getApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>">

        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

        </x-ui:schlix-explorer-toolbar>

        <div class="content">
            <p><?= ___('Sitemap is enabled for the following applications') ?>:</p>
            <ul>
            <?php foreach ($enabled_apps_array as $enabled_app): ?>
            <li><?= ___h($enabled_app) ?></li>
            <?php endforeach ?>
            </ul>
            <p><?= ___('You can change which applications are accessible by clicking the Configuration toolbar button') ?>.</p>
            <p><?= sprintf(___('The following sitemap XML URL can be submitted to %s and other search engines.'), $all_links) ?></p>
            
            <x-ui:form-group>
                <label for="url_sitemap_xml"><?= ___('Sitemap URL') ?></label>
            <x-ui:input-group>
                <x-ui:input-addon>
                    <i class="fas fa-sitemap"></i>
                </x-ui:input-addon>
            <x-ui:textbox type="url" readonly="readonly" id="url_sitemap_xml" value="<?= $this->app->getCachedSitemapXMLURL() ?>" />
            <x-ui:input-addon-button>
                <x-ui:button button-type="ok" id="btn-regenerate-sitemap" label="<?= ___('Regenerate Sitemap') ?>" fonticon="fas fa-sitemap"  />
            </x-ui:input-addon-button>
            </x-ui:input-group>
            </x-ui:form-group>
                

            <label for="txt_cached_sitemap"><?= ___('Current cached sitemap') ?></label>
            <x-ui:textarea id="txt_cached_sitemap" readonly="readonly" rows="23"><?= ___h($current_sitemap_content) ?></x-ui:textarea>
        </div>
        <!-- End Data Viewer -->
    </schlix-data-explorer-blank>
</div>

