//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

/**
 * View Controller class
 */
SCHLIX.CMS.HostAddressList = class extends SCHLIX.CMS.DataExplorerList {
    /**
     * Constructor
     */
    constructor (el, options)
    {
        super(el, options);
    };
    
    getNewItemInsertData ()
    {
        var category_id = SCHLIX.Dom.get('id').value; // id of the site
        return {"id": "new","category_id": category_id};
    }; // end func     
    
///////////////////////////////////////////////////////////
    insertNewItem ()
    {
        var page = this.control_paginator.getCurrentPage();
        var totalcount = this.getDataTableTotalItemCount();
        var insert_at_position = totalcount;

        this.setLocalStorageCacheItem( "current_start", 0);

        if (!this.checkIfThereIsAnyUnsavedNewRow())
        {
            if (totalcount == this.getRowsPerPage())
            {
                insert_at_position = 0;
                this.control_paginator.setPage(page + 1, true);
            }
            var insert_data = this.getNewItemInsertData();
            console.log(insert_data);
            this.control_datatable.addRow(insert_data, insert_at_position);

        }
        else
            alert('Please edit the item that you have just inserted before adding another one');
    }; // end func 
    
};

SCHLIX.CMS.registerComponent('schlix-wwwaddress-data-explorer', SCHLIX.CMS.HostAddressList);

SCHLIX.CMS.SiteManagerAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("sitemanager");
    };


    static formatAction  (elCell, oRecord, oColumn, oData)
    {
        var id = oRecord.getData("id");
        var hostname = oRecord.getData("hostname");

        var icon = '<i class="far fa-times-circle"></i> ';
        elCell.innerHTML = '<a class="delete-host"  href="javascript:void(0)" data-hostname="' + hostname + '" data-id="' + id + '">' + icon + ' Delete</a>';
    };

    static formatSiteName  (elCell, oRecord, oColumn, oData)
    {
        var hostname = oRecord.getData("hostname");

        var icon = '<i class="fa fa-globe"></i> ';
        elCell.innerHTML = icon + hostname;
    };
    

    /**
     * Automatically called when the DOM is ready
     * @param {event} event
     */    
    onDOMReady (event)
    {
        SCHLIX.Event.on('btn_test_database', 'click', this.onTestDBClick, this, true);
        SCHLIX.Event.delegate('hostnames-section', 'click', this.onDeleteHostClick, 'a.delete-host', this, true);
        if (SCHLIX.Dom.get('smtp_use_auth'))
        {
            SCHLIX.Event.on('smtp_use_auth', 'change', this.onSMTPAuthenticationChanged, this, true);           
            this.onSMTPAuthenticationChanged(null);
        }
        
    };
    
    /**
     * Called when the dropdown SMTP authentication is changed
     * @param {event} e
     */
    onSMTPAuthenticationChanged(e)
    {
        var elem = SCHLIX.Dom.get('smtp_use_auth');
        if (elem != null)
        {
            var smtp_auth = parseInt( elem.value);
            var el_smtp_username = SCHLIX.Dom.get('smtp_username_box');
            var el_smtp_password_box = SCHLIX.Dom.get('smtp_password_box');
            var el_smtp_oauth2_box = SCHLIX.Dom.get('smtp_oauth2_box');
            switch (smtp_auth)
            {
                case 1: 
                    el_smtp_username.style.display = '';
                    el_smtp_oauth2_box.style.display = 'none';
                    el_smtp_password_box.style.display = '';
                    break;
                case 2: 
                    el_smtp_username.style.display = '';
                    el_smtp_oauth2_box.style.display = 'block';
                    el_smtp_password_box.style.display = 'none';
                    break;                
                default:
                    el_smtp_username.style.display = 'none';
                    el_smtp_oauth2_box.style.display = 'none';
                    el_smtp_password_box.style.display = 'none';
            }
        } else SCHLIX.Alert.info('Unable to find SMTP auth input');
    };
        
    onGetTestDBResult(o)
    {
        var response = ajax_parse(o.responseText);
        var db_test_result = SCHLIX.Dom.get('db_tested');
        if (response != false)
        {
            SCHLIX.Alert.info(response);
            db_test_result.value = 'yes';
        } else
        {
            db_test_result = '0';            
        }
    };
    onFailedDatabaseTest(o)
    {
         db_test_result = '0';
    }; // end func
    
    onTestDBClick(event)
    {
        var pw = SCHLIX.Dom.get('db_password');
        if (pw)
        {
            var db_username = SCHLIX.Dom.get('db_username').value;
            var db_password = pw.value;
            var db_host = SCHLIX.Dom.get('db_host').value;
            var db_database = SCHLIX.Dom.get('db_database').value;
            var db_test_id = SCHLIX.Dom.get('id').value;
            var db_use_ssl = SCHLIX.Dom.get('db_use_ssl').checked;
            var db_ssl_ca = SCHLIX.Dom.get('db_ssl_ca').value;
            var postData = "_csrftoken=" + _csrftoken + '&username=' + encodeURIComponent(db_username) + '&password=' + encodeURIComponent(db_password) + '&host=' + db_host+ '&database=' + encodeURIComponent(db_database) + '&siteid=' + encodeURIComponent(db_test_id) + '&db_use_ssl=' + encodeURIComponent(db_use_ssl) + '&db_ssl_ca=' + encodeURIComponent(db_ssl_ca) ;
            //this.ajaxRequestPOST(this.reportPOSTOperation, this.getUpdateFieldURL(), postData, 'cronscheduler');   


            var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=testdatabase",
                    {success: this.onGetTestDBResult, failure: this.onFailedDatabaseTest, scope: this}, postData
                    );
        }
    }; // end func
    onDeleteHostClick (event)
    {
        var count = this.cms_control.getDataTableTotalItemCount();
        if (count == 1)
        {
            SCHLIX.Alert.warning('Cannot delete the only host');
            return false;
        }
        var el = SCHLIX.Dom.get(event.target.id);
        var tgt_id = el.getAttribute('data-id');
        var tgt_title = el.getAttribute('data-hostname');

        if (tgt_id == 'new')
        {
            this.cms_control.refreshControls();
        } else if (confirm('Delete ' + tgt_title + '? '))
        {
            var callback = {success: this.onHostDeleted, failure: this.handleFailure, scope: this};
            var the_app_url = site_httpbase + "/admin/app/" + this.app_name + "?action=deletehost";
            var postData = "_csrftoken=" + _csrftoken + "&items=i" + tgt_id;

            var request = SCHLIX.Ajax.POST( the_app_url, callback, postData);
        }

    }; // end func
    onHostRefreshed ()
    {
        this.cms_control.refreshControls();
    }; // end func
    
    forceRefreshHosts()
    {
            var callback = {success: this.onHostRefreshed, failure: this.handleFailure, scope: this};        
            var the_app_url = site_httpbase + "/admin/app/" + this.app_name + "?action=forcerefresh";
            var request = SCHLIX.Ajax.GET( the_app_url, callback);
        
    }; // end func
    onHostDeleted ()
    {
        this.cms_control.refreshControls();
    }; // end func
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem");
                return true;
                break;
            case 'new-address':
                this.cms_control.insertNewItem();
                break;
            case 'save-item':
                if (SCHLIX.Dom.get('db_tested').value != 'yes')
                {
                    SCHLIX.Alert.error('Please click Test Connection on the database section first to ensure you have access to it');
                    return false;
                }                
                var total_addr_count = this.cms_control.getDataTableTotalItemCount();
                if (total_addr_count < 1)
                {

                    SCHLIX.Alert.error('A minimum of 1 website address must be added');
                    return false;
                } else
                {
                    return RESOLVE_TO_PARENT;
                }
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break; 
            case 'force-refresh':
                this.forceRefreshHosts();
                return true;
                break;

            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};
